/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'l'

/*
** WARNING: BORLAME C++ 4.5 Cannot correctly compile
**  struct FOO huge *Foo;
**  e=Foo[n].elem1;
** Because Foo[n] is not cast into a normalised huge pointer,
** it will barf on 64k boundary, reading the start of the table
** all over again. Please cast Foo[n] into a huge pointer
** before dereferencing any element. This is ridiculous.
*/
#include "lbwintex.h"
#include "lbcommon.h"
#include <stdlib.h>
#include <ctype.h>

#include "lbwad.h"
#include "lbdispl.h"
#include "lbtext.h"

#include "lbwaddef.h"
#include "lbdoom.h"
#include "lbwadir.h"
#include "lblevprt.h"

#if (DLLFORDOOM)
/*
** Comparison of entries (NAME8)
*/
#if 0
#if defined __OS2__
#if defined (__BORLANDC__)
int _USERENTRY WADLname8Cmp(const void *d1,const void *d2)
#else
int _Optlink WADLname8Cmp(const void *d1,const void *d2)
#endif
#elif defined __WINDOWS__
int _USERENTRY WADLname8Cmp(const void *d1,const void *d2)
#else
int WADLname8Cmp(const void *d1,const void *d2)
#endif
{  Int16 i;
	pInt8 s1=(pInt8)d1;
	pInt8 s2=(pInt8)d2;
	for(i=0;i<NORMALISELEN;i++, s1+=1,s2+=1)
	{ if(*s1<*s2) return -1;
	  if(*s1>*s2) return 1;
	}
	return 0;
}

static void WADLsortNames(pInt8 List, Int32 ListNb, Int16 EltSz)
{
  if(ListNb<=0) return;
  if(ListNb>0x800) ListNb=0x800;
  qsort(List,(Int16)ListNb, EltSz,WADLname8Cmp);
}
#endif

/*
**
** Define calculation precision, for scaling
** (scale level, scale vertex, draw linedef...)
*/
/*nb bits for fixed point calculation*/
#define PREC      (12)
/*1/2 in fixed point, for rounding*/
#define HLFUNITY (1<<(PREC-1))
/*max*/
#define MAX(a,b)  (((a)>(b))?(a):(b))


/***************************************************/
/*
**
** Scale a level
** Implicit: SzX and SzY were set
*/
Int16 WADLscale(pBOUND Bound, Int16 How)
{ Int32 dX,dY;
  /*screen width, height*/
  if((Bound->SzX<64)||(Bound->SzX>2048)||(Bound->SzY<64)||(Bound->SzY>2048))
  { return ERRfault(ERR_BUG); }
  dX=Bound->Xmax - Bound->Xmin;
  dY=Bound->Ymax - Bound->Ymin;
  if((dX==0)||(dY==0))
  { return ERRfault(BAD_ENTRY);}

  if(How>0)
  { /*fit all of level on screen*/
	 if(dY*((Int32)Bound->SzX)> dX*((Int32)Bound->SzY))
		Bound->SzX=(Int16)((((Int32)Bound->SzY)*dX)/dY);
	 else
		Bound->SzY=(Int16)((((Int32)Bound->SzX)*dY)/dX);
  }
  else
  {
	 /*if(dX/Bound->SzX < dY/Bound->SzY)*/
    if((dX*Bound->SzY) < (dY*Bound->SzX))
      dX=  (dY*Bound->SzX) / (Bound->SzY);
    else
		dY=  (dX*Bound->SzY) / (Bound->SzX);
    Bound->Xmax=(Int16)(dX+Bound->Xmin);
    Bound->Ymax=(Int16)(dY+Bound->Ymin);
  }
  /*
  **Scale:  (Xmin,Ymin)-( Xmax,Ymax )
  **map to: (   1,1   )-(SzX-3,SzY-3)
  */
  Bound->ScalX=((Int32)Bound->SzX-1)<<PREC;
  Bound->ScalY=((Int32)Bound->SzY-1)<<PREC;
  /*scaling. not rounded.*/
  Bound->ScalX= (Bound->ScalX)/dX;
  Bound->ScalY= (Bound->ScalY)/dY;
  /*offset*/
  Bound->OfsX=Bound->Xmin;
  Bound->OfsY=Bound->Ymin;
  return 1;
}
/*
** scale a coordinate
*/
Int16 WADLgetScaled(Int16 T, Int32 Scale, Int32 Ofs)
{ static Int32 res;
  res=((Int32)T)-Ofs;
  res*=Scale;
  res+=((res>0)? HLFUNITY: -HLFUNITY);
  res>>=PREC;
  /*Int16 bounds*/
  if(res<-0x7FFFL) res=-0x7FFFL;
  else if(res>0x7FFFL) res=0x7FFFL;
  return (Int16)res;
}
/*
** Draw a scaled line
*/
Int16 WADLdrawScaledLine(pBMPOBJ Bmp,Int16 X,Int16 Y, Int16 dX, Int16 dY, pBOUND Bound, Int16 Color)
{ Int16 sX,sY,eX,eY;
  sX=WADLgetScaled(X, Bound->ScalX, Bound->OfsX);
  sY=WADLgetScaled(Y, Bound->ScalY, Bound->OfsY);
  eX=WADLgetScaled(X+dX, Bound->ScalX, Bound->OfsX);
  eY=WADLgetScaled(Y+dY, Bound->ScalY, Bound->OfsY);
  /*
  ** Draw line (sX,sY)-(eX,eY)
  */
  return BMPline(Bmp,sX,sY,eX,eY,Color);
}
/***********************************************************/
/*
**
**  Vertex
**
*/
Int32 WADLvrtxSizeI(Int32 Size)
{ return ((Size+0xFL)&~0xFL)*sizeof(struct VERTEX);} /*16-alignment*/
/*
** Read vertex, free previous such entry, if any
*/
Int16 WADLvrtxReadI(pLVLOBJ Dml, pInt8 Lmp, Int32 LmpSz)
{ Int16 NbVtx, v;
  pDMVERTEX TLmp;
  pVERTEX TVtx;
  /*check object*/
  if((Lmp==NULL)||(LmpSz<=0))
	 return ERR_BUG; /*don't catch error*/
  if(Dml==NULL)
  { Free(Lmp); return ERRfault(ERR_BUG);}
  /*find nb of vertex in lump*/
  NbVtx=(Int16)(LmpSz/((Int32)sizeof(struct DMVERTEX)));
  if(NbVtx<=0)
  { Free(Lmp); return ERRfault(BAD_ENTRY);}
  /*Allocate memory for vertex*/
  Dml->Vtx=(pVERTEX)Malloc(WADLvrtxSizeI(NbVtx));
  if(Dml->Vtx==NULL)
  { Free(Lmp); return ERR_MEM;}
  /*convert*/
  TLmp=(pDMVERTEX)Lmp;
  for(v=0,TVtx=Dml->Vtx; v<NbVtx; v++,TVtx+=1,TLmp+=1)
  { TVtx->X= TLmp->X;  /*Dml->Vtx[v]*/
	 TVtx->Y= TLmp->Y;  /*Dml->Vtx[v]*/
  }
  Dml->VtxNb=NbVtx;
  Free(Lmp);
  return 1;
}
/*
** find vertex
*/
Int16 WADLvrtxFindI(pLVLOBJ Dml, int X, int Y)
{ Int16 v,Ref;
  Int32 dx,dy,D,Dmin;
  pVERTEX TVtx;
  if(Dml==NULL) return ERRfault(ERR_BUG);
  if((Dml->Vtx==NULL)||(Dml->VtxNb<0)) return ERRfault(ERR_BUG);
  Dmin=256;  /*tolerance, should be scale-dependant.*/
  Ref=-1;
  for(v=0,TVtx=Dml->Vtx;v<Dml->VtxNb;v++,TVtx+=1)
  { dx=((Int32)X)- ((Int32)TVtx->X); /*Dml->Vtx[v]*/
	 dy=((Int32)Y)- ((Int32)TVtx->Y); /*Dml->Vtx[v]*/
	 if(dx<0) dx=-dx;
	 if(dy<0) dy=-dy;
	 D=dx+dy;  /*Equidistant= Losange*/
	 if(D<Dmin) { Dmin=D; Ref=v;}
	 if(Dmin<1) break;
  }
  return Ref;
}
/*
** Bound a set of vertex
*/
Int16 WADLvrtxBoundI(pLVLOBJ Dml,pBOUND Bound)
{ Int16 v,x,y,Xmin,Xmax,Ymin,Ymax;
  pVERTEX TVtx;
  if(Dml==NULL) return ERRfault(ERR_BUG);
  if((Dml->Vtx==NULL)||(Dml->VtxNb<0)) return ERRfault(ERR_BUG);
  Xmin=Ymin=0x7FFF;Xmax=Ymax=-0x7FFF;
  for(v=0,TVtx=Dml->Vtx;v<Dml->VtxNb;v++,TVtx+=1)
  { x=TVtx->X; /*Dml->Vtx[v]*/
	 y=TVtx->Y; /*Dml->Vtx[v]*/
	 if(Xmin>x)Xmin=x;
	 if(Ymin>y)Ymin=y;
	 if(Xmax<x)Xmax=x;
	 if(Ymax<y)Ymax=y;
  }
  Bound->Xmin=Xmin;Bound->Xmax=Xmax;
  Bound->Ymin=Ymin;Bound->Ymax=Ymax;
  return 1;
}
/*
** start cache of vertex list
*/
Int16 WADLvrtxCacheI(pLVLOBJ Dml)
{ Int16 v;
  pVERTEX TVtx;
  if(Dml==NULL) return ERRfault(ERR_BUG);
  if((Dml->Vtx==NULL)||(Dml->VtxNb<0)) return ERRfault(ERR_BUG);
  for(v=0,TVtx=Dml->Vtx;v<Dml->VtxNb;v++,TVtx+=1)
  { TVtx->cacheX=INVALIDVTX; /*Dml->Vtx[v]*/
	 TVtx->cacheY=INVALIDVTX; /*Dml->Vtx[v]*/
  }
  return 1;
}
/*
** scale a vertex (with cache)
*/
Int16 WADLvrtxGetScaled(pLVLOBJ Dml, Int16 Vertex, pBOUND Bound,pInt16 pX, pInt16 pY)
{ pVERTEX TVtx;
  Int32 resx,resy;
  /*
  if(Dml==NULL) return ERRfault(ERR_BUG);
  if(Dml->Vtx==NULL) return ERRfault(ERR_BUG);
  */
  if((Vertex<0)||(Vertex>=Dml->VtxNb)) return -1;
  TVtx=&(Dml->Vtx[Vertex]);
  if(TVtx->cacheX==INVALIDVTX)
  {
#if 1 /*fast, feeds the pipeline*/
	 /*offset*/
	 resx= (((Int32)TVtx->X)-(Bound->OfsX));
	 resy= (((Int32)TVtx->Y)-(Bound->OfsY));
	 /*scale*/
	 resx*= Bound->ScalX;
	 resy*= Bound->ScalY;
	 /*round*/
	 resx+=((resx>0)? HLFUNITY: -HLFUNITY);
	 resy+=((resy>0)? HLFUNITY: -HLFUNITY);
	 resx>>=PREC;
	 resy>>=PREC;
	 /*Int16 bounds*/
	 if(resx<-0x7FFFL) resx=-0x7FFFL;
	 if(resy<-0x7FFFL) resy=-0x7FFFL;
	 if(resx>0x7FFFL) resx=0x7FFFL;
	 if(resy>0x7FFFL) resy=0x7FFFL;
#else
	 resx= WADLgetScaled(TVtx->X, Bound->ScaleX, Bound->OfsX);
	 resy= WADLgetScaled(TVtx->Y, Bound->ScaleY, Bound->OfsY);
#endif
	 /*store*/
	 TVtx->cacheX=(Int16)resx;
	 TVtx->cacheY=(Int16)resy;

  }
  *pX=TVtx->cacheX;
  *pY=TVtx->cacheY;
  return 1;
}

/***********************************************************/
/*
**
**  LINEDEF
**
*/
/*
** read linedef, free previous such entry, if any
*/
Int16 WADLreadLinedefI(pLVLOBJ Dml,pInt8 Lmp, Int32 LmpSz,Int16 Old)
{ Int16 l,NbLnd;
  pDMLINEDEF TLmp;
  pH2LINEDEF TLmp2;
  pLINEDEF TLnd;
  /*check object*/
  if((Lmp==NULL)||(LmpSz<=0))
	 return ERR_BUG; /*don't catch error*/
  if(Dml==NULL)
  { Free(Lmp); return ERRfault(ERR_BUG);}
  /*find nb of linedefs*/
  if(Old>0)
  { NbLnd=(Int16)(LmpSz/((Int32)sizeof(struct DMLINEDEF)));
  }
  else
  { NbLnd=(Int16)(LmpSz/((Int32)sizeof(struct H2LINEDEF)));
  }
  if(NbLnd<=0)
  { Free(Lmp); return ERRfault(BAD_ENTRY);}
  Dml->LndNb=NbLnd;
  Dml->Lnd=Malloc(((Int32)Dml->LndNb)*sizeof(struct LINEDEF));
  if(Dml->Lnd==NULL)
  { Free(Lmp); return ERR_MEM;}
  if(Old>0)
  {
	 TLmp=(pDMLINEDEF)Lmp;
	 for(l=0,TLnd=Dml->Lnd; l<Dml->LndNb; l++,TLnd+=1,TLmp+=1)
	 { /*Dml->Lnd[l].xxx = Lmp[l].xxx*/
		TLnd->VtxS=  TLmp->VtxS;
		TLnd->VtxE=  TLmp->VtxE;
		TLnd->Flag=  TLmp->Flag;
		TLnd->Type=  TLmp->Type;
		TLnd->Tag=   TLmp->Tag;
		TLnd->SideR= TLmp->SideR;
		TLnd->SideL= TLmp->SideL;
		TLnd->Tag2=0;
	 }
  }
  else /*H2*/
  {
	 TLmp2=(pH2LINEDEF)Lmp;
	 for(l=0,TLnd=Dml->Lnd; l<Dml->LndNb; l++,TLnd+=1,TLmp2+=1)
	 { /*Dml->Lnd[l].xxx = Lmp2[l].xxx*/
		TLnd->VtxS=  TLmp2->VtxS;
		TLnd->VtxE=  TLmp2->VtxE;
		TLnd->Flag=  TLmp2->Flag;
		TLnd->Type=  TLmp2->Type;
		TLnd->Tag=   0;
		TLnd->Tag2=  0;
		TLnd->SideR= TLmp2->SideR;
		TLnd->SideL= TLmp2->SideL;
	 }
  }
  Free(Lmp);
  return 1;
}
/*
** Draw a linedef on the current bitmap,
** from vertexS to vertexE with scale ScaleX,ScaleY
*/

Int16 WADLdrawLineI(pLVLOBJ Dml,pBMPOBJ Bmp, pLINEDEF Lnd,pBOUND Bound,Int16 Color)
{ Int16 eX,eY,sX,sY;
  if(Lnd->VtxS==Lnd->VtxE) { return ERR_BADLINE;}
  /*
  ** Get (sX,sY), scaled + offset
  */
  if(WADLvrtxGetScaled(Dml, Lnd->VtxS, Bound, &sX, &sY)<0)
  { return ERR_BADLINE;}
  /*
  ** Get (eX,eY), scaled + offset
  */
  if(WADLvrtxGetScaled(Dml, Lnd->VtxE, Bound, &eX, &eY)<0)
  { return ERR_BADLINE;}
  /*
  ** Draw line (sX,sY)-(eX,eY)
  */
  BMPline(Bmp,sX,sY,eX,eY,Color);
  return 1;
}
/*
** get position of point relative to a line.
** return >0 if on the right, <0 if on the left
** return 0 if error, or if on line
*/
Int32 WADLposLineI(pLVLOBJ Dml, Int16 Lin, Int16 X,Int16 Y)
{ Int16 VtxS,VtxE;
  Int32  sX,sY,dX,dY;
  pLINEDEF TLnd;
  pVERTEX TVtx;
  /*dereference linedef*/
  TLnd=&(Dml->Lnd[Lin]);
  /*get start and end vertex*/
  VtxS=TLnd->VtxS;
  VtxE=TLnd->VtxE;
  /*check vertex*/
  if((VtxS<0)||(VtxS>=Dml->VtxNb)) return 0;
  if((VtxE<0)||(VtxE>=Dml->VtxNb)) return 0;
  /*Get (sX,sY)*/
  TVtx=&(Dml->Vtx[VtxS]);
  sX=(Int32)(TVtx->X);
  sY=(Int32)(TVtx->Y);
  /*Get (eX-sX,eY-sY)*/
  TVtx=&(Dml->Vtx[VtxE]);
  dX=((Int32)(TVtx->X))-sX;
  dY=((Int32)(TVtx->Y))-sY;
  /*return SM.SE = |SM|.|SE|.sin(SM,SE)*/
  /*should be normalised by |SE|=sqrt(dX+dY)*/
  return ((Int32)X-sX)*(dY)  -  ((Int32)Y-sY)*dX;
}
/*
** get projection of point on line.
*/
Int16 WADLprojLineI(pLVLOBJ Dml, pInt16 pX,pInt16 pY, Int16 Lin, Int16 X,Int16 Y)
{ Int16 VtxS,VtxE;
  Int32 sX,sY,dX,dY;
  Int32 num,den;
  pLINEDEF TLnd;
  pVERTEX TVtx;
  /*dereference linedef*/
  TLnd=&(Dml->Lnd[Lin]);
  /*get start and end vertex*/
  VtxS=TLnd->VtxS;
  VtxE=TLnd->VtxE;
  /*check vertex*/
  if((VtxS<0)||(VtxS>=Dml->VtxNb)) return -1;
  if((VtxE<0)||(VtxE>=Dml->VtxNb)) return -1;
  /*Get (sX,sY)*/
  TVtx=&(Dml->Vtx[VtxS]);
  sX=(Int32)(TVtx->X);
  sY=(Int32)(TVtx->Y);
  /*Get (eX-sX,eY-sY)*/
  TVtx=&(Dml->Vtx[VtxE]);
  dX=((Int32)(TVtx->X))-sX;
  dY=((Int32)(TVtx->Y))-sY;
  /*denominator: norm of line vector*/
  den= dY*dY + dX*dX;
  if(den<=0) return -1;
  /*numerator: line vector scalar vector (sX,sY)-(X,Y)*/
  num=((Int32)X-sX)*dX + ((Int32)Y-sY)*dY;
  /* t = num/den */
  /* (*pX,*pY)= projection of (X,Y) on line*/
  *pX= (Int16) (sX + (num*dX + (den>1))/den);
  *pY= (Int16) (sY + (num*dY + (den>1))/den);
  /*ok*/
  return 1;
}
/*
** say where we are, on line segment
** returns<0 if projection of point on line does not falls in line segment
** returns distance >0 otherwise .
**
** This is great to select line segments from inside sectors, because
** it tests againt a band orthogonal to line segment, with width equal
** to the length of line segment
*/
Int32 WADLprojWhereI(pLVLOBJ Dml, Int16 Lin, Int16 X,Int16 Y)
{ Int16 VtxS,VtxE,pX,pY;
  Int32 sX,sY,dX,dY;
  Int32 num,den;
  pLINEDEF TLnd;
  pVERTEX TVtx;
  /*dereference linedef*/
  TLnd=&(Dml->Lnd[Lin]);
  /*get start and end vertex*/
  VtxS=TLnd->VtxS;
  VtxE=TLnd->VtxE;
  /*check vertex*/
  if((VtxS<0)||(VtxS>=Dml->VtxNb)) return -1;
  if((VtxE<0)||(VtxE>=Dml->VtxNb)) return -1;
  /*Get (sX,sY)*/
  TVtx=&(Dml->Vtx[VtxS]);
  sX=(Int32)(TVtx->X);
  sY=(Int32)(TVtx->Y);
  /*Get (eX-sX,eY-sY)*/
  TVtx=&(Dml->Vtx[VtxE]);
  dX=((Int32)(TVtx->X))-sX;
  dY=((Int32)(TVtx->Y))-sY;
  /*denominator: norm of line vector*/
  den= dY*dY + dX*dX;
  if(den<=0) return -1;
  /*numerator: line vector scalar vector (sX,sY)-(X,Y)*/
  num=((Int32)X-sX)*dX + ((Int32)Y-sY)*dY;
  /*
  ** returns -1 if does not fall within line segment
  ** which is equivalent to  num/den  not between 0 and 1
  */
  if((num<0)||(num>den)) return -1;
  /*
  ** get projection point
  */
  pX= (Int16) (sX + (num*dX + (den>1))/den);
  pY= (Int16) (sY + (num*dY + (den>1))/den);
  /*
  ** returns square of distance to line
  */
  dX=((Int32)X-(Int32)pX);
  dY=((Int32)Y-(Int32)pY);
  return dX*dX+dY*dY;
}

  /*returns >0 if point is in line box*/
Int16 WADLinLineBoxI(pLVLOBJ Dml, Int16 Lin, Int16 X,Int16 Y)
{ Int16 VtxS,VtxE;
  Int16 sX,sY,eX,eY,dum;
  pLINEDEF TLnd;
  pVERTEX TVtx;
  /*dereference linedef*/
  TLnd=&(Dml->Lnd[Lin]);
  /*get start and end vertex*/
  VtxS=TLnd->VtxS;
  VtxE=TLnd->VtxE;
  /*check vertex*/
  if((VtxS<0)||(VtxS>=Dml->VtxNb)) return -1;
  if((VtxE<0)||(VtxE>=Dml->VtxNb)) return -1;
  /*Get (sX,sY)*/
  TVtx=&(Dml->Vtx[VtxS]);
  sX=TVtx->X;
  sY=TVtx->Y;
  /*Get (eX,eY)*/
  TVtx=&(Dml->Vtx[VtxE]);
  eX=TVtx->X;
  eY=TVtx->Y;
  if(sX>eX){ dum=sX;sX=eX;eX=dum;}
  if(sY>eY){ dum=sY;sY=eY;eY=dum;}
  if((X<sX)||(X>eX)||(Y<sY)||(Y>eY))return -1;
  return 1;
}
/*
** find closest line
*/
Int16 WADLpointLineI(pLVLOBJ Dml, Int16 X, Int16 Y)
{ Int16 Ref,l;
  Int32 dmin,d;
  /*check object*/
  if(Dml==NULL) { ERRfault(ERR_BUG); return NULL;}
  if(Dml->Lnd==NULL) { ERRfault(ERR_BUG); return NULL;}
  if(Dml->Vtx==NULL) { ERRfault(ERR_BUG); return NULL;}
  dmin=0x7FFFFFFFL;
  Ref=-1;
  for(l=0;l<Dml->LndNb;l++)
  { /*from projection of current point on line*/
	 d=WADLprojWhereI(Dml, l, X, Y);
	 if(d<0)continue;
    if(d<=dmin)
    { dmin=d;Ref=l;}
  }
  return Ref;
}

/******************************************************/
/*
**
** Side def
**
*/
/*
** Read sidedef, free previous such entry, if any
*/
Int16 WADLsideReadI(pLVLOBJ Dml,pInt8 Lmp, Int32 LmpSz)
{ Int16 SidNb;
  /*pDMSIDEDEF Sid;*/
  /*check object*/
  if((Lmp==NULL)||(LmpSz<=0))
	 return ERR_BUG; /*don't catch error*/
  if(Dml==NULL)
  { Free(Lmp); return ERRfault(ERR_BUG);}
  /*find nb of sidedefs in lump*/
  SidNb=(Int16)(LmpSz/((Int32)sizeof(struct DMSIDEDEF)));
  if(SidNb<=0)
  { Free(Lmp); return ERRfault(BAD_ENTRY);}
#if sizeof(DMSIDEDEF) != sizeof(SIDEDEF)
#error Please update this code
#endif
  Dml->Sid=(pSIDEDEF)Lmp; /*don't free lmp*/
  Dml->SidNb=SidNb;
  return 1;
}
/*
** Get sidedef Lump
*/
pInt8 WADLsideGetLmpI(pLVLOBJ Dml,pInt32 pLmpSz)
{
  pInt8 Lmp;
  Int32 LmpSz;
  if(Dml==NULL)
  { ERRfault(ERR_BUG); return NULL;}
  /* Get size of lump */
  LmpSz = Dml->SidNb * ((Int32)sizeof(struct DMSIDEDEF));
  /* Copy lump */
  Lmp = Malloc(LmpSz);
  if(Lmp==NULL)
  { return NULL;}
#if sizeof(DMSIDEDEF) != sizeof(SIDEDEF)
#error Please update this code
#endif
  Memcpy(Lmp,(pInt8)Dml->Sid,LmpSz); /*copy lump*/
  /**/
  *pLmpSz=LmpSz;
  return Lmp;
}
/*
** find closest sidedef
*/
Int16 WADLsidePointI(pLVLOBJ Dml, Int16 X, Int16 Y)
{ Int16 Ref,Side,l;
  Int32 dmin,d;
  pLINEDEF TLnd;
  /*check object*/
  if(Dml==NULL) { return ERRfault(ERR_BUG); }
  if(Dml->Lnd==NULL) { return ERRfault(ERR_BUG);}
  if(Dml->Vtx==NULL) { return ERRfault(ERR_BUG);}
  dmin=0x7FFFFFFFL;
  Ref=-1;
  for(l=0,TLnd=Dml->Lnd ;l<Dml->LndNb;l++, TLnd+=1)
  { /*distance to projection point*/
	 d=WADLprojWhereI(Dml, l, X, Y);
	 if(d<0) continue;
	 if(d <=dmin)
	 { /*select side*/
		if(WADLposLineI(Dml, l, X, Y)>=0) /*right side*/
		{ Side=TLnd->SideR;
		}
		else  /*left side*/
		{ Side=TLnd->SideL;
		}
		if((Side<0)||(Side>Dml->SidNb)) continue;
		dmin=d;
		Ref= Side;
	 }
  }
  return Ref;
}
/*
** List all flats in sector
*/
Int16 WADLsideListTexu(pLVLOBJ Dml,pTXTOBJ Txt)
{
  struct CNTOBJ Cnt;
  Int32 s;
  pSIDEDEF TSid;
  /**/
  if((Dml==NULL)||(Dml->Sid==NULL)||(Dml->SidNb<=0))
  { return ERRfault(ERR_BUG);}
  /*
  ** Fill table with names of floor/ceilings
  */
  CNTinit(&Cnt, (Dml->SidNb) * 3);
  for(s=0,TSid=Dml->Sid; s<Dml->SidNb; s++,TSid+=1)
  {
	 if(TSid->Lower[0] != '-')
	 { CNTaddName(&Cnt,TSid->Lower); }
	 if(TSid->Upper[0] != '-')
	 { CNTaddName(&Cnt,TSid->Upper); }
	 if(TSid->Middle[0] != '-')
	 { CNTaddName(&Cnt,TSid->Middle);}
  }
  /*
  ** List names of textures
  */
  TXTprintName(Txt,-1,"Texture:  Times used:",21);
  CNTlistNames(&Cnt,Txt);
  /**/
  CNTfree(&Cnt);
  return 1;
}
/*
** Set texture name, conform to DOOM conventions
*/
static void WADLtexuSetName(pInt8 Texu, pInt8 Src)
{
  if(isalnum(Src[0])) /* 0-9 A-Z a-z*/
  { Normalise(Texu,Src);}
  else
  { Normalise(Texu,"-");}
}
/*
** Set texture name
**  Texu[NORMALISELEN+2] =  Upper[8] Lower[8] Middle[8]
*/
Int16 WADLsideSetTexu(pLVLOBJ Dml, Int16 Sid, pInt8 Texu)
{
  pSIDEDEF TSid;
  /**/
  if((Dml==NULL)||(Dml->Sid==NULL)||(Dml->SidNb<=0)||(Sid>Dml->SidNb))
  { return ERRfault(ERR_BUG);}
  /*
  ** Get the right sidedef
  */
  TSid=&(Dml->Sid[Sid]);
  /*
  ** copy, without spaces
  */
  WADLtexuSetName(TSid->Upper, &Texu[0]);
  WADLtexuSetName(TSid->Lower, &Texu[NORMALISELEN]);
  WADLtexuSetName(TSid->Middle, &Texu[2*NORMALISELEN]);
  return 1;
}
/*
** Get texture name
**  Texu[24+2] =  Upper[8] Lower[8] Middle[8]
*/
Int16 WADLsideGetTexu(pLVLOBJ Dml, Int16 Sid, pInt8 Texu)
{
  pSIDEDEF TSid;
  /**/
  if((Dml==NULL)||(Dml->Sid==NULL)||(Dml->SidNb<=0)||(Sid>Dml->SidNb))
  { return ERRfault(ERR_BUG);}
  /*
  ** Get the right sidedef
  */
  TSid=&(Dml->Sid[Sid]);
  /*
  ** copy, without spaces
  */
  NormalizeS(&Texu[0],TSid->Upper);   /*#1*/
  NormalizeS(&Texu[8],TSid->Lower);   /*#2*/
  NormalizeS(&Texu[8+8],TSid->Middle);/*#3*/
  return 1;
}


/******************************************************/
/*
**
** Sector
**
*/
/*
** Read sector
*/
Int16 WADLsectReadI(pLVLOBJ Dml,pInt8 Lmp, Int32 LmpSz)
{ Int16 SecNb;
  /*pDMSECTOR Sec;*/
  /*check object*/
  if((Lmp==NULL)||(LmpSz<=0))
	return ERR_BUG; /*don't catch error*/
  if(Dml==NULL)
  { Free(Lmp); return ERRfault(ERR_BUG);}
  /*find nb of sectors in lump*/
  SecNb=(Int16)(LmpSz/((Int32)sizeof(struct DMSECTOR)));
  if(SecNb<=0)
  { Free(Lmp); return ERRfault(BAD_ENTRY);}
#if sizeof(DMSECTOR) != sizeof(SECTOR)
#error Please update this code
#endif
  Dml->Sec=(pSECTOR)Lmp; /*don't free Lmp*/
  Dml->SecNb=SecNb;
  return 1;
}
/*
** Get sidedef Lump
*/
pInt8 WADLsectGetLmpI(pLVLOBJ Dml,pInt32 pLmpSz)
{
  pInt8 Lmp;
  Int32 LmpSz;
  if(Dml==NULL)
  { ERRfault(ERR_BUG); return NULL;}
  /* Get size of lump */
  LmpSz = Dml->SecNb * ((Int32)sizeof(struct DMSECTOR));
  /* Copy lump */
  Lmp = Malloc(LmpSz);
  if(Lmp==NULL)
  { return NULL;}
#if sizeof(DMSECTOR) != sizeof(SECTOR)
#error Please update this code
#endif
  Memcpy(Lmp,(pInt8)Dml->Sec,LmpSz); /*copy lump*/
  /**/
  *pLmpSz=LmpSz;
  return Lmp;
}

/*
** List all flats in sector
*/
Int16 WADLsectListTexu(pLVLOBJ Dml,pTXTOBJ Txt)
{
  struct CNTOBJ Cnt;
  Int32 s;
  pSECTOR TSec;
  /**/
  if((Dml==NULL)||(Dml->Sec==NULL)||(Dml->SecNb<=0))
  { return ERRfault(ERR_BUG);}
  /*
  ** Fill table with names of floor/ceilings
  */
  CNTinit(&Cnt,Dml->SecNb*2);
  for(s=0,TSec=Dml->Sec; s<Dml->SecNb; s++,TSec+=1)
  {
	 CNTaddName(&Cnt,TSec->Floor);
	 CNTaddName(&Cnt,TSec->Ceil);
  }
  /*
  ** List names of floors/ceilings
  */
  TXTprintName(Txt,-1,"Flats:    Times used:",21);
  CNTlistNames(&Cnt,Txt);
  /*
  ** Exit
  */
  CNTfree(&Cnt);
  return 1;
}
/*
** Set texture name
**  Texu[NORMALISELEN+2] =  Ceiling[NORMALISELEN] Floor[NORMALISELEN]
*/
Int16 WADLsectSetTexu(pLVLOBJ Dml, Int16 Sec, pInt8 Texu)
{
  pSECTOR TSec;
  /**/
  if((Dml==NULL)||(Dml->Sec==NULL)||(Dml->SecNb<=0)||(Sec>Dml->SecNb))
  { return ERRfault(ERR_BUG);}
  /*
  ** Get the right sidedef
  */
  TSec=&(Dml->Sec[Sec]);
  /*
  ** copy, without spaces
  */
  WADLtexuSetName(TSec->Ceil, &Texu[0]);
  WADLtexuSetName(TSec->Floor, &Texu[NORMALISELEN]);
  return 1;
}
/*
** Get texture name
**  Texu[24+2] =  Ceiling[8] Floor[8]
*/
Int16 WADLsectGetTexu(pLVLOBJ Dml, Int16 Sec, pInt8 Texu)
{
  pSECTOR TSec;
  /**/
  if((Dml==NULL)||(Dml->Sec==NULL)||(Dml->SecNb<=0)||(Sec>Dml->SecNb))
  { return ERRfault(ERR_BUG);}
  /*
  ** Get the right sidedef
  */
  TSec=&(Dml->Sec[Sec]);
  /*
  ** copy, without spaces
  */
  NormalizeS(&Texu[0],TSec->Ceil);   /*#1*/
  NormalizeS(&Texu[8],TSec->Floor);  /*#2*/
  return 1;
}

/******************************************************/
/*
**
** Segments
**
*/
/*
** Read segment
*/
Int16 WADLssegReadI(pLVLOBJ Dml,pInt8 Lmp, Int32 LmpSz)
{ Int16 SegNb;
  /*pDMSEGS Seg;*/
  /*check object*/
  if((Lmp==NULL)||(LmpSz<=0))
	 return ERR_BUG; /*don't catch error*/
  if(Dml==NULL)
  { Free(Lmp); return ERRfault(ERR_BUG);}
  /*find nb of segment in lump*/
  SegNb=(Int16)(LmpSz/((Int32)sizeof(struct DMSEGS)));
  if(SegNb<=0)
  { Free(Lmp); return ERRfault(BAD_ENTRY);}
#if sizeof(DMSEGS) != sizeof(SEGS)
#error Please update this code
#endif
  Dml->Seg=(pSEGS)Lmp; /*don't free Lmp*/
  Dml->SegNb=SegNb;
  return 1;
}
/*
** Draw a linedef on the current bitmap,
** from vertexS to vertexE with scale ScaleX,ScaleY
*/

Int16 WADLssegDrawI(pLVLOBJ Dml,pBMPOBJ Bmp, Int16 Sg,pBOUND Bound,Int16 Color)
{ Int16 eX,eY,sX,sY;
  pSEGS TSeg;
  /*
  ** check Seg is valid
  */
  if((Sg<0)||(Sg>=Dml->SegNb)) { return ERR_BADLINE;}
  TSeg= &(Dml->Seg[Sg]);
  /*
  ** Get (sX,sY), scaled + offset
  */
  if(WADLvrtxGetScaled(Dml, TSeg->VtxS, Bound, &sX, &sY)<0)
  { return ERR_BADLINE; }
  /*
  ** Get (eX,eY), scaled + offset
  */
  if(WADLvrtxGetScaled(Dml, TSeg->VtxE, Bound, &eX, &eY)<0)
  { return ERR_BADLINE;}
  /*
  ** Draw line (sX,sY)-(eX,eY)
  */
  BMPline(Bmp,sX,sY,eX,eY,Color);
  return 1;
}
/******************************************************/
/*
**
** Sub Sector
**
*/
/*
** Read sub sector
*/
Int16 WADLssecReadI(pLVLOBJ Dml,pInt8 Lmp, Int32 LmpSz)
{ Int16 SscNb;
  /*pDMSSECTOR Ssc;*/
  /*check object*/
  if((Lmp==NULL)||(LmpSz<=0))
	 return ERR_BUG; /*don't catch error*/
  if(Dml==NULL)
  { Free(Lmp); return ERRfault(ERR_BUG);}
  /*find nb of sub sector in lump*/
  SscNb=(Int16)(LmpSz/((Int32)sizeof(struct DMSSECTOR)));
  if(SscNb<=0)
  { Free(Lmp); return ERRfault(BAD_ENTRY);}
#if sizeof(DMSSECTOR) != sizeof(SSECTOR)
#error Please update this code
#endif
  Dml->Ssc=(pSSECTOR)Lmp; /*don't free Lmp*/
  Dml->SscNb=SscNb;
  return 1;
}
/*
** Draw sub sector.
** supposes that vertex cache was started
*/
Int16 WADLssecDrawI(pLVLOBJ Dml,pBMPOBJ Bmp, Int16 Sc,pBOUND Bound,Int16 Color)
{ Int16 n,seg;
  pSSECTOR TSsc;
  /*
  if(Dml==NULL) return ERRfault(ERR_BUG);
  */
  if((Sc<0)||(Sc>=Dml->SscNb)) { return ERR_BADLINE;}
  TSsc= &(Dml->Ssc[Sc]);
  seg=TSsc->First;
  for(n=(TSsc->Nb)-1; n>=0; n--,seg++)
  { if((seg<0)||(seg>=Dml->SegNb))continue;
	 WADLssegDrawI(Dml,Bmp, seg, Bound, Color);
  }
  return 1;
}
/******************************************************/
/*
**
** Nodes
**
*/
/*
** Read nodes
*/
Int16 WADLnodeReadI(pLVLOBJ Dml,pInt8 Lmp, Int32 LmpSz)
{ Int16 NodNb;
  /*pDMNODE Nod;*/
  /*check object*/
  if((Lmp==NULL)||(LmpSz<=0))
	 return ERR_BUG; /*don't catch error*/
  if(Dml==NULL)
  { Free(Lmp); return ERRfault(ERR_BUG);}
  /*find nb of nodes in lump*/
  NodNb=(Int16)(LmpSz/((Int32)sizeof(struct DMNODE)));
  if(NodNb<=0)
  { Free(Lmp); return ERRfault(BAD_ENTRY);}
#if sizeof(DMNODE) != sizeof(NODE)
#error Please update this code
#endif
  Dml->Nod=(pNODE)Lmp;/*don't free Lmp*/
  Dml->NodNb=NodNb;
  return 1;
}
/*
** Get the index to the top node
*/
Int16 WADLnodeGetTop(pLVLOBJ Dml)
{ if((Dml==NULL)||(Dml->Nod==NULL))
  { return ERRfault(ERR_BUG); }
  if(Dml->NodNb<=0) return BAD_PARM;
  return (Dml->NodNb)-1;
}
/*
** Get the child of a given node, from X,Y
** return -1 if no node there
*/
Int16 WADLnodeGetChild(pLVLOBJ Dml,Int16 Node, Int16 X, Int16 Y)
{ Int32 vX,vY,pos;
  Int16 child;
  pNODE TNod;
  if((Dml==NULL)||(Dml->Nod==NULL))
  { return ERRfault(ERR_BUG);}
  if((Node<0)||(Node>=Dml->NodNb)) return -1;
  TNod=&(Dml->Nod[Node]);
  /*
  ** Vector from node(X,Y) to point(X,Y)
  */
  vX= ((Int32)X)-((Int32)TNod->X);
  vY= ((Int32)Y)-((Int32)TNod->Y);
  /*
  ** calculate side: if (vX,vY) scalar (dY,-dX)
  **  = (vX,vY) scalar (dX,dY) rotated right
  **  is > 0, then right side
  */
  pos= vX*((Int32)TNod->dY) - vY*((Int32)TNod->dX);
  /*
  ** select side
  */
  child = (pos>=0)? TNod->Right: TNod->Left;
  if(child&NOTNODE) return -1;
  if((child<0)||(child>=Dml->NodNb))return -1;
  return child;
}
/***********************************************************/
/*
**
**  Reject
**
*/
/*
** Read reject, free previous such entry, if any
*/
Int16 WADLrejReadI(pLVLOBJ Dml, pInt8 Lmp, Int32 LmpSz)
{ Int16 s,bit;
  Int32 RejNb;
  /*check object*/
  if((Lmp==NULL)||(LmpSz<=0))
	 return ERR_BUG; /*don't catch error*/
  if(Dml==NULL)
  { Free(Lmp); return ERRfault(ERR_BUG);}
  /*find nb of reject in lump*/
  RejNb=(LmpSz);
  if(RejNb<=0)
  { Free(Lmp); return ERRfault(BAD_ENTRY);}
  Dml->Rej=Lmp; /*don't free Lmp*/
  Dml->RejNb=RejNb;
  /*
  ** guess number of sectors without using sqrt()
  */
  if(Dml->SecNb<=0)
  { RejNb<<=3; 		/*size of bit array*/
	 for(s=0,bit=16-2;bit>=0;bit--)
	 { s |= 1<<bit;      /*test bit*/
		if(((Int32)s)*((Int32)s) <= RejNb) continue;
		s &= ~(1<<bit);   /*bit wasn't okay*/
	 }
	 Dml->SecNb= s;
  }
  return 1;
}
/*
** Get reject
*/
pInt8 WADLrejGetLmpI(pLVLOBJ Dml, pInt32 pLmpSz)
{ pInt8 Lmp;
  Int32 LmpSz;
  if((Dml==NULL)||(Dml->Rej==NULL))
  { ERRfault(ERR_BUG); return NULL;}
  LmpSz=Dml->RejNb;
  Lmp=Malloc(LmpSz);
  if(Lmp==NULL) { return NULL;}
  Memcpy(Lmp,Dml->Rej,LmpSz);
  *pLmpSz=LmpSz;
  return Dml->Rej;
}
/*
** Get Reject returns 1 if Sect can see Targ, 0 if cannot see
** and <0 if no idea
*/
Int16 WADLrejGetI(pLVLOBJ Dml, Int16 Sect, Int16 Targ)
{ Int32 r;
  Int16 bit;
  if((Sect<0)||(Sect>=Dml->SecNb)) return -1;
  if((Targ<0)||(Targ>=Dml->SecNb)) return -1;
  /*
  ** position (Sect,Targ) in bit array
  */
  r= ((Int32)Sect)*((Int32)Dml->SecNb)+Targ;
  /*
  ** convert to a bit in byte array
  */
  bit  = 1<<((Int16)r&7);
  r  >>= 3;
  /*
  ** Rej[r] is 0 if Sect can see Targ. return 1 then.
  */
  if((r<0)||(r>Dml->RejNb)) return -1;
  return (Dml->Rej[r] & bit)? 0 : 1;
}
/*
** Set reject
*/
Int16 WADLrejSetI(pLVLOBJ Dml, Int16 Sect, Int16 Targ, Int16 Ops)
{ Int32 r;
  Int16 bit;
  if((Targ<0)||(Targ>=Dml->SecNb)) return -1;
  switch(Ops)
  {
	 case WADL_REJ_SAFE:
		for(Sect=0,r=Targ; Sect<Dml->SecNb; Sect++, r+=Dml->SecNb)
		{
		  bit  = 1<<((Int16)r&7);
		  Dml->Rej[(r>>3)]|= bit;   /*set bit. sect cannot see Targ*/
		}
		return 0;
	 case WADL_REJ_UNSAFE:
		for(Sect=0,r=Targ; Sect<Dml->SecNb; Sect++, r+=Dml->SecNb)
		{
		  bit  = 1<<((Int16)r&7);
		  Dml->Rej[(r>>3)]&= ~(bit); /*clear bit. sect can see Targ*/
		}
		return 1;
  }
  if((Sect<0)||(Sect>=Dml->SecNb)) return -1;
  r= ((Int32)Sect)*((Int32)Dml->SecNb)+Targ;
  bit  = 1<<((Int16)r&7);
  switch(Ops)
  {
	 case WADL_REJ_CANTSEE:
		Dml->Rej[(r>>3)]|= bit;   /*set bit. Sect cannot see Targ*/
		break;
	 case WADL_REJ_CANSEE:
		Dml->Rej[(r>>3)]&= ~(bit);/*clear bit. Sect can see Targ*/
		break;
	 case WADL_REJ_TOGGLE:
		Dml->Rej[(r>>3)]^=bit;    /*toggle*/
		break;
  }
  return (Dml->Rej[(r>>3)]&bit)?0:1;
}
#endif /*DLLFORDOOM*/
