/****************************************************\
*
*
* WAD OBJECT INTERNAL BASIC LEVEL HANDLING API
*
*
\****************************************************/

#if (DLLFORDOOM)
/*
** Misc.
*/
  /*
  ** Scale a level
  ** pBound = bounding box
  ** How>0 show all level. How=0 biggest view
  */
Int16 WADLscale(pBOUND Bound, Int16 How);
  /*
  ** Scale a coordinate
  */
Int16 WADLgetScaled(Int16 T, Int32 Scale, Int32 Ofs);
  /*
  ** Draw a scaled line on a Bmp object
  **  BmpMe = Bmp object
  **  (X,Y) = start coordinates
  **  (dX,dY) = line displacement
  */
Int16 WADLdrawScaledLine(pBMPOBJ Bmp,Int16 X,Int16 Y, Int16 dX, Int16 dY, pBOUND Bound, Int16 Color);

/*
** Vertex
*/
  /*
  ** Read vertex
  ** Here = ref. of level header
  */
Int16 WADLvrtxReadI(pLVLOBJ Dml,pInt8 Lmp, Int32 LmpSz);
  /*
  ** find closest vertex
  ** (X,Y) = position
  */
Int16 WADLvrtxFindI(pLVLOBJ Dml, int X, int Y);
  /*
  ** Get Bounding box of all vertex
  **  pBound = return max and min x,Y there
  */
Int16 WADLvrtxBoundI(pLVLOBJ Dml,pBOUND Bound);
  /*
  ** Start cacheing vertex
  */
Int16 WADLvrtxCacheI(pLVLOBJ Dml);
  /*
  ** Get scaled vertex,
  ** note: call WADLcacheVertexI to initialise
  **  Vertex =
  **  pBound = bounding box and scale
  **  (pX,pY) = return scaled X,Y
  */
Int16 WADLvrtxGetScaled(pLVLOBJ Dml, Int16 Vertex, pBOUND Bound,pInt16 pX, pInt16 pY);

/*
** Lines
*/
  /*
  ** Read lines
  ** Here = ref. of level header
  */
Int16 WADLreadLinedefI(pLVLOBJ Dml,pInt8 Lmp, Int32 LmpSz, Int16 Old);
  /* Draw line.
  ** note: start cacheing vertex first
  **  VtxS = start vertex
  **  VtxE = end vertex
  **  pBound = bound box and scale
  **  Color = color index
  */
Int16 WADLdrawLineI(pLVLOBJ Dml,pBMPOBJ Bmp, pLINEDEF Lnd,pBOUND Bound,Int16 Color);
  /*
  ** Get position of point toward line.
  **  Lin = Line
  **  (X,Y) = point
  ** return >0 if front (right), <0 if back (left)
  ** returns 0 if point is on line
  */
Int32  WADLposLineI(pLVLOBJ Dml, Int16 Lin, Int16 X,Int16 Y);
  /*
  ** get projection of point X,Y on line.
  **  (pX,pY) = return position of projection
  **  Lin = line
  **  (X,Y) = original point
  */
Int16 WADLprojLineI(pLVLOBJ Dml, pInt16 pX,pInt16 pY, Int16 Lin, Int16 X,Int16 Y);
  /*
  ** Get distance to line segment
  **   Lin = line
  **  (X,Y) = original point
  ** returns <0 if projection point not on line segment
  ** returns distance to line segment, else
  */
Int32  WADLprojWhereI(pLVLOBJ Dml, Int16 Lin, Int16 X,Int16 Y);
  /*
  ** get square of distance from point X,Y to line
  */
Int32  WADLdistLineI(pLVLOBJ Dml, Int16 Lin, Int16 X,Int16 Y);
  /*
  ** Tell if point is in line Box
  ** returns >0 if point is in line box
  */
Int16 WADLinLineBoxI(pLVLOBJ Dml, Int16 Lin, Int16 X,Int16 Y);
  /* Find closest line
  **  (X,Y) = point
  ** returns ref of closest line, <0 if error
  */
Int16 WADLpointLineI(pLVLOBJ Dml, Int16 X, Int16 Y);
/*
** Sidedef
*/
  /*
  ** Read sidedef Lump
  */
Int16 WADLsideReadI(pLVLOBJ Dml,pInt8 Lmp, Int32 LmpSz);
  /*
  ** Get sidedef Lump
  */
pInt8 WADLsideGetLmpI(pLVLOBJ Dml,pInt32 pLmpSz);
  /*
  ** Point to closest sidedef
  **  (X,Y) = position of point
  ** returns ref of closets sidedef
  */
Int16 WADLsidePointI(pLVLOBJ Dml, Int16 X, Int16 Y);
  /*
  ** List textures used
  */
Int16 WADLsideListTexu(pLVLOBJ Dml,pTXTOBJ Txt);
  /*
  ** Set texture name
  **  Texu[NORMALISELEN+2] =  Upper[NORMALISELEN] Middle[NORMALISELEN] Lower[NORMALISELEN]
  */
Int16 WADLsideSetTexu(pLVLOBJ Dml, Int16 Sid, pInt8 Texu);
  /*
  ** Get texture name
  **  Texu[NORMALISELEN+2] =  Upper[NORMALISELEN] Middle[NORMALISELEN] Lower[NORMALISELEN]
  */
Int16 WADLsideGetTexu(pLVLOBJ Dml, Int16 Sid, pInt8 Texu);


/*
** Sector
*/
  /*
  ** Read sector
  */
Int16 WADLsectReadI(pLVLOBJ Dml,pInt8 Lmp, Int32 LmpSz);
  /*
  ** Get sector Lump
  */
pInt8 WADLsectGetLmpI(pLVLOBJ Dml,pInt32 pLmpSz);
  /*
  ** List flats used
  */
Int16 WADLsectListTexu(pLVLOBJ Dml,pTXTOBJ Txt);
  /*
  ** Set texture name
  **  Texu[NORMALISELEN+2] =  Ceil[NORMALISELEN] void[8] Floor[NORMALISELEN]
  */
Int16 WADLsectSetTexu(pLVLOBJ Dml, Int16 Sec, pInt8 Texu);
  /*
  ** Get texture name
  **  Texu[NORMALISELEN+2] =  Ceil[NORMALISELEN] void[8] Floor[NORMALISELEN]
  */
Int16 WADLsectGetTexu(pLVLOBJ Dml, Int16 Sec, pInt8 Texu);
/*
** Segs
*/
  /*
  ** Read segments
  */
Int16 WADLssegReadI(pLVLOBJ Dml,pInt8 Lmp, Int32 LmpSz);
  /*
  ** Draw segment
  **  Seg = segment to draw
  **  pBound = level and scale
  **  Color = color index
  ** supposes  cacheing vertex was started
  */
Int16 WADLssegDrawI(pLVLOBJ Dml, pBMPOBJ Bmp, Int16 Sg,pBOUND Bound,Int16 Color);
/*
** Sub Sector
*/
  /*
  ** Read sub sector
  */
Int16 WADLssecReadI(pLVLOBJ Dml,pInt8 Lmp, Int32 LmpSz);
  /*
  ** Draw subsector
  **  Sc = sub sector to draw
  **  pBound = level and scale
  **  Color = color index
  ** supposes  cacheing vertex was started
  */
Int16 WADLssecDrawI(pLVLOBJ Dml, pBMPOBJ Bmp, Int16 Sc,pBOUND Bound,Int16 Color);

/*
** Nodes
*/
  /*
  ** Read nodes
  */
Int16 WADLnodeReadI(pLVLOBJ Dml,pInt8 Lmp, Int32 LmpSz);
  /*
  ** Get the index to the top node
  */
Int16 WADLnodeGetTop(pLVLOBJ Dml);
  /*
  ** Get the child of a given node
  **  Node = node
  **  (X,Y) = coordinate of point designating the child
  ** returns reference of node, or <0 if error
  */
Int16 WADLnodeGetChild(pLVLOBJ Dml,Int16 Node, Int16 X, Int16 Y);
/*
** Reject
*/
  /*
  ** Read reject data
  */
Int16 WADLrejReadI(pLVLOBJ Dml,pInt8 Lmp, Int32 LmpSz);
  /*
  ** Save reject data
  */
pInt8 WADLrejGetLmpI(pLVLOBJ Dml, pInt32 pLmpSz);
  /*
  ** Get reject
  **  Sect = monster sector
  **  Targ = player sector
  ** returns 1 if Sect can see Targ, 0 if not, <0 if error
  */
Int16 WADLrejGetI(pLVLOBJ Dml,Int16 Sect, Int16 Targ);
  /*
  ** Set reject
  **  Sect = monster sector
  **  Targ = player sector
  **  Ops  = operation
  **        CANSEE = Sect can see Targ
  **        CANTSEE = inverse
  **        TOGGLE = toggle status
  **        SAFE  = No Sector can see Targ
  **        UNSAFE = All Sectors can see Targ
  ** returns 1 if Sect can see Targ 0 if not, <0 if error
  */
#define WADL_REJ_TOGGLE   0
#define WADL_REJ_SAFE     1
#define WADL_REJ_UNSAFE   2
#define WADL_REJ_CANTSEE  3
#define WADL_REJ_CANSEE   4
Int16 WADLrejSetI(pLVLOBJ Dml, Int16 Sect, Int16 Targ, Int16 Ops);

#endif /*DLLFORDOOM*/
