/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'U'

#include "lbwintex.h"
#include "lbcommon.h"
#include <stdlib.h>

#include "lbwad.h"
#include "lbdispl.h"
#include "lbsound.h"
#include "lbtext.h"

#include "lbwaddef.h"
#include "lbdoom.h"
#include "lbwaddir.h"
#include "lbwadir.h"
#include "lblumps.h"

/****************************************************\
*
*
*  Show Demos
*
*
\****************************************************/

#if (DLLFORDOOM)
/*
**
** Show Demos
**
*/
struct DMDEMO
{  Int8 Version; /*100+game*/
	Int8 Skill;
	Int8 Episode;
	Int8 Map;
	Int8 Multi;    /*0: Cooperative, 1: DeathMatch, 2: AltDeath*/
	Int8 Respawn;  /*0=off, !=0 = percent*/
	Int8 Fast;     /*0=off, !=0 = percent*/
	Int8 Nomonst;  /*0=off, !=0 = percent*/
	Int8 Viewer;   /*player that views 0-3*/
	Int8 Green;    /*0=play 1=no play*/
	Int8 Indigo;   /*0=play 1=no play*/
	Int8 Brown;    /*0=play 1=no play*/
	Int8 Red;      /*0=play 1=no play*/
};
typedef struct DMDEMO PTR *pDMDEMO;


Int16 WADshowDemo(pWADDEF This, Int16 Entry, pWINDOZE Wnd)
{ Int16 nbplay;
  Int32 sz;
  pDMDEMO Demo;
  Int8 *Str;
  TXTOBJ Txt;
  if(This==NULL){return BAD_PARM;}
  /*find pnames*/
  Demo=(pDMDEMO)WADreadEntryI(This,&sz,Entry);
  if(Demo==NULL) return BAD_ENTRY;
  /**/
  if(TXTinitWnd(&Txt,0,Wnd)<0)
  { return ERR_BUG; }
  /*version*/
  if(TXTprintFrm(&Txt,"Game demo (version %d.%d)",(Demo->Version)/100,(Demo->Version)%100)<0)
  { return ERR_BUG; }
  /*skill*/
  switch(Demo->Skill)
  {
	 case 0: Str="Very easy";break;
	 case 1: Str="Easy";break;
	 case 2: Str="Medium";break;
	 case 3: Str="Hard";break;
	 case 4: Str="Very Hard";break;
	 default: Str="?";break;
  }
  TXTprintFrm(&Txt,"Skill level: %s.",Str);
  /*map*/
  Strcpy(Buff,"Level:");
  if(This->Game & GAM_REGS)
  {
	 TXTprintFrm(&Txt,"Episode: %d.",Demo->Episode+1);
  }
  TXTprintFrm(&Txt,"Level: %d.",Demo->Map);
  /*nb of players*/
  nbplay=1;
  if(Demo->Indigo!=0)nbplay++;
  if(Demo->Brown!=0)nbplay++;
  if(Demo->Red!=0)nbplay++;
  TXTprintFrm(&Txt,"Nb of players: %d.",nbplay);
  if(nbplay<=1)
  { Str="Single player";}
  else
  { /*multiplayer*/
	 switch(Demo->Multi)
	 { case 0: Str="Cooperative";break;
		case 1: Str="Deathmatch";break;
		case 2: Str="Altdeath";break;
		default: Str="?";break;
	 }
  }
  TXTprintFrm(&Txt,"Game type: %s.",Str);
  /*viewpoint players*/
  TXTprintFrm(&Txt,"Recorder by player %d.",Demo->Viewer+1);
  /*duration*/
  if(nbplay>0)
  {
	 sz= (sz-sizeof(struct DMDEMO))/(4*nbplay);
  }
  TXTprintFrm(&Txt,"Duration: %d seconds.",(int)(sz/35));
  /**/
  Free(Demo);
  /**/
  TXTfree(&Txt);
  /**/
  return ELMPDMO;
}
#endif /*DLLFORDOOM*/




/****************************************************\
*
*
*  Show CGA screens as text
*
*
\****************************************************/

#if (DLLFORDOOM)||(DLLFORDUKE)
Int16 WADshowCGA(pWADDEF This, Int16 Entry, pWINDOZE Wnd)
{ Int16 x,y;
  pInt8 Lmp;
  Int32 LmpSz;
  TXTOBJ Txt;
  Int8 c;
  if(This==NULL){return BAD_PARM;}
  /*find pnames*/
  Lmp=WADreadEntryI(This,&LmpSz,Entry);
  if(Lmp==NULL) return BAD_ENTRY;
  if(LmpSz!=(80*2*25))
  {Free(Lmp); return BAD_ENTRY;}
  /**/
  if(TXTinitWnd(&Txt,0,Wnd)<0)
  { return ERR_BUG; }
  for(y=0;y<25;y++)
  { for(x=0;x<80;x++)
	 { c=Lmp[((y*80)+x)*2];
		if((c&0xE0)==0) c=' ';
		if(c==(Int8)0xFF) c=' ';
		Buff[x]=c;
	 }
	 Buff[80]='\0';
	 if(TXTprintName(&Txt,-1,Buff,80)<0)
	 { break; }
  }
  Free(Lmp);
  TXTfree(&Txt);
  return 1;
}
#endif /*DLLFORDOOM || DLLFORDUKE*/


/****************************************************\
*
*
*  Show Lump, as hex dump
*
*
\****************************************************/

static Int8 Hex(Int32 h)
{ Int8 c;c=(Int8)(h&0x0FL); return c+((c<0xA)?'0':'A'-0xA);}

static Int8 Dummy[256];

Int16 WADshowHex(pWADDEF This, Int16 Entry, pWINDOZE Wnd)
{
  Int16 col,x;
  pInt8 Lmp,TLmp;
  Int32 pos,LmpSz;
  Int16 c;
  TXTOBJ Txt;
  if(This==NULL){return BAD_PARM;}
  /*
  ** read lump
  */
  Lmp=WADreadEntryI(This,&LmpSz,Entry);
  if((Lmp==NULL)||(LmpSz<0)) return BAD_ENTRY;
  /**/
  if(TXTinitWnd(&Txt,0,Wnd)<0)
  { return ERR_BUG; }
  /**/
  for(TLmp=Lmp,pos=0;pos<LmpSz;pos+=16,TLmp+=16)
  { col=0;
	 /*position, in hexa*/
	 Dummy[(col)++]=Hex(pos>>16);
	 Dummy[(col)++]=Hex(pos>>12);
	 Dummy[(col)++]=Hex(pos>>8);
	 Dummy[(col)++]=Hex(pos>>4);
	 Dummy[(col)++]=Hex(pos);
	 Dummy[(col)++]=':';
	 /*data, in hexa*/
	 for(x=0;x<16;x++)
	 { if(pos+x>=LmpSz)break;
		if((x&0x1)==0) Dummy[(col)++]=' ';
		if(x==0x8) Dummy[(col)++]='-';
		if((x&0x3)==0) Dummy[(col)++]=' ';
		c=(Int16)TLmp[x];
		Dummy[(col)++]=Hex(c>>4);
		Dummy[(col)++]=Hex(c);
	 }
	 Dummy[(col)++]=' ';
	 Dummy[(col)++]=' ';
	 /*data, in text*/
	 for(x=0;x<16;x++)
	 { if(pos+x>=LmpSz)break;
		c=((Int16)TLmp[x])&0x7F;
		if((c<0x20)||(c==0x7F)) c='?';
		Dummy[(col)++]=(Int8)c;
	 }
	 Dummy[col]='\0';
	 if(TXTprintName(&Txt,-1,Dummy,col)<0)
	 { break; }
	 if(pos>0x2000)
	 {
		TXTprintName(&Txt,-1,"[Entry too long to be displayed] ",34);
		break;
	 }
  }
  Free(Lmp);
  /**/
  TXTfree(&Txt);
  /**/
  return 1;
}



/*
**
** Show Text into List box
**
*/
Int16 WADshowText(pWADDEF This, Int16 Entry, pWINDOZE Wnd)
{ pInt8 Lmp; Int32 LmpSz;
  TXTOBJ Txt;
  if(This==NULL) return ERR_BUG;
  Lmp=WADreadEntryI(This,&LmpSz,Entry);
  if(Lmp==NULL)  { return BAD_PARM;}
  /*upload data to list box*/
  if(TXTinitLmp(&Txt,Lmp,LmpSz)<0)
  { Free(Lmp); return ERR_BUG; }
  Free(Lmp);
  TXTputInWnd(&Txt,Wnd);
  TXTfree(&Txt);
  return 1;
}

/****************************************************\
*
*
*  Show Graphic lump
*
*
\****************************************************/


/*
** Show palette
*/
#if 0
Int16 WADplaypalToBmp(pWADDEF This, Int16 Entry)
{
  pInt8 Lmp; Int32 LmpSz;
  Int16 res;
  if(This==NULL) return ERR_BUG;
  Lmp=WADreadEntryI(This,&LmpSz,Entry);
  if(Lmp==NULL)  { return BAD_PARM;}
  res= BMPinitPlaypal(&(This->Bmp), Lmp, LmpSz);
  Free(Lmp);
  return res;
}
#endif /*0*/
/*
** Flat Heights and Width
*/
/*
** Flat picture width/height
*/
Int16 WADgetFlatWH(pInt16 pSzX, pInt16 pSzY, Int32 Size)
{ if((Size<=0L)||(Size>0x30000L))
  { return ERRfault(BAD_PICSZ);}
  switch(Size)
  { /*normal flats or patches*/
	 case 0x1000L: *pSzX=64;*pSzY=64;break;
	 /*heretic flats*/
	 case 0x1040L: *pSzX=64;*pSzY=65;break;
	 /*hexen flats*/
	 case 0x2000L: *pSzX=64;*pSzY=128;break;
	 /*quake chars*/
	 case 0x4000L: *pSzX=128;*pSzY=128;break;
	 /*TV info bar*/
	 case 8000L:   *pSzX=320;*pSzY=25;break;
	 /*TV status bar*/
	 case 20480L:  *pSzX=320;*pSzY=64;break;
	 /*TV help screen*/
	 case 27648L:  *pSzX=256;*pSzY=108;break;
	 /*Quake console*/
	 case 0x6000L: *pSzX=128;*pSzY=192;break;
	 /*DOOM/HEXEN/QUAKE title screen 320x200*/
	 case 64000L:  *pSzX=320;*pSzY=200;break;
	 /*TV map 256x256*/
	 case 0x10000L: *pSzX=256;*pSzY=256;break;
#if 0
	 /*HEXEN strange thing: STARTUP = 97x11x16x9  */
	 case 153648L: *pSzX=97*3;*pSzY=300;break;
#endif
	 /*default to 320x200 screen*/
	 default:      *pSzX=320;*pSzY=(Int16)(Size/320L);break;
  }
  return 0;
}
/*
** Flat
*/
Int16 WADflatToBmp(pWADDEF This, pBMPOBJ Bmp, Int16 Entry,pInt16 pOfsX,pInt16 pOfsY)
{ Int16 res;
  pInt8 Pic;
  Int32 PicSz;
  Int16 SzX,SzY;
  *pOfsX=INVALIDINT;
  *pOfsY=INVALIDINT;
  Pic=WADreadEntryI(This,&PicSz,Entry);
  if(Pic==NULL)
  { return BAD_PARM; }
  if(WADgetFlatWH(&SzX,&SzY,PicSz)<0)
  { Free(Pic); return BAD_PICSZ; }
  res=BMPinitFlat(Bmp,Pic,SzX,SzY);
  Free(Pic);
  return res;
}
/*
** Pictures
*/
#if (DLLFORDOOM)
Int16 WADpicToBmp(pWADDEF This, pBMPOBJ Bmp, Int16 Entry,pInt16 pOfsX,pInt16 pOfsY)
{ Int32 res;
  pInt8 Pic;
  Int32 PicSz;
  Int16 SzX,SzY;
  Pic=WADreadEntryI(This,&PicSz,Entry);
  if(Pic==NULL) return BAD_PARM;
  res=BMPinitDoomPic(Bmp,Pic,PicSz,pOfsX,pOfsY);
  if(res<=0) /*try to read a flat or heretic screen?*/
  { if(WADgetFlatWH(&SzX,&SzY,PicSz)<0)
	 { Free(Pic); return BAD_PICSZ; }
	 res=BMPinitFlat(Bmp,Pic,SzX,SzY);
  }
  Free(Pic);
  if(res<0) { return (Int16)res;}
  return 1;
}
#endif /*DLLFORDOOM*/

/*
** Play sound
*/
Int16 WADplaySound(pWADDEF This, Int16 Entry, Int16 Ops)
{
  pInt8 Lmp;
  Int32 LmpSz;
  Int16 res;
  if(This->Sound!=TRUE)
  { return 0;}
  Lmp=WADreadEntryI(This,&LmpSz,Entry);
  if(Lmp==NULL) { return BAD_PARM;}
  switch(Ops)
  { case WAD_SND_DOOM: /*play doom sound*/
		res=SNDdoomWriteWav(NULL,Lmp, LmpSz);
		break;
	 case WAD_SND_VOC:  /*play voc*/
		res=SNDvocWriteWav(NULL,Lmp,LmpSz);
		break;
	 case WAD_SND_WAV:  /*play WAV*/
		res=SNDwavPlay(Lmp,LmpSz);
		break;
  }
  Free(Lmp);
  return res;
}


#if (DLLFORDOOM)
/*
** Palette fiddling, with a colormap-like entry
** entry= reference of colormap. if -1, use COLORMAP
*/
Int16 EXPORT WADcolorMap(Int16 Self,Int16 Entry,Int16 Mapref)
{
  pInt8 Map;
  Int32 MapSz;
  Int16 Mappos;
  pWADDEF This;
  This=WADgetThis(Self);if(This==NULL){return BAD_PARM;}
  /*if Entry>0 read colormap from WAD*/
  if(Entry>=0)
  { Map=WADreadEntryI(This,&MapSz,Entry);
  }
  else /*read colormap from PWAD or main WAD*/
  { Map=WADreadObligEntryI(This,&MapSz,"COLORMAP");
  }
  if(Map==NULL) return ERRfault(ERR_COLNONE);
  Mappos=256*Mapref;
  /*apply colormap, if possible. else restore palette*/
  if((Mappos>=0)&&((Mappos+256)<MapSz))
	 BMPtransposePalette(&(This->Bmp),&Map[Mappos]);/*[0x100]*/
  else
  { BMPrestorePalette(&(This->Bmp));
	 Mapref=-1;
  }
  /*free colormap*/
  Free(Map);
  return Mapref;
}
#endif /*DLLFORDOOM*/

/****************************************************\
*
*
* DOOM Pictures
*
*
\****************************************************/

#if (DLLFORDOOM)
pInt8 WADloadFlat(pWADDEF This, pBMPOBJ Bmp,pInt32 pLmpSz, pInt8 File, Int16 Type)
{
  pInt8 Lmp; Int32 LmpSz;
  Int16 IsFlat;
  if(BMPinitBitmap(&(This->Bmp), File)<0)
  { return NULL;}
  IsFlat= BMPisFlat(Bmp,Type); /*Type = 1 or -1*/
  Lmp=BMPgetFlat(Bmp, &LmpSz);
  BMPfree(Bmp);
  if(Lmp==NULL)
  { return NULL;}
  if(IsFlat<=0)
  { ERRfaultWad((Type>0)?ERR_FLAT1:ERR_FLAT2);
    Free(Lmp); return NULL;
  }
  *pLmpSz=LmpSz;
  return Lmp;
}
pInt8 WADloadDoomPic(pWADDEF This, pBMPOBJ Bmp, pInt32 pLmpSz, pInt8 File, Int16 Entry, IDENT Id)
{
  pInt8 Lmp; Int32 LmpSz;
  Int16 OfsX,OfsY;
  /*
  ** get old offsets, if any existed
  **  returns default offsets, if none.
  */
  WADgetOffsetsI(This, Entry,&OfsX,&OfsY);
  if((Id&EMASK)==EPATCH)
  { OfsX=INVALIDINT;
    OfsY=INVALIDINT;
  }
  else if((Id&EMASK)==EGRAPHIC)
  { if(OfsX==INVALIDINT) OfsX=0;
    if(OfsY==INVALIDINT) OfsY=0;
  }
  /*read bitmap*/
  if(BMPinitBitmap(Bmp, File)<0)
  { return NULL;}
  /*load as Doom pic, null offsets*/
  Lmp=BMPgetDoomPic(Bmp, &LmpSz,OfsX,OfsY);
  BMPfree(Bmp);
  if(Lmp==NULL)
  { return NULL;}
  *pLmpSz = LmpSz;
  return Lmp;
}
#endif /*DLLFORDOOM*/

/****************************************************\
*
*
* Picture offsets, palette
*
*
\****************************************************/

#if (DLLFORDOOM)
/*
** set DOOM picture offsets
**
*/
struct DMPICOFFS
{ Int16 OfsX;
  Int16 OfsY;
};
static struct DMPICOFFS WADpicOfs;
/*
** set offsets
*/
static Int16 WADsetOffsetsI(pWADDEF This, Int16 Entry, Int16 OfsX, Int16 OfsY)
{ Int32 start,size,res;
  Int16 Id;
  if(This==NULL){return BAD_PARM;}
  if(WADmodifiableI(This)<=0) return ERR_SURE;
  Id=WADDgetEntryI(This,&start,&size,Entry);
  if((Id<0)||(size<4*sizeof(Int16))) {return (Int16)Id;}
  switch(Id & EMASK)
  { case ESPRITE: case EGRAPHIC: break;
	 default:  return ERRfault(BAD_ENTRY);
  }
  WADpicOfs.OfsX=OfsX;
  WADpicOfs.OfsY=OfsY;
  res=FILEwriteData((pInt8)&WADpicOfs,start+2*sizeof(Int16),sizeof(struct DMPICOFFS),This->File);
  if(res<=0) return (Int16)res;
  return 1;
}
/*
** get offsets
*/
Int16 WADgetOffsetsI(pWADDEF This, Int16 Entry, pInt16 pOfsX, pInt16 pOfsY)
{ Int32 start,size,res;
  Int16 Id;
  *pOfsX=INVALIDINT;
  *pOfsY=INVALIDINT;
  if(This==NULL){return BAD_PARM;}
  if((Entry<0)||(Entry>=This->LstNb))
  { return BAD_PARM;}
  Id=WADDgetEntryI(This,&start,&size,Entry);
  if((Id<0)||(size<4*sizeof(Int16)))
  {return (Int16)Id;}
  switch(Id & EMASK)
  { /*only some entries have offsets*/
	 case ESPRITE: case EGRAPHIC: case EPATCH:
		break;
	 default:
		return ERRfault(BAD_PARM);
  }
  res=FILEreadData((pInt8)&WADpicOfs,start+2*sizeof(Int16),sizeof(struct DMPICOFFS),This->File);
  if(res<0) return (Int16)res;
  *pOfsX=WADpicOfs.OfsX;
  *pOfsY=WADpicOfs.OfsY;
  return 1;
}



/*
** extern set offsets
*/
Int16 EXPORT WADsetOffsets(Int16 Self, Int16 Entry, Int16 OfsX, Int16 OfsY)
{ return WADsetOffsetsI(WADgetThis(Self),Entry, OfsX, OfsY);
}


#endif /*DLLFORDOOM*/




