/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'm'

#include "lbwintex.h"
#include "lbcommon.h"
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "lbmisc.h"


/*
** Normalised entry format: 29+1
** ########_####_####_=########_#.
**   entry   x    y     name    *
** 0        9    14    20       29
*/
#if 0
Int16 EXPORT TEXTentryMake(pInt8  Str,pInt8  entry,Int16 OfsX,Int16 OfsY,pInt8  name,Int16 Rep)
{ Int8 Entry[NORMALISELEN+NORMALISELEN+16];
  Int16 n;
  NormalizeS(&Entry[0],entry); /*entry*/
  for(n=NORMALISELEN;n<30;n++) Entry[n]=' ';
  if(name[0]!='\0')
  { Entry[NORMALISELEN+1+4+1+4]='='; /*name*/
	 NormalizeS(&Entry[NORMALISELEN+1+4+1+4+1],name);
	 Entry[NORMALISELEN+1+4+1+4+1+NORMALISELEN]=' ';
  }
  if(OfsX!=INVALIDINT)
  { NormalizeN(&Entry[NORMALISELEN+1],OfsX);
	 if(OfsY!=INVALIDINT)
		NormalizeN(&Entry[NORMALISELEN+1+4+1],OfsY);
  }
  if(Rep==VbTRUE) Entry[NORMALISELEN+1+4+1+4+1+NORMALISELEN+1]='*';
  Entry[NORMALISELEN+1+4+1+4+1+NORMALISELEN+1+1]='\0';
  Strncpy(Str,Entry,NORMALISELEN+1+5+5+NORMALISELEN+1+1);
  return NORMALISELEN+1+4+1+4+1+NORMALISELEN+1+1;/*0..29=30 byte of usefull info*/
}
/* parse entry
** return 0 if no entry, 1 else
*/
static Int16 TEXTnameParse(Int8 *Out,pInt8  In,Int16 InLen,Int16 ss)
{ Int16 s,p;
  Out[0]='\0';
  for(s=ss;s<InLen;s++)  /*search for non blank*/
  { if(In[s]!=' ') break;}
  if(s>=InLen) return InLen;
  for(p=0;s<InLen;s++,p++)
  { if(In[s]==' ')break;
	 if(p<NORMALISELEN) Out[p]=In[s];
  }
  if(p<NORMALISELEN+1)Out[p]='\0';
  Normalize(Out);
  Out[NORMALISELEN]='\0';
  return s;
}
/*
******************* parse an entry in wadinfo.txt
*/
Int16 EXPORT TEXTentryParse(pInt8  Str,pInt8  In)
{ static Int8 Entry[NORMALISELEN+2];
  static Int8 Dummy[NORMALISELEN+2];
  static Int8 Name[NORMALISELEN+2];
  Int16 InLen,s,p;
  Int16 ofx,ofy,rep;
  /*replace TAB by space, delete comments*/
  for(InLen=0;InLen<256;InLen++)
  { switch(In[InLen])
	 { case ';': case '#':   In[InLen]='\0'; break;
		case '\t': case '\n': In[InLen]=' ';break;
	 }
	 if(In[InLen]=='\0')break;
  }
  /*last Int8 could be 'repeat'*/
  rep=VbFALSE;
  for(p=InLen-1;p>0;p--)
  { if(In[p]=='*'){rep=VbTRUE;In[p]=' ';break;}
	 if(In[p]!=' ')break;
  }
  /*parse name*/
  s = TEXTnameParse(Entry,In,InLen,0);
  /*name defaults to entry name*/
  Strncpy(Name,Entry,NORMALISELEN);
  ofx=INVALIDINT;
  ofy=INVALIDINT;
  if(s<InLen)
  { /*read optional Int16*/
	 for(;s<InLen;s++) if(In[s]!=' ')break;
	 if(s<InLen)
		if(isdigit(In[s])||(In[s]=='-')||(In[s]=='+'))
		{ for(p=0;s<InLen;s++,p++)
	{ if(In[s]==' ')break;
	  if(p<NORMALISELEN) Dummy[p]=In[s];
	}
	if(p<NORMALISELEN+1)Dummy[p]='\0';
	ofx=atoi(Dummy);
	for(;s<InLen;s++) if(In[s]!=' ')break;
	if(s<InLen)
	  if(isdigit(In[s])||(In[s]=='-')||(In[s]=='+'))
	  { for(p=0;s<InLen;s++,p++)
		 { if(In[s]==' ')break;
			if(p<NORMALISELEN) Dummy[p]=In[s];
		 }
		 if(p<NORMALISELEN+1)Dummy[p]='\0';
		 ofy=atoi(Dummy);
	  }
		}
	 /*read optional = name */
	 for(;s<InLen;s++)
	 { if(In[s]=='=') break;
	 }
	 if(In[s]=='=')
	 { s++;   /*skip the equal*/
		s = TEXTnameParse(Name,In,InLen,s);
	 }
  }
  return TEXTentryMake(Str,Entry,ofx,ofy,Name,rep);
}
/*
**************** parse an entry in texture.txt **********
*/
/*
** result in pX, pY and Tname[10]
*/
Int16 TEXTtexuParse(Int8 *Tname, Int16 *pX,Int16 *pY,Int8 * In)
{ static Int8 Dummy[NORMALISELEN+2];
  static Int8 Name[NORMALISELEN+2];
  Int16 InLen,s,p;
  Int16 ofx,ofy;
  /*replace TAB by space, delete comments*/
  for(InLen=0;InLen<256;InLen++)
  { switch(In[InLen])
	 { case ';':  case '#':  In[InLen]='\0'; break;
		case '\t': case '\n': In[InLen]=' ';  break;
	 }
	 if(In[InLen]=='\0')break;
  }
  /*parse name*/
  s = TEXTnameParse(Name,In,InLen,0);
  if(s<=0) return VbFALSE;/*no name*/
  ofx=INVALIDINT;
  ofy=INVALIDINT;
  /*read Int16*/
  for(;s<InLen;s++) if(In[s]!=' ')break;
  if(s>=InLen) return VbFALSE;/*no offsets*/
  if(isdigit(In[s])||(In[s]=='-')||(In[s]=='+'))
  { for(p=0;s<InLen;s++,p++)
	 { if(In[s]==' ')break;
		if(p<NORMALISELEN) Dummy[p]=In[s];
	 }
	 if(p<NORMALISELEN+1)Dummy[p]='\0';
	 Dummy[NORMALISELEN+1]='\0';
	 ofx=atoi(Dummy);
  }
  else return VbFALSE;/*no offset X*/
  for(;s<InLen;s++) if(In[s]!=' ')break;
  if(s>=InLen)  return VbFALSE;/*no offset Y*/
  if(isdigit(In[s])||(In[s]=='-')||(In[s]=='+'))
  { for(p=0;s<InLen;s++,p++)
	 { if(In[s]==' ')break;
		if(p<NORMALISELEN) Dummy[p]=In[s];
	 }
	 if(p<NORMALISELEN+1)Dummy[p]='\0';
	 Dummy[NORMALISELEN+1]='\0';
	 ofy=atoi(Dummy);
  }
  else return VbFALSE;/*no offset Y*/
  *pX=ofx;
  *pY=ofy;
  Strncpy(Tname,Name,NORMALISELEN);
  return VbTRUE;
}

/*
**************** read lines in file *************
*/
static Int8 Line[128];
Int16 TXTcheckPatch(FILE *fp)  /*check if it's a patch line*/
{ Int16 c;
  c= fgetc(fp);
  if(c==EOF)return VbFALSE;
  if(c=='*')return VbTRUE;/*swallow '*' */
  ungetc(c,fp);
  return VbFALSE;
}
static Int16 TXTreadLine(FILE *fp)  /*read a line*/
{ Int16 c=' ';
  Int16 l=0;
  for(l=0;c!='\0';l++)
  { c= fgetc(fp); /*read line*/
	 if(c==EOF)
	 { if(l==0) return (Int16)FINISHED;
		else break;
	 }
	 else if(c=='\n')break;
	 else if(l<128)Line[l]=(c&0xFF);
  }
  if(l>=128) l=128-1;
  Line[l]='\0';
  for(l=0;l<128;l++) /*remove */
  { if((Line[l]==';')||(Line[l]=='#'))
	 { Line[l]='\0'; break;
	 }
  }
  return 1;
}
/*
************** read a [section] in wadinfo.txt ************
*/
Bool TEXTok=FALSE;
FILE *TEXTfp;
Int8 TEXTsection[10];/*section name, without []*/
Bool TEXTinside=FALSE;
/*init*/
Int16 EXPORT TEXTreadSectInit(pInt8  file,pInt8  section)
{ if(TEXTok==TRUE) return ERRfault(ERR_BUG);
  Strncpy(TEXTsection,section,NORMALISELEN);
  Strncpy(Buff,file,MAXPATHSZ-1);
  TEXTfp=fopen(Buff,"rt");
  if(TEXTfp==NULL) return ERRfault(ERR_OPENW);
  TEXTok=TRUE;
  Normalize(TEXTsection);
  TEXTsection[NORMALISELEN]='\0';
  TEXTinside=FALSE;
  return 1;
}
/*find a next section element, read it*/
Int16 EXPORT TEXTreadSection(pInt8  Str)
{ static Int8 Name[10];
  Int16 res=0,n=0;
  if(TEXTok!=TRUE) return ERRfault(ERR_BUG);
  while(1)   /*repeat until finds a texture part*/
  { res=TXTreadLine(TEXTfp);
	 if(res==FINISHED) break; /*EOF*/
	 if(Line[0]=='[') /*if a section header*/
	 { for(n=1;n<9;n++)    /*read section name*/
		{ if(Line[n]==']')break;
	Name[n-1]=Line[n];
		}
		Name[n-1]='\0';
		Normalize(Name);
		if(StrcmpI(Name,TEXTsection,NORMALISELEN))
	TEXTinside=TRUE;  /*starting the right section*/
		else
	TEXTinside=FALSE; /*another section*/
	 }
	 else if(TEXTinside==TRUE)
	 { /*parse entry*/
		res=TEXTentryParse(Str,Line);
		/*check is valid (non blank name)*/
		for(n=0;n<=NORMALISELEN;n++){ if(Str[n]!=' ')break;}
		if(n<NORMALISELEN) break; /*valid entry. return it, else seek next*/
	 }
  }
  if(res==FINISHED)
  { fclose(TEXTfp);TEXTok=FALSE;}
  return res;
}
/*
***************** read a texture.txt file *****************
*/
/*init*/
Int16 EXPORT TEXTreadTexuInit(pInt8  file)
{ if(TEXTok==TRUE) return ERRfault(ERR_BUG); /*once at the time*/
  Strncpy(Buff,file,MAXPATHSZ-1);
  TEXTfp=fopen(Buff,"rt");       /*open file*/
  if(TEXTfp==NULL) return ERRfault(ERR_OPENW);
  TEXTok=TRUE;
  return VbTRUE;
}
/*read texture. return size pat list, <0 when finished*/
Int16 EXPORT TEXTreadTexu(pInt8  Texu, pShort szX, pShort szY,pInt8  PatLst,Int16 PatLstSz)
{ Int16 res;
  static Int8 Tname[10];
  Int16 OfX,OfY;
  static Int8 Patch[16+1];
  Int32 LstSz=0;
  if(TEXTok!=TRUE) return ERRfault(ERR_BUG); /*is it initialised?*/
  while(1)
  { res=TXTreadLine(TEXTfp); /*seek first line containing a texture*/
	 if(res==FINISHED) break;
	 if(Line[0]=='*')continue;
	 if(TEXTtexuParse(Tname,&OfX,&OfY,Line)==VbTRUE) break;
  }
  if(res!=FINISHED)
  { NormalizeS(Tname,Tname);
	 Strncpy(Texu,Tname,NORMALISELEN);
	 *szX=OfX;
	 *szY=OfY;
	 /*read all patches*/
    PatLst[0]='\0';LstSz=0;
    while(TXTcheckPatch(TEXTfp)==VbTRUE)/* eats the '*' if needed*/
    { res=TXTreadLine(TEXTfp);
      if(res==FINISHED) break; /* EOF*/
      /*get patch if line contains one*/
      if(TEXTtexuParse(Tname,&OfX,&OfY,Line)==VbTRUE)
      { /*declare a patch*/
	/* LstSz+=TEXTpatchMake(Patch,(pInt8 )Tname,OfX,OfY);
	*/
	 Patch[16]='\0';
	 if(LstSz<PatLstSz) Strcat(PatLst,Patch);
      }
    }
  }
  if(res==FINISHED)     /*EOF*/
  { fclose(TEXTfp);
    TEXTok=FALSE;
    return (Int16)FINISHED;
  }
 return (Int16)LstSz;
}
#endif

