/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'P'

#include "lbwintex.h"
#include "lbcommon.h"
#include <stdlib.h>

#include "lbwad.h"
#include "lbdispl.h"
#include "lbtext.h"

#include "lbwaddef.h"
#include "lbdoom.h"
#include "lbwadir.h"
#include "lbwadid.h"
#include "lbpatch.h"


#if (DLLFORDOOM)
/****************************************************\
*
*
* Patch list cacheing API
*
*
\****************************************************/


/*
** PAT = Patches list handling
*/
#define ISFREEPATCH -1
/*
** size for memory allocations
*/
static Int32 WADPpatSz(Int16 Size)
{
  return (((Int32)Size+0xFL)&(~0xFL))*sizeof(struct PATCH);
}
/*
** Display PNAMES lump in a list
*/
Int16 WADPshowPnameI(pWADDEF This, Int16 Entry, pWINDOZE Wnd)
{ Int16 pnm,p;
  pInt8 Pnm;
  Int32 PnmSz,Size;
  pDMPATLST Pat;
  TXTOBJ Txt;

  if(This==NULL)
  { return BAD_PARM;}
  /*find pnames*/
  Pnm=NULL;
  Pnm=WADreadEntryI(This,&PnmSz,Entry);
  if(Pnm==NULL) return ERR_PATNONE;
  /**/
  Pat=(pDMPATLST)Pnm;
  pnm= (Int16)Pat->NbPatch;
  Size= sizeof(struct DMPATLST)-sizeof(PATNAME)+(Int32)pnm*sizeof(PATNAME);
  if((pnm<0)||(Size>PnmSz))
  { Free(Pnm);return ERRfaultWad(ERR_PATLST);}
  /**/
  TXTinitWnd(&Txt,NORMALISELEN,Wnd);
  for(p=0;p<pnm;p++)
  {
	 TXTprintName8(&Txt,p,Pat->Name[p],0);
  }
  TXTfree(&Txt);
  Free(Pnm);
  return 1;
}
/*
** Start cacheing patches
** Read PNAME Lump from this WAD of from main WAD.
*/
Int16 WADPinitI(pTXPOBJ Txp, pWADDEF This)
{ static Int16 pnm,p;
  static pInt8 Pnm;
  static Int32 PnmSz,Size;
  static pDMPATLST Pat;
  static pPATCH TPat;
  if(Txp==NULL) {return BAD_PARM;}
  /*checks*/
  if(Txp->Pat!=NULL) { return ERRfaultWad(ERR_PATLST);}
  if(Txp->PatNb!=0) { return ERRfaultWad(ERR_PATLST);}
  /*find pnames*/
  Pnm=WADreadObligEntryI(This, &PnmSz, "PNAMES");
  if(Pnm==NULL) { return ERRfaultWad(ERR_PATNONE);}
  /*alloc data for patch list*/
  /*get size: each pname entry is NORMALISELEN in length, start at 4*/
  /*first Int32 integer in PNAMES is the nb of patches*/
  Pat=(pDMPATLST)Pnm;
  pnm= (Int16)Pat->NbPatch;
  Size= sizeof(struct DMPATLST)-sizeof(PATNAME)+(Int32)pnm*sizeof(PATNAME);
  if((pnm<0)||(Size>PnmSz))
  { Txp->PatNb=0;Free(Pnm);return ERRfaultWad(ERR_PATLST);}
  Txp->PatNb= pnm;
  Txp->Pat=Malloc(WADPpatSz(Txp->PatNb));
  if(Txp->Pat==NULL)
  { Txp->PatNb=0;Free(Pnm);return ERR_MEM;}
  for(p=0,TPat=Txp->Pat; p<Txp->PatNb; p++,TPat+=1)
  { /*each pname entry is NORMALISELEN in length, start at 4*/
	 /*TPat = &(This->Pat[p])*/
	 Normalise(TPat->Name,Pat->Name[p]);
	 TPat->Bmp=NULL;
	 TPat->SzX=0;
	 TPat->SzY=0;
	 TPat->Num=p; /*ISFREEPATCH to be calculated when saving*/
  }
  Free(Pnm);
  return 1;
}
/*
** tell name of a patch, referenced by Pat
*/
Int16 WADPtellI(pTXPOBJ Txp, pInt8 Name, Int16 Pat)
{ if(Txp==NULL) return ERR_BUG;
  if(Txp->Pat==NULL) return ERRfaultWad(ERR_BUG);
  if((Pat<0)||(Pat>=Txp->PatNb)) return -1; /*not found*/
  Normalise(Name,Txp->Pat[Pat].Name);
  return 1;
}
/*
** find index for name. returns max if not founds
*/
Int16 WADPfindNameI(pTXPOBJ Txp, pInt8 Name)
{ static Int16 p;
  static pPATCH TPat;
  if(Txp==NULL) return ERR_BUG;
  if(Txp->Pat==NULL) return ERRfaultWad(ERR_BUG);
  for(p=0,TPat=Txp->Pat; p<Txp->PatNb; p++,TPat+=1)
  { if(Strncmp(TPat->Name,Name,sizeof(PATNAME)))
		return p; /*found*/
  }
  return -1;/*not found*/
}
/*
** Show a patch list
*/
Int16 WADPshowNameI(pTXPOBJ Txp, pWINDOZE Wnd)
{ Int16 p;
  static pPATCH TPat;
  TXTOBJ Txt;
  if(Txp==NULL) return ERR_BUG;
  if(Txp->Pat==NULL) return ERRfaultWad(ERR_BUG);
  /**/
  TXTinitWnd(&Txt,NORMALISELEN+10,Wnd);
  for(p=0,TPat=Txp->Pat; p<Txp->PatNb; p++,TPat+=1)
  {
	 TXTprintName8XY(&Txt,p,TPat->Name,TPat->SzX,TPat->SzY);
  }
  TXTfree(&Txt);
  return p;
}
/*
** find/declare a new patch name
*/
Int16 WADPaddI(pTXPOBJ Txp, pInt8 Name)
{ static Int16 p;
  static pPATCH TPat;

  p=WADPfindNameI(Txp,Name);
  if(p>=0) return p;/*already exists*/
  p=Txp->PatNb;
  Txp->PatNb+=1;
  if(WADPpatSz(p)!=WADPpatSz(Txp->PatNb))
  { Txp->Pat=Realloc(Txp->Pat,WADPpatSz(Txp->PatNb));
	 if(Txp->Pat==NULL)
	 { Txp->PatNb=0; return ERR_MEM;}
  }
  TPat=&(Txp->Pat[p]);
  Normalise(TPat->Name,Name);
  TPat->Bmp=NULL;
  TPat->SzX=0;
  TPat->SzY=0;
  TPat->Num=ISFREEPATCH; /*not determined yet*/
  return p;
}

/*
** This function is used to start cleaning up the
** patch list. it declares no patch is used
** (except those in Main WAD)
** it is critical that this function does not delete
** from the list patches used by TEXTURE1 or 2
*/
Int16 WADPusedNoneI(pTXPOBJ Txp)
{ Int16 p;
  static pPATCH TPat;
  if(Txp==NULL) return ERR_BUG;
  if(Txp->Pat==NULL) return ERRfaultWad(ERR_BUG);
  /*
  ** clear all patch count
  */
  Txp->PatRef=0;
  for(p=0,TPat=Txp->Pat; p<Txp->PatNb; p++,TPat+=1)
  {
	 TPat->Num = -1;
  }
  return 1;
}
/*
** Patch list cleanup, continued. to be called for each
** really used patch, of each texture
** declare that patch of name Name is used, returns Id
*/
Int16 WADPusedNameI(pTXPOBJ Txp, pInt8 Name)
{ Int16 p;
  static pPATCH TPat;
  p=WADPfindNameI(Txp,Name);
  if(p<0) return p;/*not found. no such patch*/
  /*
  **  get number of patch
  */
  TPat=&(Txp->Pat[p]);
  if(TPat->Num < 0)
  { /*
	 ** patch never considered before, give it a new number
	 */
	 if(Txp->PatRef<0) { Txp->PatRef=0; }
	 TPat->Num = Txp->PatRef;
	 if(Txp->PatRef< (Txp->PatNb-1))
	 { Txp->PatRef +=1; }
  }
  else
  { /*
	 ** If patch number is not reasonable, set it to zero
	 */
	 if((TPat->Num < 0)||( TPat->Num >= Txp->PatNb))
	 {
	  TPat->Num=0;
	 }
  }
  return TPat->Num;
}
/*
** save PNAMES Lump
*/
Int16 WADPsaveAllI(pTXPOBJ Txp,pWADDEF This)
{ Int16 p,used,ref;
  pInt8 Pnm;
  Int32 PnmSz;
  pPATCH TPat;
  pDMPATLST Pat;
  if((Txp==NULL)||(Txp->Pat==NULL))
  { return ERRfaultWad(ERR_BUG); }
  /*
  ** count used patches
  */
  for(used=0,p=0,TPat=Txp->Pat; p<Txp->PatNb; p++,TPat+=1)
  {
	 if(TPat->Num<0) continue; /*unused patch name*/
	 used+=1;
  }
  if(used<=0)
  { return ERRfaultWad(ERR_PATLST);}
#if 0
  if(Txp->PatRef != used)
  { ERRfaultWad(PAT_LST);
  } /*patch encoding error*/
#endif
  /*
  ** Allocate PNAME
  */
  PnmSz= sizeof(struct DMPATLST)+((Int32)used -1)*sizeof(PATNAME);
  if(PnmSz<=0)
  { return ERRfault(ERR_BUG);}
  Pnm=Malloc(PnmSz);
  if(Pnm==NULL)
  { return ERR_MEM;}
  /*
  ** fill PNAMEs
  */
  Pat=(pDMPATLST)Pnm;
  Pat->NbPatch=used;
  for(p=0,TPat=Txp->Pat; p<Txp->PatNb; p++,TPat+=1)
  {
	 ref=TPat->Num;
	 if(ref<0) continue; /*unused patch name*/
	 if(ref<used)
	 { Normalise(Pat->Name[ref],TPat->Name);
	 }
  }
  /*
  ** modify/insert entry
  */
  WADmodifyEntryI(This,0,EPNAME,"PNAMES",Pnm,PnmSz);
  Free(Pnm);
  return 1;
}
/*
** get the Bmp associated to patch, returns bytes,
** and size (SzX,SzY)
*/
pInt8 WADPcacheBmpI(pTXPOBJ Txp, pWADDEF This, pBMPOBJ Bmp, pInt8 Name)
{ static Int16 res,p,SzX,SzY;
  static Int32 PicSz;
  static pInt8 Pic;
  static pInt8 Lmp;
  static pPATCH TPat;
  /*
  ** The patch must exist already
  */
  p=WADPfindNameI(Txp,Name);
  if(p<0) { return NULL;}
  TPat=&(Txp->Pat[p]);
  /*
  ** Check if patch already cached
  */
  if(TPat->Bmp!=NULL)
  { return TPat->Bmp;}
  /*
  ** Cache Bmp
  ** read Patch in PWAD, and in main WAD if not found
  */
  Pic=WADreadObligEntryI(This, &PicSz, Name);
  if(Pic==NULL) /*not found*/
  { return NULL;}
  res=BMPinitDoomPic(Bmp,Pic,PicSz,&SzX,&SzY);
  Free(Pic);
  if(res<0){ return NULL;}
  /*
  ** Get pointer to bitmap, PicSz is ignored
  */
  Lmp=BMPfreeGift(Bmp,&SzX,&SzY,&PicSz);
  if(Lmp==NULL) {return NULL;}
  /*
  ** Store cached bitmap
  */
  TPat->Bmp=Lmp;
  TPat->SzX=SzX;
  TPat->SzY=SzY;
  return Lmp;
}
/*
** get Bmp associated to patch, returns bytes, (SzX,SzY)
*/
pInt8 WADPgetBmpI(pTXPOBJ Txp, pInt8 Name, pInt16 pSzX,pInt16 pSzY)
{ static Int16 p;
  static pPATCH TPat;
  *pSzX= *pSzY=0;
  p=WADPfindNameI(Txp,Name);
  if(p<0) { return NULL;}
  TPat=&(Txp->Pat[p]);
  /*
  ** Pat should have been cached before
  ** but it can also be a patch that was not found.
  */
  if(TPat->Bmp==NULL) /*no patch available*/
  { return NULL;}
  *pSzX=TPat->SzX;
  *pSzY=TPat->SzY;
  return TPat->Bmp;
}
/*
** Stop cacheing patches
*/
Int16 WADPfreeI(pTXPOBJ Txp)
{ static Int16 p;
  static pPATCH TPat;
  if(Txp==NULL) return ERR_BUG;
  if(Txp->Pat==NULL) return 0;
  /*for each patch, free it if needed*/
  for(p=0,TPat=Txp->Pat; p<Txp->PatNb; p++,TPat+=1)
  { if(TPat->Bmp!=NULL)
	 { Free(TPat->Bmp); }
  }
  Free(Txp->Pat);
  /*cleanup the mess*/
  Txp->Pat=NULL;
  Txp->PatNb=0;
  return 1;
}



/****************************************************\
*
*
* Texture parts API
*
*
\****************************************************/

/*
** Init a patch list, from NULL of from eventual DOOMPATCH
** WARNING: When initialising from DOOMPATCH, the WADP module
**          must have been initialised, and contain the list
**          of all avaialbe patches.
*/
static Int32 WADKsizeI(Int16 TexPsz)  /*minimun 16*/
{
  return (Int32)sizeof(struct TEXPAT)+((((Int32)TexPsz+1)+0xFL)&(~0xFL))*sizeof(struct PAT);
}
pTEXPAT WADKinitI(pTXPOBJ Txp,pDMPATCH DmPat,Int16 DmNbPat)
{
  pTEXPAT TexP;
  Int8 Name[NORMALISELEN+2];
  Int16 i;
  /*if init data=NULL, normal init*/
  if((DmPat==NULL)||(DmNbPat<=0)) DmNbPat=0;
  /*init*/
  TexP=Malloc(WADKsizeI(DmNbPat));
  if(TexP==NULL) return NULL;
  TexP->NbPat=DmNbPat;
  /*read data*/
  if(DmNbPat>0)
  { for(i=0;i<TexP->NbPat;i++) /*could find a patch*/
	 {
		TexP->P[i].OfsX=DmPat[i].OfsX;
		TexP->P[i].OfsY=DmPat[i].OfsY;
		/*
		** Get Name of patch from Index.
		** if error, put void name
		*/
		if(WADPtellI(Txp,Name,DmPat[i].Pidx)<=0)
		{ Name[0] = '\0'; }
		Normalise(TexP->P[i].Name,Name);
	 }
  }
  return TexP;
}
/*
** Tell nb of patches in list
*/
Int16 WADKlengthI(pTEXPAT TexP)
{ if(TexP==NULL) { return ERRfault(ERR_BUG);}
  return TexP->NbPat;
}
/*
** get the contents of a patch
*/
Int16 WADKgetPatI(pTEXPAT TexP,Int16 idx,pInt8 Name,pInt16 pOfsX, pInt16 pOfsY)
{ if(TexP==NULL) { ERRfault(ERR_BUG); return NULL;}
  if((idx<0)||(idx>=TexP->NbPat))return BAD_PARM;
  *pOfsX=TexP->P[idx].OfsX;
  *pOfsY=TexP->P[idx].OfsY;
  return Normalise(Name,TexP->P[idx].Name);
}
/*
** Compare two patch list, and return >0 if equal
*/
Int16 WADKcmpI(pTEXPAT TexP, pTEXPAT TexQ)
{ Int32 i,sz;
  pInt8 P,Q;
  if((TexP==NULL)||(TexQ==NULL)) { return ERRfault(ERR_BUG);}
  if(TexP->NbPat!=TexQ->NbPat) return -1; /*size differ*/
  P=(pInt8)(TexP->P); Q=(pInt8)(TexQ->P);
  sz=(TexP->NbPat)*sizeof(struct PAT);
  for(i=0;i<sz;i++)
  { if((P[i])!=(Q[i])) return -1;/*data differ*/
  }
  return 1; /*equal*/
}
/*
** Modify an existing patch in list
*/
Int16 WADKsetPatI(pTXPOBJ Txp,pTEXPAT TexP,Int16 Pat,pInt8 Name, Int16 OfsX, Int16 OfsY)
{ if(TexP==NULL) { return ERRfault(ERR_BUG);}
  if((Pat<0)||(Pat>=TexP->NbPat)) { return BAD_PARM;}
  if((Name!=NULL)&&(Name[0]!='\0'))
  { Normalise(TexP->P[Pat].Name,Name);
	 /*Declare an eventual new patch name*/
    WADPaddI(Txp, Name);
  }
  if(OfsX!=INVALIDINT) TexP->P[Pat].OfsX=OfsX;
  if(OfsY!=INVALIDINT) TexP->P[Pat].OfsY=OfsY;
  return Pat;
}
/*
** Add a patch to list. increase list size
*/
pTEXPAT WADKaddPatI(pTXPOBJ Txp,pTEXPAT TexP,pInt8 Name, Int16 OfsX, Int16 OfsY)
{ Int16 p;
  if(TexP==NULL) { ERRfault(ERR_BUG); return NULL;}
  /*limit size of patch list*/
  if(TexP->NbPat>64)
  { ERRfaultWad(ERR_PATNB); return NULL;}
  p=TexP->NbPat;
  TexP->NbPat+=1;
  if(WADKsizeI(TexP->NbPat)>WADKsizeI(p)) /*need realloc*/
  { TexP=(pTEXPAT)Realloc(TexP,WADKsizeI(TexP->NbPat));
	 if(TexP==NULL)
	 { return NULL;} /*malloc failed*/
  }
  WADKsetPatI(Txp,TexP,p,Name,OfsX,OfsY);
  return TexP;
}
/*
** Delete a patch from list
*/
pTEXPAT WADKdelPatI(pTEXPAT TexP,Int16 Pat)
{ Int16 p;
  if(TexP==NULL) { ERRfault(ERR_BUG); return NULL;}
  if((Pat<0)||(Pat>=TexP->NbPat)) {return TexP;}
  for(p=Pat+1;p<TexP->NbPat;p++)
  { Memcpy(&(TexP->P[p-1]),&(TexP->P[p]),sizeof(struct PAT));
  }
  p=TexP->NbPat;
  TexP->NbPat-=1;
  if(WADKsizeI(p)>WADKsizeI(TexP->NbPat)) /*need realloc*/
  { TexP=(pTEXPAT)Realloc(TexP,WADKsizeI(TexP->NbPat));
	 if(TexP==NULL)
	 { return NULL;}/*realloc failed*/
  }
  return TexP;
}
/*
** Free a patch list
*/
void WADKfreeI(pTEXPAT TexP)
{ if(TexP==NULL) { return;}
  Free(TexP);
}
/*
** duplicate a patch list.
*/
pTEXPAT WADKduplicateI(pTEXPAT TexP)
{
  pTEXPAT texp;
  if(TexP==NULL) { ERRfault(ERR_BUG); return NULL;}
  /*limit size of patch list*/
  if((TexP->NbPat>64)||(TexP->NbPat<0))
  { ERRfaultWad(ERR_PATNB); return NULL;}
  /*make new patch list*/
  texp=Malloc(WADKsizeI(TexP->NbPat));
  if(texp==NULL)
  { return NULL;}
  /*copy old patch list on new patch list*/
  Memcpy(texp,TexP,WADKsizeI(TexP->NbPat));
  return texp;
}
/*
** Copy a patch to a DOOM patch structure
** WARNING: require that the WADP module be initialised
**          and WADusedNone be called once before
** This is to retreive valid unique patch handles
**
*/
Int16 WADKcopyI(pTXPOBJ Txp,pDMPATCH DmPat, pTEXPAT TexP)
{ static Int16 p;
  /*check*/
  if((Txp==NULL)||(DmPat==NULL)||(TexP==NULL))
  { return ERRfault(ERR_BUG);}
  /*copy data*/
  for(p=0;p<TexP->NbPat;p++) /*could find a patch*/
  { /*Get Index from Name*/
	 DmPat[p].Pidx=WADPusedNameI(Txp,TexP->P[p].Name);
	 DmPat[p].OfsX=TexP->P[p].OfsX;
	 DmPat[p].OfsY=TexP->P[p].OfsY;
	 DmPat[p].dummy1=1L;
  }
  return 1;
}
#endif /*DLLFORDOOM*/

