/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'S'


#include "lbwintex.h"
#include "lbcommon.h"
#include <stdlib.h>
#include "lbwad.h"
#include "lbdispl.h"
#include "lbtext.h"

#include "lbwaddef.h"
#include "lbdoom.h"
#include "lbwaddir.h"
#include "lbwadir.h"
#include "lbwadid.h"
#include "lbquake.h"
#include "lbqkspr.h"



#if (DLLFORQUAK)
/****************************************************\
*
*
* Quake PACK sprites
*
*
\****************************************************/


/*
** SPR Directory Iterator
*/
typedef struct
{ pInt8 Dir;
  Int32 DirSz;   /*size of lump*/
  Int32 Pos;     /*position in lump*/
  pInt8 Pic;     /*pointer to picture*/
  Int32 SzX;     /*width*/
  Int32 SzY;     /*height*/
  Int16 NbSub;   /*remaining number of sub entries*/
  Int16 Entry;   /*current entry*/
}SPRDIR;
typedef SPRDIR PTR *pSPRDIR;

static Int16 SPRdirDirInit(pSPRDIR pDir, pWADDEF This, Int16 Entry)
{
  pQKSPRH Head;
  pDir->Dir=WADreadEntryI(This, &pDir->DirSz, Entry);
  if(pDir->Dir==NULL)
  { return -1;}
  Head=(pQKSPRH)pDir->Dir;
  if((pDir->DirSz<sizeof(QKSPRH))||(Strncmp(Head->Name,"IDSP",4)<=0))
  { Free(pDir->Dir); return ERRfault(BAD_ENTRY);}
  if(Head->Version<QKSPRVERSION)
  { Free(pDir->Dir); return ERRfault(ERR_VERSION);}
  /*pDir->NbEntry=(Int16)Head->FrameNb;*/
  pDir->Entry=-1;
  pDir->NbSub=-1;
  pDir->Pos=sizeof(QKSPRH);
  pDir->Pic=NULL;
  pDir->SzX=pDir->SzY=0;
  return 1;
}
static Int16 SPRdirNext(pSPRDIR pDir)
{
  pQKSPRID Head;
  pQKSPRPIC PicHead;
  Int32 PicSz;
  /**/
  pDir->Pic=NULL;
  if(pDir->Pos >= pDir->DirSz)
  { return -1; }
  /*
  ** Tag Entry
  */
  pDir->Entry+=1;
  /*
  ** If not inside a list of pictures
  */
  if(pDir->NbSub<=0)
  {
	 Head=(pQKSPRID)&(pDir->Dir[pDir->Pos]);
	 if(Head->Id==0)
	 {  /*single picture*/
		 pDir->Pos+=sizeof(Head->Id);
		 pDir->NbSub=-1;
	 }
	 else
	 {  /*multi picture list*/
		 pDir->NbSub=(Int16)Head->Nb;
		 /*check number of pictures*/
		 if((Head->Nb<1)||(Head->Nb>0x20))
		 { return ERRfault(BAD_ENTRY);}
		 /*move to first picture*/
		 pDir->Pos+= sizeof(QKSPRID) + (Head->Nb - 1)*sizeof(Float32);
	 }
  }
  /*
  ** Get picture, SzX, SzY
  */
  PicHead = (pQKSPRPIC)&(pDir->Dir[pDir->Pos]);
  pDir->Pos+= sizeof(QKSPRPIC);
  pDir->Pic = &(pDir->Dir[pDir->Pos]);
  pDir->SzX = PicHead->SzX;
  pDir->SzY = PicHead->SzY;
  /*
  ** check that picture is valid
  */
  PicSz= (PicHead->SzX) * (PicHead->SzY);
  if((PicSz<0)||(PicSz>0x100000L))
  { return -1;}
  /*
  ** skip picture
  */
  pDir->Pos += PicSz;
  /*
  ** If multi-picture list, take next picture in the list
  */
  if(pDir->NbSub>0)
  {
	 pDir->NbSub -=1;
  }
  return pDir->Entry;
}
static void SPRdirFree(pSPRDIR pDir)
{
  Free(pDir->Dir);
  pDir->Dir=NULL;
  pDir->Pic=NULL;
  /*do not reset Start, Size, SzX, SzY*/
}
  /*
  ** List Frames in Sprite picture
  */
Int16 SPRdirFramList(pWADDEF This, Int16 Entry, pWINDOZE Wnd)
{
  TXTOBJ Txt;
  SPRDIR Dir;
  Int8 Name[NORMALISELEN*2+2];
  if(TXTinitWnd(&Txt,NORMALISELEN*2,Wnd)<0)
  { return ERR_SURE;}
  /**/
  if(SPRdirDirInit(&Dir,This,Entry)<0)
  { TXTfree(&Txt); return BAD_ENTRY;}
  /**/
  while(SPRdirNext(&Dir)>=0)
  { /*
	 ** Print
	 */
	 Strcpy(Name,"Pic ");
	 StrcatNum(Name,(Dir.SzX&0xFFFFL),10);
	 Strcat(Name,"x");
	 StrcatNum(Name,(Dir.SzY&0xFFFFL),10);
	 /**/
	 if(TXTprintName(&Txt, Dir.Entry, Name, sizeof(Name))<0)
	 { break; }
  }
  /**/
  SPRdirFree(&Dir);
  /**/
  TXTfree(&Txt);
  /**/
  return 1;
}
Int16 SPRdirToBmp(pWADDEF This, pBMPOBJ Bmp, Int16 Entry,Int16 Sdir)
{
  Int16 res=-1;
  SPRDIR Dir;
  /**/
  if(SPRdirDirInit(&Dir,This,Entry)<0)
  { return BAD_ENTRY;}
  /**/
  while(SPRdirNext(&Dir)>=0)
  {
	 if(Dir.Entry<Sdir)
	 { continue; }
	 /*
	 ** Display as flat
	 */
	 if((Dir.Pic!=NULL)&&(Dir.SzX>0)&&(Dir.SzY>0))
	 {
		res=BMPinitFlat(Bmp,Dir.Pic,(Int16)Dir.SzX,(Int16)Dir.SzY);
	 }
	 break;
  }
  /**/
  SPRdirFree(&Dir);
  /**/
  return res;
}
#endif /*DLLFORQUAK*/
