/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'Y'


#include "lbwintex.h"
#include "lbcommon.h"
#include <stdlib.h>
#include "lbwad.h"
#include "lbdispl.h"
#include "lbtext.h"

#include "lbwaddef.h"
#include "lbquake.h"
#include "lbwaddir.h"
#include "lbwadir.h"
#include "lbwadid.h"
#include "lbqkpart.h"
#include "lbqktexu.h"


#if (DLLFORQUAK)
/****************************************************\
*
*
* Quake Textures
*
*
\****************************************************/
/*
** TexuSz= sizeof(QKMIPTEX)-sizeof(Texu->Pix)+TexuSz+(TexuSz>>2)+(TexuSz>>4)+(TexuSz>>6);
*/
Int32 BSPtexuSz(pQKMIPTEX Texu)
{
  Int32 TexuSz,PicSz,Top;
  Int16 t;
  if(Texu==NULL)
  { return 0;}
  /*typical size of picture*/
  PicSz= (Texu->SzX)*(Texu->SzY);
  /*minimum size*/
  TexuSz=sizeof(QKMIPTEX);
  /* Calculate the furthest pixel offset*/
  for(t=0; t<4; t++)
  { Top= Texu->Offs[t] + PicSz;
	 if(Top>TexuSz) TexuSz=Top;
	 PicSz >>=2; /*Picture reduced by 2*2 */
  }
  return TexuSz;
}

Int16 BSPtexuInit(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz)
{
  pQKTEXLIST Head;
  pQKMIPTEX  Texu;
  Int32 TexuSz;
  Int16 n;
  /**/
  Head=(pQKTEXLIST)Lmp;
  if((LmpSz<sizeof(QKTEXLIST))||(Head->Nb<0))
  { return BAD_ENTRY;}
  Bsp->TexuNb=Head->Nb;
  /*
  ** Check number of textures
  */
  if(Bsp->TexuNb<=0)
  { return ERRfault(BAD_ENTRY);}
  if(Bsp->TexuNb>=256)
  { /* Too many textures*/
	 ERRfault(BAD_ENTRY);
	 Bsp->TexuNb=256;
  }
  /*
  ** Create table of textures
  */
  /*Calloc(Bsp->TexuNb, sizeof(ppQKMIPTEX));*/
  Bsp->Texu=(ppQKMIPTEX)Malloc(Bsp->TexuNb*sizeof(ppQKMIPTEX));
  if(Bsp->Texu==NULL) { return ERR_MEM;}
  /*
  ** Read all textures
  */
  for(n=0; n<Bsp->TexuNb; n++)
  {
	 if((Head->Start[n]<0)||((Head->Start[n]+sizeof(QKMIPTEX))>LmpSz))
	 { /*illegal texture position*/
		ERRfault(ERR_STRUCT);
		Bsp->Texu[n]=NULL;
	 }
	 else
	 { /*
		** Calculate size of texture
		*/
		Texu= (pQKMIPTEX)&Lmp[Head->Start[n]];
		TexuSz=BSPtexuSz(Texu);
		/*
		** Check size
		*/
		if((TexuSz<0)||((Head->Start[n]+TexuSz)>LmpSz))
		{ /*illegal texture size*/
		  ERRfault(ERR_STRUCT);
		  Bsp->Texu[n]=NULL;
		}
		else
		{ /*create new texture*/
		  Bsp->Texu[n]=(pQKMIPTEX)Malloc(TexuSz);
		  if(Bsp->Texu[n]!=NULL)
		  { Memcpy(Bsp->Texu[n],Texu,TexuSz);}
		}
	 }
  }
  return 1;
}
/*
** Copy all texu into lump
** if Lmp==NULL or LmpSz<0, return lump size
*/
Int32 BSPtexuCopyAll(pBSPDEF Bsp, pInt8 Lmp, Int32 LmpSz)
{
  Int32 Start,Size,TexuSz;
  Int16 n;
  pQKTEXLIST Head;
  if((Bsp==NULL)||(Bsp->Texu==NULL)||(Bsp->TexuNb<0))
  { return ERR_BUG; }
  /**/
  Size= sizeof(QKTEXLIST)+ (Bsp->TexuNb-1)*sizeof(Int32);
  /*
  ** copy texture
  */
  Head=(pQKTEXLIST)Lmp;
  if((Lmp!=NULL)&&(Size<LmpSz))
  { Head->Nb=Bsp->TexuNb; }
  for(n=0; n<Bsp->TexuNb; n++)
  {
    Start=Size;
    TexuSz=BSPtexuSz(Bsp->Texu[n]);
    if(TexuSz>0)
    { Size+= (TexuSz+3)&(~3);}
    if((Lmp!=NULL)&&(Size<=LmpSz))
    {
      Head->Start[n]=Start;
      if(Bsp->Texu[n]!=NULL)
      { Memcpy(&Lmp[Start],Bsp->Texu[n],TexuSz);}
    }
  }
  return Size;
}

Int16 BSPtexuFree(pBSPDEF Bsp)
{
  Int16 n;
  /**/
  if(Bsp->Texu==NULL)
  { return -1;}
  /*
  ** Free all individual textures
  */
  if(Bsp->TexuNb>0)
  {
	 for(n=0; n<Bsp->TexuNb; n++)
	 {
		if(Bsp->Texu[n]!=NULL)
		{ Free(Bsp->Texu[n]); }
	 }
  }
  Free(Bsp->Texu);
  Bsp->Texu=NULL;
  Bsp->TexuNb=0;
  return 1;
}
/*
** Get Texture
*/
pQKMIPTEX BSPtexuGetI(pBSPDEF Bsp, Int16 Texu)
{
  if((Bsp==NULL)||(Bsp->Texu==NULL)||(Texu<0)||(Texu>=Bsp->TexuNb))
  { return NULL;}
  return Bsp->Texu[Texu];/*is a pointer*/
}
/*
** Check textures
*/
Int16 BSPtexuCheck(pBSPDEF Bsp, pTXTOBJ Txt)
{
  Int32 n; Int16 t,res;
  ppQKMIPTEX TTexu;
  pQKMIPTEX Texu;
  res=1;
  TXTprintName(Txt,QBSP_TEXU,"Checking Textures",-1);
  for(TTexu=Bsp->Texu,n=0; n<Bsp->TexuNb; n++,TTexu+=1)
  {
	 Texu = *TTexu;
	 if(Texu==NULL)
	 {
		TXTprintFrm(Txt," Texu %ld: bad format",n);
		res=-1;
		continue;
	 }
	 if((Texu->SzX & 0x7)||(Texu->SzY & 0x7))
	 {
		TXTprintFrm(Txt," Texu %ld: size not divisible by 8",n);
		res=-1;
	 }
	 for(t=0; t<4; t++)
	 {
		if(Texu->Offs[t] < sizeof(QKMIPTEX))
		{
			TXTprintFrm(Txt," Texu %ld: bad offset %d",n,t);
			res=-1;
		}
	 }
  }
  return res;
}
/****************************************************\
*
*
* Quake BSP directory show
*
*
\****************************************************/

/*
** BSP Directory Iterator
*/
typedef struct
{
  Int32  TexuStart; /*start of texture in BSP entry*/
  pQKTEXLIST TexuDir;
  Int32  Texu; /*texture number*/
  Int32  Start; /*start of entry, in BSP entry*/
}BSPDIR;
typedef BSPDIR PTR *pBSPDIR;


static Int16 BSPtexuDirInit(pBSPDIR Dir, pWADDEF This, Int16 Entry)
{
  pQKBSPHEAD Head;
  Int32 Nb,Start,Size;
  /*
  ** Read BSP header
  */
  Head=(pQKBSPHEAD)WADreadEntryPartI(This, Entry, 0, sizeof(QKBSPHEAD));
  if(Head==NULL)
  { return BAD_ENTRY;}
  Start=Head->Dir[QBSP_TEXU].Start;
  Size =Head->Dir[QBSP_TEXU].Size;
  Nb=Head->Id; /*store Nb, so as to free Head*/
  Free(Head);
  if(Nb<QKBSPVERSION)
  { return ERRfault(ERR_VERSION);}
  if((Start<sizeof(QKBSPHEAD))||(Size<sizeof(QKTEXLIST)))
  { return ERRfault(BAD_ENTRY);}
  Dir->TexuStart=Start;
  /*
  ** Read Texture lump
  */
  Dir->TexuDir=(pQKTEXLIST)WADreadEntryPartI(This,Entry,Start,sizeof(QKTEXLIST));
  if(Dir->TexuDir==NULL)
  { return BAD_ENTRY;}
  Nb= Dir->TexuDir->Nb;
  Free(Dir->TexuDir);
  if(Nb<=0)
  { return ERRfault(BAD_ENTRY);}
  Size= sizeof(QKTEXLIST)+(Nb-1)*sizeof(Int32);
  Dir->TexuDir=(pQKTEXLIST)WADreadEntryPartI(This,Entry,Start,Size);
  if(Dir->TexuDir==NULL)
  { return BAD_ENTRY; }
  Dir->Texu=-1;
  return 1;
}
static Int16 BSPtexuDirNext(pBSPDIR Dir)
{
  Int16 n;
  n= (Int16)(Dir->Texu+1);
  if((n<0)||(n>=Dir->TexuDir->Nb))
  { return -1; }/*last*/
  Dir->Texu = n;
  if(Dir->TexuDir->Start[n]<0)
  { Dir->Start = -1;}
  else
  { Dir->Start = Dir->TexuDir->Start[n]+ Dir->TexuStart;}
  return n;
}
static void BSPtexuDirFree(pBSPDIR Dir)
{
  Free(Dir->TexuDir);
  Dir->TexuDir=NULL;
  /*do not reset the rest*/
}
/*
** List Textures in BSP model
*/
Int16 BSPtexuDirList(pWADDEF This, Int16 Entry, pWINDOZE Wnd)
{ TXTOBJ Txt;
  BSPDIR Dir;
  Int8 Name[32+2];
  pQKMIPTEX Texu;
  /**/
  if(This==NULL){return BAD_PARM;}
  /**/
  if(TXTinitWnd(&Txt,sizeof(Name),Wnd)<0)
  { return ERR_BUG; }
  /*
  ** read directory lump
  */
  if(BSPtexuDirInit(&Dir, This, Entry)<0)
  { TXTfree(&Txt); return BAD_ENTRY ;}
  /*
  ** List directory
  */
  while(BSPtexuDirNext(&Dir)>=0)
  { /*
	 ** Print
	 */
	 if(Dir.Start<0) /*invalid texture ref, skip it*/
	 { continue;}
	 Texu=(pQKMIPTEX)WADreadEntryPartI(This,Entry,Dir.Start,sizeof(QKMIPTEX));
	 if(Texu==NULL)  /*bad texture*/
	 { continue; }
	 Strncpy(Name,Texu->Name,sizeof(Texu->Name));
	 if(TXTprintName(&Txt, Dir.Texu, Name, 0)<0)
	 { break; }
  }
  /**/
  BSPtexuDirFree(&Dir);
  /**/
  TXTfree(&Txt);
  /**/
  return 1;
}
/*
** Get Bsp entry as Bmp
*/
Int16 BSPtexuDirToBmp(pWADDEF This, pBMPOBJ Bmp,Int16 Entry, Int16 Sdir, Bool ShowMip)
{
  BSPDIR Dir;
  pQKMIPTEX Texu;
  Int32 TexuSz;
  pInt8 Lmp;
  Int16 res,SzX,SzY;
  /**/
  if(This==NULL)
  { return ERRfault(ERR_BUG);}
  /*
  ** read directory lump
  */
  if(BSPtexuDirInit(&Dir, This, Entry)<0)
  { return BAD_ENTRY;}
  /*
  ** Search directory
  */
  while(BSPtexuDirNext(&Dir)>=0)
  {
	 if(Dir.Texu>=Sdir)
	 { break; }
  }
  /**/
  BSPtexuDirFree(&Dir);
  if(Dir.Start<=0)
  { return BAD_ENTRY;}
  /**/
  Texu=(pQKMIPTEX)WADreadEntryPartI(This,Entry,Dir.Start,sizeof(QKMIPTEX));
  if(Texu==NULL)
  { return BAD_ENTRY;}
  TexuSz=BSPtexuSz(Texu);
  Free(Texu);
  Texu= (pQKMIPTEX)WADreadEntryPartI(This, Entry, Dir.Start, TexuSz);
  if(Texu==NULL)
  { return BAD_ENTRY;}
  Lmp=(pInt8)Texu;
  SzX= (Int16)Texu->SzX;
  SzY= (Int16)Texu->SzY;
  if((SzX>0)&&(SzY>0)&&(SzX<=2048)&&(SzY<=2048))
  { if(ShowMip==TRUE)
	 {
		res=BMPinitMipTex(Bmp, (pInt8)Texu, TexuSz, SzX, SzY, &Texu->Offs[0]);
	 }
	 else
	 {
		res=BMPinitFlat(Bmp, &Lmp[Texu->Offs[0]], SzX, SzY);
	 }
  }
  Free(Texu);
  return res;
}

  /*
  ** Make WAD entry into picture
  */
Int16 BSPtexuToBmp(pWADDEF This, pBMPOBJ Bmp, Int16 Entry)
{
  pQKMIPTEX Texu;
  Int32 TexuSz;
  pInt8 Lmp;
  Int16 res,SzX,SzY;
  Texu=(pQKMIPTEX)WADreadEntryI(This,&TexuSz,Entry);
  if(Texu==NULL)
  { return BAD_ENTRY;}
  Lmp=(pInt8)Texu;
  SzX= (Int16)Texu->SzX;
  SzY= (Int16)Texu->SzY;
  if((SzX>0)&&(SzY>0)&&(SzX<=2048)&&(SzY<=2048))
  {
    /*res=BMPinitMipTex(Bmp, (pInt8)Texu, TexuSz, SzX, SzY, &Texu->Offs[0]);*/
    res=BMPinitFlat(Bmp, &Lmp[Texu->Offs[0]], SzX, SzY);
  }
  Free(Texu);
  return res;
}

#endif /*DLLFORQUAKE*/
