/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'S'


#include "lbwintex.h"
#include "lbcommon.h"
#include "lbwad.h"
#include "lbdoom.h"
#include "lbsound.h"
#include <stdio.h>
/*windows sound*/
#if defined __WINDOWS__
#include <windows.h>
#include <mmsystem.h>
#endif
/*
** Play wav data, allocated with MallocSpecial
*/
static Int16 SNDwavPlayI(pInt8 wav);

/****************************************************\
*
*
* Play sounds
*
*
\****************************************************/
/*
** Play a sound from WAV file in memory
** returns false if error.
** memory shall be later freed,
** when sound is over.
*/
static pInt8 SNDwav=NULL;
static Int16 SNDwavPlayI(pInt8 wav)
{ Int16 res;
  /*
  ** stop previous sound
  */
#if defined __WINDOWS__
  sndPlaySound(NULL,SND_ASYNC); /*stop*/
#endif
  if(SNDwav!=NULL)
  { Free(SNDwav); SNDwav=NULL;}
  if(wav!=NULL)
  {
    /*
    ** stop previous sound, play new sound
    */
#if defined __WINDOWS__
    res=sndPlaySound((LPSTR)wav,SND_ASYNC|SND_MEMORY|SND_NODEFAULT);
#endif
    if(res<0)
    { Free(wav);return BAD_PARM;}
    SNDwav=wav;
  }
  return 1;
}
/****************************************************\
*
*
* Convert sample stereo or 16 bit into 8 bit
*
*
\****************************************************/

Int32 SNDsmplChangeNbits(pInt8 Smpl,Int32 SmplSz, Bool Bit16, Bool Stereo)
{
  pInt8 TSmpl,TSmpl2;
  Int32 s,size=SmplSz,step=1;
  Int8 Add=0;
  if(Bit16==TRUE)
  { size>>=1; step<<=1; Add=(Int8)0x80;}
  if(Stereo==TRUE)
  { size>>=1; step<<=1;}
  if(step<=1) { return SmplSz; }
  TSmpl2=&Smpl[1];
  for(TSmpl=Smpl,s=0; s<size; s++,TSmpl+=1,TSmpl2+=step)
  { *TSmpl= (*TSmpl2)+Add; }
  return size;
}


/****************************************************\
*
*
* Convert sample rate
*
*
\****************************************************/

/*
** Sample rate conversion
** Smpl is swallowed
*/
#if 0
#define PRECISION  (8)
pInt8 SNDsmplChangeRate(Int32 *pDtaSz,Int32 Rate,pInt8 Smpl,Int32 SmplSz,Int32 SmplRate)
{ Int32 DtaSz,s,ss;
  pInt8 Dta, TDta, TSmpl;
  Int32 factor;
  /**/
  if((Smpl==NULL)||(SmplSz<=0)) return NULL;
  if((Rate<4096)||(SmplRate<4096)) return NULL;
  if(SmplRate==Rate)
  { *pDtaSz=SmplSz; return Smpl; }
  /*conversion factor*/
  factor=(Rate<<PRECISION)/SmplRate;
  /*allocate memory for samples*/
  DtaSz=(SmplSz*factor)>>PRECISION;
  Dta=Malloc(DtaSz);
  if(Dta==NULL) return NULL;
  /*Expand/shrink to the target sample Rate*/
  /*Shrink: BEWARE OF ALIASING. LOWER-PASS FILTER FIRST
  */
  /* Expand: should put zeroes, then lower pass filter
  ** instead, we repeat samples. this is a stupid lower pass
  ** that doesn't kill all high frequencies.
  */
  factor=(SmplRate<<PRECISION)/Rate;
  for(s=0,TDta=Dta; s<DtaSz; s++,TDta+=1)
  { ss=(s*factor)>>PRECISION;
	 TSmpl= &Smpl[ss];
	 TDta[0] = TSmpl[0];
  }
  /*Free original sample*/
  Free(Smpl);
  /*Return*/
  *pDtaSz=DtaSz;
  return Dta;
}
#endif

/****************************************************\
*
*
*  WAV read/write
*
*
\****************************************************/

/*
** SAMPLE <-> WAV Conversion Functions
*/
struct RIFFHEAD /*RIFF file header*/
{ Int8 riff[4];
  Int32 length;
  Int8 wave[4];
};
typedef struct RIFFHEAD PTR *pRIFFHEAD;
struct CHUNK           /*general RIFF data chunk header*/
{ Int8 name[4];
  Int32 size;
};
struct WAVEFMT         /*RIFF format*/
{ Int8 name[4];
  Int32 size;
  Int16 tag; Int16 channel;
  Int32 smplrate; Int32 bytescnd;
  Int16 align;   Int16 nbits;
};
struct WAVEDATA        /*RIFF data*/
{ Int8 name[4];
  Int32 size;
};
struct WAVEHEAD
{ struct RIFFHEAD rif;
  struct WAVEFMT  fmt;
  struct WAVEDATA dta;
};
typedef struct WAVEHEAD PTR *pWAVEHEAD;
/*
** Play or save a sample
** Convert a 8-bit sample (Bps bytes per samples) to Wav
*/
Int16 SNDsmplWriteWav(pInt8 File, pInt8 Smpl, Int32 Size, Int32 Rate)
{
  pInt8 wav;
  Int32 wavSz;
  pWAVEHEAD whead;
  if((Size<=0)||(Smpl==NULL))
  { return NULL;}
  /*
  ** Special Malloc, because sndPlaySound() wants
  ** memory allocated with GMEM_MOVEABLE
  */
  wav=MallocSpecial(sizeof(struct WAVEHEAD)+Size);
  if(wav==NULL)
  { return NULL;}
  /*
  ** Copy sound
  */
  Memcpy(&wav[sizeof(struct WAVEHEAD)],Smpl,Size);
  whead = (pWAVEHEAD)wav;
  Strncpy(whead->rif.riff,"RIFF",4);
  whead->rif.length=(sizeof(struct RIFFHEAD)-8+sizeof(struct WAVEFMT)+sizeof(struct WAVEDATA)+Size);
  Strncpy(whead->rif.wave,"WAVE",4);
  Strncpy(whead->fmt.name,"fmt ",4);
  whead->fmt.size=sizeof(struct WAVEFMT)-8;
  whead->fmt.tag=1;          /*type=Pulse Code Modulation*/
  whead->fmt.channel=1;      /*1 channel*/
  whead->fmt.smplrate=((Int32)Rate)&0xFFFFL; /*sample per second*/
  whead->fmt.bytescnd=((Int32)Rate)&0xFFFFL;
  whead->fmt.align=1;        /*block align on bytes*/
  whead->fmt.nbits=8;        /*8 bit samples*/
  Strncpy(whead->dta.name,"data",4);
  whead->dta.size=Size;
  wavSz= sizeof(struct WAVEHEAD)+Size;
  /*
  ** Play or save sound
  */
  if(File==NULL)
  { return SNDwavPlayI(wav); }
  wavSz=FILEwriteData(wav,0,wavSz,File);
  Free(wav);
  if(wavSz<0) {return (Int16)wavSz;}
  return 1;
}
static Int32 SNDwavSeekChunk(pInt8  File,Int32 start,pInt8 name)
{
  Int32 pos;
  Int16 n;
  struct CHUNK chunk;
  pos=start;
  for(n=0;n<256;n++)
  { if(FILEreadData((pInt8 )&chunk,pos,sizeof(struct CHUNK),File)<0)
	 { return ERRfault(BAD_FILE);}
	 if(chunk.size<0)
	 { return ERRfault(ERR_BADFMT);}
	 /*
	 ** found the right chunk
	 */
	 if(Strncmp(chunk.name,name,4))
	 { return pos;}
	 pos+= chunk.size + sizeof(struct CHUNK);
  }
  return ERRfault(ERR_BADFMT);
}
/*
** Read Wav file
*/
pInt8 SNDsmplReadWav(pInt8 File, pInt32 pSize, pInt32 pRate)
{
  struct RIFFHEAD riff;
  struct WAVEFMT fmt;
  struct WAVEDATA dta;
  pInt8 Smpl;
  Int32 SmplSz,start,res;
  Bool Stereo=FALSE,Bit16=FALSE;
  FILEreadData((pInt8 )&riff,0,sizeof(struct RIFFHEAD),File);
  /*check RIFF header */
  if(!(Strncmp(riff.riff,"RIFF",4)&&Strncmp(riff.wave,"WAVE",4)))
  {ERRfault(BAD_FILE); return NULL;}
  /*look for fmt  */
  start=SNDwavSeekChunk(File,sizeof(struct RIFFHEAD),"fmt ");
  if(start<0) return NULL;
  res=FILEreadData((pInt8 )&fmt,start,sizeof(struct WAVEFMT),File);
  if(res<0)
  { return NULL;}
  /*check fmt*/
  if(fmt.tag!=1)
  { ERRfault(ERR_NOTSRAW); return NULL;}
  switch(fmt.nbits)
  { case 16: Bit16=TRUE; break;
	 case 8:  break;
	 default: ERRfault(ERR_NOT8BIT); return NULL;
  }
  if(fmt.channel!=1)
  { ERRfault(ERR_NOTMONO); return NULL;}
  if(fmt.size<0)
  { ERRfault(ERR_BADFMT);return NULL;}
  start+= (sizeof(struct CHUNK)+fmt.size);
  /*look for "data"=0x61746164L*/
  start=SNDwavSeekChunk(File,start,"data");
  if(start<0) return NULL;
  res=FILEreadData((pInt8 )&dta,start,sizeof(struct WAVEDATA),File);
  if(res<0)
  { return NULL;}
  /*check data*/
  if(dta.size<0)
  { ERRfault(ERR_BADFMT);return NULL;}
  /*
  ** Read samples
  */
  SmplSz=dta.size;
  Smpl=Malloc(SmplSz);
  if(Smpl==NULL)
  { ERRfault(ERR_MEM);return NULL;}
  res=FILEreadData(Smpl,start+sizeof(struct WAVEDATA),SmplSz,File);
  if(res<0)
  { Free(Smpl); return NULL;}
  /*
  ** convert
  */
  SmplSz=SNDsmplChangeNbits(Smpl,SmplSz,Bit16,Stereo);
  /*return*/
  *pRate=(Int16)(fmt.smplrate);
  *pSize=SmplSz;
  return Smpl;
}


/*
**  play a DOOM sound or save it to file
**
*/
Int16 SNDwavPlay(pInt8 Lmp, Int32 LmpSz)
{
  pInt8 Wav;
  pRIFFHEAD Head;
  /*
  ** Convert DOOM sound to sample
  */
  if(LmpSz<=sizeof(struct WAVEHEAD))
  { return ERRfault(ERR_BADSND);}
  Head=(pRIFFHEAD)Lmp;
  if(!(Strncmp(Head->riff,"RIFF",4)&&Strncmp(Head->wave,"WAVE",4)))
  { return ERRfault(ERR_BADSND);}
  Wav=MallocSpecial(LmpSz);
  if(Wav==NULL) { return ERR_MEM;}
  Memcpy(Wav,Lmp,LmpSz);
  /*do not free Wav*/
  return SNDwavPlayI(Wav);
}



/****************************************************\
*
*
*  DOOM Sound
*
*
\****************************************************/


/*
** Read Wav file into DOOM sound.
** if Rate>0 then addapt to rate.
*/
#if (DLLFORDOOM)
pInt8 SNDdoomReadWav(pInt8 File, pInt32 pLmpSz,Int32 Rate)
{
  Int32 Rat2;
  pInt8 Smpl;
  Int32 SmplSz;
  pInt8 Lmp;
  static pDMSNDHEAD Head;
  /*
  ** Read Wav file
  */
  Smpl=SNDsmplReadWav(File,&SmplSz,&Rat2);
  if(Smpl==NULL) return NULL;
  /*convert rate to Rate, if needed*/
#if 0
  if(Rate>0)
  { Smpl=SNDsmplChangeRate(&SmplSz,Rate,Smpl,SmplSz,Rat2);
	 if(Smpl==NULL) return NULL;
  }
  else
#endif
	 Rate=Rat2;
  /*
  ** Convert sample to DOOM sound
  */
  Lmp=Malloc(sizeof(struct DMSNDHEAD)+SmplSz);
  if(Lmp==NULL) {Free(Smpl); return NULL;}
  Memcpy(&Lmp[sizeof(struct DMSNDHEAD)],Smpl,SmplSz);
  Free(Smpl);
  /*prepare header*/
  Head=(pDMSNDHEAD)Lmp;
  Head->Ident=3; /*DOOM sound id=3*/
  Head->Rate=(Int16)Rate;
  Head->Size=SmplSz;
  *pLmpSz=sizeof(struct DMSNDHEAD)+SmplSz;
  return Lmp;
}

/*
**  play a DOOM sound or save it to file
**
*/
Int16 SNDdoomWriteWav(pInt8  File,pInt8 Lmp, Int32 LmpSz)
{
  pInt8 Smpl;
  pDMSNDHEAD Head;
  Int32 SmplSz;
  Int32 Rate;
  /*
  ** Convert DOOM sound to sample
  */
  if(LmpSz<=sizeof(struct DMSNDHEAD))
  { return ERRfault(ERR_BADSND);}
  Head=(pDMSNDHEAD)Lmp;
  if((Head->Ident!=3)||(Head->Size<0)) /*3=DOOM code for WAV sounds*/
  { return ERRfault(ERR_BADSND);}
  Rate=((Int32)Head->Rate)&0xFFFFL;
  if(Rate<1000)
  { return ERRfault(ERR_BADSND);}
  Smpl=&Lmp[sizeof(struct DMSNDHEAD)];
  SmplSz= LmpSz-sizeof(struct DMSNDHEAD);
  if(SmplSz>Head->Size) SmplSz=Head->Size;
  /*
  ** Save sample to WAV
  */
  SNDsmplWriteWav(File,Smpl,SmplSz,Rate);
  /*Free(Smpl); no!*/
  return 1;
}
#endif /*DLLFORDOOM*/

/****************************************************\
*
*
*  VOC Sound
*
*
\****************************************************/
struct VOCHEAD
{ Int8  Ident[0x13];  /*0x13 "Creative Voice File"*/
  Int8  Eof;       /*0x1A*/
  Int16 Block;   /*offset to block1=0x1A*/
  Int16 Version;  /*0x010A*/
  Int16 Version2; /*0x2229*/
};
typedef struct VOCHEAD PTR *pVOCHEAD;

struct VOCBLOCK   /*Block type*/
{ Int8  Type;
  Int8  SizeL;
  Int8  SizeM;
  Int8  SizeU;
};
typedef struct VOCBLOCK PTR *pVOCBLOCK;

struct VOCBLOCK1   /*Block type 1*/
{ Int8  Rate;   /*sample_rate = 1000000/(256- Rate)*/
  Int8  Cmprs;  /*0=no compression*/
};
typedef struct VOCBLOCK1 PTR *pVOCBLOCK1;
struct VOCBLOCK9   /*Block type 9*/
{ Int16 Rate;   /*sample_rate = Rate)*/
  Int16 Cmprs;
  Int8  Bits;  /*8 bits*/
  Int8  Stereo; /*1=Stereo*/
  Int32 Dum;    /*0*/
  Int16 Dum0;   /*0*/
};
typedef struct VOCBLOCK9 PTR *pVOCBLOCK9;
/*
**  play a VOC sound or save it to WAV file
*/
Int16 SNDvocWriteWav(pInt8 File,pInt8 Lmp, Int32 LmpSz)
{
  pInt8 Smpl;
  pVOCHEAD Head;     pVOCBLOCK Block;
  pVOCBLOCK1 Block1; pVOCBLOCK9 Block9;
  Int32 SmplSz, Rate, Pos;
  Bool Stereo=FALSE,Bit16=FALSE;
  if(LmpSz<=sizeof(struct VOCHEAD))
  { ERRfault(ERR_BADSND); return NULL;}
  Head=(pVOCHEAD)Lmp;
  if(! Strncmp(Head->Ident,"Creative",8))
  { return ERRfault(ERR_BADVOC);}
  /*
  ** Find first Block
  */
  if((Head->Block<=0)||(Head->Block > LmpSz))
  { return ERRfault(ERR_BADVOC);}
  Pos = Head->Block;
  /*
  ** Generic VOC Block
  */
  Block = (pVOCBLOCK) &Lmp[Pos];
  Pos += sizeof(struct VOCBLOCK);
  SmplSz= ((((((Int32)Block->SizeU)& 0xFFL)<<8) + (((Int32)Block->SizeM)&0xFFL))<<8) + (((Int32)Block->SizeL)&0xFFL);
  /*
  ** Block Type
  */
  switch(Block->Type)
  { case 1:
		Block1 = (pVOCBLOCK1) &Lmp[Pos];
		Pos    += sizeof(struct VOCBLOCK1);
		SmplSz -= sizeof(struct VOCBLOCK1);
		Rate = 1000000L/(256L- (((Int32)Block1->Rate)&0xFF));
		break;
	 case 9:
		Block9 = (pVOCBLOCK9) &Lmp[Pos];
		Pos    += sizeof(struct VOCBLOCK9);
		SmplSz -= sizeof(struct VOCBLOCK9);
		Rate=  ((Int32)Block9->Rate)&0xFFFFL;
		if(Block9->Bits==16)
		{ Bit16=TRUE; break;}
		if(Block9->Bits==8) { break;}
		/*break; no!*/
	 default:
		return ERRfault(ERR_BADVOC);
  }
  Smpl=&Lmp[Pos];
  if( (SmplSz+Pos)> LmpSz) { SmplSz=LmpSz-Pos; }
  /*
  ** Convert to 8 bit
  */
  SmplSz=SNDsmplChangeNbits(Smpl,SmplSz,Bit16,Stereo);
  /*
  ** Play or save
  */
  SNDsmplWriteWav(File,Smpl,SmplSz,Rate);
  /*Free(Smpl); no!*/
  return 1;
}

