/****************************************************\
*
*
* TEXT OBJECT INTERNAL  API
*
\****************************************************/

  /*
  ** Public version of TEXDEF object.
  ** Structure is hidden
  */
typedef struct
{ Int8 Dum[0x14];
}TXTOBJ;
typedef TXTOBJ PTR *pTXTOBJ;
  /*
  ** Init Text
  **  EltSz = fixed size of elements, or 0 if variable sized
  */
Int16 TXTinit(pTXTOBJ Text, Int16 EltSz);
  /*
  ** Init Text from Text lump, variable sized
  ** returns <0 if fails
  */
Int16 TXTinitLmp(pTXTOBJ Text,pInt8 Lmp,Int32 LmpSz);
  /*
  ** Init Text for direct Window output
  ** returns <0 if fails
  */
Int16 TXTinitWnd(pTXTOBJ Text, Int16 EltSz, pWINDOZE Wnd);
  /*
  ** Free Text
  */
Int16 TXTfree(pTXTOBJ Text);
  /*
  ** Get Text, size
  */
pInt8 TXTget(pTXTOBJ Text,pInt32 pLmpSz);
  /*
  ** Print one line Formatted
  **  Form = format like "%4.4d %s"
  */
Int16 TXTprintFrm(pTXTOBJ Text,Int8 *Form, ...);
  /*
  ** Print a Name
  **  Code = code associated to the name (ItemData)
  **	Name = name
  */
Int16 TXTprintName(pTXTOBJ Text,Int32 Code, pInt8 Name, Int16 NameSz);
  /*
  ** Print a Name
  **  Code = code associated to the name (ItemData)
  **	Name = name
  **  How  = 0=normal 1=indented
  */
Int16 TXTprintName8(pTXTOBJ Text,Int32 Code, pInt8 Name, Int16 How);
  /*
  ** Print a Name and (X,Y) position or extent
  **  Code = code associated to the name (ItemData)
  **  Name = name
  **  X,Y  = position
  */
Int16 TXTprintName8XY(pTXTOBJ Text,Int32 Code,pInt8 Name, Int16 X, Int16 Y);
  /*
  ** Put in listbox, dropbox, text
  **  Wnd = window representing listbox, drop box,...
  */
Int16 TXTputInWnd(pTXTOBJ Text,pWINDOZE Wnd);
  /*
  ** Read from list box
  */
Int16 TXTinitFromList(pTXTOBJ Text,pWINDOZE Wnd);


/*
** Text counter
*/
struct CNTOBJ {Int8 Dummy[0xC];};
typedef struct CNTOBJ PTR *pCNTOBJ;
  /*
  **
  */
Int16 CNTinit(pCNTOBJ CntO, Int32 Size);
Int16 CNTaddName(pCNTOBJ CntO, pInt8 Name);
Int16 CNTlistNames(pCNTOBJ CntO, pTXTOBJ Text);
Int16 CNTfree(pCNTOBJ CntO);

