/*
** Internal type of WADs
*/
#define IS_PWAD (0x01)
#define IS_IWAD (0x02)
#define IS_WAD2 (0x04)
#define IS_KENS (0x10)
#define IS_PACK (0x20)

/*
** Internal type of Operations
*/
#define MODIF_ADD  (1)
#define MODIF_INS  (2)
#define MODIF_SET  (3)
#define MODIF_DEL  (4)



/****************************************************\
*
* DOOM TEXTURE/PATCH OBJECT INTERNAL DEFINITIONS
*
\****************************************************/
#if (DLLFORDOOM)
/*
** Internal Patch definition
** One per patch in game
*/
struct PATCH
{
  Int16 SzX;		/*X size of patch*/
  Int16 SzY;		/*Y size of patch.*/
  pInt8 Bmp;		/*if not NULL, Bmp Bytes*/
  Int8 Name[8];
  Int16 Num;      /*reference number*/
  Int16 Pad;      /*align4*/
};
typedef struct PATCH PTR *pPATCH;
/*
** Internal Tex Patch list
** One per texture
*/
struct PAT
{
  Int8 Name[NORMALISELEN]; /*name of the patch*/
  Int16 OfsX;              /*horizontal offset*/
  Int16 OfsY;              /*vertical offset*/
};
struct TEXPAT
{
  Int16 NbPat;            /*nb of patches*/
  Int16 Pad;      		  /*align4*/
  struct PAT P[1];        /*list of patches*/
};
typedef struct TEXPAT PTR *pTEXPAT;
/*
** Internal Texture list
**
*/
struct TEXTURE
{
  Int8 Name[NORMALISELEN];
  pTEXPAT TexP; /*patches in texture*/
  Int16 SzX;      /*width:  8,16,32,64,128,256,512,1024,2048*/
  Int16 SzY;      /*height: 1 to 128*/
  Int16 Id;      /*1 or 2, depend on lump*/
  Int16 Age;     /*Old or new*/
};
typedef struct TEXTURE PTR *pTEXTURE;
/*
** Texture/Patch information
*/
struct TXPOBJ
{ /*patch list*/
  pPATCH Pat;		/* Patch list*/
  Int16   PatNb;        /* Size of PATCH list*/
  Int16   PatRef;       /* Next patch number available.*/
  /*texture list*/
  pTEXTURE Tex;         /* Texture list*/
  Int16   TexNb;        /* Size of texture list*/
  Int16   Dum;          /* align4*/
};
typedef struct TXPOBJ PTR *pTXPOBJ;
#endif /*DLLFORDOOM*/

/****************************************************\
*
* DOOM LEVEL OBJECT DEFINITION
*
\****************************************************/
#if (DLLFORDOOM)
/*
** Internal Vertex Definition
*/
#define INVALIDVTX (-0x7FFF)
struct VERTEX
{
  Int16 X;
  Int16 Y;
  Int16 cacheX;/*if not INVALIDVTX, cache calculation*/
  Int16 cacheY;/*if not INVALIDVTX, cache calculation*/
};
typedef struct VERTEX PTR *pVERTEX;
/*
** Internal Linedef Definition
*/
struct LINEDEF
{
	Int16 VtxS; /* index of vertex start  */
	Int16 VtxE; /* index of vertex end */
	Int16 Flag;/* flags 1=impassible 2=block 4=2sided  32=secret  128=not on map*/
	Int16 Type;/* special type*/
	Int16 Tag; /* sector tag  */
	Int16 Tag2; /* what is this? */
	Int16 SideR;/* Index of Right SideDef (-1=null) */
	Int16 SideL;/* Index of Left SideDef (-1=null)  */
};
typedef struct LINEDEF PTR *pLINEDEF;
/*
** Internal Sidedef definition
*/
struct SIDEDEF
{
	Int16 OfsX;          /*X offset of texture*/
	Int16 OfsY;          /*Y offset of texture*/
	Int8  Upper[8];      /*name of upper texture or -*/
	Int8  Lower[8];      /*name of lower texture or -*/
	Int8  Middle[8];     /*name of top texture or -*/
	Int16 Sector;        /*sector reference*/
};
typedef struct SIDEDEF PTR *pSIDEDEF;
/*
** Internal Sector definition
*/
struct SECTOR
{
	Int16 FloorZ;        /*height of floor*/
	Int16 CeilZ;         /*ceiling of floor*/
	Int8  Floor[8];      /*name of flat*/
	Int8  Ceil[8];       /*name of flat*/
	Int16 Light;         /*light level*/
	Int16 Type;          /*type*/
	Int16 Tag;   	/*line teg*/
};
typedef struct SECTOR PTR *pSECTOR;
/*
** segment
*/
struct SEGS
{
  Int16 VtxS;           /*start vertex*/
  Int16 VtxE;           /*end vertex*/
  Int16 Angle;          /*direction angle*/
  Int16 Line;           /*line the SEG is part of*/
  Int16 Side;           /*-1 if left, 0 if right*/
  Int16 OfsX;           /*texture X offset*/
};
typedef struct SEGS PTR *pSEGS;
/*
** Sub Sector
*/
struct SSECTOR
{
  Int16 Nb;                /*nb of SEGS*/
  Int16 First;             /*index of first SEG*/
};
typedef struct SSECTOR PTR *pSSECTOR;

/*
** Node
*/
struct NODE
{
  Int16 X;        /*start of line*/
  Int16 Y;
  Int16 dX;       /*line vector*/
  Int16 dY;
  Int16 RYmax;    /*right bounding*/
  Int16 RYmin;
  Int16 RXmin;
  Int16 RXmax;
  Int16 LYmax;    /*left bounding*/
  Int16 LYmin;
  Int16 LXmin;
  Int16 LXmax;
  Int16 Right;   /*Right node, or SSector if & 0x8000*/
  Int16 Left;    /*Left  node, or SSector if & 0x8000*/
};
typedef struct NODE PTR *pNODE;
#define NOTNODE (0x8000)

struct LVLOBJ
{
  Int16 Level;          /* entry that is the start of level*/
  /*vertex*/
  Int16 VtxNb;          /* nb of vertex*/
  pVERTEX Vtx;          /* vertex list*/
  /*sidedef*/
  pSIDEDEF Sid;         /* sidedef list*/
  Int16 SidNb;          /* Nb of sidedefs*/
  /*linedef*/
  Int16 LndNb;          /* linedef size*/
  pLINEDEF Lnd;         /* linedef list*/
  /*sector*/
  pSECTOR Sec;          /* sector list*/
  Int16 SecNb;          /* number of sectors*/
  /*segments*/
  Int16 SegNb;          /* number of sectors*/
  pSEGS Seg;          /* sector list*/
  /*sub sector*/
  pSSECTOR Ssc;          /* sector list*/
  Int16 SscNb;          /* number of sectors*/
  /*nodes*/
  Int16 NodNb;          /* number of sectors*/
  pNODE Nod;          /* sector list*/
  /*reject*/
  pInt8 Rej;            /* reject list*/
  Int32 RejNb;           /* reject size in Int8*/
};
typedef struct LVLOBJ PTR *pLVLOBJ;
#endif /*DLLFORDOOM*/

/****************************************************\
*
* QUAKE
*
\****************************************************/
/*
** BSP Object
*/
typedef struct
{ Int32 Dum[1+(15*2)+1+1+1];
}BSPOBJ;
typedef BSPOBJ PTR *pBSPOBJ;


/****************************************************\
*
* WAD OBJECT INTERNAL DEFINITIONS
*
\****************************************************/
/*
** Internal WAD directory definition
*/
struct WADDIR        /*WAD directory entry*/
{
  Int32  Start;       /*Start of entry*/
  Int32  Size;        /*Size of entry*/
  Int8  Name[NORMALISELEN];/*Name of entry*/
  IDENT Id;          /*Identity of entry*/
  Int16 Dirty;       /*Entry is dirty, align4*/
};
typedef struct WADDIR PTR *pWADDIR;


/*
** Wad object
*/
struct WADDEF
{ /*
  ** Wad directory
  */
  pWADDIR Lst;       /* WAD Directory list*/
  Int16   LstNb;  	/* nb of entries in list*/
  Int16   DirDirty;  /* Dir has been modified*/
  Int32   WritePtr;  /* where to write next*/
  /*
  ** Original Wad file
  */
  Int16   Locked;
  Int16   WadType;   /* type of WAD: IS_PWAD, IS_WAD, IS_WAD2*/
  Int32    OrigTime;
  Int32    OrigFileSz;/* original file size */
  Int32    OrigDirPos;
  Int32    OrigDirNb;
  Int8    File[128]; /* WAD file name*/
  /*
  ** Main Wad
  */
  Int16   IwadSelf;	/* WAD object = Main WAD*/
  Int16   Game;		/* Game which the WAD represents*/
 #if (DLLFORDOOM)
  /*
  ** DOOM Texture information
  */
  struct TXPOBJ Txp;
  /*
  ** DOOM level informations
  */
  struct LVLOBJ Dml;     /*level*/
#endif /*DLLFORDOOM*/
#if (DLLFORQUAK)
  /*
  ** Quake Bsp level
  */
  BSPOBJ Qkl;
#endif /*DLLFORQUAK*/
  /*
  ** Bitmap Object
  */
  struct BMPOBJ Bmp;    /*Bmp object*/
  /*
  ** Sound
  */
  Int16   Sound;        /*TRUE if can play sound*/
  Int16   Dum;          /*align 4*/
  /*
  ** ErrWnd special
  */
  Int32   ErrWnd;
};
typedef struct WADDEF PTR *pWADDEF;

/*
** Error codes
*/
#define ERR_WADNB 	-101
#define ERR_CLEAN 	-102
#define ERR_BADWAD   -103
#define ERR_BADWADH  -104
#define ERR_ESIZE 	-105
#define ERR_ESTART 	-106
#define ERR_BADIWAD  -107
#define ERR_BADGRP 	-108
#define ERR_WADPIC   -109
#define ERR_DIRTY 	-110
#define ERR_DINS  	-111
#define ERR_DFULL  	-112
#define ERR_DVOID  	-113
#define ERR_DEAD  	-114
#define ERR_PATLST   -115
#define ERR_PATNONE  -116
#define ERR_PATABSNT -117
#define ERR_PALNONE  -118
#define ERR_BADLEVEL -119
#define ERR_BADLINE  -120
#define ERR_SHRIWAD  -121
#define ERR_MDF_IWAD -122
#define ERR_MDF_NTRY -123
#define ERR_COLNONE  -124
#define ERR_WADLOCK  -125
#define ERR_FLAT1    -126
#define ERR_FLAT2    -127
#define ERR_BADMUS   -128
#define ERR_BADBEH   -129
#define ERR_PATNB 	-130

	 /*Error declaration MACRO*/
#define ERRfaultWad(a) ERRfaultW(__LINE__,a,WINTEXMODULE)
Int16 ERRfaultW(Int16 Line,Int16 Type, Int8 Module);

