/****************************************************\
*
*
*  WAD DIRECTORY API
*
*
\****************************************************/
  /*
  ** Init WAD directory from WAD, WAD2 or KEN file
  */
Int16 WADDinitFromWadI(pWADDEF This, Int16 LstNb);
Int16 WADDinitFromWad2I(pWADDEF This, Int16 LstNb);
Int16 WADDinitFromKenI(pWADDEF This, Int16 LstNb);
Int16 WADDinitFromPackI(pWADDEF This, Int16 LstNb);
  /*
  ** Free WAD directory
  */
void WADDfreeI(pWADDEF This);
  /*
  ** Change existing directory entry
  */
Int16 WADDsetEntryI(pWADDEF This,Int16 Entry,IDENT Id, pInt8 Name, Int32 Start,Int32 Size);
  /*
  ** Delete existing directory entry
  */
Int16 WADDdelEntryI(pWADDEF This, Int16 Entry);
  /*
  ** Insert new directory entry
  */
Int16 WADDinsEntryI(pWADDEF This, Int16 Entry, IDENT Id, pInt8 Name, Int32 Start, Int32 Size);
	/*
	** get informations about an entry
	** pStart = return entry start  (in bytes, from start of WAD)
	** pSize = return entry size  (in bytes)
	** returns entry id, or <0 if error.
	*/
Int16 WADDgetEntryI(pWADDEF This, pInt32 pStart, pInt32 pSize, Int16 Entry);
	/*
	** Get name of entry
	** Entry = ref. of entry
	** returns a pointer to the actual entry name.
	*/
pInt8 WADDgetNameEntryI(pWADDEF This,Int16 Entry);
	/*
	** Change name of entry
	*/
Int16 WADDchangeNameEntryI(pWADDEF This, Int16 Here, IDENT Id, pInt8 Name, pInt8 OldName);
	/*
	** Find fist entry in WAD directory
	**  Here = position where search starts
	**  Name = name of entry to find
	**  Id   = if >0, select only entries of ident=Id
	** Returns entry reference, or <0 if error
	*/
Int16 WADDfindEntryI(pWADDEF This,Int16 Here, pInt8  Name, IDENT Id);

/****************************************************\
*
*
*  WAD HEADER API
*
*
\****************************************************/

  /*
  ** Write header of WAD (only PWAD)
  */
Int16 WADHheaderWriteI(pInt8 File,Int32 DirPos,Int32 DirNb);
  /*
  ** Read header of PWAD, IWAD, WAD2, KEN
  ** return <0 if error, or IS_PWAD, IS_IWAD, IS_WAD2, IS_KENS
  */
Int16 WADHheaderReadI(pInt32 pDirPos,pInt32 pDirNb,pInt8 File, Int32 FileSz);
  /*
  ** Create fake PWAD, completely empty
  */
Int16 WADHmakeFakeWadI(pInt8 File);
  /*
  ** Save the directory of the WAD
  ** if Restorable>0, make the WAD restorable, but with warning.
  ** if Restorable=0, make the WAD restorable, no warning.
  ** if restorable<0, the WAD is not restorable.
  */
Int16 WADHdirSaveI(pWADDEF This, Int16 Restore);

