#if 0
' type WINDOZE for visual basic
'
Global const Wpicbox = 666
Global const Wlistbox = 777
Global const Wdropbox = 999
'
Type Windoze
  Typ As Integer  'type
  hWnd As Integer 'handle on a window
  hDC As Integer  'handle on a display controler
End Type
'
' Level bounds
'
Type Bound
' screen
  SzX as Integer   'MUST BE SET
  SzY as Integer   'height,width
'  level scaled
  ScaleX As Long   'screen X scale
  ScaleY As Long   'screen Y scale
  OfsX   As Long   'screen X offset
  OfsY   As Long   'screen Y offset
'  max and min to display in level
  Xmin as Long  'MUST BE SET
  Ymin as Long
  Zmin as Long
  Xmax as Long
  Ymax as Long
  Zmax as Long
' viewpoint
  X      As Long
  Y      As Long
  Z      As Long
  Phi    As Long   'horiz rot, in degree
  The    As Long   'vertical rot, in degree
End Type
'
'
Type BspInfos
  Id     As Long 'type of BSP object
  Nb     As Long 'Nb of elements
  N      As Long 'Id of element
  N2     As Long
  PlanType  As Long
  NodeFront As Long
  NodeBack  As Long
  TinfTexu  As Long
  TinfSoffs  As Single
  TinfToffs  As Single
  FaceLType As Integer
  FaceShadow As Integer
  FaceLite1 As Integer
  FaceLite2 As Integer
  LeafType  As Long
  ModlNode As Long
  ModlSplit As Long
  ModlSplit2 As Long
  ModlSplit3 As Long
  ModlLeafNb As Long
  TexuName  As String * 16
End Type



' Basic Operations on the WAD object
' (Init,Free,Get entries, Modify entries)
'
' init WAD object, returns object reference>0
'  if Lck =1, lock the WAD for read only.
'  Transp = Trnasparent color
'  Error = Error Window handles
Declare Function WADinit% Lib "lbwintex.dll" (ByVal file$, ByVal Main%, ByVal Lock%, ByVal Transparent&)
'  forget WAD object, save modified directory
'  if Sav = -1, restore WAD. =0 ignore, =1, save dir
Declare Function WADfree% Lib "lbwintex.dll" (ByVal Self%, ByVal Sav%)
'  Set customs parameters
'  error windows
Declare Function WADsetCustoms% Lib "lbwintex.dll" (ByVal Self%, ByVal ErrWnd&)
'    check WAD. returns 16bit flags
Declare Function WADcheck% Lib "lbwintex.dll" (ByVal Self%);
'    get Id of the Game this WAD is for (10,11,12=DOOM 20,21=HERETIC)
'    get the reference of the MainWAD
'    tell if the WAD directory was modified and not saved.
'    if File$<>"", give the name of the WAD file
Declare Function WADgetInfos% lib "lbwintex.dll" (ByVal Self%, Gam%, MainWad%, DirDirty%, ByVal File$)
'    get Size and Start of a dir entry
'    returns Id
Declare Function WADgetEntry% Lib "lbwintex.dll" (ByVal Self%, start&, size&, ByVal Entry%)
'    Find entry, starting at Here, from entry name
Declare Function WADfindEntry% Lib "lbwintex.dll" (ByVal Self%, ByVal Here%, ByVal Nam$)
'    Set dir Entry, with the provided Name, Start, Size
'    Modif: 1=add 2=ins 3=set 4=del
'    Modify Start or Size only if >=0
'    If Id%>=0 then set identity of entry
'    the WAD directory is not saved on file, it is kept dirty
Declare Function WADsetEntry% Lib "lbwintex.dll" (ByVal Self%, ByVal Here%,ByVal Nam$, ByVal Start&, ByVal Size&, ByVal Id%, ByVal Modif%)
'    Save Directory of WAD, so that WAD becomes usable
'    by other WAD tools, like level editors
Declare Function WADsaveDir% Lib "lbwintex.dll" (ByVal Self%)
'    Restore a WAD file
'    whose directory was modified
Declare Function WADrestore% Lib "lbwintex.dll" (ByVal File$, ByVal Safe%)
'    cleanup PWAD into another WAD
'    this ignores entry compression
Declare Function WADcleanup% Lib "lbwintex.dll" (ByVal Self%, ByVal File$)
'
' List entries
'
'    list entries in directory, according to type.
'    hLst = listbox where to list entries
'           itemdata will contain entry id and reference
'    Type = type of entries to list.
'           if<0, all entries.
'           if sub type, only that sub type.
'    Entry = Entry to look for
'    returns position of entry >=0
Declare Function WADlistDir% Lib "lbwintex.dll" (ByVal Self%, Wnd As Windoze, ByVal Typ%, ByVal Entry%)
'
'		List all PWAD/IWAD entrie with references
'		 if Type has a general type, list that type
'		 in Type has a subtype, list only the subtype
'		returns 1
Declare Function WADlistAll% Lib "lbwintex.dll" (ByVal Self%, Wnd As Windoze, ByVal Typ%)
'    list of entry types
'    (only the general types)
'
Global Const EMASK	= &HFF
Global Const EWHAT	= &H80
Global Const ELEVEL	= &H0
Global Const ELUMP	= &H1
Global Const ESOUND	= &H2
Global Const ETEXTUR	= &H3
Global Const EGRAPHIC	= &H4
Global Const ESPRITE	= &H5
Global Const EPATCH	= &H6
Global Const EFLAT	= &H7
Global Const EMUSIC	= &H8

'
'   Check the name of an entry, warn user if needed.
'   Name = Entry name
'   Type = proposed entry type (general type)
'   txt   = text buffer, for message
'   txtsz = buffer size
'   return <0 if error,  ident if accepted
Declare Function WADentryCheckId% Lib "lbwintex.dll" (ByVal Self%, ByVal Typ%, ByVal nam$, ByVal Txt$, ByVal TxtSz%)
'
'   Show any entries, depending on type.
'    PicB = Picture Box for sprites/patches
'    Wnd = window for picture/level/lists
'    Shw = if>0, then show, else just say what is selected
'   Returns indication of what is displayed
'    SHOWE_NONE 0  no entry shown
'    SHOWE_PICB 1  show a picture
'    SHOWE_OFFS 2       with offsets
'    SHOWE_VIEW 4       with views
'    SHOWE_LIST 8  show a list
'    SHOWE_LEVL 16 show a level map
'    SHOWE_SDIR 32 show a entry subdirectory list
Declare Function WADshowEntry% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, Wnd As Windoze , ByVal Shw%)
'
'	 Show Sub Directory entry
'	  Entry = entry containing the SubDir
'	  Sdir = entry in the subdir
'	  Wnd = window for picture/level/lists
'	  Show = if <0, then do not display anything
'				 if >0, then display the relevant data
'	 returns the type of what is to be displayed
'	 (call first with show<0, set the right window, call again with show>0)
Declare Function WADsdirShow% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%,ByVal Sdir%,Wnd As Windoze , ByVal Shw%)
'
'  Set various parameters
'   Sound: <0 ignored,=0 no sound, >0 sound
'
Declare Function WADsetParams% Lib "lbwintex.dll" (ByVal Self%, ByVal Sound%)
'
'   Show an entry, by name rather than by entry ref.
'   PicB = picture box where entry is shown
'   Ident = EPATCH or EFLAT
'   Name = name of the patch or flat
'   Search in PWAD first, then in main WAD.
Declare Function WADshowByName% Lib "lbwintex.dll" (ByVal Self%, Pic As Windoze, ByVal Ident%, ByVal nam$)
'
'   Change colormap for picture display
'   Entry = Colormap entry (if <0, use COLORMAP in main WAD)
'   Mapref = Which colormap (if <0, restore normal one)
Declare Function WADcolorMap% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%,ByVal Mapref%)
'
' Save entries to individual files
'
'   Save any entry to a file
'   Entry = reference of entry. must be valid.
'   File = name of the file. must be valid.
'   The format of File will depend on the entry type
Declare Function WADsaveEntry% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, ByVal file$)
'
'	Save a subdir entry
'	 File = file where art is saved
'	 Entry = entry containing the ART
'	 Sdir =  entry in subdir
'	 File = name of the file. must be valid.
'	The format of File will depend on the entry type
Declare Function WADsdirSave% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, ByVal Sdir%, ByVal File$)
'
' Load entries from individual files, into the WAD
'
'    Load an entry from file,
'    Entry = suggested position in WAD directory.
'    Id = identification of the entry
'    Name = name of the entry
'    File = file name where the data is.
'    File will be read depending on Id
Declare Function WADloadEntry% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, ByVal Id%, ByVal Nam$, ByVal File$)
'    Load a level part
'    Entry = position of existing level header
'    File = a WAD file that contains a level
'    What = 0: all level  1:nodes and blockmap 2:only reject
Declare Function WADloadLevel% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, ByVal File$, ByVal What%)
'    Load a text entry from listbox
'    Entry = suggested position in wad dir.
'    Id = identification of entry
'    Name = name of entry
'    hList = Listbox
Declare Function WADloadText% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, ByVal Id%, ByVal Nam$, Lst As Windoze)
'    Load an entry from another opened WAD
'    Wad = object reference of the other Wad
'    WadEntry = Entry in that other Wad
Declare Function WADloadFromWad% Lib "lbwintex.dll" (ByVal Self%, ByVal Wad2%, ByVal Wad2Entry%)
'    Set offsets of DOOM picture
'    Entry = picture entry (must be sprite or patch or graphic)
'    OfsX = X offset
'    OfsY = Y offset
Declare Function WADsetOffsets% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, ByVal ofsx%, ByVal ofsy%)
'
' Check WAD
'
'    List textures used in a WAD
'    hList = listbox where to list textures
Declare Function WADlistTextures% Lib "lbwintex.dll" (ByVal Self%, Lst As Windoze)
'    Check WAD
'    hList = listbox where to put the result
Declare Function WADcheckWad% Lib "lbwintex.dll" (ByVal Self%, Lst As Windoze)
'
'    show a picture on screen
'    on Form.Load()   WadshowWindoze(PicBB,1)
'    on PicB.Paint()  WadshowWindoze(PicBB,0)
'    on Form.Unload() WadshowWindoze(PicBB,-1)
'    The PicBox must be Visible, Autoredraw=NO, ClipControl=yes
Declare Function WADshowWindoze% Lib "lbwintex.dll" (PicB As Windoze, ByVal Ops%)


'
' Texture
'
'   Allocate texture lump
'   Start texture, and start cacheing patches
'   Read textures and PNAMES in main WAD and in PWAD
Declare Function WADTinit% Lib "lbwintex.dll" (ByVal Self%)
'   return name and size, from reference
'   name must be string*8+2. returns size of name 
Declare Function WADTgetTex% Lib "lbwintex.dll" (ByVal Self%, ByVal Texu%, ByVal Nam$, SzX%, SzY%)
'   Modif: 1=add, 2=ins 3=set 4=del  entry
Declare Function WADTsetTex% Lib "lbwintex.dll" (ByVal Self%, ByVal Texu%, ByVal Nam$, ByVal SzX%, ByVal SzY%, ByVal Modif%)
'   find texture
Declare Function WADTfindTex% Lib "lbwintex.dll" (ByVal Self%, ByVal Nam$)
'   list textures. Filt=0: all  Filt=1:only redefined
'  which filters texture 1 or 2 (if <0, no filter)
'  new filters old 0 and new 1(if <0, no filter)
Declare Function WADTlistTex% Lib "lbwintex.dll" (ByVal Self%, Lst As Windoze, ByVal Whch%, ByVal Nw%)
'   display a texture
Declare Function WADTshowTex% Lib "lbwintex.dll" (ByVal Self%, ByVal Texu%, Pic As Windoze)
'   Modif: 1=add, 2=ins 3=set 4=del patch
Declare Function WADTsetPatch% Lib "lbwintex.dll" (ByVal Self%, ByVal Texu%, ByVal Pat%, ByVal Nam$, ByVal OfsX%, ByVal OfsY%, ByVal Modif%)
'   get patch Pat in texture Texu, into Name, OfsX, OfsY
'   Name must be string*8+2
Declare Function WADTgetPatch% Lib "lbwintex.dll" (ByVal Self%, ByVal Texu%, ByVal Pat%, ByVal Nam$, OfsX%, OfsY%)
'   list patches. Name, OfsX, OfsY. ItemData= patch reference
'  list to a list box
Declare Function WADTlistPatch% Lib "lbwintex.dll" (ByVal Self%, ByVal Texu%, Lst As Windoze)
'   save all texture and PNAME to WAD
Declare Function WADTsaveAll% Lib "lbwintex.dll" (ByVal Self%)
'   free texture
'   stop cacheing patches
'   clean up the mess
Declare Function WADTfree% Lib "lbwintex.dll" (ByVal Self%)
'
' Clear texture clipboard
Declare Function  WADTclipbClear% Lib "lbwintex.dll" ()
'
' Copy texture in clipboard
Declare Function WADTclipbCopy% Lib "lbwintex.dll" (ByVal Self%, ByVal Texu%)
'
'  Paste textures from clipboard
Declare Function WADTclipbPaste% Lib "lbwintex.dll" (ByVal Self%, ByVal Texu%)


'   get Xmin Xmax Ymin Ymax of a level
Declare Function WADLboundLevel% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, BoundEx As Bound)
'   set Xmin Xmax Ymin Ymax of a bound box
'   Modif= 0,1= left/right 2,3=up/down
'   0x10=zoom out 0x11=zoom in
Declare Function WADLboundScale% Lib "lbwintex.dll" (BoundEx As Bound, ByVal X%, ByVal Y%, ByVal Modif%)
'   point to an object of a given type
'   returns the identifier of that object, or -1
'   if Id=ELINDEF, Point to linedef
'   if Id=ESIDEDEF, Point to sidedef
'   if Id=ESECTOR, Point to sector
'   if Id=ENODE, Point to node. return a node, and depth
'   if Id=EREJECT, toggle reject for sector at X,Y
Declare Function WADLpointObject& Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, ByVal Id%, ByVal Object%, ByVal X%, ByVal Y%, ByVal OX%, ByVal OY%)
'    Modify reject data
'    Entry = level header
'    Target = Target sector (player sector)
'    Sector = monster sector
'    Ops = 0 toggle Sector can/cant see Target
'	  1 make target safe, 2 make target unsafe
'    returns status of reject
Declare Function WADLmodifyReject% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, ByVal Target%, ByVal Sector%, ByVal Ops%)
'
'	  Modify sidedef data
'	  Entry = level header
'	  Sid = Sidedef number
'	  Ops = 0 Set texture names from Texu
'			  1 Get texture names into Texu
'          2 Set ceil/floor names from Texu
'          3 Get ceil/floor names into Texu
'	  Texu[24] = Upper[8]   Lower[8] Middle[8]
'	  Texu[24] = Ceiling[8] Floor[8]
'			  Texu must of size 24 at least.
'	 returns >0 if ok
Declare Function WADLmodifTexu% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, ByVal Obj%, ByVal Ops%, ByVal Texu$)
'   Draw the linedefs of a level map
'   Depending on Id, display the object Obj
'   highlighted. Use only level entries for Id
Declare Function WADLshowLevel% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, ByVal Lin%, ByVal Id%, BoundEx As Bound, Pic As Windoze)
'   Save level part
'   Id=part to save
'   Entry=level header
Declare Function WADLsaveLevel% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%, ByVal Id%)
'
'   Init BSP model from entry
Declare Function BSPinit% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%)
'
'   Free BSP model
Declare Function BSPfree% Lib "lbwintex.dll" (ByVal Self%)
'
'   Save BSP model
Declare Function BSPsave% Lib "lbwintex.dll" (ByVal Self%)
'
'   Check BSP model
'   report problems in windows
'   return >0 if ok, <0 if problems
Declare Function BSPcheck% Lib "lbwintex.dll" (ByVal Self%, Wnd As Windoze)
'
'  Show a BSP level
Declare Function BSPshow% Lib "lbwintex.dll" (ByVal Self%, Wnd As Windoze, BoundEx As Bound, ByVal Obj&, ByVal Typ%)
'
'  Show/Modify BSP element
Declare Function BSPmodify% Lib "lbwintex.dll" (ByVal Self%, Infos As BspInfos, ByVal What%)
'
'	 Get Entry/Ident for ItemData
'	  Ident = Entry identification
'	  Code = Entry code = LstB.ItemData(n)
'	  Returns Ident and Entry ref in PWAD.
Declare Function HELPdecodeEntry% Lib "lbwintex.dll" (Ident%, ByVal Code&)
'	Get type and Index of button
'	  *pIndex = -1 or Index of the type selection button (0...9)
'	  Game = Current game
'	  Id   = Type of entry, or -1
'	  returns Type and *pIndex
Declare Function HELPgetIdxType% Lib "lbwintex.dll" (Index% , ByVal Gam%, ByVal Typ%)
'
'    List the entries of the given type into drop box
'     Type= types of entries listed
'     Game= which game is it for? 0x10=doom; 0x12=doom2...
Declare Sub HELPforWad Lib "lbwintex.dll" (Wnd As Windoze, ByVal Typ%, ByVal Gam%)
'
'    Find if a given name is matched
'     Type= types of entries listed
'     Game= which game is it for? 0x10=doom; 0x12=doom2...
'    returns <0 if name not matched
'    returns 0 if name contains illegal Int8
'    returns 1 if name is matched
Declare Function HELPfindName% Lib "lbwintex.dll"(ByVal Nam$, ByVal Typ%, ByVal Gam%)
'
'    Give help test for a name
'     Name =  name searched
'     Type = Type searched  (-1=all)
'     Game = game searched
'     Text = buffer
'     TextSz = size of buffer
'    returns actual size of text
Declare Function HELPforName% Lib "lbwintex.dll"(ByVal Nam$, ByVal Typ%, ByVal Gam%,ByVal Txt$, ByVal TxtSz%)
'
'    Give the name of a type
'     Type = entry type to be identified
'     Text = buffer
'     TextSz = size of buffer
'    returns actual size of text
Declare Function HELPforType% Lib "lbwintex.dll" (ByVal Typ%, ByVal Txt$, ByVal TxtSz%)
' HELP for file extension
' Id = entry type
'  Ops = 1:file to load   0:file to save
' returns the type of editor for the file
Declare Function HELPfileForType% Lib "lbwintex.dll" (ByVal Typ%, ByVal Ops%)



'
'   clear clipboard
'
Declare Function WADclipbClear% Lib "lbwintex.dll" ()
'
'   Copy entry from WAD into clipboard
'
Declare Function WADclipbCopy% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%)
'
'   Copy first entry from cliboard to WAD
'   return <=0 if clipboard is empty
'
Declare Function WADclipbPaste% Lib "lbwintex.dll" (ByVal Self%, ByVal Entry%)

'
' Append sprites to a WAD
'  Force = <0 check if needed,  =0 do not force, >0 force
' return <0 if not needed, 0 if dubious(S_END), >0 if needed
'
Declare Function WADappSprites% Lib "lbwintex.dll" (ByVal Self%, ByVal Force%)

#endif