/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/
#define WINTEXMODULE 'w'

/****************************************************\
*
*
*  ALL THE FUNCTIONS HERE ARE INDEPENDENT
*  call only once at the time. not in parallel
*
\****************************************************/

#include "lbwintex.h"
/*include windows.h after lbwintex.h*/
#if defined __WINDOWS__
#include <windows.h>
#endif
#include "lbcommon.h"
#include "lbwindoz.h"

/*
** This file contains all the windoze-related stuff,
** like list box handling and picture box handling.
**
*/

/****************************************************\
*
*
*  List Box Handling for Windoze
*
*
\****************************************************/

/*
** Clear list box
*/
#if defined __WINDOWS__
Int16 LISTclear(HWND hWnd)
{
  return (Int16)SendMessage(hWnd,LB_RESETCONTENT, (WPARAM)0, (LPARAM)0L);
}
Int16 CMBXclear(HWND hWnd)
{
  return (Int16)SendMessage(hWnd,CB_RESETCONTENT, (WPARAM)0, (LPARAM)0L);
}
#endif
/*
** Get number of elements in list box
*/
#if 1
#if defined __WINDOWS__
Int16 LISTcount(HWND hWnd)
{
  return (Int16)SendMessage(hWnd,LB_GETCOUNT, (WPARAM)0, (LPARAM)(0L));
}
Int16 CMBXcount(HWND hWnd)
{
  return (Int16)SendMessage(hWnd,CB_GETCOUNT, (WPARAM)0, (LPARAM)(0L));
}
#endif  /*__WINDOWS__*/
#endif /*0*/
/*
** Set list element to Text
** Set associated ItemData (a Int32) to Code
*/
#if defined __WINDOWS__
Int16 LISTset(HWND hWnd, Int16 Index, Int32 Code, pInt8 Text)
{
  if(Index<0) Index=-1; /*-1 = last item*/
  Index=(Int16)SendMessage(hWnd,LB_INSERTSTRING, (WPARAM)Index, (LPARAM)Text);
  if(Index>=0) SendMessage(hWnd,LB_SETITEMDATA, (WPARAM)Index, (LPARAM)Code);
  if(Index<0) Index=-1;
  return Index;
}
Int16 CMBXset(HWND hWnd, Int16 Index, pInt8 Text)
{
  if(Index<0) Index=-1; /*-1 = last item*/
  Index=(Int16)SendMessage(hWnd,CB_INSERTSTRING, (WPARAM)Index, (LPARAM)Text);
  if(Index<0) Index=-1;
  return Index;
}
#endif

/*
** get text, not more than TextSz. return size read
*/
#if 1
#if defined __WINDOWS__
Int16 LISTget(HWND hWnd,Int16 Index,pInt8 Text,Int16 TextSz)
{
  Int16 size;
  if((Text==NULL)||(TextSz<0)) return -1;
  if(Index<0) return -1;
  size=(Int16)SendMessage(hWnd,LB_GETTEXTLEN, (WPARAM)Index, (LPARAM)0L);
  if(size>TextSz) size=TextSz;
  if(size>0)
  { if(SendMessage(hWnd,LB_GETTEXT, (WPARAM)Index, (LPARAM)Text)<=0)
	 return -1;
  }
  return size;
}
Int16 CMBXget(HWND hWnd,Int16 Index,pInt8 Text,Int16 TextSz)
{
  Int16 size;
  if((Text==NULL)||(TextSz<0)) return -1;
  if(Index<0) return -1;
  size=(Int16)SendMessage(hWnd,CB_GETLBTEXTLEN, (WPARAM)Index, (LPARAM)0L);
  if(size>TextSz) size=TextSz;
  if(size>0)
  { if(SendMessage(hWnd,CB_GETLBTEXT, (WPARAM)Index, (LPARAM)Text)<=0)
	 return -1;
  }
  return size;
}
#endif /*__WINDOWS__*/
#endif /*0*/





/****************************************************\
*
*
*  Bitmap 256 color Handling
*
*
\****************************************************/
typedef struct
{ UInt8         id[2];
  Int32          filesize;
  Int16         reserved[2];
  Int32          headersize;
} BMPHEAD;
static BMPHEAD BmpH;
#if defined __WINDOWS__
typedef struct
{  BITMAPINFOHEADER bmiHeader;
	RGBQUAD          bmiColors[256];
} BITMAPINFO256;
static BITMAPINFO256 BmpI;
#endif

static Int32 BMP8set(pInt32 pBmpSz,Int16 SzX,Int16 SzY,pRGB Pal, Int16 PalNb)
{ Int16 NBits,p;
  Int32 LineSz,BmpSz;
  NBits=8;               /*8 bits*/
  LineSz=(Int32)SzX;      /*8 bits*/
  LineSz=(LineSz+3L)&(~3L);
  BmpSz=((Int32)SzY)*LineSz;
  /*
  ** set header
  */
#if defined __WINDOWS__
  BmpI.bmiHeader.biBitCount=NBits;
  BmpI.bmiHeader.biWidth=SzX;
  BmpI.bmiHeader.biHeight=SzY;
  BmpI.bmiHeader.biSize= sizeof(BITMAPINFOHEADER);
  BmpI.bmiHeader.biPlanes=1;
  BmpI.bmiHeader.biCompression=BI_RGB;
  BmpI.bmiHeader.biSizeImage=BmpSz; /*or 0, for RGB*/
  BmpI.bmiHeader.biXPelsPerMeter= 0;
  BmpI.bmiHeader.biYPelsPerMeter= 0;
  BmpI.bmiHeader.biClrUsed= PalNb;
  BmpI.bmiHeader.biClrImportant= 0;
  /*
  ** Copy palette
  */
  for(p = 0; p < PalNb; p++)
  { BmpI.bmiColors[p].rgbRed=Pal[p].R;
	 BmpI.bmiColors[p].rgbGreen=Pal[p].G;
	 BmpI.bmiColors[p].rgbBlue=Pal[p].B;
	 BmpI.bmiColors[p].rgbReserved = 0;
  }
  for(; p < 256; p++)
  { BmpI.bmiColors[p].rgbRed=0;
	 BmpI.bmiColors[p].rgbGreen=0;
	 BmpI.bmiColors[p].rgbBlue=0;
	 BmpI.bmiColors[p].rgbReserved = 0;
  }
#endif /*__WINDOWS__*/
  /**/
  *pBmpSz= BmpSz;
  return LineSz;
}
#if defined __WINDOWS__
typedef struct tagLOGPALETTE256
{ WORD 		palVersion;
  WORD 		palNumEntries;
  PALETTEENTRY	palPalEntry[256];
}LOGPALETTE256;
static LOGPALETTE256 BMP8logPal;
#endif /*__WINDOWS__*/
/*
**
**
** if Ops>0 init a windoze objects
** if Ops==0 display a bitmap
** if Ops<0 free a windoze objects
** From Visual Basic, this must be called:
**  Ops>0 on Form.Load()
**  Ops=0 on PicBox.Paint()
**  Ops<0 on Form.Unload()
** The PicBox must be Visible, Autoredraw=NO, ClipControl=yes
*/
Int16 BMP8display(pDISPLAY Display, Int16 Ops)
{
#if defined __WINDOWS__
  HPALETTE oldPal;
  HDC	     tempDC=NULL;
  HGDIOBJ  oldBmp=NULL;
  /*
  ** Picture
  */
  if(Display==NULL) return ERRfault(BAD_PARM);
  /*
  ** check ops >0 (init) or Ops <0 (free)
  */
  if(Ops!=0)
  {
	 if(Ops<0)
	 {
		if(Display->hBitmap!=NULL) DeleteObject((HANDLE)Display->hBitmap);
		if(Display->hPal!=NULL) DeleteObject((HANDLE)Display->hPal);
	 }
	 Display->hBitmap=NULL;
	 Display->hPal=NULL;
	 return 1;
  }

  if(Display->hDC==NULL) Display->hDC=GetDC((HWND)Display->hWnd);
  /*
  ** Set palette, if device or BMP needs it.
  */
  if(Display->hPal!=NULL)
  { /*
	 ** Select the logical palette on the display context
	 */
	 oldPal = SelectPalette((HDC)Display->hDC, (HPALETTE)Display->hPal, 0);
	 if(oldPal==NULL)
	 { return ERRfault(BAD_WIN2);}
	 /*
	 ** Realise the palette on Display context
	 */
	 RealizePalette((HDC)Display->hDC);
  }
  /*
  ** Create Windoze DC, to put Window on screen
  */
  tempDC = CreateCompatibleDC((HDC)Display->hDC);
  oldBmp = SelectObject(tempDC, (HBITMAP)Display->hBitmap);
  /*
  ** Resize windows
  */
#if 0 /*bugs visual basic?*/
  SetWindowPos ((HWND)Display->hWnd,NULL,0, 0,Display->SzX,Display->SzY,SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE);
#endif
  /*
  ** Put on display
  */
  if((Display->SzX>0)&&(Display->SzY>0))
  {
	 BitBlt((HDC)Display->hDC, 0, 0, Display->SzX, Display->SzY, tempDC, 0, 0, SRCCOPY);
  }
  /*
  ** Restore old palette, and delete current
  */
  if(Display->hPal != NULL)
  {
	 SelectPalette((HDC)Display->hDC, oldPal, 0);
  }
  /*
  ** Restore old bitmap and delete temp. DC
  */
  SelectObject(tempDC, oldBmp);
  DeleteDC(tempDC);
  /*
  ** Resize windows
  */
#if 0 /*doesn't bug visual basic, but looks lame.*/
  SetWindowPos ((HWND)Display->hWnd,NULL,0, 0,Display->SzX,Display->SzY,SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE);
#endif
#endif /*__WINDOWS__*/
  return 1;
}
/*
** create bitmap and palette, set hbitmap and hpalette in
** WINDOZE, deallocate previous.
**
*/
Int16 BMP8create(pDISPLAY Display,pInt8 Ptr,Int16 SzX,Int16 SzY,pRGB Pal, Int16 PalNb)
{ Int32 BmpSz;
  /**/
  Int16  bits, p;
#if defined __WINDOWS__
  HPALETTE oldPal;
  /*
  ** Picture
  */
  if((Display==NULL)||(Ptr==NULL)||(Pal==NULL))
  { return ERRfault(BAD_PARM);}
  if(Display->hDC==NULL) Display->hDC=GetDC((HWND)Display->hWnd);
  /*
  ** Delete previous palette and bitmap
  */
  if(Display->hBitmap!=NULL)/*is not selected on a DC*/
  { DeleteObject((HBITMAP)Display->hBitmap);}
  if(Display->hPal!=NULL)
  { DeleteObject((HPALETTE)Display->hPal);}
  Display->hBitmap=NULL;
  Display->hPal=NULL;
  /*
  ** set Bitmap header stuff
  ** including color palette
  */
  BMP8set(&BmpSz, SzX, SzY, Pal, PalNb);
  Display->SzX=SzX;
  Display->SzY=SzY;
  /*
  ** how many bits for device
  */
  bits = GetDeviceCaps((HDC)Display->hDC, PLANES) * GetDeviceCaps((HDC)Display->hDC, BITSPIXEL);
  /*
  ** Set palette, if device or BMP needs it.
  */
  if(bits<=8)
  { BMP8logPal.palVersion = 0x300;
	 BMP8logPal.palNumEntries = PalNb;
	 /*
	 ** Set palette (don't copy palette directly)
	 ** Don't match colors to system colors
	 */
	 for(p = 0; p < PalNb; p++)
	 { BMP8logPal.palPalEntry[p].peBlue  = BmpI.bmiColors[p].rgbBlue;
		BMP8logPal.palPalEntry[p].peGreen = BmpI.bmiColors[p].rgbGreen;
		BMP8logPal.palPalEntry[p].peRed   = BmpI.bmiColors[p].rgbRed;
		BMP8logPal.palPalEntry[p].peFlags = PC_NOCOLLAPSE;/*don't match*/
	 }
	 /*
	 ** Create a logical palette
	 */
	 Display->hPal = CreatePalette((LPLOGPALETTE)&BMP8logPal);
	 if(Display->hPal == NULL)
	 { return ERRfault(BAD_WIN1);}
	 /*
	 ** select palette, so that DC has right colors
	 */
	 oldPal=SelectPalette((HDC)Display->hDC,(HPALETTE)Display->hPal,0);
	 if(oldPal==NULL)
	 { return ERRfault(BAD_WIN2);}
	 /*
	 ** realise palette
	 */
	 RealizePalette((HDC)Display->hDC);
  }
  /*
  ** Create a compatible bitmap, from Device Independant Bitmap
  */
  Display->hBitmap = CreateDIBitmap((HDC)Display->hDC, (LPBITMAPINFOHEADER)&BmpI.bmiHeader,CBM_INIT, Ptr, (LPBITMAPINFO)&BmpI,DIB_RGB_COLORS);
  if(Display->hPal!=NULL)
  {
	 SelectPalette((HDC)Display->hDC,oldPal,0);
  }
  if(Display->hBitmap == NULL){ return ERRfault(BAD_WIN);}
  /*
  ** Resize windows
  */
#if 1 /*doesn't bug visual basic*/
  SetWindowPos ((HWND)Display->hWnd,NULL,0, 0,Display->SzX,Display->SzY,SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE);
#endif
#endif /*__WINDOWS__*/
  return 1;
}
/*
** Get the color in palette closest to (R,G,B)
** starting from Start (to favorize right palette)
*/
#define ABS(a) (((a)<0)?-(a):(a))
Int8 BMP8getColor(pRGB Palette,Int16 Start,Int16 R,Int16 G,Int16 B)
{ Int16 n,c,r,g,b;
  Int16 best=0x4000;
  Int16 test=0;
  Int8 bestc=0;
  R&=0xFF; G&=0xFF; B&=0xFF;
  for(n=0,c=Start;n<256;n++)
  {  r = (((Int16)Palette[c].R)&0xFF)-(R);
	  g = (((Int16)Palette[c].G)&0xFF)-(G);
	  b = (((Int16)Palette[c].B)&0xFF)-(B);
	  test = ABS(r)+ABS(g)+ABS(b);
	  if(test<best){best=test;bestc=(Int8)c;}
	  if(best<2)break;
	  c++;
	  if(c>=256)c=0;
  }
  return bestc;
}
/*
** quantize a BMP buffer
*/
Int16 BMP8quantize8(pInt8 Ptr,Int32 BmpSz,pRGB Palette)
{ static Int16 c;
  static Int32 p;
  static pInt8 P;
  static Int8 NewIndex[256]; /*conversion table*/
  if(Ptr==NULL) return ERRfault(ERR_BUG);
  /*
  ** Create a conversion table, from old index to new indexes
  */
  for(c=0;c<256;c++) /*init conversion table*/
  { NewIndex[c]=BMP8getColor(Palette,c, BmpI.bmiColors[c].rgbRed,BmpI.bmiColors[c].rgbGreen,BmpI.bmiColors[c].rgbBlue);
  }
  /*
  ** Convert all bytes
  */
  for(p=0,P=Ptr; p<BmpSz; p++, P+=1)
  { *P = NewIndex[((Int16)(*P))&0xFF];
  }
  return 1;
}

/*
** Convert a Bmp to 8 bit, conform to Palette
*/
static pInt8 BMP8convert(pInt32 pLineSz, pInt32 pBmpSz,pInt8 Ptr,Int16 SzX,Int16 SzY,Int16 NBits,pRGB Palette)
{ static Int32 LineSz,BmpSz;
  static Int32 oLineSz;
  pInt8 oPos;
  pInt8 Pos;
  static Int16 x,y;
  /*8bit size*/
  *pLineSz= LineSz= ((Int32)SzX +3L)& (~3L);
  *pBmpSz= BmpSz=  ((Int32)SzY)*LineSz;
  switch(NBits)
  { case 24:
	  /*
	  **  ULTRA-SLOW COLOR CONVERSION
	  **  This should use a hash table, definitely!
	  **  Well, someone code it. Ain't too hard...
     */
     oLineSz= ((3L*((Int32)SzX))+3L)&(~3L);
     /*convert*/
     for(oPos=Pos=Ptr,y=0;y<SzY;y++,Pos+= LineSz,oPos+=oLineSz)
     { for(x=0;x<SzX;x++)
       { Pos[x]= (Int8)BMP8getColor(Palette,0,oPos[3*x],oPos[3*x+1],oPos[3*x+2]);
       }
     }
     /*realloc*/
     Ptr=Realloc(Ptr,BmpSz);
     if(Ptr==NULL) return NULL;
     break;
   case 4:
     oLineSz= ((((Int32)SzX)>>1)+3L)&(~3L);
     Ptr=Realloc(Ptr,BmpSz);
     if(Ptr==NULL) return NULL;
     /*convert*/
     for(oPos=Pos=Ptr,y=0;y<SzY;y++,Pos+= LineSz,oPos+=oLineSz)
     { for(x=0;x<SzX;x+=2)
       { Pos[x]  =  (oPos[x>>1])&0x0F;
	 Pos[x+1]= ((oPos[x>>1])>>4)&0x0F;
       }
     }
     /*Now convert as if Bmp 8 bits*/
   case 8:
     /*convert colors of Bmp 8 bits*/
     if(BMP8quantize8(Ptr, BmpSz, Palette)<0) return NULL;
     break;
   default:
     return NULL;
  }
  return Ptr;
}
/*
** Read Bitmap File into Bmp structure
** return Ptr to bitmap, SizeX,SizeY if ok
*/
pInt8 BMP8readBMP(pInt16 pSzX, pInt16 pSzY, pRGB Palette, pInt8 File)
{ static Int32 res,BmpSz,PalSz,LineSz;
  static Int16 SzX,SzY,NBits;
  static pInt8 Ptr;
  /*
  ** Open file
  */
  res=FILEopen(File,FREAD);
  if(res<0) return NULL;
  /*
  ** Read Bmp File header
  */
  res=FILEread((pInt8)(&BmpH),-1,sizeof(BMPHEAD));
  if(res<0)
  { FILEclose(); ERRfault(BAD_HDRBMP); return NULL;}
  /*
  ** Check header
  */
  if((BmpH.id[0]!='B') || (BmpH.id[1]!='M'))
  { FILEclose(); ERRfault(BAD_HDRBMP); return NULL;}
  /*
  ** load the BMP structure
  */
  res=FILEread((pInt8)&BmpI.bmiHeader,-1,sizeof(BITMAPINFOHEADER));
  if(res<0)
  { FILEclose(); return NULL;}
  if(BmpI.bmiHeader.biSize!=sizeof(BITMAPINFOHEADER))
  { FILEclose(); ERRfault(BAD_HDRBMP); return NULL;}
  if(BmpI.bmiHeader.biCompression!=BI_RGB)
  { FILEclose(); ERRfault(BAD_NORGB); return NULL;}
  /*
  ** determine parameters
  */
  NBits=BmpI.bmiHeader.biBitCount;
  SzX=(Int16) BmpI.bmiHeader.biWidth;
  SzY=(Int16) BmpI.bmiHeader.biHeight;
  switch(NBits)
  { case 8:
      LineSz = (Int32)SzX;
      PalSz=256*sizeof(RGBQUAD);
      break;
    case 24:
      LineSz = 3*((Int32)SzX);
      PalSz=0;
      break;
    case 4:
      LineSz = ((Int32)SzX)/2;
      PalSz=16*sizeof(RGBQUAD);
      break;
    default:
     ERRfault(BAD_NBIT);
     FILEclose(); return NULL;
  }
  LineSz= (LineSz+ 3L) & (~3L);
  BmpSz = LineSz*((Int32)SzY);
  /*
  ** Test
  */
  if((SzX<1)||(SzY<1)||(SzX>=512)||(SzY>=256))
  { FILEclose(); ERRfault(BAD_PICSZ); return NULL;}
  /*
  ** Read palette
  */
  if(PalSz>0)
  { res=FILEread((pInt8)&BmpI.bmiColors,-1,PalSz);
    if(res<0)
	 { FILEclose(); ERRfault(BAD_HDRBMP); return NULL;}
  }
  /*
  ** Allocate Bmp bits
  */
  Ptr=Malloc(BmpSz);
  if(Ptr==NULL)
  { FILEclose(); return NULL;}
  /*
  **  read Bmp Data, in reverse Y order (top to down)
  **  at position headersize.
  */
  res=FILEread(Ptr,BmpH.headersize,BmpSz);
  FILEclose();
  if(res<0)
  { Free(Ptr);return NULL;}
  /*
  ** Convert to 8 bits, palette
  */
  Ptr=BMP8convert(&LineSz,&BmpSz,Ptr,SzX,SzY,NBits,Palette);
  if(Ptr==NULL) return NULL;
  /*
  ** NBits=8, return
  */
  *pSzX=SzX;
  *pSzY=SzY;
  return Ptr;
}
/*
** write a BMP to a file, free BMP
*/
Int16 BMP8writeBMP(pInt8 Ptr,Int16 SzX,Int16 SzY, pRGB Pal,pInt8  File)
{ static Int32 res,PalSz,BmpSz;

  BMP8set(&BmpSz, SzX, SzY, Pal,256);
  /*
  ** open file
  */
  res=FILEopen(File,FCREATE);
  if(res<0)
  { return (Int16)res;}
  /*
  ** size of palette
  */
  PalSz=256*sizeof(RGBQUAD);
  /*
  ** Compose Bmp file header
  */
  BmpH.id[0]='B';     BmpH.id[1]='M';
  BmpH.reserved[0]=0; BmpH.reserved[1]=0;
  BmpH.headersize= sizeof(BMPHEAD)+sizeof(BITMAPINFOHEADER)+PalSz;
  BmpH.filesize=   BmpH.headersize+ BmpSz;
  /*
  ** Write Bmp file header
  */
  res=FILEwrite((pInt8)(&BmpH),0,sizeof(BMPHEAD));
  if(res<0)
  { FILEclose();return (Int16)res;}
  /*
  ** Write palette
  */
  res=FILEwrite((pInt8)&BmpI,-1,sizeof(BITMAPINFO256));
  if(res<0)
  { FILEclose();return (Int16)res;}
  /*
  ** Write Bmp bytes, which MUST  be stored in the
  ** inverse Y order (from down to top)
  **
  */
  res=FILEwrite(Ptr,-1,BmpSz);
  FILEclose();
  if(res<0)
  { return (Int16)res;}
  return 1;
}
