//========================================================================
// Quick MUS->MID converter by S.Bacquet for WinTex by O.Montanuy
// 11-25-95
// Compiled with Borland C++ 3.1
//========================================================================

#if !defined( __QMUS2MID_H )
#define __QMUS2MID_H

#define	MUSFILECOR	-1	// MUS file corrupted
#define	TOOMCHAN		-2	// Too many channels
#define	MEMALLOC		-3	// Memory allocation error

typedef struct Track huge * pTrack;
typedef struct MUSheader huge * pMUSheader;

// MUS header
typedef struct MUSheader
{
	Int8			ID[4] ;          // identifier "MUS" 0x1A
	UInt16      ScoreLength ;    // length of score
	UInt16  		ScoreStart ;     // start of score
	UInt16  		channels ;	     // count of primary channels
	UInt16   	SecChannels ;	  // count of secondary channels (?)
	UInt16  		InstrCnt ;       // count of instruments
	UInt16  		dummy ;          // ????
	pUInt16  	instruments ;   // list of intruments
};


// MIDI track
struct Track
{
	UInt32  current ;      // the current position in the track
	Int8   vel ;          // velocity of the last note
	Int32   DeltaTime ;    // the current delta time of the track
	UInt8  LastEvent ;    // thee last event occured in the track
	pUInt8 data ;	       // MIDI data
} ;


// The killing function !
pInt8 qmus2mid(pInt32 midsize, const pInt8 musdata, Int32 mussize,  Int16 division, Int32 BufferSize, Int16 nocomp ) ;

#endif
