VERSION 2.00
Begin Form GetTexu 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Select a texture"
   ClientHeight    =   3990
   ClientLeft      =   1185
   ClientTop       =   1740
   ClientWidth     =   7755
   ForeColor       =   &H00000000&
   Height          =   4365
   Left            =   1140
   LinkTopic       =   "Form1"
   ScaleHeight     =   3990
   ScaleWidth      =   7755
   Top             =   1410
   Width           =   7845
   Begin OptionButton TexuOpt 
      BackColor       =   &H00C0C0C0&
      Caption         =   "LowerTexture"
      ForeColor       =   &H00000000&
      Height          =   315
      Index           =   1
      Left            =   2760
      TabIndex        =   4
      Top             =   3480
      Width           =   1695
   End
   Begin OptionButton TexuOpt 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Middle Texture"
      ForeColor       =   &H00000000&
      Height          =   315
      Index           =   2
      Left            =   2760
      TabIndex        =   7
      Top             =   3000
      Width           =   1695
   End
   Begin OptionButton TexuOpt 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Upper Texture"
      ForeColor       =   &H00000000&
      Height          =   315
      Index           =   0
      Left            =   2760
      TabIndex        =   8
      Top             =   2520
      Value           =   -1  'True
      Width           =   1695
   End
   Begin CheckBox IsTexu 
      BackColor       =   &H00C0C0C0&
      Caption         =   "IsTexu"
      ForeColor       =   &H00000000&
      Height          =   255
      Left            =   6600
      TabIndex        =   9
      Top             =   180
      Visible         =   0   'False
      Width           =   915
   End
   Begin ListBox DirB 
      BackColor       =   &H00C0C0C0&
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "System"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00000000&
      Height          =   3630
      Left            =   120
      MultiSelect     =   2  'Extended
      TabIndex        =   6
      Top             =   180
      Width           =   2175
   End
   Begin PictureBox PicB 
      BackColor       =   &H00000000&
      BorderStyle     =   0  'None
      ClipControls    =   0   'False
      Height          =   2055
      Left            =   2460
      MousePointer    =   2  'Cross
      ScaleHeight     =   2055
      ScaleWidth      =   3855
      TabIndex        =   5
      Top             =   180
      Width           =   3855
   End
   Begin CommandButton CmdVoid 
      BackColor       =   &H00C0C0C0&
      Caption         =   "No Texture"
      Height          =   375
      HelpContextID   =   500
      Left            =   6480
      TabIndex        =   3
      Top             =   1860
      Width           =   1155
   End
   Begin CommandButton CmdCancel 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Cancel"
      Height          =   375
      HelpContextID   =   500
      Left            =   6480
      TabIndex        =   1
      Top             =   1200
      Width           =   1155
   End
   Begin CommandButton CmdOkay 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Okay"
      Height          =   375
      HelpContextID   =   500
      Left            =   6480
      TabIndex        =   0
      Top             =   660
      Width           =   1155
   End
   Begin Label TexuName 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "-"
      ForeColor       =   &H00000000&
      Height          =   255
      Index           =   1
      Left            =   4800
      TabIndex        =   12
      Top             =   3540
      Width           =   1335
   End
   Begin Label TexuName 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "-"
      ForeColor       =   &H00000000&
      Height          =   255
      Index           =   2
      Left            =   4800
      TabIndex        =   11
      Top             =   3060
      Width           =   1335
   End
   Begin Label TexuName 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "-"
      ForeColor       =   &H00000000&
      Height          =   255
      Index           =   0
      Left            =   4800
      TabIndex        =   10
      Top             =   2580
      Width           =   1335
   End
   Begin Label PwadRef 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "PWadRef"
      ForeColor       =   &H000000FF&
      Height          =   195
      Left            =   780
      TabIndex        =   2
      Top             =   540
      Visible         =   0   'False
      Width           =   855
   End
End
Option Explicit
'
'
Dim PWADself%      'ref. of the PWAD
Dim PWADgame%    'code for the game
Dim PWADmainWad% 'main Wad
Dim PWADisTexu%  'is it a texture, or a flat?
'
Dim DirBB As windoze
'
Dim PicBB As windoze

Sub CmdCancel_Click ()
  Unload Me
End Sub

Sub CmdOkay_Click ()
  Dim nam$
  nam$ = Left$(UCase$(Trim$(TexuName(0).Caption)) & "        ", 8)
  nam$ = nam$ & Left$(UCase$(Trim$(TexuName(1).Caption)) & "        ", 8)
  nam$ = nam$ & Left$(UCase$(Trim$(TexuName(2).Caption)) & "        ", 8)
  Call ChooseSetRes(nam$)
  Unload Me
End Sub

Sub CmdVoid_Click ()
  Call DirSet("-")
End Sub

Sub DirB_Click ()
  ' Display a texture when clicked in texture list
  '
  Dim Entry%, Ident%, nam$
  Entry% = PWADdirGetName%(DirB, Ident%, nam$)
  If Entry% < 0 Then Exit Sub
  nam$ = Trim$(Left$(nam$, 8))
  If nam$ = "" Then Exit Sub
  If PWADisTexu% Then  '
    ' set texture
    Call TexuSetAndDisplay(Entry%, nam$)
  Else
    ' set flat
    Call FlatSetAndDisplay(Entry%, nam$)
  End If
End Sub

Sub DirSelect ()
  'select
  Dim nam$
  If TexuOpt(0).Value Then nam$ = TexuName(0).Caption
  If TexuOpt(1).Value Then nam$ = TexuName(1).Caption
  If TexuOpt(2).Value Then nam$ = TexuName(2).Caption
  Call ListFindSelect(DirB, nam$)
End Sub

Sub DirSet (ByVal nam$)
  If TexuOpt(0).Value Then TexuName(0).Caption = nam$
  If TexuOpt(1).Value Then TexuName(1).Caption = nam$
  If TexuOpt(2).Value Then TexuName(2).Caption = nam$
End Sub

Sub FlatSetAndDisplay (ByVal Entry%, ByVal nam$)
  '
  ' Set flat name and display it
  '
  Call DirSet(nam$)
  '
  '
  ' Show flat
  '
  If Entry% < 0 Then Exit Sub
  '
  ' Redraw Texture
  '
  PicBB.Typ = WpicBox
  PicBB.hWnd = PicB.hWnd
  PicBB.hDC = PicB.hDC
  '
  Dim res%
  res% = WADshowByName(PWADself%, PicBB, 7, nam$)'7=EFLAT
  If res% < 0 Then Exit Sub
  'paint picture
  res% = WADshowWindoze(PicBB, 0)
End Sub

Sub Form_Load ()
  Call WindowInit
End Sub

Sub Form_Unload (Cancel As Integer)
  Call WindowFree
End Sub

Sub PicB_Paint ()
  Dim res%
  PicBB.Typ = WpicBox
  PicBB.hWnd = PicB.hWnd
  PicBB.hDC = PicB.hDC
  res% = WADshowWindoze(PicBB, 0)
End Sub

Sub PwadRef_Change ()
  If WindowInit2(Val(PwadRef.Caption)) > 0 Then Exit Sub
  '
  Unload Me
End Sub

Sub TexuList ()
  ' list all textures
  DirB.Visible = False
  DirBB.Typ = WlistBox
  DirBB.hWnd = DirB.hWnd
  If WADTlistTex(PWADself%, DirBB, 0, -1) < 0 Then Exit Sub
  DirB.Visible = True
  Call DirSelect
End Sub

Sub TexuSetAndDisplay (ByVal texu%, ByVal nam$)
  '
  ' set texture name and display it
  '
  'Dim szx%, szy%, nam$, res%
  'Dim buf As String * 10
  ' get name
  'res% = WADTgetTex(PWADSelf%, texu%, buf$, szx%, szy%)
  'If res% < 0 Then Exit Sub
  'nam$ = Trim$(Left$(buf$, res%))
  '
  ' Set texture name
  '
  Call DirSet(nam$)
  '
  '
  ' Show texture
  '
  If texu% < 0 Then Exit Sub
  '
  ' Redraw Texture
  '
  PicBB.Typ = WpicBox
  PicBB.hWnd = PicB.hWnd
  PicBB.hDC = PicB.hDC
  '
  Dim res%
  res% = WADTshowTex(PWADself%, texu%, PicBB)
  If res% < 0 Then Exit Sub
  'show texture
  res% = WADshowWindoze(PicBB, 0)
  'TexuB.Refresh 'provokes out of stack space
End Sub

Sub WindowFree ()
  '
  ' free pic boxes
  '
  Dim res%
  PicBB.Typ = WpicBox
  res% = WADshowWindoze(PicBB, -1)
  '
  '
  If PWADself% < 0 Then Exit Sub
  '
  'free texture list
  res% = WADTfree(PWADself%)
  '
  ' exit
End Sub

Sub WindowInit ()
  '
  ' boxes
  '
  DirBB.Typ = WlistBox
  Dim res%
  PicBB.Typ = WpicBox
  res% = WADshowWindoze(PicBB, 1)
End Sub

Function WindowInit2% (ByVal Self%)
  '
  ' Init window
  '
  WindowInit2% = -1 'fail, by default
  '
  PWADisTexu% = False
  If IsTexu.Value = 1 Then PWADisTexu% = True
  '
  ' Check if PWAD exists
  '
  PWADself% = Self%       'reference of WAd
  Dim dirty%, file$
  If Not PWADgetInfo(PWADself%, PWADgame%, PWADmainWad%, dirty%, file$) Then
    Unload Me
    Exit Function
  End If
  '
  ' set windoze handle
  '
  If WADsetCustoms(PWADself%, Me.hWnd) < 0 Then Exit Function
  
  Dim res%
  If PWADisTexu% Then
    TexuOpt(2).Value = True
    '
    ' Init texture (should check PWADself before)
    '
    '
    Screen.MousePointer = 11'wait
    res% = WADTinit(PWADself%)
    Screen.MousePointer = 0 'end wait
    '
    If res% < 0 Then
      PWADself% = -1
      Unload Me
    End If
    '
    ' List all textures in PWAD or IWAD
    '
    '
    Call TexuList
    '
  Else
    '
    ' Init Flats
    '
    CmdVoid.Visible = False 'flats cannot be void
    TexuOpt(1).Value = True
    TexuOpt(2).Visible = False 'hide middle
    TexuName(2).Visible = False'hide middle
    '
    ' List flats
    '
    DirB.Visible = False
    DirB.Clear
    DirBB.Typ = WlistBox
    DirBB.hWnd = DirB.hWnd
    res% = WADlistAll(PWADself%, DirBB, 7)'7=EFLAT
    If res% < 0 Then Exit Function
    DirB.Visible = True
    Call DirSelect
  End If
  '
  WindowInit2% = 1 'ok
End Function

