VERSION 2.00
Begin Form EdtFlat 
   Caption         =   "Edit Flats"
   ClientHeight    =   4890
   ClientLeft      =   1020
   ClientTop       =   1545
   ClientWidth     =   6420
   Height          =   5265
   HelpContextID   =   800
   Icon            =   EDTFLAT.FRX:0000
   Left            =   975
   LinkTopic       =   "Form1"
   ScaleHeight     =   4890
   ScaleWidth      =   6420
   Top             =   1215
   Width           =   6510
   Begin Frame PicFrame 
      BackColor       =   &H00C0C0C0&
      ClipControls    =   0   'False
      Height          =   1575
      HelpContextID   =   4010
      Left            =   2040
      TabIndex        =   11
      Top             =   120
      Width           =   1635
      Begin PictureBox FlatPic 
         BackColor       =   &H00FFFF00&
         BorderStyle     =   0  'None
         Height          =   1395
         Left            =   60
         ScaleHeight     =   1395
         ScaleWidth      =   1515
         TabIndex        =   12
         Top             =   120
         Width           =   1515
      End
   End
   Begin CommandButton Cmd 
      Caption         =   "Rename"
      Height          =   315
      HelpContextID   =   4050
      Index           =   1
      Left            =   180
      TabIndex        =   10
      Top             =   3960
      Width           =   1155
   End
   Begin CommandButton Cmd 
      Caption         =   "Import"
      Height          =   315
      HelpContextID   =   4040
      Index           =   2
      Left            =   180
      TabIndex        =   9
      Top             =   3120
      Width           =   1155
   End
   Begin ListBox EntryName 
      BackColor       =   &H00808080&
      Height          =   1980
      HelpContextID   =   4045
      Left            =   120
      TabIndex        =   8
      Top             =   1020
      Width           =   1575
   End
   Begin CommandButton CmdSave 
      BackColor       =   &H00808080&
      Caption         =   "Save"
      Height          =   315
      HelpContextID   =   4070
      Left            =   180
      TabIndex        =   7
      Top             =   540
      Width           =   1155
   End
   Begin SSCheck ERepeat 
      Caption         =   "Repeat previous entry"
      Font3D          =   0  'None
      Height          =   195
      HelpContextID   =   4000
      Left            =   3960
      TabIndex        =   6
      Top             =   1500
      Width           =   2235
   End
   Begin ListBox FlatLst 
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Courier"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   2565
      Left            =   1800
      TabIndex        =   5
      Top             =   1800
      Width           =   4455
   End
   Begin ComboBox Ident 
      Height          =   300
      HelpContextID   =   4060
      Left            =   1800
      TabIndex        =   4
      TabStop         =   0   'False
      Text            =   "HELP"
      Top             =   4500
      Width           =   4455
   End
   Begin CommandButton Cmd 
      Caption         =   "Add"
      Height          =   315
      HelpContextID   =   4020
      Index           =   0
      Left            =   180
      TabIndex        =   3
      Top             =   3540
      Width           =   1155
   End
   Begin CommandButton Exit 
      BackColor       =   &H00808080&
      Caption         =   "Quit"
      Height          =   315
      Left            =   180
      TabIndex        =   2
      Top             =   120
      Width           =   1155
   End
   Begin Label Info 
      Caption         =   "They are used for floors and ceilings, not sky."
      ForeColor       =   &H00800000&
      Height          =   435
      Index           =   1
      Left            =   4080
      TabIndex        =   14
      Top             =   960
      Width           =   2055
   End
   Begin Label Info 
      Caption         =   "Flats are bitmaps of size 64x64, without any transparent areas."
      Height          =   675
      Index           =   0
      Left            =   4140
      TabIndex        =   13
      Top             =   240
      Width           =   1935
   End
   Begin Image CmdForget 
      Height          =   480
      Left            =   480
      Picture         =   EDTFLAT.FRX:0302
      Top             =   4320
      Width           =   480
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   7
      X1              =   660
      X2              =   1500
      Y1              =   4620
      Y2              =   4620
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   6
      X1              =   1080
      X2              =   1980
      Y1              =   4140
      Y2              =   4140
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   5
      X1              =   1680
      X2              =   1500
      Y1              =   3300
      Y2              =   3240
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   2
      X1              =   1680
      X2              =   1500
      Y1              =   3300
      Y2              =   3360
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   4
      X1              =   1980
      X2              =   840
      Y1              =   3300
      Y2              =   3300
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   3
      X1              =   1080
      X2              =   1980
      Y1              =   3720
      Y2              =   3720
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   1
      X1              =   840
      X2              =   840
      Y1              =   3120
      Y2              =   2640
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   0
      X1              =   1500
      X2              =   1500
      Y1              =   4140
      Y2              =   4620
   End
   Begin Label WorkDirec 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "work dir"
      ForeColor       =   &H000000FF&
      Height          =   195
      Left            =   4020
      TabIndex        =   1
      Top             =   60
      Visible         =   0   'False
      Width           =   855
   End
   Begin Label WadInfo 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "wadinfo.txt"
      ForeColor       =   &H000000FF&
      Height          =   255
      Left            =   5040
      TabIndex        =   0
      Top             =   60
      Visible         =   0   'False
      Width           =   915
   End
End
Option Explicit
Dim ListDirty As Integer
Dim FlatFileNam As String

Sub Cmd_Click (Index As Integer)
   Dim file$, file2$
   Dim nam$, entry$
   Dim X%, Y%, repeat%
   Select Case Index
     Case 0 'new
       If Not Tutor("add a new flat to the list. The entry name is taken from the drop box.") Then Exit Sub
       entry = HelpGetName(Ident, True)
       If Len(entry) <= 0 Then Exit Sub
       file = ChooseFile(".", "*.bmp", True, "Select a new Flat (64x64 .BMP)")
       If Not DIRexistFile(file) Then
         nam = ""
         repeat = True
       Else
         repeat = False
         nam = FileName(file)
         file2 = MakeFileName(WorkDirec.Caption, nam)
         Call EditCopyFile(file, file2)
         nam = FileRoot(file)
       End If
       nam = EntryMake(entry, INVALID, INVALID, nam, repeat)
       If Len(nam) <= 0 Then Exit Sub
       FlatLst.ListIndex = ListInsert(FlatLst, nam$)
       ListDirty = True
     Case 1 'rename
       If Not Tutor("rename a flat using a name taken from the drop box.") Then Exit Sub
       If FlatLst.ListIndex < 0 Then Exit Sub
       entry = EntryGet(X, Y, nam, repeat, FlatLst.Text)
       entry = HelpGetName(Ident, True)
       If Len(entry) <= 0 Then Exit Sub
       nam = EntryMake(entry, INVALID, INVALID, nam, repeat)
       If Len(nam) <= 0 Then Exit Sub
       FlatLst.List(FlatLst.ListIndex) = nam
       ListDirty = True
     Case 2 'import
       If EntryName.ListIndex < 0 Then Exit Sub
       entry$ = EntryName.Text
       Dim ofx%, ofy%
       If Not WADexportName(WorkDirec.Caption, entry$, ofx%, ofy%) Then Exit Sub
       nam = EntryMake(entry$, INVALID, INVALID, entry$, False)
       If Len(nam) <= 0 Then Exit Sub
       FlatLst.ListIndex = ListInsert(FlatLst, nam$)
       ListDirty = True
   End Select
End Sub

Sub CmdForget_Click ()
  Call EntryDelete(FlatLst, WorkDirec.Caption, ".BMP")
  ListDirty = True
End Sub

Sub CmdSave_Click ()
  If Not Tutor("save the modifications") Then Exit Sub
  If Not ListDirty Then Exit Sub
  Call SectionWrite(FlatLst, WadInfo.Caption, "FLATS")
  ListDirty = False
End Sub

Sub EntryName_Click ()
   If EntryName.ListIndex < 0 Then Exit Sub
   Call WADshowName(FlatPic, EntryName.Text)
   Call HelpMatch(Ident, EntryName.Text)
End Sub

Sub EntryName_KeyPress (KeyAscii As Integer)
  KeyAscii = WADnameSeek(EntryName, KeyAscii)
End Sub

Sub ERepeat_Click (Value As Integer)
  If FlatLst.ListIndex <= 0 Then Exit Sub
  Dim nam$, entry$
  Dim X%, Y%, repeat%
  entry = EntryGet(X, Y, nam, repeat, FlatLst.Text)
  If repeat = Value Then Exit Sub
  repeat = Value
  FlatLst.List(FlatLst.ListIndex) = EntryMake(entry, INVALID, INVALID, nam, repeat)
  ListDirty = True
End Sub

Sub Exit_Click ()
 Unload Me
End Sub

Sub FlatLst_Click ()
  'Call HelpMatch(Ident, nam)
   If FlatLst.ListIndex < 0 Then Exit Sub
   Dim nam$, entry$
   Dim X%, Y%, repeat%
   entry = EntryGet(X, Y, nam, repeat, FlatLst.Text)
   'load file if exists
   Dim filenam As String
   filenam = MakeFileName(WorkDirec.Caption, nam & ".bmp")
   If repeat Then filenam = ""
   Call Display(FlatPic, FlatFileNam, filenam)
   Call HelpMatch(Ident, entry)
End Sub

Sub FlatLst_DblClick ()
   If FlatLst.ListIndex < 0 Then Exit Sub
   Dim nam$, entry$
   Dim X%, Y%, repeat%
   entry = EntryGet(X, Y, nam, repeat, FlatLst.Text)
   If repeat Then Exit Sub
   Dim file$
   file = MakeFileName(WorkDirec.Caption, nam & ".bmp")
   Call EditBmpFile(file)
End Sub

Sub FlatLst_KeyDown (KeyCode As Integer, Shift As Integer)
  Select Case KeyCode
    Case KEY_DELETE
      Call EntryDelete(FlatLst, WorkDirec.Caption, ".BMP")
      ListDirty = True
  End Select
End Sub

Sub FlatPic_Click ()
  Call EditBmpFile(FlatFileNam)
End Sub

Sub Form_Load ()
   ListDirty = False

End Sub

Sub Form_Unload (Cancel As Integer)
  If Not ListDirty Then Exit Sub
  If QueryOk("Save file " & WadInfo.Caption & " ?") Then Call CmdSave_Click
End Sub

Sub Ident_Change ()
  Call HelpCheckSelect(Ident)
End Sub

Sub Ident_KeyDown (KeyCode As Integer, Shift As Integer)
   If KeyCode = KEY_DELETE Then KeyCode = 0
End Sub

Sub Ident_KeyPress (KeyAscii As Integer)
  KeyAscii = HelpKeyPress(Ident, KeyAscii)
End Sub

Sub Info_Click (Index As Integer)
   Select Case Index
     Case 0
       Call Infos("Don't leave transparent areas, and don't use repeating patterns like grids (because of aliasing)")
     Case 1
       Call Infos("Sky is not a flat. It is made with texture SKY1, SKY2 or SKY3 depending on the level. The flat F_SKY1 is used to indicate sky, but the picture is irrelevant.")
   End Select
End Sub

Sub WadInfo_Change ()
  Select Case typeIWAD()
   Case 10, 11 'doom
   Call HelpD(Ident, "F_SKY1", "Display Sky texture")
   Call HelpD(Ident, "NUKAGE1", "Anim start")
   Call HelpD(Ident, "NUKAGE3", "Anim stop")
   Call HelpD(Ident, "FWATER1", "Anim start")
   Call HelpD(Ident, "FWATER4", "Anim stop")
   Call HelpD(Ident, "SWATER1", "Anim start")
   Call HelpD(Ident, "SWATER4", "Anim stop")
   Call HelpD(Ident, "LAVA1", "Anim start")
   Call HelpD(Ident, "LAVA4", "Anim stop")
   Call HelpD(Ident, "BLOOD1", "Anim start")
   Call HelpD(Ident, "BLOOD3", "Anim stop")
   Case 12 'doom2
   Call HelpD(Ident, "RROCK05", "Anim start")
   Call HelpD(Ident, "RROCK08", "Anim stop")
   Call HelpD(Ident, "SLIME01", "Anim start")
   Call HelpD(Ident, "SLIME04", "Anim stop")
   Call HelpD(Ident, "SLIME05", "Anim start")
   Call HelpD(Ident, "SLIME08", "Anim stop")
   Call HelpD(Ident, "SLIME09", "Anim start")
   Call HelpD(Ident, "SLIME12", "Anim stop")
   Case 20, 21, 22'heretic
   Call HelpD(Ident, "FLTWAWA1", "Anim start. splash!")
   Call HelpD(Ident, "FLTWAWA3", "Anim stop.")
   Call HelpD(Ident, "FLTSLUD1", "Anim start. splash!")
   Call HelpD(Ident, "FLTSLUD3", "Anim stop.")
   Call HelpD(Ident, "FLTTELE1", "Anim start.")
   Call HelpD(Ident, "FLTTELE4", "Anim stop.")
   Call HelpD(Ident, "FLTFLWW1", "Anim start. splash!")
   Call HelpD(Ident, "FLTFLWW3", "Anim stop.")
   Call HelpD(Ident, "FLTLAVA1", "Anim start. splash!")
   Call HelpD(Ident, "FLTLAVA4", "Anim stop.")
   Call HelpD(Ident, "FLATHUH1", "Anim start.")
   Call HelpD(Ident, "FLATHUH4", "Anim stop.")
  End Select
  Call HelpD(Ident, "????????", "Any Flat")
  Call HelpMatch(Ident, "--------")'set to ????
  'load list
  ListDirty = False
  'read section  1 = no   X Y offset
  Call SectionRead(FlatLst, WadInfo.Caption, "FLATS", 1)
End Sub

