VERSION 2.00
Begin Form EdtLump 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Edit Lumps"
   ClientHeight    =   4005
   ClientLeft      =   1185
   ClientTop       =   1740
   ClientWidth     =   5865
   ClipControls    =   0   'False
   FontBold        =   -1  'True
   FontItalic      =   0   'False
   FontName        =   "Courier"
   FontSize        =   9.75
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   4380
   HelpContextID   =   200
   Icon            =   EDTLUMP.FRX:0000
   Left            =   1140
   LinkTopic       =   "Form1"
   ScaleHeight     =   4005
   ScaleWidth      =   5865
   Top             =   1410
   Width           =   5955
   Begin CommandButton CmdSave 
      BackColor       =   &H00808080&
      Caption         =   "Save"
      Height          =   315
      HelpContextID   =   4070
      Left            =   300
      TabIndex        =   7
      Top             =   540
      Width           =   1155
   End
   Begin CommandButton CmdImp 
      Caption         =   "Import"
      Height          =   315
      HelpContextID   =   4040
      Left            =   1920
      TabIndex        =   9
      Top             =   3120
      Width           =   1155
   End
   Begin ListBox EntryName 
      BackColor       =   &H00808080&
      Height          =   2955
      HelpContextID   =   4045
      Left            =   180
      TabIndex        =   8
      Top             =   960
      Width           =   1635
   End
   Begin CommandButton CmdEdit 
      Caption         =   "Edit"
      Height          =   315
      Left            =   3300
      TabIndex        =   6
      Top             =   2700
      Width           =   1155
   End
   Begin ComboBox Ident 
      Height          =   300
      HelpContextID   =   4060
      Left            =   1920
      TabIndex        =   5
      Text            =   "HELP"
      Top             =   3600
      Width           =   3855
   End
   Begin CommandButton CmdNewLump 
      Caption         =   "Add"
      Height          =   315
      HelpContextID   =   4020
      Left            =   3300
      TabIndex        =   2
      Top             =   3120
      Width           =   1155
   End
   Begin ListBox LumpLst 
      Height          =   2370
      Left            =   1980
      TabIndex        =   1
      Top             =   180
      Width           =   3735
   End
   Begin CommandButton Exit 
      BackColor       =   &H00808080&
      Caption         =   "Quit"
      Height          =   315
      Left            =   300
      TabIndex        =   0
      Top             =   120
      Width           =   1155
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   5
      X1              =   2580
      X2              =   2640
      Y1              =   2760
      Y2              =   2940
   End
   Begin Image CmdForget 
      Height          =   480
      Left            =   4980
      Picture         =   EDTLUMP.FRX:0302
      Top             =   2700
      Width           =   480
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   4
      X1              =   2520
      X2              =   2580
      Y1              =   2940
      Y2              =   2760
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   3
      X1              =   5220
      X2              =   5220
      Y1              =   3000
      Y2              =   1980
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   2
      X1              =   2580
      X2              =   2580
      Y1              =   3240
      Y2              =   2220
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   1
      X1              =   3900
      X2              =   3900
      Y1              =   3780
      Y2              =   2400
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   0
      X1              =   2700
      X2              =   1560
      Y1              =   3300
      Y2              =   3300
   End
   Begin Label WorkDirec 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "work dir"
      ForeColor       =   &H00000080&
      Height          =   195
      Left            =   2760
      TabIndex        =   4
      Top             =   2640
      Visible         =   0   'False
      Width           =   495
   End
   Begin Label WadInfo 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "wadinfo.txt"
      ForeColor       =   &H00000080&
      Height          =   195
      Left            =   4680
      TabIndex        =   3
      Top             =   3300
      Visible         =   0   'False
      Width           =   915
   End
End
Option Explicit
Dim match$
Dim ListDirty As Integer

Sub CmdEdit_Click ()
   If LumpLst.ListIndex < 0 Then Exit Sub
   Dim content As String
   Dim entry As String
   Dim nam As String
   Dim X As Integer
   Dim Y As Integer
   Dim repeat As Integer
   entry = EntryGet(X, Y, nam, repeat, LumpLst.Text)
   Call HelpMatch(Ident, entry)
   Dim file As String
   
   Select Case entry
     Case "TITLE", "HELP1", "HELP2", "CREDIT", "E2END", "FINAL1", "FINAL2"
       file = MakeFileName(WorkDirec.Caption, nam & ".bmp")
       EditBmpFile (file)
     Case "ENDOOM", "ENDTEXT", "LOADING"
       file = MakeFileName(WorkDirec.Caption, nam & ".lmp")
       EditTedFile (file)
     Case "DMXGUS"
       'Open file For Binary Access Read As #1
       'content = Input(FileLen(file), #1)
       'Close #1
       'file = MakeFileName(WorkDirec.Caption, nam & ".txt")
       'EditTextFile (file)
   End Select

End Sub

Sub CmdForget_Click ()
   Call EntryDelete(LumpLst, WorkDirec.Caption, ".LMP")
   ListDirty = True
End Sub

Sub CmdImp_Click ()
  Dim file$
  Dim entry$, nam$
  If EntryName.ListIndex < 0 Then Exit Sub
  entry$ = EntryName.Text
  file$ = MakeFileName(WorkDirec.Caption, entry$ & ".lmp")
  If Not IWADexportLump(entry$, file$) Then Exit Sub
  nam = EntryMake(entry$, INVALID, INVALID, entry$, False)
  If Len(nam) <= 0 Then Exit Sub
  LumpLst.ListIndex = ListInsert(LumpLst, nam$)
  ListDirty = True
End Sub

Sub CmdNewLump_Click ()
   If Not Tutor("add a new lump to the list. The entry name is taken from the drop box.") Then Exit Sub
   Dim file$
   Dim nam$, entry$
   entry$ = HelpGetName(Ident, True)
   If Len(entry$) <= 0 Then Exit Sub
   Select Case entry$
     Case "TITLE", "HELP1", "HELP2", "CREDIT", "E2END", "FINAL1", "FINAL2"
      file$ = ChooseFile(".", "*.bmp", True, "Choose a new 320x200 picture")
     Case Else
      file$ = ChooseFile(".", "*.lmp", True, "Choose a new lump")
   End Select
   If Not DIRexistFile(file$) Then Exit Sub
   nam$ = FileName(file$)
   Dim file2$
   file2$ = MakeFileName(WorkDirec.Caption, nam)
   Call EditCopyFile(file$, file2$)
   Dim i As Integer
   i = InStr(nam, ".")
   If i > 1 Then nam = Left$(nam, i - 1)
   nam$ = EntryMake(entry$, INVALID, INVALID, nam$, False)
   If Len(nam$) <= 0 Then Exit Sub
   LumpLst.ListIndex = ListInsert(LumpLst, nam$)
   ListDirty = True
End Sub

Sub CmdSave_Click ()
  If Not Tutor("save the modifications") Then Exit Sub
  If Not ListDirty Then Exit Sub
  Call SectionWrite(LumpLst, WadInfo.Caption, "LUMPS")
  ListDirty = False
End Sub

Sub EntryName_Click ()
   If EntryName.ListIndex < 0 Then Exit Sub
   Call HelpMatch(Ident, EntryName.Text)
End Sub

Sub EntryName_KeyPress (KeyAscii As Integer)
  KeyAscii = WADnameSeek(EntryName, KeyAscii)
End Sub

Sub Exit_Click ()
  Unload Me
End Sub

Sub Form_Load ()
  ListDirty = False
End Sub

Sub Form_Unload (Cancel As Integer)
  If Not ListDirty Then Exit Sub
  If QueryOk("Save file " & WadInfo.Caption & " ?") Then Call CmdSave_Click
End Sub

Sub Ident_Change ()
  Call HelpCheckSelect(Ident)
End Sub

Sub Ident_KeyDown (KeyCode As Integer, Shift As Integer)
   If KeyCode = KEY_DELETE Then KeyCode = 0
End Sub

Sub Ident_KeyPress (KeyAscii As Integer)
  KeyAscii = HelpKeyPress(Ident, KeyAscii)
End Sub

Sub LumpLst_Click ()
   If LumpLst.ListIndex < 0 Then Exit Sub
   Dim entry$, nam$
   Dim X%, Y%, repeat%
   entry = EntryGet(X, Y, nam, repeat, LumpLst.Text)
   Call HelpMatch(Ident, entry)
End Sub

Sub LumpLst_DblClick ()
  Call CmdEdit_Click
End Sub

Sub LumpLst_KeyDown (KeyCode As Integer, Shift As Integer)
  Select Case KeyCode
    Case KEY_DELETE
      Call EntryDelete(LumpLst, WorkDirec.Caption, ".LMP")
      ListDirty = True
  End Select
End Sub

Sub WadInfo_Change ()
   Call HelpD(Ident, "PLAYPAL", "Color palette")
   Call HelpD(Ident, "COLORMAP", "Mapping of colors")
   Call HelpD(Ident, "DEMO1", "Game Demo 1")
   Call HelpD(Ident, "DEMO2", "Game Demo 2")
   Call HelpD(Ident, "DEMO3", "Game Demo 3")
   Call HelpD(Ident, "DMXGUS", "GUS sound card INI")
   Call HelpD(Ident, "GENMIDI", "MIDI config.")
  Select Case typeIWAD()
   Case 10, 11, 12 'doom, doom2
   Call HelpD(Ident, "ENDOOM", "End Screen")
   Case 20, 21, 22'heretic
   Call HelpD(Ident, "ENDTEXT", "End Screen")
   Call HelpD(Ident, "LOADING", "Loading Screen")
   Call HelpD(Ident, "AUTOPAGE", "table ")
   Call HelpD(Ident, "SNDCURVE", "Sound mapping")
   Call HelpD(Ident, "TINTTAB", "table ")
   Call HelpD(Ident, "TINTTAB", "table ")
   Call HelpD(Ident, "E2PAL", "palette for E2END")
   Call HelpD(Ident, "TITLE", "Title Screen")
   Call HelpD(Ident, "HELP1", "Help Screen")
   Call HelpD(Ident, "HELP2", "Help Screen")
   Call HelpD(Ident, "CREDIT", "Credit Screen")
   Call HelpD(Ident, "E2END", "End Screen")
   Call HelpD(Ident, "FINAL1", "Final Screen")
   Call HelpD(Ident, "FINAL2", "Final Screen")
  End Select
   Call HelpD(Ident, "E?M?", "Level header")
   Call HelpD(Ident, "MAP??", "Level header")
   Call HelpD(Ident, "THINGS", "Level objects")
   Call HelpD(Ident, "LINEDEFS", "Level lines")
   Call HelpD(Ident, "SIDEDEFS", "Level walls")
   Call HelpD(Ident, "VERTEXES", "Level corners")
   Call HelpD(Ident, "SEGS", "Level segments")
   Call HelpD(Ident, "SSECTORS", "Level sub sectors")
   Call HelpD(Ident, "NODES", "Level BSP nodes")
   Call HelpD(Ident, "SECTORS", "Level sectors")
   Call HelpD(Ident, "BLOCKMAP", "Level locations")
   Call HelpD(Ident, "REJECT", "Level reject")
   Call HelpD(Ident, "????????", "Any lump")
   'Init Lump List
   'read section   7 = no X Y offset, repeat, name
   Call SectionRead(LumpLst, WadInfo.Caption, "LUMPS", 7)
End Sub

