Option Explicit

'INI file handling
Dim INIfile As String
'
'HELP lock
'
Dim HELPfreeze As Integer
'
' choose file default
'
Dim ChooseDflt As String
'
'WAD editors
'
Dim IWADfile As String
Dim IWADexe As String
Dim IWADtyp As Integer '10=DOOM 20=HERETIC  +0=regd +1=sharew +2=commercial
Dim TWADfile As String
'
'WAD viewer
'
Dim WADtyp As Integer        'type of entry
Dim WADscal As Integer       ' current scale 1 to 8
Dim WADpatDir As String
Dim WADtransp As Long     ' transparent color
Dim WADtexuXsz As Integer
Dim WADtexuYsz As Integer
'
'Lamer level
'
Dim NoTutor As Integer
'
'code for invalid integers
'(used for patches)
Global Const INVALID = -6666

'files-----------------------------------------------
Const ATTR_NORMAL = 0

' Key Codes-------------------------------------------
'Const KEY_CANCEL = &H3
Global Const KEY_BACK = &H8
'Global Const KEY_TAB = &H9
'Global Const KEY_CLEAR = &HC
Global Const KEY_RETURN = &HD
'Const KEY_SHIFT = &H10
Global Const KEY_CONTROL = &H11
'Const KEY_MENU = &H12
'Const KEY_PAUSE = &H13
'Const KEY_CAPITAL = &H14
'Const KEY_ESCAPE = &H1B
Global Const KEY_SPACE = &H20
Global Const KEY_PRIOR = &H21
Global Const KEY_NEXT = &H22
'Global Const KEY_END = &H23
'Global Const KEY_HOME = &H24
'Global Const KEY_LEFT = &H25
'Global Const KEY_UP = &H26
'Global Const KEY_RIGHT = &H27
'Global Const KEY_DOWN = &H28
'Global Const KEY_INSERT = &H2D
Global Const KEY_DELETE = &H2E
'Const KEY_HELP = &H2F

' Shift parameter masks
Global Const SHIFT_MASK = 1
'Global Const CTRL_MASK = 2
'Global Const ALT_MASK = 4

' Button parameter masks------------------------------
Global Const LEFT_BUTTON = 1
Global Const RIGHT_BUTTON = 2
'Global Const MIDDLE_BUTTON = 4

'---------------scale type-----------------
'send message to make loading of lists faster
'Const WM_USER = &H400
'Global Const LB_ADDSTRING = (&H400 + 1)
Const LB_FINDSTRING = (&H400 + 16)
Const LB_INSERTSTRING = (&H400 + 2)
Declare Function SendMessage Lib "User" Alias "SendMessage" (ByVal hWnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, ByVal lParam As String) As Integer

'modules
Declare Function GetModuleUsage% Lib "Kernel" (ByVal hModule%)
'INI files: profile strings
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, lpKeyName As Any, lpString As Any, ByVal lplFileName As String) As Integer
'
' help
'
'Global Const HELP_CONTENTS = &H3     ' Display Help for a particular topic
'Global Const HELP_CONTEXT = &H1     ' Display topic identified by number in Data
'Global Const HELP_QUIT = &H2        ' Terminate help
'Global Const HELP_INDEX = &H3       ' Display index
'Global Const HELP_HELPONHELP = &H4  ' Display help on using help
'Global Const HELP_SETINDEX = &H5    ' Set an alternate Index for help file with more than one index
'Global Const HELP_KEY = &H101       ' Display topic for keyword in Data
'Global Const HELP_MULTIKEY = &H201  ' Lookup keyword in alternate table and display topic
'Type MULTIKEYHELP
'    mkSize As Integer
'    mkKeylist As String * 1
'    szKeyphrase As String * 253
'End Type
Declare Function WinHelp Lib "User" (ByVal hWnd As Integer, ByVal lpHelpFile As String, ByVal wCommand As Integer, dwData As Any) As Integer
Declare Function ExitWindows Lib "User" (ByVal dwReturnCode As Long, ByVal wReserved As Integer) As Integer
Declare Function ExitWindowsExec Lib "User" (ByVal lpszExe As String, ByVal lpszParams As String) As Integer
'Global Const SND_SYNC = &H0
'Global Const SND_ASYN = &H1
'Global Const SND_NODEFAULT = &H2
'Global Const SND_LOOP = &H8
'Global Const SND_NOSTOP = &H10
Declare Function SndPlaySound Lib "MMSYSTEM.DLL" (ByVal lpszSoundName$, ByVal wFlags%) As Integer
'
' shell
'
' hWnd% = handle of parent windoze
' op$   = "open"
' file$ = filename to edit
' param$= ""
' dir$  = App.dir. the default dir
' shw%  = SW_SHOW=5
' return < 32 is an error. else, it's the appli handle
'Declare Function ShellExecute Lib "SHELL.DLL" (ByVal hWnd%, ByVal op$, ByVal file$, ByVal param$, ByVal cwd$, ByVal shw%)
'res% = ShellExecute(hWnd, "open", file$, " ", Pat$, 5)



'
'
' DeuTex library
'
' check if a file exists
Declare Function DIRexistFile% Lib "lbdeutex.dll" (ByVal filenam$)
' check if a directory exists
Declare Function DIRexistDir% Lib "lbdeutex.dll" (ByVal filenam$)
' split a path into: directory, full file name, root file name
' static direc as string * 128 : static  filnam as string * 64 : static root as string * 64
Declare Function DIRsplitPath% Lib "lbdeutex.dll" (ByVal direc$, ByVal filnam$, ByVal root$, ByVal Path$)
' make a path, for directory and file name
' static path as string * 128
Declare Function DIRmakePath% Lib "lbdeutex.dll" (ByVal Path$, ByVal direc$, ByVal filenam$)
' parse an entry  'in' into components
' static out as string * 128, returns size
Declare Function TEXTentryParse% Lib "lbdeutex.dll" (ByVal out$, ByVal in$)
'make an entry 'out' from components
' static entry out as string * 31
Declare Function TEXTentryMake% Lib "lbdeutex.dll" (ByVal out$, ByVal entry$, ByVal ofsx%, ByVal ofsY%, ByVal nam$, ByVal Rep%)
'make a patch
Declare Function TEXTpatchMake% Lib "lbdeutex.dll" (ByVal out$, ByVal nam$, ByVal ofsx%, ByVal ofsY%)
'start reading file in search for [section]
Declare Function TEXTreadSectInit% Lib "lbdeutex.dll" (ByVal file$, ByVal section$)
'read a part of file. return <0 if finished
' static out as string * 128, returns size
Declare Function TEXTreadSection% Lib "lbdeutex.dll" (ByVal out$)

'init. reply true if ok
Declare Function TEXTreadTexuInit% Lib "lbdeutex.dll" (ByVal file$)
'read texture. reply patlensz <0 if end
Declare Function TEXTreadTexu% Lib "lbdeutex.dll" (ByVal nam$, szX%, szY%, ByVal patlst$, ByVal patlstsz%)


' set the DOOM colors from main WAD (read PLAYPAL entry)
Declare Function IWADcolors% Lib "lbdeutex.dll" (ByVal doom$, ByVal r%, ByVal G%, ByVal B%)
' declare the WAD to be searched into. read directory.
Declare Function IWADdeclare% Lib "lbdeutex.dll" (ByVal doom$)
' forget the directory. call that last!
Declare Function IWADforget% Lib "lbdeutex.dll" ()
' load a .BMP file, quantize to IWAD colors
Declare Function IWADgetBmp% Lib "lbdeutex.dll" (ByVal hDC%, szX%, szY%, ByVal scal%, ByVal filenam$)
' put a DOOM picture/flat on a picture
Declare Function IWADgetPic% Lib "lbdeutex.dll" (ByVal dhDC%, szX%, szY%, ByVal scal%, ofx%, ofy%, ByVal entry$)
' X and Y size of the picture (call after IWADgetPic or BMPgetBmp)
' search all entries of a specified type.
' 1=gfx,2=,3=,4=,5=flat
Declare Function IWADsearchType% Lib "lbdeutex.dll" (ByVal ListH%, ByVal typ%)
' export a doom pic as 8-bit bitmap (with offsets)
Declare Function IWADexportPic% Lib "lbdeutex.dll" (ByVal entry$, ofx%, ofy%, ByVal filenam$)
' export sound
Declare Function IWADexportSound% Lib "lbdeutex.dll" (ByVal entry$, ByVal filenam$)
' export lump
Declare Function IWADexportLump% Lib "lbdeutex.dll" (ByVal entry$, ByVal filenam$)
' display a texture directly, from normalised patch list
Declare Function IWADtexuShow% Lib "lbdeutex.dll" (ByVal dhDC%, szX%, szY%, ByVal scal%, ByVal patlst$, ByVal PatDir$) ', ByVal Xmove%)
' read one texture after the other
Declare Function IWADtexuRead% Lib "lbdeutex.dll" (ByVal nam$, szX%, szY%, ByVal patlst$, ByVal patlstsz%, ByVal which%)
' play a DOOM sound
Declare Function IWADplaySound% Lib "lbdeutex.dll" (ByVal entry$)

Declare Sub LISTload Lib "lbdeutex.dll" (ByVal ListH%, ByVal NamLst$, ByVal NamLstSz%)
' list dir
Declare Function LISTwadDir% Lib "lbdeutex.dll" (ByVal ListH%, ByVal file$)

'edit file
'hWnd = 0
'file = file to edit
'direc = working directory
Declare Function EXECeditFile% Lib "lbdeutex.dll" (ByVal hWnd%, ByVal file$, ByVal direc$)


'Sub Transparent (Des As Control, Src As Control, ByVal X As Integer, ByVal Y As Integer, ByVal Invis As Long)
' copy a bitmap from Src to Des
'   put the bitmap at X,Y in Des
'   Invis is the invisible color
'   Dim OrigColor As Long  'Holds original background color from source DC
'   Dim suc As Integer 'Stores result of call to Windows API
'Ensure Destination is a picture box
'        If TypeOf Des Is PictureBox Then
'           Des.ScaleMode = PIXEL
'        Else Exit Sub
'        End If
'Ensure Source is a picture box
'        Dim W, h As Integer
'        If TypeOf Src Is PictureBox Then
'           Src.ScaleMode = PIXEL
'           W = Src.ScaleWidth
'           h = Src.ScaleHeight
'        Else Exit Sub
'        End If
'
'declare monochrome bitmaps handles
'    Dim maskDC As Integer
'    Dim hMaskBmp, hMaskPrev As Integer
'   'mask
'      maskDC = CreateCompatibleDC(Des.hDC)   'Create DC to hold stage
'      hMaskBmp = CreateBitmap(W, h, 1, 1, ByVal 0&)  'monochr
'      hMaskPrev = SelectObject(maskDC, hMaskBmp)
'  'declare color bitmaps
'     Dim resultDC As Integer
'     Dim hResultBmp, hResultPrev As Integer
'     resultDC = CreateCompatibleDC(Des.hDC) 'Create DC to hold stage
'     hResultBmp = CreateCompatibleBitmap(Des.hDC, W, h)  'result
'     hResultPrev = SelectObject(resultDC, hResultBmp)

 'Create mask: set background color of source to transparent color.
 '  all pixels that correspond to background will be white
 '  all others will be black
'    OrigColor = SetBkColor(Src.hDC, Invis)                          'OK!
'    suc = BitBlt(maskDC, 0, 0, W, h, Src.hDC, 0, 0, SRCCOPY)        'OK!
 '  restore colors
'    OrigColor = SetBkColor(Src.hDC, OrigColor)
 ' poke a mask in destination
'    suc = BitBlt(Des.hDC, X, Y, W, h, maskDC, 0, 0, SRCAND)         'OK!
 'Create inverse of mask to AND w/ source & combine w/ background.
'    suc = BitBlt(maskDC, 0, 0, W, h, maskDC, 0, 0, DSTINVERT)       'OK!?
 'copy source in result
'    suc = BitBlt(resultDC, 0, 0, W, h, Src.hDC, 0, 0, SRCCOPY)
 'mask result with inverted mask
'    suc = BitBlt(resultDC, 0, 0, W, h, maskDC, 0, 0, SRCAND)
 'write result  by OR
'    suc = BitBlt(Des.hDC, X, Y, W, h, resultDC, 0, 0, SRCPAINT)
   
'   Dim BmpPrev As Integer
   'Deallocate system resources for result
'   BmpPrev = SelectObject(resultDC, hResultPrev)
'   suc = DeleteObject(hResultBmp)
'   suc = DeleteDC(resultDC)
   'Deallocate system resources for mask
'   BmpPrev = SelectObject(maskDC, hMaskPrev)
'   suc = DeleteObject(hMaskBmp)
'   suc = DeleteDC(maskDC)
'End Sub

Sub CallDCK (ByVal file As String, ByVal level As String)
' call Doom Contruction Kit
  If Not DIRexistFile(IWADfile) Then Exit Sub
  If Not DIRexistFile(TWADfile) Then TWADfile = ""
  Dim cmd$
  cmd$ = INIgetValue("Extern", "DCK")
  If Not cmd$ Like "*%WAD%*" Then
     Call Infos("Make sure the [386Enh] section of SYSTEM.INI contains   device=windpmi.386 and that windpmi.386 is in your system directory. Otherwise DCK will not run under windows.")
     cmd$ = ChooseFile("dck.pif", "*.exe;*.pif", True, "Please select DCK 2.1")
     If Not DIRexistFile(cmd$) Then Exit Sub
     cmd$ = cmd$ & " /t %DATA%  /game %GAME%   %WAD%"
     Call INIputValue("Extern", "DCK", cmd$, True)
  End If
'DCK [/t file1 [file2]] [/game xxx] [file [map]]
'/T loads texture files, eg:
'   DCK /T FLATS.WAD MYTEXTUR.WAD
'/GAME switches to one of the "GD" games, the defaults being:
'   DOOM1  DOOM2  HERETIC
'[file [map]] edits a particular file and map.
  Call CmdEditor(cmd$, IWADfile, file$, TWADfile, level)
  Dim game$
  Select Case IWADtyp
   Case 10, 11
     game = "DOOM1"
   Case 12
     game = "DOOM2"
   Case 20, 21
     game = "HERETIC"
   Case 22
     game = "HERETIC2"
  End Select
  cmd$ = SubstitStr(cmd$, "%GAME%", game$)
  Dim res%
  On Error GoTo Hell13
  res = Shell(cmd$, 1)
  Exit Sub
Hell13:
  Call CrashCmd(cmd$)
  Resume Next
End Sub

Sub CallDeHackEd (ByVal patch$, ByVal loadit%)
' call Dehacked
'  tell it where the IWAD is
'  try to tell it the name of the dhe file
'
  If Not DIRexistFile(IWADfile) Then Exit Sub
  'find the executable
  Dim exe$
  Select Case IWADtyp
    Case 10, 11, 12'doom or doom2
     exe = INIgetValue("Extern", "DHE")
     If Not DIRexistFile(exe) Then
       exe = ChooseFile(".\dehacked.exe", "*.exe", True, "Please select DEHACKED.EXE (DOOM exe editor). Version 2.3.")
       Call INIputValue("Extern", "DHE", exe, True)
     End If
    Case 20, 21, 22'heretic
     exe = INIgetValue("Extern", "HHE")
     If Not DIRexistFile(exe) Then
       exe = ChooseFile(".\hhe.exe", "*.exe", True, "Please select HHE.EXE (HERETIC exe editor). Version 1.0.")
       Call INIputValue("Extern", "HHE", exe, True)
     End If
  End Select
  If Not DIRexistFile(exe$) Then
      Call Crash(exe$ & " not found")
      Exit Sub
  End If
  ' declare DOOM
  exe$ = exe$ & " " & FilePath(IWADfile)
  ' declare patch if needed
  If loadit Then exe$ = exe$ & " -reload -load " & patch$
  'dhe command line
  'dehacked   [doom_directory] [-load dhe_file]
  Dim res%
  On Error GoTo Hell14
  res = Shell(exe$, 3)
  Exit Sub
Hell14:
  Call CrashCmd(exe$)
  Resume Next
End Sub

Sub CallDoom (file As String)
' execute doom
' and restart windows.
'
  If Not DIRexistFile(file) Then Exit Sub
  If Not UCase$(file) Like "*.WAD" Then Exit Sub
  If Not DIRexistFile(IWADfile) Then Exit Sub
  If Not DIRexistFile(IWADexe) Then Exit Sub
  If Not DIRexistFile(TWADfile) Then TWADfile = ""
  Dim cmd, params As String
  params = "-file " & TWADfile & " " & file
  If Not QueryCancel("Windows may not call doom properly. A crash is possible.") Then Exit Sub
  Dim res As Integer
  res = ExitWindowsExec(IWADexe, params)
End Sub

Sub CallDoomcad (ByVal file As String, ByVal level As String)
  If Not DIRexistFile(IWADfile) Then Exit Sub
  If Not DIRexistFile(TWADfile) Then TWADfile = ""
  Dim direc As String
  direc = INIgetValue("Extern", "DoomCAD")
  If Not DIRexistDir(direc) Then
     direc = ChooseDir(".", "Please indicate the directory of DoomCAD (.EXE and .INI)")
     Call INIputValue("Extern", "DoomCAD", direc, True)
  End If
  If Not DIRexistDir(direc) Then Exit Sub
  Dim cadini, cadexe As String
  cadini = MakeFileName(direc, "doomcad.ini")
  cadexe = MakeFileName(direc, "doomcad.exe")
  
  Dim res As Integer
  If DIRexistFile(file) Then
    res = WritePrivateProfileString("DOOMCAD", "CurWadFile", file, cadini)
  End If
  res = WritePrivateProfileString("DOOMCAD", "WadFileLoc", IWADfile, cadini)
  'TWADfile, and level unusable
  On Error GoTo Hell10
  res = Shell(cadexe, 1)
  Exit Sub
Hell10:
  Call CrashCmd(cadexe$)
  Resume Next
End Sub

Sub CallEdmap (ByVal file As String, ByVal level As String)
' call EdMap
  If Not DIRexistFile(IWADfile) Then Exit Sub
  If Not DIRexistFile(TWADfile) Then TWADfile = ""
  Dim cmd$
  cmd$ = INIgetValue("Extern", "EdMap")
  If Not cmd$ Like "*%WAD%*" Then
     cmd$ = ChooseFile("edmap.exe", "*.exe", True, "Please select EdMap 1.42")
     If Not DIRexistFile(cmd$) Then Exit Sub
     cmd$ = cmd$ & " %DATA% %WAD% /M:%LEVEL%"
     Call INIputValue("Extern", "EdMap", cmd$, True)
  End If
  Call CmdEditor(cmd$, IWADfile, file$, TWADfile, level)
  Dim res%
  On Error GoTo hell20
  res = Shell(cmd$, 1)
  Exit Sub
hell20:
  Call CrashCmd(cmd$)
  Resume Next
End Sub

Sub CallNWT (ByVal file As String)
' call new wad tools
  If Not DIRexistFile(file) Then Exit Sub
  Dim cmd$
  cmd = INIgetValue("Extern", "NewWadTool")
  If Not (cmd Like "*%WAD%*") Then
     cmd = ChooseFile(cmd, "nwt.exe", True, "Please select NewWadTool")
     If Not DIRexistFile(cmd$) Then Exit Sub
     cmd = cmd & " -file %WAD%"
     Call INIputValue("Extern", "NewWadTool", cmd$, True)
  End If
  Call CmdEditor(cmd$, IWADfile, file$, "", "")
  Dim res%
  On Error GoTo Hell9
  res = Shell(cmd, 3) 'max, with focus
  Exit Sub
Hell9:
  Call CrashCmd(cmd$)
  Resume Next
End Sub

Sub CallWadEd (ByVal file As String, ByVal level As String)
' call Doom Contruction Kit
  If Not DIRexistFile(IWADfile) Then Exit Sub
  If Not DIRexistFile(TWADfile) Then TWADfile = ""
  
  Dim cmd$
  cmd$ = INIgetValue("Extern", "WadEd")
  If Not cmd$ Like "*%WAD%*" Then
     cmd$ = ChooseFile("waded.exe", "*.exe", True, "Please select WadEd")
     If Not DIRexistFile(cmd$) Then Exit Sub
     cmd$ = cmd$ & " %WAD%"
     Call INIputValue("Extern", "WadEd", cmd$, True)
  End If
  Call CmdEditor(cmd$, IWADfile, file$, TWADfile, level)
  Dim res%
  On Error GoTo Hell19
  res = Shell(cmd$, 1)
  Exit Sub
Hell19:
  Call CrashCmd(cmd$)
  Resume Next
End Sub

Sub CallWinDeu (ByVal file As String, ByVal level As String)
  If Not DIRexistFile(IWADfile) Then Exit Sub
  If Not DIRexistFile(TWADfile) Then TWADfile = ""
  Dim direc As String
  If Not DIRexistFile(file) Then file = ""
  Dim cmd$
  cmd = INIgetValue("Extern", "WinDEU")
  If Not cmd Like "*%WAD%*" Then
     Call Infos("WinDEU command is not correct. A command for WINDEU will be generated.")
     cmd = ChooseFile(cmd, "*.exe", True, "Please select WinDEU.EXE")
     If Not DIRexistFile(cmd$) Then Exit Sub
     cmd = cmd & " -w %DOOM% -file  %DATA%  %WAD%"
     Call INIputValue("Extern", "WinDEU", cmd, True)
  End If
  Call CmdEditor(cmd$, IWADfile, file$, TWADfile, level)
  'check if windeu.ini is present (should be)
  file = MakeFileName(App.Path, "windeu.ini")
  If Not DIRexistFile(file) Then Call Infos("You should put your windeu.ini file in " & App.Path)
  'execute
  Dim res As Integer
  On Error GoTo Hell11
  res = Shell(cmd, 1)
  Exit Sub
Hell11:
  Call CrashCmd(cmd$)
  Resume Next
End Sub

Sub CallWT (ByVal file As String)
' call Wad Tools
  If Not DIRexistFile(file) Then Exit Sub
  Dim cmd$
  cmd = INIgetValue("Extern", "WadTool")
  If Not (cmd Like "*%WAD%*") Then
     cmd = ChooseFile(cmd, "wt.exe", True, "Please select NewWadTool")
     If Not DIRexistFile(cmd$) Then Exit Sub
     cmd = cmd & " -file %WAD%"
     Call INIputValue("Extern", "WadTool", cmd$, True)
  End If
  Call CmdEditor(cmd$, IWADfile, file$, "", "")
  Dim res%
  On Error GoTo Hell8
  res = Shell(cmd, 3) 'max with focus
  Exit Sub
Hell8:
  Call CrashCmd(cmd$)
  Resume Next
End Sub

Function ChooseDir (ByVal default$, Info$) As String
  Load GetDir
  GetDir.What = Info$
  GetDir.IsFile.Value = 0
  GetDir.Result.Caption = default$
  GetDir.Show 1
  If DIRexistDir(GetDir.Result.Caption) Then
    ChooseDir = GetDir.Result.Caption
  Else
    ChooseDir = default$
  End If
  Unload GetDir
End Function

Function ChooseFile (ByVal default$, ByVal mask$, ByVal mustbe, ByVal Info$) As String
' mustbe = true if file must exist
' mask = "*.txt", "*.wad;*.lmp", ...
  Load GetDir
  GetDir.What = Info$
  GetDir.IsFile.Value = 1
  GetDir.Result.Caption = default
  GetDir.Files.Pattern = mask
  GetDir.Show 1
  If mustbe And (Not DIRexistFile(GetDir.Result.Caption)) Then
    ChooseFile = default
  Else
    ChooseFile = GetDir.Result.Caption
  End If
  Unload GetDir
End Function

Function ChooseGetDefault ()
   ChooseGetDefault = ChooseDflt
End Function

Sub ChooseSetDefault (ByVal default$)
   If DIRexistDir(default$) Then Exit Sub
   ChooseDflt = default$
End Sub

Sub CmdEditor (cmd$, ByVal doom$, ByVal pwad$, ByVal dta$, ByVal level$)
  cmd = SubstitStr(cmd, "%DOOM%", doom$)
  cmd = SubstitStr(cmd, "%DATA%", dta$)
  cmd = SubstitStr(cmd, "%WAD%", pwad$)
  cmd = SubstitStr(cmd, "%RWAD%", Left$(pwad$, Len(pwad$) - 4))
  cmd = SubstitStr(cmd, "%LEVEL%", level$)
End Sub

Sub Crash (text$)
  MsgBox "Error:" & Chr$(10) & text$, 16, "WinTex Error"
End Sub

Sub CrashCmd (cmd$)
  MsgBox "Bad Command " & Chr$(10) & cmd$, 16, "External Tool Error"
End Sub

Sub Display (picB As Control, file$, ByVal filenam$)
  'return file$
  If Not DIRexistFile(filenam) Then
      If TypeOf picB Is PictureBox Then picB.Cls
      file$ = ""
      Exit Sub
  End If
  file = filenam
  If TypeOf picB Is PictureBox Then
    picB.Visible = True
    picB.AutoRedraw = True
    Dim szX%, szY%
    'first load bitmap, then, if not found, load entry
    If IWADgetBmp(picB.hDC, szX, szY, 1, filenam$) < 0 Then Exit Sub
    picB.Width = szX * Screen.TwipsPerPixelX        'set width
    picB.Height = szY * Screen.TwipsPerPixelY       'set height
    picB.Refresh             'paint picture
  End If
End Sub

Sub EditBmpFile (ByVal file$)
  If Not DIRexistFile(file) Then Exit Sub
  If Not UCase$(Right$(file, 4)) = ".BMP" Then Exit Sub
  Dim res%
  res% = EXECeditFile(0, file$, App.Path)
End Sub

Sub EditCopyFile (ByVal file$, file2$)
  On Error Resume Next
  FileCopy file$, file2$
End Sub

Sub EditDeleteFile (ByVal file As String)
  If Not DIRexistFile(file) Then Exit Sub
  'Delete? OK/CANCEL
  If QueryOk("Delete file " & file & " ?") Then
    Kill file
  End If
End Sub

Sub EditInstallBat (ByVal direc$, ByVal pwad$, ByVal deh$)
'
' create an install batch
'  direc = the directory where to write install.bat
'  pwad = the name of the PWAD file
'  deh = the name of the dehacked file
'  IWADtyp = the version of doom, concerned by the batch
  If Not DIRexistDir(direc$) Then Exit Sub
  Dim bat$
  bat = MakeFileName(direc$, "install.bat")
  Dim oksprite, okflat, okdeh As Integer
  oksprite = False
  okflat = False
  okdeh = False
  Call Infos("You are about to generate an install file called " & bat)
  oksprite = QueryOk("Do you redefine sprites in your PWAD?")
  okflat = QueryOk("Do you redefine  flats in your PWAD?")
  okdeh = QueryCancel("Do you use a Patch to modify the executable?")
  Dim rpwad$ ' pwad
  Dim rdhe$  ' dehacked patch
  rpwad$ = FileName(pwad$)
  rdhe$ = FileName(deh$)
  Dim rdoom$    ' doom file
  Dim rdoomexe$ ' doom exe
  rdoom = FileName(IWADfile)
  rdoomexe = FileName(IWADexe)
  Dim dheexe As String
  Select Case IWADtyp
    Case 10, 11, 12'doom, doom2
      dheexe = "dehacked"
    Case 20, 21, 22'heretic
      dheexe = "hhe"
  End Select

  On Error GoTo hell31
  Open bat For Output As #1
  Print #1, "@echo."
  Print #1, "@echo. Installation"
  Print #1, "@echo."
  'check main wad
  Print #1, "@if not exist " & rdoom$ & " goto miss"
  Print #1, "@echo @echo. Restoration > restore.bat"
  
  'dehacked patch
  If okdeh Then
    Print #1, "@rem Install EXE Patch"
    Print #1, "@if not exist " & rdoomexe$ & " goto miss"
    Print #1, "@if exist original.deh goto noorig"
    Select Case IWADtyp
      Case 10, 11, 12'doom, doom2
        Print #1, "@echo dehacked -reload >> restore.bat"
        Print #1, "@dehacked -reload -load " & rdhe
      Case 20, 21, 22'heretic
        Print #1, "@echo hhe -reload >> restore.bat"
        Print #1, "@hhe -reload -load " & rdhe
    End Select
    Print #1, "@if not ERRORLEVEL 0 goto fail "
    If Len(rpwad$) > 0 Then
      Select Case IWADtyp
        Case 10, 11, 12'doom, doom2
          Print #1, "@echo doomhack -file " & rpwad$ & " >> play.bat "
        Case 20, 21, 22'heretic
          Print #1, "@echo herehack -file " & rpwad$ & " >> play.bat "
      End Select
    End If
  End If
  If oksprite Or okflat Then
    Print #1, "@rem Install Sprites or Flats in WAD"
    Print #1, "@echo deusf -res " & rpwad$ & " >> restore.bat"
    Dim slct As String
    slct = ""
    If Not oksprite Then slct = " -flats"
    If Not okflat Then slct = " -sprites"
    Print #1, "@deusf" & slct & " -app " & rpwad$
    Print #1, "@if not ERRORLEVEL 0 goto fail "
  End If
  Print #1, "@echo Installation succeeded."
  Print #1, "@echo type PLAY to play the modified game."
  Print #1, "@echo type RESTORE to uninstall."
  Print #1, "@goto end"
  Print #1, ":fail"
  Print #1, "@echo. Installation failed."
  Print #1, "@goto end"
  Print #1, ":miss"
  Print #1, "@echo. Installation impossible: Games files are missing."
  Print #1, "@echo. Please Install in game directory."
  Print #1, "@goto end"
  Print #1, ":end"
  Close #1
  Call Infos("Created installation batch:" & Chr$(10) & bat)
  Exit Sub
hell31:
  Call Crash("Could not create " & bat)
  Exit Sub
End Sub

Sub EditLevel (ByVal file As String, ByVal level As String)
  If Not DIRexistFile(file) Then Exit Sub
  If Not UCase$(Right$(file, 4)) = ".WAD" Then Exit Sub
  If Not DIRexistFile(IWADfile) Then Exit Sub
  If Not DIRexistFile(TWADfile) Then TWADfile = ""
  Dim cmd As String
  cmd = INIgetValue("Extern", "Editor")
  Dim res As Integer
  If Not (cmd Like "*%WAD%*") Then
     Call Infos("Editor command is not correct. A command will be generated, but it's only valid for DEU. Edit the 'Editor=' line in WinTex.INI.")
     cmd = ChooseFile("deu.exe", "*.exe", True, "Please select the DEU executable")
     If Not DIRexistFile(cmd$) Then Exit Sub
     cmd = cmd & " -w %DOOM% -file  %DATA%  %WAD%"
     Call INIputValue("Extern", "Editor", cmd, True)
  End If
  Call CmdEditor(cmd$, IWADfile, file$, TWADfile, level)
  On Error GoTo Hell2
  res = Shell(cmd, 3)  'max with focus
  Exit Sub
Hell2:
  Call CrashCmd(cmd$)
  Resume Next
End Sub

Sub EditMidi2Mus (ByVal file As String)
  If Not DIRexistFile(file) Then Exit Sub
  If Not UCase$(Right$(file, 4)) = ".MID" Then Exit Sub
  Dim file2 As String
  file2 = Left$(file, Len(file) - 3) & "mus"
  Dim cmd As String
  Dim res As Integer
  cmd = INIgetValue("Extern", "Midi2Mus")
  If Not (cmd Like "*%MIDI%*") Then
     cmd = "midi2mus %MIDI%"
     Call INIputValue("Extern", "Midi2Mus", cmd, True)
  End If
  cmd = SubstitStr(cmd, "%MIDI%", file)
  cmd = SubstitStr(cmd, "%MUS%", file2)
  On Error GoTo Hell3
  res = Shell(cmd, 4)  'normal, no focus
  Exit Sub
Hell3:
  Call CrashCmd(cmd$)
  Resume Next
End Sub

Sub EditMus2Midi (ByVal file As String)
  If Not DIRexistFile(file) Then Exit Sub
  If Not UCase$(Right$(file, 4)) = ".MUS" Then Exit Sub
  Dim file2 As String
  file2 = Left$(file, Len(file) - 3) & "mid"
  Dim cmd As String
  Dim res As Integer
  cmd = INIgetValue("Extern", "Mus2Midi")
  If Not (cmd Like "*%MUS%*") Then
     cmd = "mus2midi %MUS% %MIDI%"
     Call INIputValue("Extern", "Mus2Midi", cmd, True)
  End If
  cmd = SubstitStr(cmd, "%MUS%", file)
  cmd = SubstitStr(cmd, "%MIDI%", file2)
  On Error GoTo Hell4
  res = Shell(cmd, 4)  'normal, no focus
  Exit Sub
Hell4:
  Call CrashCmd(cmd$)
  Resume Next
End Sub

Sub EditNodes (ByVal file As String, ByVal level As String)
  If Not DIRexistFile(file) Then Exit Sub
  If Not UCase$(Right$(file, 4)) = ".WAD" Then Exit Sub
  Dim file2 As String
  file2 = Left$(file, Len(file) - 4) & ".OLD"
  Dim cmd$
  Dim res%
  cmd$ = INIgetValue("Extern", "Nodes")
  If Len(cmd$) <= 0 Then
     cmd = ChooseFile("bsp.exe", "*.exe", True, "Please select a node builder (BSP prefered)")
     If Not DIRexistFile(cmd) Then Exit Sub
     cmd = cmd & " %OLD% %WAD%"
     Call INIputValue("Extern", "Nodes", cmd, True)
  End If
  If DIRexistFile(file2) Then Kill file2
  Call EditCopyFile(file$, file2$)
  Call CmdEditor(cmd$, IWADfile, file$, "", level)
  cmd$ = SubstitStr(cmd$, "%OLD%", file2$)
  On Error GoTo Hell5
  res = Shell(cmd, 4)  'normal, no focus
  'if failed to make file, copy back the old one
  If Not DIRexistFile(file) Then Name file2 As file
  Exit Sub
Hell5:
  Call CrashCmd(cmd$)
  Resume Next
End Sub

Sub EditReject (ByVal file As String, ByVal level As String)
  If Not DIRexistFile(file) Then Exit Sub
  If Not UCase$(Right$(file, 4)) = ".WAD" Then Exit Sub
  Dim file2 As String
  file2 = Left$(file, Len(file) - 4) & ".OLD"
  Dim cmd As String
  Dim res As Integer
  cmd = INIgetValue("Extern", "Reject")
  If Len(cmd$) <= 0 Then
     cmd = ChooseFile("rmb.exe", "*.exe", True, "Please select a reject builder (RMB.EXE or REJECT.EXE)")
     If Not DIRexistFile(cmd$) Then Exit Sub
     cmd = LCase$(cmd)
     'addapt to known editors
     If cmd Like "*reject.exe" Then
        cmd = cmd & " %RWAD% %LEVEL% 1000"
     ElseIf cmd Like "*rmb.exe" Then
        cmd = cmd & " %OLD% %WAD% NOMAP"
     Else
        cmd = cmd & " %OLD% %WAD%"
     End If
     Call INIputValue("Extern", "Reject", cmd, True)
  End If
  If DIRexistFile(file2$) Then Kill file2
  Call EditCopyFile(file$, file2$)
  Call CmdEditor(cmd$, IWADfile, file$, "", level)
  cmd$ = SubstitStr(cmd$, "%OLD%", file2)
  On Error GoTo Hell6
  res = Shell(cmd, 4)  'normal, no focus
  'if failed to make file, copy back the old one
  If Not DIRexistFile(file) Then Name file2 As file
  Exit Sub
Hell6:
  Call CrashCmd(cmd$)
  Resume Next
End Sub

Sub EditTedFile (ByVal file As String)
  If Not DIRexistFile(file) Then Exit Sub
  If Not UCase$(Right$(file, 4)) = ".LMP" Then Exit Sub
  Dim cmd As String
  Dim res As Integer
  cmd = INIgetValue("Extern", "EditTed")
  If Len(cmd$) <= 0 Then
     cmd$ = ChooseFile("ted.exe", "*.exe", True, "Please select an End Screen editor (TED.EXE or ENDOOM.EXE)")
     If Not DIRexistFile(cmd$) Then Exit Sub
     cmd$ = cmd$ & " %FILE%"
     Call INIputValue("Extern", "EditTed", cmd, True)
  End If
  cmd = SubstitStr(cmd, "%FILE%", file)
  On Error GoTo Hell
  res = Shell(cmd, 3)
  Exit Sub
Hell:
  Call CrashCmd(cmd$)
  Resume Next
End Sub

Sub EditTextFile (ByVal file$)
  If Not DIRexistFile(file$) Then Exit Sub
  'check valid
  If Not UCase$(Right$(file, 4)) = ".TXT" Then Exit Sub
  Dim res%
  res% = EXECeditFile(0, file$, App.Path)
End Sub

Sub EditWavFile (ByVal file$)
  If Not DIRexistFile(file) Then Exit Sub
  If Not UCase$(Right$(file, 4)) = ".WAV" Then Exit Sub
  Dim res%
  res% = EXECeditFile(0, file$, App.Path)
End Sub

Sub EntryDelete (Lst As Control, ByVal direc$, ByVal extens$)
' delete current entry in list
' call EntryDelete(LumpLst,WorkDirec.Caption,".WAD")
'
   If Lst.ListIndex < 0 Then Exit Sub
   Dim entry As String
   Dim nam As String
   Dim X As Integer
   Dim Y As Integer
   Dim repeat As Integer
   entry = EntryGet(X, Y, nam, repeat, Lst.Text)
   If Not repeat Then
     Dim filenam As String
     filenam = MakeFileName(direc$, nam & extens$)
     EditDeleteFile (filenam)
   End If
   'delete reference to entry
   Dim I As Integer
   I = Lst.ListIndex
   Lst.RemoveItem (Lst.ListIndex)
   If I < Lst.ListCount Then Lst.ListIndex = I
End Sub

Function EntryGet (X%, Y%, nam$, repeat%, ByVal s As String) As String
'Get entry made with EntryMake
'don't confuse with EntryParse, which is more clever
    EntryGet = ""
    If Len(s) < 29 Then Exit Function
    EntryGet = Trim$(Left$(s, 8))
    If (Mid$(s, 29 + 1, 1) = "*") Then
      repeat% = True
    Else
      repeat% = False
    End If
    nam$ = Trim$(Mid$(s, 20 + 1, 8))
    Dim num As String
    num = Mid$(s, 9 + 1, 4)
    If (num = Space$(4)) Then
      X% = INVALID
    Else
      X% = Val(num)
    End If
    num = Mid$(s, 14 + 1, 4)
    If (num = Space$(4)) Then
      Y% = INVALID
    Else
      Y% = Val(num)
    End If
End Function

Function EntryMake (ByVal entry$, ByVal X%, ByVal Y%, ByVal nam$, ByVal Rep%) As String
' Make entry from description, as
'    ENTRY  [X]  [Y] [= NAM] [*]
'
   Dim s As String * 128
   Dim res%
   res = TEXTentryMake(s, entry, X, Y, nam, Rep)
   EntryMake = Left$(s, res)
End Function

Function EntryParse (ByVal entry$, ByVal which%) As String
' read entry, parse as
'    ENTRY   X  Y  = NAM *
'    return entry
' or a string of length 0 if failure
    EntryParse = ""
    Dim s As String * 128
    Dim res%
    res = TEXTentryParse(s, entry)
    If Left$(s, 8) = Space$(8) Then Exit Function
    Select Case which
    Case 1  ' no   X Y offset
       Mid$(s, 9 + 1, 10) = Space$(10)
    Case 5  ' no   X Y offset, repeat
       Mid$(s, 9 + 1, 10) = Space$(10)
       Mid$(s, 29, 1) = " "
    Case 7  ' no   X Y offset, repeat, name
       Mid$(s, 9 + 1, 20) = Space$(20)
    End Select
    EntryParse = Left$(s, res)
End Function

Function FileName (ByVal Path$)
  Dim direc As String * 128
  Dim filnam  As String * 16
  Dim root  As String * 16
  Dim res%
  res = DIRsplitPath(direc$, filnam$, root$, Path$)
  FileName = Left$(filnam$, Len(filnam$))
End Function

Function FilePath (ByVal Path$)
  Dim direc As String * 128
  Dim filnam  As String * 16
  Dim root  As String * 16
  Dim res%
  res = DIRsplitPath(direc$, filnam$, root$, Path$)
  FilePath = Left$(direc$, res)
End Function

Function FileRoot (ByVal Path$)
  Dim direc As String * 128
  Dim filnam  As String * 16
  Dim root  As String * 16
  Dim res%
  res = DIRsplitPath(direc$, filnam$, root$, Path$)
  FileRoot = Left$(root$, Len(root$))
End Function

Sub HelpCheckSelect (Help As Control)
  ' Help is a ComboBox
  ' Check that replacement selecion corresponds to #
  ' so that only # are replaced
  If HELPfreeze Then Exit Sub 'avoid event loop
  If TypeOf Help Is ComboBox Then
    Dim res As Integer
    res = InStr(Help.Text, "#")
    If res > 0 Then Help.SelStart = res - 1
    Help.SelLength = 0
  End If
End Sub

Sub HelpD (Help As Control, What$, comment$)
'declare, abreged
  If TypeOf Help Is ComboBox Then
    Dim txt$
    txt$ = Format$(What$, "!>@@@@@@@@") & " = " & comment
    'Dim res%
    'res = SendMessageByString(Help.hWnd, LB_ADDSTRING, 0, txt$)
    Help.AddItem (txt)
  End If
End Sub

Function HelpGetName (Help As Control, ByVal strict%) As String
    HelpGetName = ""
    If Len(Help.Text) < 1 Then Exit Function
    Dim s As String
    s = Left$(Help.Text, 8)
    If InStr(s, "?") > 0 Then
      If strict% Then
        Call Crash("Replace all '?' by valid characters, in " & s)
        Exit Function
      Else
        s = Left$(s, InStr(s, "?") - 1)
      End If
    End If
    HelpGetName = UCase$(Trim$(s))
End Function

Sub HelpINIWrite (Help As Control, section$)
   If TypeOf Help Is ComboBox Then
      Dim Value$
      Dim res As Integer
      res = WritePrivateProfileString(section$, Null, Value$, INIfile)
   End If
End Sub

Function HelpKeyPress (Help As Control, KeyAscii As Integer) As Integer
  If HELPfreeze Then Exit Function'avoid event loop
  ' replace key according to a pattern
  Static pattrn$
  HelpKeyPress = 0  'default = disable
  'what is the reference pattern?
  If Help.ListIndex >= 0 Then pattrn$ = Left$(Help.List(Help.ListIndex), 8)
  Dim s As Integer
  s = Help.SelStart + 1
  If s < 1 Then Exit Function
  If s > 8 Then Exit Function
  'if key on '#' then accept key
  If KeyAscii = KEY_BACK Then Exit Function
  If Mid$(pattrn$, s, 1) = "?" Then
     Help.SelLength = 1
     HelpKeyPress = KeyAscii
     Exit Function
  End If
  'cancel key
  Help.SelLength = 0
End Function

Sub HelpMatch (Help As Control, ByVal nam As String)
  'search name
  If Help.ListCount < 1 Then Exit Sub
  HELPfreeze = True
  Static target As String
  target = Format$(nam, "!>@@@@@@@@")
  Static found As Integer
  found = -1
  Static h As Integer
  Static test As String
  For h = 0 To Help.ListCount - 1
    test = Left$(Help.List(h), 8)
    If target Like test Then
      found = h
      Exit For
    End If
  Next h
  If found >= 0 And found < Help.ListCount Then Help.ListIndex = found
  HELPfreeze = False
End Sub

Sub Infos (text$)
  MsgBox "Information:" & Chr$(10) & text$, 64, "WinTex Infos"
End Sub

Sub INIedit ()
  On Error GoTo Hell18
  Dim res%
  res = Shell("notepad " & INIfile, 1)
  Exit Sub
Hell18:
  Call Crash("Notepad not found. Hard luck!")
  Resume Next
End Sub

Function INIgetValue (ByVal section$, ByVal key$) As String
' file INIfile:
' [section]
' Key = Value
   Dim RetStr As String
   RetStr = String(255, Chr(0))
   INIgetValue = Left(RetStr, GetPrivateProfileString(section$, ByVal key$, "", RetStr, Len(RetStr), INIfile))
End Function

Sub INIputValue (ByVal section$, ByVal key$, ByVal Value$, ByVal warn%)
'    file INIfile:
'      [section]
'       Key = Value
' return 0 if not found.
' if warn = true, then warn the user
  Dim res As Integer
  res = WritePrivateProfileString(section$, ByVal key$, ByVal Value$, INIfile)
  If warn Then Infos (key$ & " = " & Value$ & Chr$(10) & "was added to WINTEX.INI. You can edit it.")
End Sub

Sub InitIWAD (ByVal file$, ByVal exe$, ByVal typ%)
  IWADfile = file$
  IWADexe = exe$
  IWADtyp = typ%
End Sub

Sub InitTWAD (ByVal file$)
 TWADfile = file$
End Sub

Function ListFind% (ListB As Control, idx%, match$)
  'find a string in a list
  'returns index
  'returns -1 (unselect) if fail
  If idx% < -1 Then idx% = -1
  Dim res%
  res% = SendMessage(ListB.hWnd, LB_FINDSTRING, idx%, match$)
  If res% < -1 Then res% = -1
  If res% >= ListB.ListCount Then res = -1
  ListFind% = res%
End Function

Function ListFindEx8% (ListB As Control, idx%, text$)
  'find an exact 8-char string in a list
  'returns index
  'returns -1 (unselect) if fail
  ListFindEx8% = -1
  Dim match$
  match$ = Trim$(Left$(text$, 8))
  If Len(match$) <= 0 Then Exit Function
  If idx% < -1 Then idx% = -1
  Dim res%
  res% = SendMessage(ListB.hWnd, LB_FINDSTRING, idx%, match$)
  If res% < 0 Then Exit Function'fail
  Dim n%, ref%
  ref% = res%
  For n% = 0 To 256 'avoid loops
    If Trim$(Left$(ListB.List(res%), 8)) = match$ Then Exit For
    res% = SendMessage(ListB.hWnd, LB_FINDSTRING, res%, match$)
    'fail
    If res% = ref% Then Exit Function'fail, and loop
    If res% < 0 Then Exit Function   'fail, not found
  Next n%
  If res% >= ListB.ListCount Then Exit Function'failed
  If res% < -1 Then Exit Function'failed
  ListFindEx8% = res%
End Function

Function ListInsert (ListB As Control, text$)
  'add an item at current position
  'returns index
  'returns -1 (unselect) if fail
  Dim res%
  res% = ListB.ListIndex
  If res% < -1 Then
     res% = -1
  ElseIf res% < ListB.ListCount Then
     res% = res% + 1
  End If
  res% = SendMessage(ListB.hWnd, LB_INSERTSTRING, res%, text$)
  If res% < -1 Then res% = -1
  If res% >= ListB.ListCount Then res = -1
  ListInsert = res%
End Function

Function MakeFileName (ByVal Path As String, ByVal file As String) As String
 Static out As String * 128
 'deal with VILE strange name
 'replace the VILE[ VILE\ VILE]
 'by          VIL@A VIL@B VIL@C
 Select Case Mid$(file, 4 + 1, 1)
   Case "["
     Mid$(file, 4 + 1, 2) = "$"
   Case "\"
     Mid$(file, 4 + 1, 2) = "@"
   Case "]"
     Mid$(file, 4 + 1, 2) = "#"
 End Select
 Select Case Mid$(file, 6 + 1, 1)
   Case "["
     Mid$(file, 6 + 1, 2) = "$"
   Case "\"
     Mid$(file, 6 + 1, 2) = "@"
   Case "]"
     Mid$(file, 6 + 1, 2) = "#"
 End Select

 Dim res%
 res = DIRmakePath(out, Path, file)
 MakeFileName = Left$(out, res)

End Function

Function ParseString (ByVal buffer As String, table() As String, comment As String) As Integer
' input: a string to parse (according to spaces and tabs)
'
' output: result            as integer
'         table(0..result)  as string
'         comment           as string
'
   Dim last, deb, fin, nb As Integer
   Dim s, part As String
   ReDim table(0 To 10)

   ' get the comments after # if any
   s = buffer
   comment = ""
   deb = InStr(s, "#")
   If deb > 0 Then
     s = Left$(s, deb - 1)
     comment = Right$(s, deb)
   End If
   deb = InStr(s, ";")
   If deb > 0 Then
     s = Left$(s, deb - 1)
     comment = Right$(s, deb)
   End If
   'remove TABs
   s = SubstitStr(s, Chr$(9), " ")
   'parse the string
   deb = 1
   nb = 0             'nothing found yet
   Do
     If deb > Len(s) Then Exit Do
     fin = InStr(deb, s, " ")
     If fin = deb Then    'ignore blanks
      deb = deb + 1
     ElseIf fin <= 0 Then 'last part
        If nb >= UBound(table) Then ReDim Preserve table(nb + 1)
        table(nb) = Mid$(s, deb, Len(s) - deb + 1)
        nb = nb + 1
        Exit Do
     Else                 'get a part
        If nb >= UBound(table) Then ReDim Preserve table(nb + 10)
        table(nb) = Mid$(s, deb, fin - deb)
        nb = nb + 1
        deb = fin + 1     'next part
     End If
   Loop
   ReDim Preserve table(nb)
   ParseString = nb
End Function

Sub PlayMidi (ByVal file$)
  If Not DIRexistFile(file$) Then Exit Sub
  If Not UCase$(Right$(file$, 4)) Like ".MID" Then Exit Sub
  Dim res%
  res% = EXECeditFile(0, file$, App.Path)
'  Dim cmd As String
'  Dim res As Integer
'  cmd = INIgetValue("Extern", "PlayMidi")
'  If Not (cmd Like "*%MIDI%*") Then
'    cmd = "mplayer %MIDI%"
'    Call INIputValue("Extern", "PlayMidi", cmd, True)
'  End If
'  cmd = SubstitStr(cmd, "%MIDI%", file)
'  res = Shell(cmd, 1)
End Sub

Sub PlaySound (ByVal file As String)
  If Not DIRexistFile(file) Then Exit Sub
  If Not (UCase$(file) Like "*.WAV") Then Exit Sub
  'true= sound is played
  ' asynchronous
  ' exit silently if no sound found
  ' don't stop current sound
  ' SND_ASYN SND_NODEFAULT SND_NOSTOP
  Dim flag As Integer
  flag = &H1 Or &H2 Or &H10
  'ignore result
  flag = SndPlaySound(file, flag)
End Sub

Sub ProjectMake (ByVal direc$, ByVal color$, ByVal wadinf$, ByVal pwad$)
'
' create an install batch
'  direc = the directory where to write make.bat
'  pwad = the name of the PWAD file
'  IWADtyp = the version of doom, concerned by the batch
  If Not DIRexistDir(direc$) Then Exit Sub
  Dim bat$
  bat = MakeFileName(direc$, "make.bat")
  Dim rdoom$
  rdoom$ = FilePath(IWADfile)
  On Error GoTo hell30
  Open bat For Output As #1
  Print #1, "@rem Doom=" & rdoom$
  Print #1, "@rem Rgb=" & color$
  Print #1, "@rem Target=" & pwad$
  Print #1, "@echo."
  Print #1, "@echo. Making " & pwad$
  Print #1, "@echo."
  'check main wad
  Print #1, "@deutex -doom " & rdoom$ & " -dir " & direc$ & " -rgb " & color$ & " -make " & pwad
  Print #1, "@pause"
  Close #1
  Call Infos("To build your project: double-click on " & bat & " from WinFile.")
  Exit Sub
hell30:
  Call Crash("Could not create " & bat)
  Exit Sub
End Sub

Sub ProjectRead (doom$, color$, pwad$, ByVal bat$)
' input = batch file make.bat
  doom$ = ""
  color$ = ""
  pwad$ = ""
  Dim lin$
  Open bat$ For Input As #1
  Do
    If EOF(1) Then Exit Do
    Line Input #1, lin$
    If lin$ Like "@rem Doom=*" Then
      doom$ = Trim$(Mid$(lin$, 10 + 1))
    ElseIf lin$ Like "@rem Rgb=*" Then
      color$ = Trim$(Mid$(lin$, 9 + 1))
    ElseIf lin$ Like "@rem Target=*" Then
      pwad$ = Trim$(Mid$(lin$, 12 + 1))
    End If
  Loop
  Close #1
End Sub

Function QueryCancel (ByVal txt$)
' ask, default to cancel
     QueryCancel = False
     If MsgBox("Warning:" & Chr$(10) & txt$, 1 + 32 + 256, "Warning") <> 1 Then Exit Function
     QueryCancel = True
End Function

Function QueryOk (ByVal txt$)
' ask, default to ok
     QueryOk = False
     If MsgBox("Warning:" & Chr$(10) & txt$, 1 + 32, "WinTex Infos") <> 1 Then Exit Function
     QueryOk = True
End Function

Sub SectionRead (Lst As Control, ByVal file$, ByVal section$, ByVal which%)
' read a DeuTex formated file and returns an array of lines
'  section(0...nb-1)
' file    is the file name      wadinfo.txt
' section is the section name   [section]
' which  = type of section contents
  
  If TypeOf Lst Is ListBox Then
     If TEXTreadSectInit(file$, section$) < 0 Then Exit Sub
  Else Exit Sub
  End If
  Dim res%
  Lst.Clear
  'look for all entries
  Dim entry As String * 128
  Do
    res = TEXTreadSection(entry$)
    If res < 0 Then Exit Do
    Lst.AddItem (Left$(entry$, res))
  Loop
  'section completely read
  If Lst.ListCount > 0 Then Lst.ListIndex = 0
End Sub

Sub SectionWrite (Lst As Control, ByVal file As String, ByVal section As String)
' read a DeuTex formated file and
' replace one section
' file    is the file name      wadinfo.txt
' section is the section name   begin: section end: sections
  If TypeOf Lst Is ListBox Then
    If Not UCase$(file) Like "*.TXT" Then Exit Sub
    If Len(file) < 1 + 4 Then Exit Sub
  Else
     Exit Sub
  End If
'
'if file exist, first save other sections section
'
  If Not DIRexistFile(file) Then
    Open file For Output Access Write As #2
  Else
    Dim fileold As String
    fileold = Left$(file, Len(file) - 4) & ".BAK"
    ' security save
    If DIRexistFile(fileold) Then Kill fileold
    Call EditCopyFile(file, fileold)
    Open fileold For Input Access Read As #1
    Open file For Output Access Write As #2
    ' #1 is origin, #2 is destination
    Dim SectBegin, buffer As String
    SectBegin = "[[]" & section & "]"
    Dim inside As Integer
    inside = False  'are we inside the old section?
    Do While Not EOF(1)
      Line Input #1, buffer 'get a line
      If buffer Like SectBegin Then 'old section begining
       inside = True
      ElseIf buffer Like "[[]?*]" Then 'another section
       inside = False
      End If
      If Not inside Then  'forget the old section
        Print #2, buffer
      End If
    Loop
    Close #1
  End If
  '
  ' write the new section
  '
  ' DON'T PUT COMMENTS (would never disapear)!
  Print #2, "[" & section & "]"
  Dim I As Integer
  For I = 0 To Lst.ListCount - 1
    Print #2, Lst.List(I)
  Next I
  Close #2
End Sub

Function SubstitStr (ByVal s As String, ByVal varnam As String, ByVal Value As String) As String
' non critical function
'
' substitute characters in a string
 Dim res As String
 Dim varlen, pos As Integer
 varlen = Len(varnam)
 res = s
 If InStr(Value, varnam) >= 0 Then 'security
   Do
    pos = InStr(res, varnam)
    If pos <= 0 Then Exit Do
    res = Left$(res, pos - 1) & Value & Mid$(res, pos + varlen)
   Loop
 End If
 SubstitStr = res
End Function

Function Tutor (ByVal txt$)
' returns true if user accepts
  Tutor = True
  If NoTutor Then Exit Function
  Dim res%
  res% = MsgBox("This will " & txt$ & Chr$(10) & Chr$(10) & "(Press F1 for help, CANCEL to stop tutorial)", 3 + 48, "WinTex Tutorial")
  If res% <> 6 Then Tutor = False
  If res% <> 2 Then Exit Function
  If MsgBox("End Tutorial Mode?", 4 + 32, "Tutorial Mode") = 6 Then
    Call TutorInit(1) 'disable
  End If
End Function

Sub TutorInit (ByVal level%)
  Select Case level%
   Case 0 'enquire
     NoTutor = False
     If UCase$(INIgetValue("Settings", "Tutorial")) = "OFF" Then NoTutor = True
   Case 1 ' switch
     NoTutor = Not NoTutor
     Dim no$
     no$ = "ON"
     If NoTutor Then no$ = "OFF"
     Call INIputValue("Settings", "Tutorial", no$, False)
     Call Infos("Tutorial mode " & no$)
  End Select
End Sub

Function typeIWAD () As Integer
  typeIWAD = IWADtyp
End Function

Sub WADexit ()
  Dim res%
  res = IWADforget()
End Sub

Function WADexportName (ByVal direc$, ByVal entry$, ofx, ofy) As Integer
  WADexportName = False
  If Len(entry$) = 0 Then Exit Function
  If Not DIRexistDir(direc$) Then Exit Function
  Dim file$
  Select Case WADtyp
    Case 4, 5, 6, 7, 8 'graph, sprit, patch, extend patch ,flats
       ' Export Picture/Flat
      Dim ofsx%, ofsY%
      file$ = MakeFileName(direc$, entry$ & ".bmp")
      If IWADexportPic(entry$, ofsx, ofsY, file$) < 0 Then Exit Function'failure
      ofx = ofsx
      ofy = ofsY
    Case 2 'sounds
       ' Export SOUND
       file$ = MakeFileName(direc$, entry$ & ".wav")
       If Not IWADexportSound(entry$, file$) Then Exit Function
    Case 3 'music
       file$ = MakeFileName(direc$, entry$ & ".mus")
       If Not IWADexportLump(entry$, file$) Then Exit Function
  End Select
  WADexportName = True
End Function

Sub WADinfos (scal%, ByVal chscal%)
' retrieve nb entries, scale and change scale
  WADscal% = WADscal% + chscal%
  If WADscal% < 1 Then WADscal% = 1
  If WADscal% > 8 Then WADscal% = 8
  scal% = WADscal
End Sub

Function WADinit (ListB As Control, ByVal typ%, ByVal pwad$, ByVal r%, ByVal G%, ByVal B%) As Integer
'
' initialise the display of entries in a WAD
' scroll is set to the right boundaries
' listB is set to the initial content
' if pwad$="" then init with IWAD
' returns true or false
  WADinit = False
  WADtyp = typ%
  Dim res%
  res = IWADcolors(IWADfile, r%, G%, B%)
  If res < 0 Then Exit Function
  If Len(pwad$) > 1 Then
    res = IWADdeclare(pwad$)
  Else
    res = IWADdeclare(IWADfile)
  End If
  If res < 0 Then Exit Function
  res = IWADsearchType(ListB.hWnd, WADtyp)
  If res < 0 Then Exit Function
  WADscal = 1
  WADpatDir = "."
  WADtexuXsz = 512
  WADtexuYsz = 128
  WADtransp = RGB(r%, G%, B%)
  WADinit = True
End Function

Function WADnameSeek (ListB As Control, ByVal KeyAscii%)
   Static match$
   WADnameSeek = 0 'cancel key
   Dim lmatch%
   Select Case KeyAscii
     Case KEY_BACK  'backspace
       lmatch% = Len(match$)
       If lmatch% > 0 Then lmatch% = lmatch% - 1
       match$ = Left$(match$, lmatch%)
     Case 0 To 32
       'ignore non-ascii
       match$ = ""
     Case Else
       match$ = match$ & UCase$(Chr$(KeyAscii))
  End Select
  lmatch% = Len(match$)
  If lmatch% <= 0 Or lmatch% > 8 Then
    match$ = ""
    Exit Function
  End If
  If Len(match$) <= 0 Then Exit Function
  Dim res%
  res% = ListFind(ListB, ListB.ListIndex - 1, match$)
  If res% >= 0 Then ListB.ListIndex = res%
End Function

Sub WADpatchShow (picB As Control, ByVal entry$)
   picB.Visible = True
   picB.AutoRedraw = True
   Static szX%, szY%
   Static ofx%, ofy%
   Static file$
   'first load bitmap, then, if not found, load entry
   file$ = MakeFileName(WADpatDir, entry$ & ".bmp")
   If DIRexistFile(file$) Then
     If IWADgetBmp(picB.hDC, szX, szY, 1, file$) < 0 Then Exit Sub
   ElseIf IWADgetPic(picB.hDC, szX, szY, 1, ofx%, ofy%, entry$) < 0 Then
       picB.Visible = False  'no pic
       Exit Sub
   End If
   picB.Width = szX * Screen.TwipsPerPixelX        'set width
   picB.Height = szY * Screen.TwipsPerPixelY       'set height
   picB.Refresh             'paint picture
   'DoEvents 'NO!!!
End Sub

Sub WADshowName (picB As Control, ByVal entry$)
  If Len(entry$) = 0 Then Exit Sub
  Select Case WADtyp
    Case 4, 5, 6, 7, 8'graph, sprite, patch, extend patch ,flats
       If TypeOf picB Is PictureBox Then
         'PicB.Visible = True
         picB.AutoRedraw = True   'prepare for modification
         Dim szX%, szY% 'size
         Dim ofx%, ofy% 'offsets
         If IWADgetPic(picB.hDC, szX, szY, WADscal, ofx, ofy, entry$) < 0 Then Exit Sub    'failure
         picB.Width = szX * Screen.TwipsPerPixelX        'set width
         picB.Height = szY * Screen.TwipsPerPixelY       'set height
         
         picB.Refresh             'paint picture
         picB.Visible = True
         'DoEvents 'NO!!!
       End If
    Case 2 'sounds
       If IWADplaySound(entry$) < 0 Then Exit Sub
    Case 3 'music
  End Select
End Sub

Sub WADshowSprt (picB As Control, ByVal entry$, ofsx%, ofsY%)
  If Len(entry$) = 0 Then Exit Sub
  Select Case WADtyp
    Case 5 'sprit
       If TypeOf picB Is PictureBox Then
         'PicB.Visible = True
         picB.AutoRedraw = True   'prepare for modification
         Dim szX%, szY% 'size
         Dim ofx%, ofy% 'offsets
         If IWADgetPic(picB.hDC, szX%, szY%, WADscal%, ofx%, ofy%, entry$) < 0 Then Exit Sub    'failure
         picB.Width = szX% * Screen.TwipsPerPixelX        'set width
         picB.Height = szY% * Screen.TwipsPerPixelY       'set height
         ofsx = ofx%
         ofsY = ofy%
         'Don't show picture:
         'only do it after the offsets are positionned
         'picB.Refresh             'paint picture
         'picB.Visible = True
         'DoEvents 'NO!!!
       End If
  End Select
End Sub

Sub WADtexuInit (TexuB As Control, ByVal Xsz%, ByVal Ysz%, ByVal PatDir$, ByVal resize%)
  If Xsz% < 4 Then Exit Sub
  If Ysz% < 4 Then Exit Sub
  If Xsz% > 2048 Then Xsz = 2048
  If Ysz% > 128 Then Ysz = 128
  WADtexuXsz = Xsz%
  WADtexuYsz = Ysz%
  If Not DIRexistDir(PatDir$) Then Exit Sub
  WADpatDir = PatDir$
  If resize% Then
    If TypeOf TexuB Is PictureBox Then
      TexuB.BackColor = WADtransp
      TexuB.Width = Xsz% * Screen.TwipsPerPixelX
      TexuB.Height = Ysz% * Screen.TwipsPerPixelY
    End If
  End If
End Sub

Sub WADtexuShow (TexuB As Control, patlst$)
' Show a DOOM texture
' picb= a picture box
' scal= scale: x1 to x8
' patlst= a list of patches with offsets
'         each patch is with format ABCDEFGH-123-123
' patdir= a directory with some patch .bmp files
  If TypeOf TexuB Is PictureBox Then
    TexuB.Visible = True
    TexuB.AutoRedraw = True
    Static szX%, szY%
    szX = WADtexuXsz
    szY = WADtexuYsz
    TexuB.Width = szX * Screen.TwipsPerPixelX
    TexuB.Height = szY * Screen.TwipsPerPixelY
    If IWADtexuShow(TexuB.hDC, szX, szY, 1, patlst$, WADpatDir) < 0 Then Exit Sub
    TexuB.Refresh
  End If
End Sub

Sub WinTexHelp (ByVal key%)
  Dim res%
  Select Case key%
    Case -1   'HELP_CONTENTS
     res = WinHelp(WinTex.hWnd, App.HelpFile, &H3, 0)
    Case -2   'HELP_INDEX
     res = WinHelp(WinTex.hWnd, App.HelpFile, &H3, 0)
    Case -3   'HELP_HELPONHELP
     res = WinHelp(WinTex.hWnd, App.HelpFile, &H4, 0)
    Case Else 'HELP_CONTEXT
     res = WinHelp(WinTex.hWnd, App.HelpFile, &H1, key%)
  End Select
End Sub

Sub WinTexInit ()
  'this is needed, if we want to find lbdeutex
  ChDir (App.Path)
  'set help file
  Dim file$
  file$ = MakeFileName(App.Path, "wintex.hlp")
  If DIRexistFile(file$) Then App.HelpFile = file$
  INIfile = MakeFileName(App.Path, "wintex.ini")
  Call TutorInit(0)
End Sub

