// statment.h  - definition of 'Statement' and associated stuff

#ifndef _statment_h_
#define _statment_h_

#include "bastypes.h"
typedef struct tagScriptInfo ScriptInfo;
#include "opcode.h" // just in case it wasn't included already...

typedef struct tagStatement
{
    WORD    wLead;      // index of toplevel instruction of statement
    WORD    wStart;     // index of first instruction of statement
    int     iLabel;     // 0 for none
    WORD    wJump;      // jump: target statement index (0xFFFF if none)
    WORD    wJumpType;  // JT_xxx constant
    WORD    wDoCnt;     // number of do {} loops that start at this adress
    WORD    wBreak;     // break adress for loops etc. Also for 'if'!
                        // (defines number of statements inside loop)
    WORD    wStartLoop; // start adress of loop
} Statement;

enum    // Jump Types
{
    JT_NONE,    // not a jump
    JT_SWITCH,
    JT_CASE,
    JT_DEFAULT,
    JT_SWITCHBREAK,
    JT_TERMINATOR, // 'break' at end of switch body
    JT_BREAK,
    JT_CONTINUE,
    JT_WHILE,
    JT_UNTIL,
    JT_ENDWHILE,
    JT_ENDUNTIL,
    JT_DOWHILE, // at end of loop!
    JT_DOUNTIL, // at end of loop!
    JT_IF,      // 'if' without 'else'
    JT_IFELSE,  // 'if' with 'else'
    JT_ELSE,
    JT_UNKNOWN
};

int GetStatements(ScriptInfo *psi);
    // return FALSE if ok or TRUE if error. In case of
    // error, retrieve the error message with
    // GetStringBuffer();

#endif

