/****************************************************\
*
*
* DISPLAY OBJECT INTERNAL PICTURE API
*
\****************************************************/

/*
**
** To reuse this module, you only need to understand the API
** below, that describe all the methods available for the
** Bmp Object. Typical usage of Bmp object consist of:
**  1/ Palette setting
**  2/ Bmp usage (repeat as many time as you wish)
**      a/ BmpInit
**      b/ display Palette adjustment
**      c/ Bmp modification  OR  Bmp load from file or data
**      d/ Bmp display       OR  Bmp save to file or data
**      e/ BmpFree
*/


/*
**
** BMPOBJ is the public form of the object BMPREF
** (same size, same operations, no details given)
*/
struct BMPOBJ { Int8 Dta[0x62C];};
typedef struct BMPOBJ PTR *pBMPOBJ;
	/*
	** Initialisation of Bmp object
	*/
Int16 BMPinitI(pBMPOBJ Bmp);
	/*
	** Last operation on Bmp object
	*/
Int16 BMPfreeI(pBMPOBJ Bmp);
	/*
	** check status of BMP.
	** bit0: Bmp Exist
	** bit1: Bmp has palette
	** bit2: Bmp has data loaded
	** nit3:   and sizeX is reasonable
	** bit4:   and sizeY is reasonable
	** bit5:   and Nb of bits is correct
	*/
Int16 BMPcheck(pBMPOBJ Bmp);
/*
**
** Color Palette configuration
**
*/
  /*
  ** Set Ref palette, from a RGB array of 3x256=0x300
  */
Int16 BMPsetPalette(pBMPOBJ Bmp,pInt8 Pal/*[0x300]*/);
  /*
  ** Find the index of the transparent color, and set this
  ** color to the given RGB.
  **  Game = index of color. if <0, search it
  **  Trasparent= new RGB value for transparent color RGB(r,g,b);
  */
Int16 BMPsetTransparentColor(pBMPOBJ Bmp,Int16 Index, Int32 Transparent);
/*
**
**  Allocate Memory to a Bmp object
**
*/
  /* Allocate space for a new BMP, (of nbits per pixel)
  ** Get the initial pixels from the memory in bmpH, if bmpH not NULL
  ** BMP are unallocated by the BmpDisplay, or BmpSave function
  **
  ** SzX,SzY = Size of Bmp
  ** Nbits = number of bits (8)
  ** Lmp = pointer to data: Bitmap color indexes
  ** PalTyp = if >0, BMP->Palette, if <O, static System
  */
Int16 BMPinit(pBMPOBJ Bmp,Int16 SzX,Int16 SzY,Int16 Nbits,pInt8 Lmp, Int16 PalTyp);
/*
**
** Display palette modification
**
*/
  /*
  ** Declare system colors that are usable
  */
#define BMP_COL_BLACK      0
#define BMP_COL_DARKGREY   1
#define BMP_COL_GREY       2
#define BMP_COL_WHITE      3
#define BMP_COL_DARKRED    4
#define BMP_COL_DARKGREEN  5
#define BMP_COL_DARKBLUE   6
#define BMP_COL_DARKPURPLE 7
#define BMP_COL_DARKYELLOW 8
#define BMP_COL_DARKCYAN   9
#define BMP_COL_RED        10
#define BMP_COL_GREEN      11
#define BMP_COL_BLUE       12
#define BMP_COL_PURPLE     13
#define BMP_COL_YELLOW     14
#define BMP_COL_CYAN       15
  /*
  ** Transpose display palette, from Ref palette
  */
Int16 BMPtransposePalette(pBMPOBJ Bmp,pInt8 Trn/*[0x100]*/);
  /*
  ** Set display palette= Ref palette
  */
Int16 BMPrestorePalette(pBMPOBJ Bmp);
  /*
  ** Get the index for an RGB color (8 bit only)
  ** in the Ref palette
  */
Int8 BMPmatchColor(pBMPOBJ Bmp,Int16 R, Int16 G, Int16 B);
  /*
  ** Get the index of the transparent color (8bit only)
  */
Int16 BMPgetTransparentColor(pBMPOBJ Bmp);

/*
**
** Modify a Bmp memory
**
*/
  /*
  ** clear a 8 bit bitmap. fill with colIndex, or transparent
  ** if <0
  */
Int16 BMPclear(pBMPOBJ Bmp, Int16 colIndex);
  /*
  ** Draw a line on a Bmp,(sX,sY)-(eX,eY), with current color index
  ** Warning: origin is at the lower-left corner, not upper left
  */
Int16 BMPline(pBMPOBJ Bmp,Int16 sX,Int16 sY,Int16 eX,Int16 eY,Int16 col);
  /*
  ** Assuming the color palette is the same, this pastes some
  ** bitmap onto the current bitmap, at offsets OfsX, OfsY
  */
Int16 BMPputBmp(pBMPOBJ Bmp,Int16 OfsX,Int16 OfsY,pInt8 Pat,Int16 PatSzX,Int16 PatSzY);
/*
**
**  Read bitmaps or other kind of pictures (from file or data)
**
*/
  /*
  ** Read a Bitmap from File, Allocate a BMP and put it there
  ** quantize it's color (and indexes) to the current BmpPalette.
  ** (8 bit only)
  */
Int16 BMPinitBitmap(pBMPOBJ Bmp, pInt8 File);
  /*
  ** Read Playpal into BMP, Alloc BMP, Don't free pic
  ** Addapt to current palette, and return the offsets.
  */
Int16 BMPinitPlaypal(pBMPOBJ Bmp,pInt8 Pal, Int32 PalSz);
  /*
  ** Init BMP from FLAT
  **  Flat = lump containing flat pic
  **  SzX = width of flat pic
  **  SzY = height of flat pic
  */
Int16 BMPinitFlat(pBMPOBJ Bmp,pInt8 Flat,Int16 SzX, Int16 SzY);
  /*
  ** Init BMP from Duke Flat
  **  Flat = lump containing flat pic
  **  SzX = width of flat pic
  **  SzY = height of flat pic
  */
Int16 BMPinitDukePic(pBMPOBJ Bmp,pInt8 Flat,Int16 SzX, Int16 SzY);
  /*
  ** Init BMP from DoomPIC
  **  Pic = lump containing DOOM pic
  **  PicSz = size of lump
  **  pOfsX,pOfsY = return the X and Y offsets
  ** Addapt to current palette, and return the offsets.
  */
Int16 BMPinitDoomPic(pBMPOBJ Bmp,pInt8 Pic, Int32 PicSz, pInt16 pOfsx, pInt16 pOfsy);



	/*
	** Init BMP from MIP texture
	**  Lmp = lump containing MIP texture
	**  LmpSz = size of lump
	*/
Int16 BMPinitMipTex(pBMPOBJ Bmp, pInt8 Lmp, Int32 LmpSz, Int16 SzX, Int16 SzY, pInt32 Offs);



/*
**
** Retreive file or data from bitmap
**
*/
  /*
  ** Write a BMP to a File, as Bitmap
  **   File = bitmap file
  */
Int16 BMPwrite(pBMPOBJ Bmp,pInt8  File);
  /*
  ** Tell if a Bmp is a valid flat
  **  Type= >0 for 64x64, <0 for 320x200
  */
Int16 BMPisFlat(pBMPOBJ Bmp,Int16 Type);
  /* Convert a BMP into a Flat, returns data and size
  **  pSize = returns size of data
  ** returns pointer ot data, or null
  */
pInt8 BMPgetFlat(pBMPOBJ Bmp,pInt32 pSize);
#if (DLLFORDOOM)
  /* Convert a BMP into DoomPic, returns data and size
  **  pSize = returns size of data
  **  OfsX,OfsY = offsets of DOOM picture
  ** returns pointer ot data, or null
  */
pInt8 BMPgetDoomPic(pBMPOBJ Bmp,pInt32 pSize,Int16 OfsX,Int16 OfsY);
#endif
  /* Give a bitmap to another module and forget it.
  **  pSizeX = returns width
  **  pSizeY = returns height
  **  pLiseSz = returns bytes per lines
  ** returns pointer to bitmap data, or null
  ** The color palette is not transfered
  ** This function kills the current bitmap
  */
pInt8 BMPfreeGift(pBMPOBJ Bmp,pInt16 pSizeX,pInt16 pSizeY, pInt32 pLineSz);
  /*
  ** Free a bmp object
  */
Int16 BMPfree(pBMPOBJ Bmp);
/*
**
** Bitmap display
**
*/
  /*
  ** Prepare for display of a Bmp picture on window
  **  Pic = pointer to picbox window information
  ** set the size of the picture box. it will need a refresh
  */
Int16 BMPassignToWindoze(pBMPOBJ Bmp,pWINDOZE Pic);
  /*
  ** Display a previously prepared bitmap
  */
Int16 BMPshowWindoze(pWINDOZE Pic,Int16 Ops);

/****************************************************\
*
*
* DISPLAY OBJECT INTERNAL LIST API
*
\****************************************************/
#if 0
  /*
  ** clear a list box/combo box
  */
Int16 LstClear(pWINDOZE Win);
  /*
  ** set item of a list box/combo box
  **  Index = Index of item (if<0, last item)
  **  Code  = Code associated to Item (by Itemdata)
  **  Text  = text associated to Item (Item value)
  */
Int16 LstSet(pWINDOZE Win,Int16 Index,Int32 Code,pInt8 Text);
  /*
  ** get Item of a listboc/combo box
  **   Index= Index of item, must be > 0
  **   Text,TextSz = buffer ofr text
  */
Int16 LstGet(pWINDOZE Win,Int16 Index,pInt8 Text,Int16 TextSz);

/*
** LIST box handling
*/
	 /*add name in list*/
Int16 LstAdd8(pWINDOZE Wnd,Int32 Ref,pInt8 Name);
	 /*add name in list*/
Int16 LstAdd8XY(pWINDOZE Wnd,Int32 Ref,pInt8 Name,Int16 X, Int16 Y);
#endif
