/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'A'

#include "lbwintex.h"
#include "lbcommon.h"
#include <stdlib.h>

#include "lbwad.h"
#include "lbdispl.h"
#include "lbtext.h"

#include "lbwaddef.h"
#include "lbdoom.h"
#include "lbwaddir.h"
#include "lbwadir.h"
#include "lbmerge.h"

#if (DLLFORDOOM)
/*
** Append sprites to a WAD
**  Force = <0 check if needed,  =0 do not force, >0 force
** return <0 if not needed, 0 if dubious(S_END), >0 if needed
*/
Int16 EXPORT WADappSprites(Int16 Self, Int16 Force)
{
  pWADDEF This;
  pWADDEF That; /*main WAD*/
  pWADDIR TLst;
  pInt8 Lmp; Int32 LmpSz;
  Int16 Entry;
  Int16 pos,s_end;
  Int16 Needed = -1;
  Int8 Name[NORMALISELEN+2];
  This=WADgetThis(Self);
  if(This==NULL) return BAD_PARM;
  /*
  ** PWAD must be modifiable
  */
  if(WADmodifiableI(This)<=0) return ERR_SURE;
  /*
  ** Get main WAD
  */
  That=WADgetThat(This->IwadSelf);
  if(That==NULL) { return BAD_PARM;}
  /*
  ** Find SS_END or S_END
  */
  s_end = WADDfindEntryI(This, 0, "SS_END", ES_END);
  if(s_end>=0)
  { Needed = 1;}  /*app is needed*/
  else
  {
	 s_end = WADDfindEntryI(This, 0, "S_END", ES_END);
	 if(s_end>=0)
	 { Needed = 0;} /*app maybe not needed*/
  }
  /**/
  if((Needed==0)&&(WADDfindEntryI(This, 0, "S_START", ES_STA)>=0))
  { Needed=-1;}  /*app not needed at all*/
  /*
  ** Check if append is forced
  */
  if((Force<0)||(Needed<0))
  { return Needed; }
  if((Force==0)&&(Needed==0))
  { return 0; }
  /*
  ** Prepare to preserve WAD
  */
  WADpreserveI(This, 0);
  /*
  ** Try all sprites
  */
  pos=s_end;
  for(TLst=That->Lst,Entry=0; Entry<That->LstNb; Entry++,TLst+=1)
  {
	 /*
	 ** Discard non-sprite
	 */
	 if((TLst->Id & EMASK)!=ESPRITE) continue;
	 /*
	 ** Check sprite does not exist and is not canceled
	 */
	 Normalise(Name,TLst->Name);
	 if(WADspriteNeeded(This,s_end,Name)<=0) continue;
	 /* Name now is the modified name of the sprite*/
	 /*
	 ** read entry
	 */
	 Lmp=WADreadEntryI(That,&LmpSz,Entry);
	 if(Lmp==NULL)
 	 {
		/* restore WAD */
		WADpreserveI(This, 1);
		return BAD_ENTRY;
	 }
	 /*
	 ** Save entry
	 */
	 if(WADinsertEntryI(This, pos, ESPRITE, Name, Lmp, LmpSz)<0)
	 {
		/* restore WAD */
		WADpreserveI(This, 1);
		return BAD_FILE;
	 }
	 /*
	 ** Move to next entry
	 */
	 if(pos < (This->LstNb-1))
	 { pos+=1; }
  }
  /*
  ** convert SS_END to S_END
  ** convert SS_START to S_START
  */
  WADDchangeNameEntryI(This, 0, ES_END, "S_END", "SS_END");
  WADDchangeNameEntryI(This, 0, ES_STA, "S_START", "SS_START");
  /*
  ** save new directory. restorable without warning.
  */
  WADHdirSaveI(This,0);
  return Needed;
}
#endif /*DLLFORDOOM*/



