/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'Q'


#include "lbwintex.h"
#include "lbcommon.h"
#include <stdlib.h>
#include "lbwad.h"
#include "lbdispl.h"
#include "lbtext.h"

#include "lbwaddef.h"
#include "lbquake.h"
#include "lbwaddir.h"
#include "lbwadir.h"
#include "lbwadid.h"
#include "lbqkpart.h"
#include "lbqktexu.h"
#include "lbqkbsp.h"



#if (DLLFORQUAK)




/****************************************************\
*
*
* Quake BSP read/write
*
*
\****************************************************/
/*
** Init Bsp
*/
Int16 BSPinitI(pBSPOBJ Qkl)
{
  pBSPDEF Bsp=(pBSPDEF)Qkl;
  Bsp->Level=-1;
  Bsp->Enti= NULL; Bsp->EntiSz= 0;
  Bsp->Plan= NULL; Bsp->PlanNb= 0;
  Bsp->Texu= NULL; Bsp->TexuNb= 0;
  Bsp->Vrtx= NULL; Bsp->VrtxNb= 0;
  Bsp->Visi= NULL; Bsp->VisiSz= 0;
  Bsp->Node= NULL; Bsp->NodeNb= 0;
  Bsp->Tinf= NULL; Bsp->TinfNb= 0;
  Bsp->Face= NULL; Bsp->FaceNb= 0;
  Bsp->Lite= NULL; Bsp->LiteSz= 0;
  Bsp->Clip= NULL; Bsp->ClipNb= 0;
  Bsp->Leaf= NULL; Bsp->LeafNb= 0;
  Bsp->LFac= NULL; Bsp->LFacNb= 0;
  Bsp->Edge= NULL; Bsp->EdgeNb= 0;
  Bsp->LEdg= NULL; Bsp->LEdgNb= 0;
  Bsp->Modl= NULL; Bsp->ModlNb= 0;
  Bsp->CachVrtx=NULL;
  Bsp->CachPlan=NULL;
  Bsp->ColEdge=NULL;
  return 0;
}
/*
** Free Bsp
*/
Int16 BSPfreeI(pBSPOBJ Qkl)
{
  pBSPDEF Bsp=(pBSPDEF)Qkl;
  /*
  ** Release data
  */
  if(Bsp->Enti!=NULL) { Free(Bsp->Enti);}
  if(Bsp->Plan!=NULL) { Free(Bsp->Plan);}
  BSPtexuFree(Bsp);
  if(Bsp->Vrtx!=NULL) { Free(Bsp->Vrtx);}
  if(Bsp->Visi!=NULL) { Free(Bsp->Visi);}
  if(Bsp->Node!=NULL) { Free(Bsp->Node);}
  if(Bsp->Tinf!=NULL) { Free(Bsp->Tinf);}
  if(Bsp->Face!=NULL) { Free(Bsp->Face);}
  if(Bsp->Lite!=NULL) { Free(Bsp->Lite);}
  if(Bsp->Clip!=NULL) { Free(Bsp->Clip);}
  if(Bsp->Leaf!=NULL) { Free(Bsp->Leaf);}
  if(Bsp->LFac!=NULL) { Free(Bsp->LFac);}
  if(Bsp->Edge!=NULL) { Free(Bsp->Edge);}
  if(Bsp->LEdg!=NULL) { Free(Bsp->LEdg);}
  if(Bsp->Modl!=NULL) { Free(Bsp->Modl);}
  BSPcachFree(Bsp);
  /*
  ** Set to zero
  */
  BSPinitI(Qkl);
  return 0;
}
/*
** Read Bsp
*/
Int16 BSPinitFromEntryI(pBSPOBJ Qkl, pWADDEF This, Int16 Entry)
{
  pInt8 Lmp;
  Int32 LmpSz;
  pQKBSPHEAD Head;
  pBSPDEF Bsp=(pBSPDEF)Qkl;
  Int16 n;
  /**/
  if((This==NULL)||(Bsp==NULL))
  { return ERR_SURE;}
  /*
  ** Read Entry
  */
  Lmp=WADreadEntryI(This,&LmpSz,Entry);
  if(Lmp==NULL)
  { return BAD_ENTRY;}
  Head=(pQKBSPHEAD) Lmp;
  /*
  ** Check validity of BSP header
  */
  if(Head->Id!=QKBSPVERSION)
  { Free(Lmp); return ERRfault(ERR_VERSION);}
  for(n=0;n<QKBSPDIRNB;n++)
  { if((Head->Dir[n].Start<0)||(Head->Dir[n].Start+Head->Dir[n].Size>LmpSz))
	 { Free(Lmp); return ERRfault(BAD_ENTRY);}
  }
  /*
  ** Read entries
  */
  BSPfreeI((pBSPOBJ)Bsp);
  /**/
  Bsp->Level=Entry;
  /*read entities*/
  BSPentiInit(Bsp,&Lmp[Head->Dir[QBSP_ENTI].Start],Head->Dir[QBSP_ENTI].Size);
  /*read planes*/
  BSPplanInit(Bsp,&Lmp[Head->Dir[QBSP_PLAN].Start],Head->Dir[QBSP_PLAN].Size);
  /*read textures*/
  BSPtexuInit(Bsp,&Lmp[Head->Dir[QBSP_TEXU].Start],Head->Dir[QBSP_TEXU].Size);
  /*read vertices*/
  BSPvrtxInit(Bsp,&Lmp[Head->Dir[QBSP_VRTX].Start],Head->Dir[QBSP_VRTX].Size);
  /*read visilists*/
  BSPvisiInit(Bsp,&Lmp[Head->Dir[QBSP_VISI].Start],Head->Dir[QBSP_VISI].Size);
  /*read node*/
  BSPnodeInit(Bsp,&Lmp[Head->Dir[QBSP_NODE].Start],Head->Dir[QBSP_NODE].Size);
  /*read texinfo*/
  BSPtinfInit(Bsp,&Lmp[Head->Dir[QBSP_TINF].Start],Head->Dir[QBSP_TINF].Size);
  /*read face*/
  BSPfaceInit(Bsp,&Lmp[Head->Dir[QBSP_FACE].Start],Head->Dir[QBSP_FACE].Size);
  /*read light*/
  BSPliteInit(Bsp,&Lmp[Head->Dir[QBSP_LITE].Start],Head->Dir[QBSP_LITE].Size);
  /*read clipe*/
  BSPclipInit(Bsp,&Lmp[Head->Dir[QBSP_CLIP].Start],Head->Dir[QBSP_CLIP].Size);
  /*read leaf*/
  BSPleafInit(Bsp,&Lmp[Head->Dir[QBSP_LEAF].Start],Head->Dir[QBSP_LEAF].Size);
  /*read list faces*/
  BSPlfacInit(Bsp,&Lmp[Head->Dir[QBSP_LFAC].Start],Head->Dir[QBSP_LFAC].Size);
  /*read edges*/
  BSPedgeInit(Bsp,&Lmp[Head->Dir[QBSP_EDGE].Start],Head->Dir[QBSP_EDGE].Size);
  /*read list edges*/
  BSPledgInit(Bsp,&Lmp[Head->Dir[QBSP_LEDG].Start],Head->Dir[QBSP_LEDG].Size);
  /*read modl*/
  BSPmodlInit(Bsp,&Lmp[Head->Dir[QBSP_MODL].Start],Head->Dir[QBSP_MODL].Size);
  /*
  ** Init cache
  */
  BSPcachInit(Bsp);
  /*
  ** Exit
  */
  Free(Lmp);
  return 1;
}

/*
**  Check Bsp
**   report problems in Wnd
**   return >0 if ok, <0 if there is a problem
*/
Int16 BSPcheckI(pBSPOBJ Qkl, pWINDOZE Wnd)
{
  pBSPDEF Bsp=(pBSPDEF)Qkl;
  TXTOBJ Txt;
  Int16 res=1;
  /**/
  if((Bsp==NULL)||(Bsp->Level<0))
  { return ERR_SURE;}
  /*
  ** Init Text
  */
  TXTinitWnd(&Txt,0,Wnd);
  /*
  ** check entries
  */
  res|=BSPentiCheck(Bsp,&Txt);
  res|=BSPplanCheck(Bsp,&Txt);
  res|=BSPtexuCheck(Bsp,&Txt);
  res|=BSPvrtxCheck(Bsp,&Txt);
  res|=BSPvisiCheck(Bsp,&Txt);
  res|=BSPnodeCheck(Bsp,&Txt);
  res|=BSPtinfCheck(Bsp,&Txt);
  res|=BSPfaceCheck(Bsp,&Txt);
  res|=BSPliteCheck(Bsp,&Txt);
  res|=BSPclipCheck(Bsp,&Txt);
  res|=BSPleafCheck(Bsp,&Txt);
  res|=BSPlfacCheck(Bsp,&Txt);
  res|=BSPedgeCheck(Bsp,&Txt);
  res|=BSPledgCheck(Bsp,&Txt);
  res|=BSPmodlCheck(Bsp,&Txt);
  /*
  ** List edges in faces
  */
#if 0
  BSPfaceEdgeList(Bsp,&Txt);
#endif
  /*
  ** free text
  */
  TXTfree(&Txt);
  return res;
}
/*
** Save a BSP level
*/
Int16 BSPsaveI(pBSPOBJ Qkl, pWADDEF This, Int16 Entry)
{ pBSPDEF Bsp=(pBSPDEF)Qkl;
  Int32 Size,LmpSz;
  pInt8 Lmp;
  QKBSPHEAD Head;
  /**/
  Head.Id = QKBSPVERSION;
  LmpSz= sizeof(QKBSPHEAD);
  /**/
  Size = BSPentiCopyAll(Bsp, NULL, -1);
  Head.Dir[QBSP_ENTI].Start= LmpSz;
  Head.Dir[QBSP_ENTI].Size = Size;
  LmpSz+= (Size+3)&(~3);
  Size = BSPplanCopyAll(Bsp, NULL, -1);
  Head.Dir[QBSP_PLAN].Start= LmpSz;
  Head.Dir[QBSP_PLAN].Size = Size;
  LmpSz+= (Size+3)&(~3);
  Size = BSPtexuCopyAll(Bsp, NULL, -1);
  Head.Dir[QBSP_TEXU].Start= LmpSz;
  Head.Dir[QBSP_TEXU].Size = Size;
  LmpSz+= (Size+3)&(~3);
  Size = BSPvrtxCopyAll(Bsp, NULL, -1);
  Head.Dir[QBSP_VRTX].Start= LmpSz;
  Head.Dir[QBSP_VRTX].Size = Size;
  LmpSz+= (Size+3)&(~3);
  Size = BSPvisiCopyAll(Bsp, NULL, -1);
  Head.Dir[QBSP_VISI].Start= LmpSz;
  Head.Dir[QBSP_VISI].Size = Size;
  LmpSz+= (Size+3)&(~3);
  Size = BSPnodeCopyAll(Bsp, NULL, -1);
  Head.Dir[QBSP_NODE].Start= LmpSz;
  Head.Dir[QBSP_NODE].Size = Size;
  LmpSz+= (Size+3)&(~3);
  Size = BSPtinfCopyAll(Bsp, NULL, -1);
  Head.Dir[QBSP_TINF].Start= LmpSz;
  Head.Dir[QBSP_TINF].Size = Size;
  LmpSz+= (Size+3)&(~3);
  Size = BSPfaceCopyAll(Bsp, NULL, -1);
  Head.Dir[QBSP_FACE].Start= LmpSz;
  Head.Dir[QBSP_FACE].Size = Size;
  LmpSz+= (Size+3)&(~3);
  Size = BSPliteCopyAll(Bsp, NULL, -1);
  Head.Dir[QBSP_LITE].Start= LmpSz;
  Head.Dir[QBSP_LITE].Size = Size;
  LmpSz+= (Size+3)&(~3);
  Size = BSPclipCopyAll(Bsp, NULL, -1);
  Head.Dir[QBSP_CLIP].Start= LmpSz;
  Head.Dir[QBSP_CLIP].Size = Size;
  LmpSz+= (Size+3)&(~3);
  Size = BSPleafCopyAll(Bsp, NULL, -1);
  Head.Dir[QBSP_LEAF].Start= LmpSz;
  Head.Dir[QBSP_LEAF].Size = Size;
  LmpSz+= (Size+3)&(~3);
  Size = BSPlfacCopyAll(Bsp, NULL, -1);
  Head.Dir[QBSP_LFAC].Start= LmpSz;
  Head.Dir[QBSP_LFAC].Size = Size;
  LmpSz+= (Size+3)&(~3);
  Size = BSPedgeCopyAll(Bsp, NULL, -1);
  Head.Dir[QBSP_EDGE].Start= LmpSz;
  Head.Dir[QBSP_EDGE].Size = Size;
  LmpSz+= (Size+3)&(~3);
  Size = BSPledgCopyAll(Bsp, NULL, -1);
  Head.Dir[QBSP_LEDG].Start= LmpSz;
  Head.Dir[QBSP_LEDG].Size = Size;
  LmpSz+= (Size+3)&(~3);
  Size = BSPmodlCopyAll(Bsp, NULL, -1);
  Head.Dir[QBSP_MODL].Start= LmpSz;
  Head.Dir[QBSP_MODL].Size = Size;
  LmpSz+= (Size+3)&(~3);
  /*
  ** Alloc memory
  */
  if(LmpSz<0)
  { return ERR_BUG;}
  Lmp=Malloc(LmpSz);
  if(Lmp==NULL)
  { return ERR_MEM;}
  /*
  ** Copy header
  */
  Memcpy(Lmp,&Head,sizeof(QKBSPHEAD));
  /*
  ** Copy parts
  */
  BSPentiCopyAll(Bsp, &Lmp[Head.Dir[QBSP_ENTI].Start],Head.Dir[QBSP_ENTI].Size);
  BSPplanCopyAll(Bsp, &Lmp[Head.Dir[QBSP_PLAN].Start],Head.Dir[QBSP_PLAN].Size);
  BSPtexuCopyAll(Bsp, &Lmp[Head.Dir[QBSP_TEXU].Start],Head.Dir[QBSP_TEXU].Size);
  BSPvrtxCopyAll(Bsp, &Lmp[Head.Dir[QBSP_VRTX].Start],Head.Dir[QBSP_VRTX].Size);
  BSPvisiCopyAll(Bsp, &Lmp[Head.Dir[QBSP_VISI].Start],Head.Dir[QBSP_VISI].Size);
  BSPnodeCopyAll(Bsp, &Lmp[Head.Dir[QBSP_NODE].Start],Head.Dir[QBSP_NODE].Size);
  BSPtinfCopyAll(Bsp, &Lmp[Head.Dir[QBSP_TINF].Start],Head.Dir[QBSP_TINF].Size);
  BSPfaceCopyAll(Bsp, &Lmp[Head.Dir[QBSP_FACE].Start],Head.Dir[QBSP_FACE].Size);
  BSPliteCopyAll(Bsp, &Lmp[Head.Dir[QBSP_LITE].Start],Head.Dir[QBSP_LITE].Size);
  BSPclipCopyAll(Bsp, &Lmp[Head.Dir[QBSP_CLIP].Start],Head.Dir[QBSP_CLIP].Size);
  BSPleafCopyAll(Bsp, &Lmp[Head.Dir[QBSP_LEAF].Start],Head.Dir[QBSP_LEAF].Size);
  BSPlfacCopyAll(Bsp, &Lmp[Head.Dir[QBSP_LFAC].Start],Head.Dir[QBSP_LFAC].Size);
  BSPedgeCopyAll(Bsp, &Lmp[Head.Dir[QBSP_EDGE].Start],Head.Dir[QBSP_EDGE].Size);
  BSPledgCopyAll(Bsp, &Lmp[Head.Dir[QBSP_LEDG].Start],Head.Dir[QBSP_LEDG].Size);
  BSPmodlCopyAll(Bsp, &Lmp[Head.Dir[QBSP_MODL].Start],Head.Dir[QBSP_MODL].Size);
  /*
  ** Modify entry
  */
  if(Entry<0)
  { Entry=(Int16)(Bsp->Level); }
  WADmodifyEntryI(This,Entry,EPK_BSP,NULL,Lmp,LmpSz);
  Free(Lmp);
  return 1;
}

/*
**
** Show a BSP level
*/
Int16 BSPshowI(pBSPOBJ Qkl, pBMPOBJ Bmp, pWINDOZE Wnd, pBOUND Bound, Int32 Obj, Int16 Typ)
{
  pBSPDEF Bsp=(pBSPDEF)Qkl;
  MATRIX Rot;
  VECTOR Obs;
  /**/
  if((Bsp==NULL)||(Bsp->Level<0))
  { return ERR_SURE;}

  /*
  ** Calculate rotation matrix
  */
  BSPcachCalcRot(&Rot, Bound->Phi, Bound->The);
  Obs.X=(Float32)Bound->X;
  Obs.Y=(Float32)Bound->Y;
  Obs.Z=(Float32)Bound->Z;
  /*
  ** Calculate position of vertex on screen
  */
  BSPcachCalcVrtx(Bsp, Bound, &Obs, &Rot);
  /*
  ** Calculate position of planes toward observer
  */
  BSPcachCalcPlan(Bsp, &Obs);
  /*
  ** Allocate a BMP, use system colors
  */
  if(BMPinit(Bmp,Bound->SzX,Bound->SzY,8,NULL,-1)<0)
  { return ERR_BUG;}
  /*
  ** clear background in black, load default palette
  */
  BMPclear(Bmp,BMP_COL_BLACK);
  /*
  ** Paint edges
  */
  BSPedgePaintAll(Bsp,BMP_COL_DARKGREY);
  /**/
  switch(Typ)
  {
	 case QBSP_NODE: /*Obj=Node*/
		if((Obj>=0)&&(Obj< Bsp->NodeNb))
		{ BSPnodePaint(Bsp,Obj);}
		break;
	 case QBSP_VISI: /*Obj=Leaf*/
		if((Obj>=0)&&(Obj< Bsp->LeafNb))
		{ BSPvisiPaint(Bsp,Obj);}
		break;
	 case QBSP_FACE: /*Obj=Face*/
		if((Obj>=0)&&(Obj< Bsp->FaceNb))
		{ BSPfacePaint(Bsp,Obj, BMP_COL_YELLOW);}
		break;
	 case QBSP_LEAF: /*Obj=Leaf*/
		if((Obj>=0)&&(Obj< Bsp->LeafNb))
		{ BSPleafPaint(Bsp,Obj, BMP_COL_YELLOW);}
		break;
	 case QBSP_MODL: /*Obj=Modl*/
		if((Obj>=0)&&(Obj< Bsp->ModlNb))
		{ BSPmodlPaint(Bsp,Obj, BMP_COL_YELLOW);}
		break;
	 default:		  /*Obj=not used*/
      if(Typ<32)
		{
        BSPleafPaintType(Bsp);
		  /*BSPfacePaintAll(Bsp, BMP_COL_GREEN);*/
      }
      else
      {
		  BSPfacePaintSpecial(Bsp, Obj, Typ-32, BMP_COL_YELLOW);
		}
		break;
  }

#if 0 /*DEBUG*/
  BMPline(Bmp, 100,100, 100,200, 1);
  BMPline(Bmp, 100,100, 100,0,   1);

  BMPline(Bmp, 100,100, 200,100, 1);
  BMPline(Bmp, 100,100,   0,100, 1);
  /* X dominant*/
  BMPline(Bmp, 100,100, 200,150, 1);
  BMPline(Bmp, 100,100, 200, 50, 1);
  /* Y dominant*/
  BMPline(Bmp, 100,100, 150,200, 1);
  BMPline(Bmp, 100,100,  50,200, 1);
#endif
  /*
  ** show all edges
  */
#if 1
  BSPedgeLineAll(Bsp,Bmp,Bound);
#endif
  /*
  ** show axis
  */
#if 0
  BSPcachLineAxis(Bmp, Bound, &Obs, &Rot);
#endif
  /*
  ** Display level
  */
  BMPassignToWindoze(Bmp,Wnd);
  BMPfree(Bmp);
  return 1;
}
/*
**
*/
Int16 BSPmodifyI(pBSPOBJ Qkl, pBSPINFOS Infos, Int16 What)
{
  pBSPDEF Bsp=(pBSPDEF)Qkl;
  if((Bsp==NULL)||(Infos==NULL))
  { return ERRfault(ERR_BUG);}
  switch(Infos->Id)
  { case QBSP_PLAN:
		return BSPplanModify(Bsp, Infos, What);
	 case QBSP_NODE:
		return BSPnodeModify(Bsp, Infos, What);
	 case QBSP_TINF:
		return BSPtinfModify(Bsp, Infos, What);
	 case QBSP_FACE:
		return BSPfaceModify(Bsp, Infos, What);
	 case QBSP_CLIP:
		return BSPclipModify(Bsp, Infos, What);
	 case QBSP_LEAF:
		return BSPleafModify(Bsp, Infos, What);
	 case QBSP_MODL:
		return BSPmodlModify(Bsp, Infos, What);
  }
  return BAD_PARM;
}




/****************************************************\
*
*
* Quake BSP    EXTERNALS
*
*
\****************************************************/

Int16 EXPORT BSPinit(Int16 Self, Int16 Entry)
{
  pWADDEF This;
  This= WADgetThis(Self);
  if(This==NULL)
  { return ERR_SURE;}
  return BSPinitFromEntryI(&(This->Qkl),This,Entry);
}

Int16 EXPORT BSPfree(Int16 Self)
{
  pWADDEF This;
  This= WADgetThis(Self);
  if(This==NULL)
  { return ERR_SURE;}
  return BSPfreeI(&(This->Qkl));
}

Int16 EXPORT BSPcheck(Int16 Self, pWINDOZE Wnd)
{
  pWADDEF This;
  This= WADgetThis(Self);
  if(This==NULL)
  { return ERR_SURE;}
  return BSPcheckI(&(This->Qkl), Wnd);
}

Int16 EXPORT BSPsave(Int16 Self)
{
  pWADDEF This;
  This= WADgetThis(Self);
  if(This==NULL)
  { return ERR_SURE;}
  return BSPsaveI(&(This->Qkl), This, -1);
}


Int16 EXPORT BSPshow(Int16 Self, pWINDOZE Wnd, pBOUND Bound, Int32 Obj, Int16 Typ)
{
  pWADDEF This;
  This= WADgetThis(Self);
  if(This==NULL)
  { return ERR_SURE;}
  /*
  ** If Typ<0 calculate bound box
  */
  if(Typ<0)
  { return BSPvrtxCalcBound((pBSPDEF)&(This->Qkl),Bound); }
  /*
  ** Otherwise, just display the level
  */
  return BSPshowI(&(This->Qkl),&(This->Bmp), Wnd, Bound,Obj, Typ);
}
Int16 EXPORT BSPmodify(Int16 Self, pBSPINFOS Infos, Int16 What)
{
  pWADDEF This;
  This= WADgetThis(Self);
  if(This==NULL)
  { return ERR_SURE;}
  /*
  ** Otherwise, just display the level
  */
  return BSPmodifyI(&(This->Qkl), Infos, What);
}

#endif /*DLLFORQUAK*/
