/****************************************************\
*
*
* ENTRY AND TYPES EXTERNAL IDENTIFICATION SERVICE
*
*
\****************************************************/

   /*
   ** List the entries of the given type into drop box
   **  Type= types of entries listed
   **  Game= which game is it for? 0x10=doom; 0x12=doom2...
   */
void EXPORT HELPforWad(pWINDOZE hLstB, IDENT Type,Int16 Game);
   /*
   ** Find if a given name is matched
   **  Type= types of entries listed
   **  Game= which game is it for? 0x10=doom; 0x12=doom2...
   ** returns <0 if name not matched
   ** returns 0 if name contains illegal Int8
   ** returns 1 if name is matched
   */
Int16 EXPORT HELPfindName(pInt8 Name, IDENT Type, Int16 Game);
   /*
   ** Give help test for a name
   **  Name =  name searched
   **  Type = Type searched  (-1=all)
   **  Game = game searched
   **  Text = buffer
   **  TextSz = size of buffer
   ** returns actual size of text, or <0 if error
   */
Int16 EXPORT HELPforName(pInt8 Name, IDENT Type, Int16 Game,pInt8 Text,Int16 TextSz);
   /*
   ** Give the name of a type
   **  Type = entry type to be identified
   **  Text = buffer
   **  TextSz = size of buffer
   ** returns actual size of text
   */
Int16 EXPORT HELPforType(Int16 Type,pInt8 Text,Int16 TextSz);


#if 0
'
'    List the entries of the given type into drop box
'     Type= types of entries listed
'     Game= which game is it for? 0x10=doom; 0x12=doom2...
Declare Sub HELPforWad Lib "lbwintex.dll" (hLst As Windoze, ByVal Typ%, ByVal Gam%)
'
'    Find if a given name is matched
'     Type= types of entries listed
'     Game= which game is it for? 0x10=doom; 0x12=doom2...
'    returns <0 if name not matched
'    returns 0 if name contains illegal Int8
'    returns 1 if name is matched
Declare Function HELPfindName% Lib "lbwintex.dll"(ByVal Nam$, ByVal Typ%, ByVal Gam%)
'
'    Give help test for a name
'     Name =  name searched
'     Type = Type searched  (-1=all)
'     Game = game searched
'     Text = buffer
'     TextSz = size of buffer
'    returns actual size of text
Declare Function HELPforName% Lib "lbwintex.dll"(ByVal Nam$, ByVal Typ%, ByVal Gam%,ByVal Txt$, ByVal TxtSz%)
'
'    Give the name of a type
'     Type = entry type to be identified
'     Text = buffer
'     TextSz = size of buffer
'    returns actual size of text
Declare Function HELPforType% Lib "lbwintex.dll" (ByVal Typ%, ByVal Txt$, ByVal TxtSz%)
#endif
