

/****************************************************\
*
*
* WAD OBJECT INTERNAL BASIC WAD SERVICE API
* These functions shall be used only in WAD related modules
* They propose the basic WAD manipulation services.
*
\****************************************************/



	/*
	** get a pointer to the Wad object,
	** Me = reference of the Wad object
	*/
pWADDEF WADgetThis(Int16 Self);
pWADDEF WADgetThat(Int16 Self); /*no change to error report*/
	/*
	** Init WAD object
	** Lock = if>0 then wad is write-locked
	** Transparent = default transparent color
   ** ErrorWnd = error window
	*/
Int16 WADinitI(pWADDEF This, pInt8 File,Int16 Main,Int16 Lock,Int32 Transparent, Int32 Error);
	/*
	** Free a WAD
	*/
Int16 WADfreeI(pWADDEF This, Int16 Save);
	/*
	** Returns >0 if a WAD can be modified
	*/
Int16 WADmodifiableI(pWADDEF This);
	/*
	** Preserve WAD file original size and directory
   **  Restore = if <0 preserve, if >0 restore file
	*/
Int16 WADpreserveI(pWADDEF This, Int16 Restore);
	/*
	** Insert an entry in WAD (do not check if duplicated)
	**  Entry = position where to insert entry (<0 means: at the end)
	**  Name = name of entry
	**  Id = if >0, declare the identification of the entry
	**  Lmp = if !=NULL, data  (not freed by this function)
	**  LmpSz = size of data
	** Returns position of entry, or <0 if error
	*/
Int16 WADinsertEntryI(pWADDEF This, Int16 Entry, IDENT Id, pInt8 Name, pInt8 Lmp, Int32 LmpSz);
	/*
	** Semi-clever Entry modification
	**  Entry = suggested position for entry
	**  Id = identification of entry
	**  Name = name of entry
	**  Lmp = if !=NULL, data  (not freed by this function)
	**  LmpSz = size of data
	** Returns position of entry, or <0 if error
	*/
Int16 WADmodifyEntryI(pWADDEF This, Int16 Entry, IDENT Id, pInt8 Name, pInt8 Lmp, Int32 LmpSz);
	/*
	** Allocate memory and read an entry from PWAD
	**  pSize = return the size of the lump
	**  Entry = reference of the entry
	** Returns a pointer to the lump (NULL if no entry)
	*/
pInt8 WADreadEntryI(pWADDEF This,pInt32 pSize,Int16 Entry);
	/*
	** Allocate memory and read part of an entry from PWAD
	**  Entry = reference of the entry
	**  Start = start of the entry part (from start of entry)
	**  Size = size of the entry part (in the entry)
	** Returns a pointer to the lump (NULL if no entry/no part)
	*/
pInt8 WADreadEntryPartI(pWADDEF This, Int16 Entry, Int32 Start, Int32 Size);
	/*
	** Find and read an entry that must exist in PWAD or in IWAD.
	**  pSize = return the size of the lump
	**  Name = name of the entry
	** Return a pointer to the lump (NULL if no entry)
	*/
pInt8 WADreadObligEntryI(pWADDEF This, pInt32 pSize, pInt8 Name);
	/*
	** Save a level into a new WAD File
	**  Entry = reference of level header entry in WAD
	**  File = name of new Wad file
	** returns >0 if ok.
	*/
Int16 WADsaveLevelI(pWADDEF This, Int16 Entry,pInt8 File);
	/*
	** Load a level from an existing WAD
	**  Entry = suggested position for level
	**  Name = level name
	**  File = name of WAD file
	**  What = 0: load level 1: load node 2:load reject
	*/
#define WAD_LDLVL 0
#define WAD_LDNOD 1
#define WAD_LDREJ 2
Int16 WADloadLevelI(pWADDEF This, Int16 Entry, pInt8 Name, pInt8 File, Int16 What);
	/*
	** Check if a sprite is needed
	**  Top = consider only entries 0..Top
	**  Name = name of sprite (modified if needed)
	** Returns <0 if not needed
	*/
Int16 WADspriteNeeded(pWADDEF This, Int16 Top, pInt8 Name);





