/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'm'

#include "lbwintex.h"
#include "lbcommon.h"
#include <stdlib.h>

#include "lbwad.h"
#include "lbdispl.h"
#include "lbsound.h"
#include "lbmusic.h"
#include "lbtext.h"

#include "lbwaddef.h"
#include "lbdoom.h"
#include "lbwaddir.h"
#include "lbwadir.h"
#include "lbwadid.h"
/*
#include "lbpatch.h"
#include "lblevel.h"
#include "lbtexu.h"
#include "lblumps.h"
#include "lbbehav.h"
*/


/****************************************************\
*
*
*   Misc
*
*
\****************************************************/

/*
** show a bitmap
*/
Int16 EXPORT WADshowWindoze(pWINDOZE PicB, Int16 Ops)
{
  return BMPshowWindoze(PicB,Ops);
}

/*
** Set parameters
**  Sound: <0 stop sound,=0 no sound, >0 sound
**  ErrWnd: !=NULL = Windows handle
*/
Int16 EXPORT WADsetParams(Int16 Self, Int16 Sound)
{ pWADDEF This;
  This=WADgetThis(Self);
  /**/
  if(This==NULL)
  { return BAD_PARM;}
  /*
  ** Sound playing
  */
  if(Sound>0)
  { This->Sound = TRUE;}
  else
  { if(Sound==0)
	 { This->Sound = FALSE;
	 }
	 MUSstop(); /*Kill music*/
  }
  return 1;
}


/****************************************************\
*
*
*  Checking WADs
*
*
\****************************************************/

/*
** Check WAD
** put result in list box.
*/
Int16 EXPORT WADcheckWad(Int16 Self, pWINDOZE hList)
{ pWADDEF This=WADgetThis(Self);
  if(This==NULL){return BAD_PARM;}
  (void)hList;
  /*
  ** check duplicate entries
  */
  /*
  ** check sprites out of bounds
  */
  /*
  ** check flat out of bounds
  */
  /*
  ** check textures
  */
  return 1;
}

/****************************************************\
*
*
* List WAD directory
*
*
\****************************************************/

/*
** List dir entry
*/
#define LSTD_LVL   1
#define LSTD_ALL   2
#define LSTD_GEN   3
#define LSTD_TYP   4
static Int16 WADlistDirI(pWADDEF This, pTXTOBJ Txt, Int16 Type, Int16 Entry, Int16 Which)
{
  Int16 pos,e,how;
  Int32 ref;
  pWADDIR TLst;
  if((This==NULL)||(This->Lst==NULL)||(This->LstNb<0))
  { return ERR_BUG;}
  /*
  ** List directory
  */
  for(pos=0,e=0,TLst=This->Lst; e<This->LstNb; e++,TLst+=1)
  { /*
	 ** select listed entries, depending on what type
	 */
	 switch(Which)
	 { case LSTD_ALL:  /*filter: none*/
		  break;
		case LSTD_LVL:  /*filter: only some level parts*/
#if 0   /*0 to disable short level list*/
		  switch(TLst->Id)
		  { case ELVLHDR:  case ESECTOR:
			 case ESIDEDEF: case EBEHAVE:
				break;
			 default:
				continue;
		  }
#endif
		case LSTD_GEN:  /*filter: same general type*/
		  if(((TLst->Id)&EMASK)!=Type) continue;
		  break;
		case LSTD_TYP:  /*filter: exact same type*/
		  if((TLst->Id)!=Type) continue;
		  break;
	 }
	 /*
	 ** Entry reference
	 */
	 ref = (((Int32)TLst->Id)<<16) | (((Int32)e)  & 0x7FFFL);
	 /*
	 ** select how to list entry
	 */
	 how=(((TLst->Id&EMASK)==ELEVEL)&&(TLst->Id!=ELVLHDR))? 1:0;
	 /*
	 ** List entry
	 */
	 if(TXTprintName8(Txt,ref,TLst->Name,how)<0){ break;}
	 /*
	 ** search for position of Entry
	 */
	 if(e<=Entry){ pos++; }
  }
  return pos; /*>0 if entry found*/
}

/*
**  List all PWAD and IWAD entries of a given type, with references
**   if Type has a general type, list that type
**   in Type has a subtype, list only that subtype
**  returns 1
*/
Int16 EXPORT WADlistAll(Int16 Self, pWINDOZE Wnd, Int16 Type)
{ Int16 Which;
  TXTOBJ Txt;
  pWADDEF This;
  pWADDEF That=NULL;
  This=WADgetThis(Self);
  if((This==NULL)||(This->Lst==NULL)||(This->LstNb<0))
  { return ERR_BUG;}
  if(This->IwadSelf>=0)
  { That= WADgetThat(This->IwadSelf);
	 if((That==NULL)||(That->Lst==NULL)||(That->LstNb<0))
	 { return ERR_BUG;}
  }
  /**/
  if(Type<0)
  { return ERR_BUG;} /*all*/
  Which = ((Type&EMASK) == Type)? LSTD_GEN: LSTD_TYP;
  /*
  ** List directory
  */
  if(TXTinitWnd(&Txt,NORMALISELEN,Wnd)<0)
  { return ERR_BUG; }
  WADlistDirI(This,&Txt,Type,-1,Which);
  if(That!=NULL)
  { WADlistDirI(That,&Txt,Type,-1,Which);}
  TXTfree(&Txt);
  return 1; /*>0 if entry found*/
}


/*
**  List WAD entries, with references
**   if Type<0, list all types
**   if Type has a general type, list that type
**   in Type has a subtype, list only the subtype
**  returns position of entry+1
*/
Int16 EXPORT WADlistDir(Int16 Self, pWINDOZE Wnd, Int16 Type, Int16 Entry)
{ Int16 Which,pos;
  TXTOBJ Txt;
  pWADDEF This;
  This=WADgetThis(Self);
  if((This==NULL)||(This->Lst==NULL)||(This->LstNb<0))
  { return ERR_BUG;}
  /**/
  if(Type<0)
  { Which = LSTD_ALL;} /*all*/
  else if(Type==ELEVEL)
  { Which = LSTD_LVL;} /*levels*/
  else
  { Which = ((Type&EMASK) == Type)? LSTD_GEN: LSTD_TYP;}
  /*
  ** List directory
  */
  if(TXTinitWnd(&Txt,NORMALISELEN,Wnd)<0)
  { return ERR_BUG; }
  pos=WADlistDirI(This,&Txt,Type,Entry,Which);
  TXTfree(&Txt);
  return pos; /*>0 if entry found*/
}



/*
** Find void spaces
*/
struct WASTE
{ Int32 Start;
  Int32 Size;
};
typedef struct WASTE PTR *pWASTE;


/*
** Comparison of entries (WADDIR)
*/
#if defined __OS2__
#if defined (__BORLANDC__)
int _USERENTRY WADIwasteCmp(const void *d1,const void *d2)
#else
int _Optlink WADIwasteCmp(const void *d1,const void *d2)
#endif
#elif defined __WINDOWS__
int _USERENTRY WADIwasteCmp(const void *d1,const void *d2)
#else
int WADIwasteCmp(const void *d1,const void *d2)
#endif
{
	pWASTE e1 = (pWASTE)d1;
	pWASTE e2 = (pWASTE)d2;
	if(e1->Start < e2->Start) return -1;
	if(e1->Start > e2->Start) return 1;
	if(e1->Size  < e2->Size) return -1;
	if(e1->Size  > e2->Size) return 1;
	return 0;
}

Int16 WADIlistWaste(pWADDEF This, pWINDOZE Wnd)
{
  pWASTE Wst,TWst;
  pWADDIR TLst;
  Int32 WstNb;
  Int32 e;
  Int32 top,diff,total;
  TXTOBJ Txt;

  if((This==NULL)||(This->Lst==NULL)||(This->LstNb<0))
  { ERRfault(ERR_BUG); }
  if(This->LstNb==0)
	 return 0;
  WstNb= This->LstNb;
  Wst=(pWASTE)Malloc(WstNb * sizeof(struct WASTE));
  if(Wst==NULL)
	return ERR_MEM;
  for(e=0,TLst=This->Lst,TWst=Wst; e< WstNb; e++, TLst+=1,TWst+=1)
  {
	 TWst->Start = TLst->Start;
	 TWst->Size  = TLst->Size;
  }
#if 1
  qsort(Wst,(Int16)WstNb,sizeof(struct WASTE),WADIwasteCmp);
#endif
  /*
  ** set up
  */
  TXTinitWnd(&Txt,0,Wnd);
  /*
  ** List wasted spaces
  */
  TXTprintName(&Txt,-1,"List of wasted space:",22);
  top = 0xC; /* size of WAD header*/
  for(total=0,e=0,TWst=Wst; e<WstNb; e++,TWst+=1)
  {
	  diff= TWst->Start- top;
	  if(top< (TWst->Start + TWst->Size))
	  {
		 top = TWst->Start+TWst->Size;
	  }
	  if(diff<4)continue; /*don't report Int32 word alignement*/
	  total+=diff;
	  TXTprintFrm(&Txt,"  %4.4ld bytes wasted at 0x%6.6lx",diff,top);
  }
  TXTprintName(&Txt,-1," ",1);
  TXTprintFrm(&Txt,"Total wasted space = %ld bytes.",total);
  TXTfree(&Txt);
  Free(Wst);
  return 1;
}



