Option Explicit
'
' choose file default
'
Dim ChooseDflt$   'default dir
Dim ChooseRes$    'result
'
' temp dir to store stuff for editing
'
Dim TempDirec$    'temp dir
'
' tutorial active
'
Dim NoTutor As Integer
'
' WINTEX.INI file name
'
Dim INIfile As String
'
' HELP lock to avoid event loops
'
Dim HELPfreeze As Integer
'files-----------------------------------------------
'Const ATTR_NORMAL = 0

' Key Codes-------------------------------------------
'Const KEY_CANCEL = &H3
Global Const KEY_BACK = &H8
'Global Const KEY_TAB = &H9
'Global Const KEY_CLEAR = &HC
Global Const KEY_RETURN = &HD
'Const KEY_SHIFT = &H10
Global Const KEY_CONTROL = &H11
'Const KEY_MENU = &H12
'Const KEY_PAUSE = &H13
'Const KEY_CAPITAL = &H14
'Const KEY_ESCAPE = &H1B
Global Const KEY_SPACE = &H20
Global Const KEY_PRIOR = &H21
Global Const KEY_NEXT = &H22
'Global Const KEY_END = &H23
'Global Const KEY_HOME = &H24
Global Const KEY_LEFT = &H25
Global Const KEY_UP = &H26
Global Const KEY_RIGHT = &H27
Global Const KEY_DOWN = &H28
'Global Const KEY_INSERT = &H2D
Global Const KEY_DELETE = &H2E
'Const KEY_HELP = &H2F

' Shift parameter masks
Global Const SHIFT_MASK = 1
'Global Const CTRL_MASK = 2
'Global Const ALT_MASK = 4

' Button parameter masks------------------------------
Global Const LEFT_BUTTON = 1
Global Const RIGHT_BUTTON = 2
'Global Const MIDDLE_BUTTON = 4
'
' external functions from WINDOZE API
'
'send message to make loading of lists faster
'Const WM_USER = &H400
'Global Const LB_ADDSTRING = (&H400 + 1)
Const LB_FINDSTRING = (&H400 + 16)
Const LB_INSERTSTRING = (&H400 + 2)
Global Const LB_SETHORIZONTALEXTENT = &H400 + 21
Declare Function SendMessage Lib "User" Alias "SendMessage" (ByVal hWnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, ByVal lParam As String) As Integer


'modules
Declare Function GetModuleUsage% Lib "Kernel" (ByVal hModule%)
'win INI files
Declare Function GetProfileString Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal lpDefault$, ByVal lpReturnedString$, ByVal nSize%) As Integer
'INI files: profile strings
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName$, ByVal lpKeyName$, ByVal lpDefault$, ByVal lpReturnedString$, ByVal nSize%, ByVal lpFileName$) As Integer
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpApplicationName$, ByVal lpKeyName$, ByVal lpString$, ByVal lplFileName$) As Integer
'
'
'
'Declare Function ExitWindows Lib "User" (ByVal dwReturnCode As Long, ByVal wReserved As Integer) As Integer

Function ChooseDir (ByVal default$, Info$) As String
  '
  ' Select a directory
  ' default: default directory name
  ' info:    say what must be chosen
  ' return "" on cancel
  '
  Load GetDir
  GetDir.What = Info$
  GetDir.IsFile.Value = 0
  GetDir.Result.Caption = LCase$(default$) 'init GetDir
  ChooseRes$ = ""
  GetDir.Show 1
  DoEvents
  If Not DIRexistDir(ChooseRes$) Then ChooseRes$ = ""
  ChooseDir = ChooseRes$
  Unload GetDir
End Function

Function ChooseEntry$ (ByVal nam$, ByVal typ%, ByVal game%, ByVal What$, ByVal strict%, ByVal self%)
   '
   ' Select an entry name
   ' nam$ = default name
   ' typ = type of entry
   ' game = what game
   ' what$ = description
   ' strict = if true, then the entry must exist in list
   ' self = if >= 0, then ref of WAD, for checking
   '
   ChooseEntry = ""
   Load GetName
   GetName.What = "Select a name for a " & What$
   If strict% = True Then
     GetName.strict.Value = 1
   ElseIf strict% = 1 Then
     GetName.strict.Value = 2 'list entry type in WAD
   Else
     GetName.strict.Value = 0
   End If
   'arguments
   GetName.PSelf.Caption = self%
   GetName.Ptype.Caption = typ%
   GetName.EntryHelp.Text = nam$
   GetName.PGame.Caption = game%  'init
   ChooseRes$ = ""
   GetName.Show 1
   DoEvents
   nam$ = ChooseRes$
   ChooseEntry = UCase$(Trim$(Left$(nam$, 8)))
End Function

Function ChooseFile (ByVal default$, ByVal mask$, ByVal mustbe, ByVal Info$) As String
  '
  ' Select a file
  ' default: default file name
  ' mustbe:  is true if file must exist
  ' mask:    "*.*", "*.txt", "*.wad","*.lmp", ...
  ' info:    say what must be chosen
  ' return "" on cancel
  '
  Load GetDir
  GetDir.What = Info$
  GetDir.IsFile.Value = 1
  GetDir.Result.Caption = LCase$(default$)  'Init GetDir
  GetDir.Files.Pattern = LCase$(mask$)
  ChooseRes$ = ""
  GetDir.Show 1
  DoEvents
  ' if file must exist, and it doesn't, cancel.
  If mustbe And Not DIRexistFile(ChooseRes$) Then ChooseRes$ = ""
  'return
  ChooseFile = ChooseRes$
End Function

Function ChooseGetDefault ()
   '
   ' Get default Choose directory, used only be
   ' Get Dir form
   '
   ChooseGetDefault = ChooseDflt
End Function

Function ChooseGetRes$ ()
   '
   ' returns last result
   '
   ChooseGetRes$ = ChooseRes$
End Function

Function ChooseIdent$ (ByVal nam$, ByVal typ%, ByVal Gam%)
  '
  ' find the identity of an entry, by name and type
  '
  ChooseIdent = ""
  Dim res%
  Static buffer As String * 256
  res% = HELPforName(nam$, typ%, Gam%, buffer$, 256)
  If res% <= 0 Then Exit Function
  ChooseIdent = Left$(buffer$, res%)
End Function

Sub ChooseSetDefault (ByVal default$)
   '
   ' Set default Choose directory
   '
   If Not DIRexistDir(default$) Then Exit Sub
   ChooseDflt = default$
End Sub

Sub ChooseSetRes (ByVal file$)
   '
   ' used only to return results for Get Dir frame
   '
   ChooseRes = file$
End Sub

Sub Crash (Text$)
  MsgBox "Error:" & Chr$(10) & Text$, 16, "Error"
  DoEvents
End Sub

Sub FileCopyOk (ByVal file$, file2$)
  On Error Resume Next
  Kill file2$
  FileCopy file$, file2$
End Sub

Sub FileDeleteOk (ByVal file$)
  If Not DIRexistFile(file$) Then Exit Sub
  'Delete? OK/CANCEL
    If Not QueryOk("Delete file " & file$ & " ?") Then Exit Sub
  On Error Resume Next
  Kill file$
End Sub

Sub FileMoveOk (ByVal file$, file2$)
  On Error Resume Next
  Kill file2$
  Name file$ As file2$
End Sub

Function FileName (ByVal Path$)
  ' get complete file name
  Dim filnam  As String * 16
  Dim res%
  res = DIRsplitFile(filnam$, Path$)
  FileName = Trim$(Left$(filnam$, res%))
End Function

Function FilePath (ByVal Path$)
  ' get file path name
  Dim direc As String * 128
  Dim res%
  res% = DIRsplitDir(direc$, Path$)
  FilePath = Trim$(Left$(direc$, res%))
End Function

Function FileRoot (ByVal Path$)
  ' get root file name
  Dim root  As String * 16
  Dim res%
  res = DIRsplitRoot(root$, Path$)
  FileRoot = Trim$(Left$(root$, res%))
End Function

Sub Infos (Text$)
  MsgBox Text$, 64, "Informations"
End Sub

Sub INIedit ()
  If XternFileEdit(".txt", INIfile$) = 0 Then Exit Sub
End Sub

Function INIgetValue (ByVal section$, ByVal key$) As String
' file INIfile:
' [section]
' Key = Value
   Dim RetStr As String
   RetStr = String(255, Chr(0))
   INIgetValue = Left(RetStr, GetPrivateProfileString(section$, ByVal key$, "", RetStr, Len(RetStr), INIfile))
End Function

Sub INIinit (ByVal file$)
   INIfile = file$
End Sub

Sub INIputValue (ByVal section$, ByVal key$, ByVal Value$, ByVal warn%)
'    file INIfile:
'      [section]
'       Key = Value
' return 0 if not found.
' if warn = true, then warn the user
  Dim res As Integer
  res = WritePrivateProfileString(section$, ByVal key$, ByVal Value$, INIfile)
  If warn Then Infos ("Entry added to " & INIfile & ":" & Chr$(10) & key$ & " = " & Value$)
End Sub

Function ListFind% (ListB As Control, ByVal idx%, ByVal match$)
  'find a string in a list
  'returns index
  'returns -1 (unselect) if fail
  If idx% < -1 Then idx% = -1
  Dim res%
  res% = SendMessage(ListB.hWnd, LB_FINDSTRING, idx%, match$)
  If res% < -1 Then res% = -1
  If res% >= ListB.ListCount Then res = -1
  ListFind% = res%
End Function

Sub ListFindSelect (ListB As Control, ByVal match$)
  'find a string in a list
  'returns index
  'returns -1 (unselect) if fail
  If match$ = "" Then Exit Sub
  Dim idx%
  idx% = ListB.ListIndex
  If idx% < -1 Then idx% = -1
  idx% = SendMessage(ListB.hWnd, LB_FINDSTRING, idx%, match$)
  If idx% >= ListB.ListCount Then idx% = -1
  If idx% < 0 Then Exit Sub
  'select
  ListB.ListIndex = idx%
  ListB.Selected(idx%) = True
End Sub

Function MakeFileName (ByVal Path As String, ByVal file As String) As String
 Static out As String * 256
 Dim res%
 res = DIRmakePath(out, LCase$(Path), LCase$(file))
 MakeFileName = Left$(out, res)
End Function

Function MakeFileOld (ByVal file$)
  '
  ' add extension .OLD
  '
  Dim root$, Path$
  root$ = FileRoot(file$)
  Path$ = FilePath(file$)
  MakeFileOld = MakeFileName(Path$, root$ & ".old")
End Function

Function MakeOkName$ (ByVal file$)
 'deal with VILE strange name
 'replace the VILE[ VILE\ VILE]
 'by          VIL@A VIL@B VIL@C
 file$ = FileName(file$)
 Select Case Mid$(file, 4 + 1, 1)
   Case "["
     Mid$(file$, 4 + 1, 2) = "$"
   Case "\"
     Mid$(file$, 4 + 1, 2) = "@"
   Case "]"
     Mid$(file$, 4 + 1, 2) = "#"
 End Select
 Select Case Mid$(file, 6 + 1, 1)
   Case "["
     Mid$(file$, 6 + 1, 2) = "$"
   Case "\"
     Mid$(file$, 6 + 1, 2) = "@"
   Case "]"
     Mid$(file$, 6 + 1, 2) = "#"
 End Select
 MakeOkName = file$
End Function

Sub MakeTempDir (ByVal direc$)
  'set temp directory
  'if "", then set itself
  If direc$ = "" Then
    direc$ = INIgetValue("Directory", "Temp")
    If direc$ = "" Then direc$ = Environ$("TMP")
    If direc$ = "" Then direc$ = Environ$("TEMP")
    If direc$ = "" Then direc$ = ChooseGetDefault()
  Else
    Call INIputValue("Directory", "Temp", direc$, False)
  End If
  TempDirec$ = direc$
End Sub

Function MakeTempFile$ (file$)
  '
  ' make a temporary file name
  '
  MakeTempFile$ = MakeFileName(TempDirec$, file$)
End Function

Function QueryCancel (ByVal txt$)
  ' ask, default to cancel
  QueryCancel = False
  If MsgBox(txt$, 1 + 32 + 256, "Warning") <> 1 Then Exit Function
  QueryCancel = True
End Function

Function QueryOk (ByVal txt$)
' ask, default to ok
   QueryOk = False
   If MsgBox(txt$, 1 + 32, "Information") <> 1 Then Exit Function
   QueryOk = True
End Function

Function tutor (ByVal warn%, ByVal txt$)
' returns true if user accepts
  tutor = True
  If NoTutor Then Exit Function
  Dim res%, panel%
  Dim msg$
  panel% = 64
  msg$ = "This will " & txt$
  Select Case warn%
    Case 1
      panel% = 48  'warning
      msg$ = "Warning:" & Chr$(10) & msg$
    Case 2
      panel% = 16  'stop
      msg$ = "Be Careful:" & Chr$(10) & msg$
  End Select
  msg$ = msg$ & Chr$(10) & Chr$(10) & "(Press F1 for help, CANCEL to stop Tutorial)"
  res% = MsgBox(msg$, 3 + panel%, "Tutorial")
  DoEvents
  If res% <> 6 Then tutor = False
  If res% <> 2 Then Exit Function
  If MsgBox("Really End Tutorial? This will disable all warnings.", 4 + 32, "Tutorial") = 6 Then
    Call TutorInit(1) 'disable
    DoEvents
  End If
End Function

Sub TutorInit (ByVal level%)
  Select Case level%
   Case 0 'enquire
     NoTutor = False
     If UCase$(INIgetValue("Settings", "Tutorial")) = "OFF" Then NoTutor = True
   Case 1 ' switch
     NoTutor = Not NoTutor
     Dim no$
     no$ = "ON"
     If NoTutor Then no$ = "OFF"
     Call INIputValue("Settings", "Tutorial", no$, False)
     Call Infos("Tutorial mode " & no$)
  End Select
End Sub

