/*
  DEUTEX is Copyright (c) 1994,1995 Olivier Montanuy (montanuy@lannion.cnet.fr)

  Legal stuff:
   You can reuse any part of this copyrighted code in any freeware project you wish.
   However I request that you give me some credit for the code you reuse
   If you want to release a modified version of DeuTex, or a version included in another
   program, I request that you warn me by e-mail, because since I don't have much
   time to improve that program, I'd like to know what happens to it.
   
   You are NOT ALLOWED to make ANY commercial derivative from this code without my written
   consent (which isn't hard to get provided you play fair).
		
  Technical stuff:
   This source is released because I lack time to improve it myself.
   Many many parts could be greatly improved, and some should be entirely rewritten.
   I hope it will at least be usefull for inspiration, if nothing else.
*/

/*use old GIF encoder, new one is doing errors*/
#define NEWGIFE 0
/*use old GIF decoder, new one is down*/
#define NEWGIFD 0
/************ Important defines *************
#define DeuTex  for DOS .EXE  Unix Linux OS/2
#define DeuSF   for DOS .EXE  Unix Linux OS/2
*********************************************/

#if defined (__alpha)        /*__ALPHA__ for Alpha processor?*/
/*long = int64 on a 64bit processor*/
typedef int Int32;
typedef short Int16;
typedef unsigned int UInt32;
typedef unsigned short UInt16;
typedef char Int8;
typedef unsigned char UInt8;
#else
/*long = Int32 on a 32 bit processor*/
typedef long Int32;
typedef short Int16;
typedef unsigned long UInt32;
typedef unsigned short UInt16;
typedef char Int8;
typedef unsigned char UInt8;
#endif

#if defined DeuTex
#if defined DeuSF
/*DeuTex and DeuSF are mutualy exclusive*/
#error You cant compile DeuTex and DeuSF at the same time
#else /*compiling DeuTex*/
#define DEUTEXNAME "DeuTex"
#endif
#else /*compiling DeuSF*/
#if defined DeuSF
#define DEUTEXNAME "DeuSF"
#else /*one of DeuTex or DeuSF must be defined*/
#error Please define one of DeuTex or DeuSF (with -DDeuTex or -DDeuSF)
#endif
#endif





/* DeuTex Version*/
#define DEUTEXMAJOR 3
#define DEUTEXMINOR 8

#if defined (__MSDOS__) /*MSDOS*/
#if defined (__GNUC__)  /*MSDOS with GNU-C*/
#define huge
#else                   /*MSDOS but not GNU-C*/
#ifndef __HUGE__
#error Please Compile in HUGE memory model
#endif
#endif
#elif defined (__OS2__)
#if defined (__BORLANDC__)
#define huge
#endif
#else /*Unix*/
#define huge
#endif

/*exit,atoi,atol */
#include <stdlib.h>
/*printf, read,write,...*/
#include <stdio.h>
/*strncmp, strncpy*/
#include <string.h>







/*
** IWAD magic numbers
*/
#define IWADMAGIC     	0x5749
#define PWADMAGIC       0x5750
#define WADMAGIC	0x4441




/* use 'huge' only with MSDOS, in huge memory model */
/*MSDOS*/



#if defined (__MSDOS__)
#define FOPEN_RB	"rb"
#define FOPEN_RBP	"rb+"
#define FOPEN_WB	"wb"
#define FOPEN_RT	"rt"
#define FOPEN_WT	"wt"
#define FOPEN_AT	"at"
#define FOPEN_AB        "ab"
/*OS/2*/
#elif defined (__OS2__)
#define SEEK_SET 0
#define FOPEN_RB	"rb"
#define FOPEN_RBP	"rb+"
#define FOPEN_WB	"wb"
#define FOPEN_RT	"r"
#define FOPEN_WT	"w"
#define FOPEN_AT	"a"
#define FOPEN_AB        "a"
#else
/*UNIX*/
#define SEEK_SET 0
#define O_BINARY 0
#define FOPEN_RB	"r"
#define FOPEN_RBP	"r+"
#define FOPEN_WB	"w"
#define FOPEN_RT	"r"
#define FOPEN_WT	"w"
#define FOPEN_AT	"a"
#define FOPEN_AB        "a"
#endif



#define MEMORYCACHE  (0x8000L)
/* steps to increase size of WAD directory*/
#define MAXPWADDIR	(128)
/*Add 64000 bytes of pure junk, because of a bug in DEU5.21 */
#define MAXJUNK64	(1000)
/*special value, means int is not valid*/
#define INVALIDINT      (-6666)
/*indicate an extern WAD entry*/
#define EXTERNAL  (0x80000000L)


typedef Int16 Bool;
#define TRUE			1
#define FALSE			0




Int32  SwapInt32(Int32 l);
Int16 SwapInt16(Int16 s);
Int32 CharToInt32(char huge *ori);
Int32 CharToInt16(char huge *ori);

/*type of WAD files. correspond to 1st half of name*/
typedef Int16 WADTYPE;
#define IWAD (IWADMAGIC)
#define PWAD (PWADMAGIC)


/************ deutex.c ************/
/* Entry selection Bits*/
typedef Int16 NTRYB;
#define BLEVEL 		(0x01)
#define BLUMP		(0x02)
#define BSOUND		(0x04)
#define BTEXTUR		(0x08)
#define BGRAPHIC	(0x10)
#define BSPRITE		(0x20)
#define BPATCH		(0x40)
#define BFLAT		(0x80)
#define BMUSIC		(0x100)
#define BALL		(0x1FF)

typedef Int16 SNDTYPE;
#define SNDNONE		(0)
#define SNDAU		(1)
#define SNDWAV		(2)
#define SNDVOC		(3)
typedef Int16 IMGTYPE;
#define PICNONE		(0)
#define PICBMP		(1)
#define PICGIF		(2)
#define PICPPM		(3)
#define PICTGA		(4)
#define PICWAD		(5)






/****************** mkwad.c ********************/
/*wad directory*/
struct WADDIR           /*same as in doom*/
{ Int32 start;           /*start of entry*/
  Int32 size;            /*size of entry*/
  char name[8];        /*name of entry*/
};

struct WADINFO
{ Int32 ntry;            /*entries in dir*/
  Int32 dirpos;          /*position of dir*/
  struct WADDIR huge *dir;   /*directory */
  Int32 maxdir;		/*max nb of entry in dir*/
  Int32 wposit;		/*position for write*/
  Int32 maxpos;		/*farther referenced byte in WAD*/
  FILE *fp;	        /*file */
  Bool ok;		/*security ok&1=read ok&2=write*/
};



/********************ident.c********************/
typedef Int16 PICTYPE;
#define PGRAPH	(2)
#define	PWEAPN	(4)
#define	PSPRIT	(6)
#define	PPATCH	(8)
#define	PFLAT	(0xA)
#define	PLUMP	(0xC)

typedef Int16 ENTRY;
#define EMASK	(0xFF00)
#define EVOID	(0)
#define ELEVEL	(0x100)
#define EMAP	(0x200)/*Levels (doom1) and Maps(Doom2)*/
#define ELUMP	(0x300)
#define ETEXTUR	(0x400)
#define EPNAME	(0x500)/*textures*/
#define ESOUND	(0x600)
#define 	ESNDPC	(0x601)
#define 	ESNDWAV (0x602)
#define EGRAPHIC (0x700)
#define ESPRITE	(0x800)
#define EPATCH 	(0x900)
#define 	EPATCH1	(0x901)
#define 	EPATCH2	(0x902)
#define 	EPATCH3	(0x903)
#define EFLAT	(0xA00)
#define 	EFLAT1	(0xA01)
#define 	EFLAT2	(0xA02)
#define 	EFLAT3	(0xA03)
#define EMUSIC	(0xB00)
#define EDATA	(0x1000)
#define EZZZZ	(0x7F00)   /*unidentified entries*/




/******************* lists.c ********************/


/*deutex.c: misc*/
Bool LetsHaveFunBaby(long guesswhat);
/*compose.c: TEXTURE list*/
/*compose.c: TEXTURE insertion...rather, WAD composition*/
void CMPOmakePWAD( char *doomwad,WADTYPE type, char *PWADname,
			 char *DataDir,char *texin,NTRYB select,
			 char trnR, char trnG, char trnB,Bool George);
/*substit.c: DOOM.EXE string substitution*/
void EXE2list(FILE *out,char *doomexe,Int32 start,Int16 thres);
void EXEsubstit(char *texin,char *doomexe,Int32 start,Int16 thres);

void XTRlistDir(char *doomwad,char *wadin,NTRYB select);

void XTRvoidSpacesInWAD(char *wadin);

void XTRcompakWAD(char *DataDir,char *wadin, char *texout,Bool ShowIdx);
void XTRstructureTest(char *doomwad,char *wadin);
void XTRtextureUsed(char *wadin);
