/*
  DEUTEX is Copyright (c) 1994,1995 Olivier Montanuy (montanuy@lannion.cnet.fr)

  Legal stuff:
   You can reuse any part of this copyrighted code in any freeware project you wish.
   However I request that you give me some credit for the code you reuse
   If you want to release a modified version of DeuTex, or a version included in another
   program, I request that you warn me by e-mail, because since I don't have much
   time to improve that program, I'd like to know what happens to it.
   
   You are NOT ALLOWED to make ANY commercial derivative from this code without my written
   consent (which isn't hard to get provided you play fair).
                
  Technical stuff:
   This source is released because I lack time to improve it myself.
   Many many parts could be greatly improved, and some should be entirely rewritten.
   I hope it will at least be usefull for inspiration, if nothing else.
*/



/****MSDOS****/
#if defined (__MSDOS__)
#include <io.h>
/****OS/2****/
#elif defined (__OS2__)
#include <io.h>
#if defined (__BORLANDC__)
#else
#define filelength _filelength
#endif
/****UNIX****/
#else
#endif
#include <sys/stat.h>
#include <time.h>

#include "deutex.h"
#include "tools.h"
#include "mkwad.h"
#include "ident.h"

/*************Begin WAD module **********************
** Open PWAD file. *pcount=global byte counter
** leaves number of entries and directory pointer NULL
*/


/******************End WAD module ******************/




const WADR_READ=1;
const WADR_WRITE=2;
const WADR_RDWR=3;
const WADR_PIPO=8;



/************ begin   WAD module ***********/

void WADRopenPipo(struct WADINFO *info,Int32 ntry)
{  /*directory */
   if((info->ok&WADR_RDWR)) Bug("WadPpk");
   info->ok=WADR_PIPO;
   if(ntry<=0)             Bug("WadPpo");
   info->maxdir=ntry;
   /*more than 64k bugs DOS for no reason.*/
/*
#if defined (__MSDOS__)
	if(ntry>=0x1000) info->maxdir=0x1000;
#endif
*/
	info->dir   =(struct WADDIR huge *)Malloc((info->maxdir)*sizeof(struct WADDIR));
   info->maxpos=ntry*sizeof(struct WADDIR);
   info->ntry=0;
   info->wposit=info->maxpos;
}
struct WADDIR huge *WADRclosePipo(struct WADINFO *info,Int32 huge *ntry)
{  if((info->ok!=WADR_PIPO)) Bug("WadPpc");
   info->ok=FALSE;
   if(info->ntry<0)info->ntry=0;
   info->dir=(struct WADDIR huge *)Realloc(info->dir,(info->ntry)*sizeof(struct WADDIR));
   *ntry=info->ntry;
   return info->dir;
}
Int32 WADRdirAddPipo(struct WADINFO *info,Int32 start,Int32 size,char *entry)
{ Int16 n;
  if(info->ok!=WADR_PIPO) Bug("WadDaP");
  n=(Int16)info->ntry; /*position of new entry*/
  if(n<0) Bug("WadDa2");
  if(n<info->maxdir) /*can add to the dir*/
  { info->ntry++; /*new dir size*/
    info->dir[n].size=size;
    info->dir[n].start=start;
    Normalise(info->dir[n].name,entry);
  }
  return n; /* nb entries */
}

void WADRopenR(struct WADINFO *info,char *wadin)
{  /*directory */
   Int32 ntry,dirpos;
   Int16 n;
   struct WADDIR dir;
   if((info->ok&WADR_RDWR)) Bug("WadOpr");
   info->fp=fopen(wadin,FOPEN_RB);
   if((info->fp)==NULL)ProgError("Can't open WAD %s for reading",wadin);
   info->ok=WADR_READ;
   /*signature*/
   switch(WADRreadShort(info))
   { case PWAD: case IWAD: break;
     default:   ProgError("WAD %s has a bad header",wadin);
   }
   if(WADRreadShort(info)!=WADMAGIC)         ProgError("WAD %s has a bad header2",wadin);
   /*start of directory*/
   ntry  = WADRreadLong(info);
   if(ntry<=0)                                 ProgError("WAD %s is empty",wadin);
   if(ntry>=0x2000)                         ProgError("WAD has too many entries");
   info->dirpos= dirpos= WADRreadLong(info);
   if((dirpos<0)||(dirpos>0x10000000L))        ProgError("WAD dir references are incorrect");
   /*allocate directory*/
   info->maxdir=ntry;
   info->dir   =(struct WADDIR huge *)Malloc((info->maxdir)*sizeof(struct WADDIR));
   /*read directory, calculate further byte in wad*/
   info->maxpos=dirpos+(ntry*sizeof(struct WADDIR));
   WADRseek(info,dirpos);
   info->ntry=0;
   for(n=0;n<ntry;n++)
   { WADRreadBytes(info,(char huge *)&dir,sizeof(struct WADDIR));  /*start,size,name*/
     WADRdirAddEntry(info,BE_Int32(dir.start),BE_Int32(dir.size),dir.name);
   }
   if(info->ntry!=ntry)Bug("WadOrN");
   info->wposit=info->maxpos;
   Phase("Reading WAD %s:\t(%ld entries)\n",wadin,ntry);
}
static char signature[0x20];
void WADRopenW(struct WADINFO *info,char *wadout,WADTYPE type)
{  Phase("Creating %cWAD %s\n",(type==IWAD)?'I':'P',wadout);
   if((info->ok&WADR_RDWR)) Bug("WadOpW");

   /*check file*/
   info->fp = fopen( wadout, FOPEN_RB);
   if(info->fp!=NULL) ProgError("Won't overwrite existing file %s", wadout);
   /*open file*/
   info->fp = fopen( wadout, FOPEN_WB);
   if(info->fp==NULL)ProgError( "Can't create file %s", wadout);
   info->ok=WADR_WRITE;
   info->wposit=0;
   info->ntry  =0;
   info->maxdir=MAXPWADDIR;
   info->dir   =(struct WADDIR huge *)Malloc((info->maxdir)*sizeof(struct WADDIR));
   WADRwriteShort(info,type);   /* WAD type: PW or IW*/
   WADRwriteShort(info,WADMAGIC); /* WAD type: AD*/
   /* will be fixed when closing the WAD*/
   WADRwriteLong(info,-1);     /* no counter of dir entries */
   WADRwriteLong(info,-1);     /* no dir pointer */
   /* DeuTex notice*/
   sprintf(signature," DeuTex %1.1d.%1.1d %cOJM 94 ",DEUTEXMAJOR,DEUTEXMINOR,0xB8);
                     /********----**----**-********/
   WADRwriteBytes(info,signature,0x20-0xC);
   WADRalign4(info);
}
/*
** Assumes file already opened write
** if not, open it first
** OPEN READ-WRITE,not APPEND
** because APPEND can't FSEEK to start of file
*/
void WADRopenA(struct WADINFO *info,char *wadinout)
{  Phase("Modifying WAD %s\n",wadinout);
   if((info->ok&WADR_WRITE)) Bug("WadOpA");
   if(!(info->ok&WADR_READ))
   { WADRopenR(info,wadinout);
   }
   /*reopen for append*/
   fclose(info->fp);
   info->fp = fopen( wadinout, FOPEN_RBP); /*rb+ = read/write binary*/
   if(info->fp==NULL)ProgError( "Can't append to file %s", wadinout);
   info->ok = WADR_RDWR;
   WADRseek(info,info->wposit);
}



/***************** Directory ***************/
/*
** Add a new entry in the directory
** increase ntry, redim dir
** update maxdir and maxpos
** returns entry ref
*/
Int32 WADRdirAddEntry(struct WADINFO *info,Int32 start,Int32 size,char *entry)
{ Int16 n;
  Int32 sz;
  if(!(info->ok&(WADR_RDWR))) Bug("WadDAE");
  n=(Int16)info->ntry; /*position of new entry*/
  if(n>=info->maxdir) /*shall we move the dir?*/
  { info->maxdir+=MAXPWADDIR;
    info->dir=(struct WADDIR huge *)Realloc((char huge *)info->dir,(info->maxdir)*sizeof(struct WADDIR));
  }
  info->ntry++; /*new dir size*/
  info->dir[n].size=size;
  info->dir[n].start=start;
  Normalise(info->dir[n].name,entry);
  sz=start+size;
  if(sz>info->maxpos)
    info->maxpos=sz;
  return n; /* nb entries */
}
/*
** write the directory (names, counts, lengths)
** then update the number of  entries and dir pointer
*/
void WADRwriteDir(struct WADINFO *info)
{  Int16 n;
   struct WADDIR dir;
   if(!(info->ok&WADR_WRITE)) Bug("WadWD");
   WADRalign4(info);      /*align entry on Int32 word*/
   info->dirpos=info->wposit; /*current position*/
   /* write the new WAD directory*/
   for(n=0;n<info->ntry;n++)
   {  dir.start=BE_Int32(info->dir[n].start);
      dir.size=BE_Int32(info->dir[n].size);
      Normalise(dir.name,info->dir[n].name);
      WADRwriteBytes(info,(char huge *)&dir,sizeof(struct WADDIR));
   }
   /* fix up the directory start information */
   WADRsetDirRef(info,info->ntry,info->dirpos);
   n=(Int16)( info->dirpos+(sizeof(struct WADDIR)*info->ntry));
   if(n>info->maxpos) info->maxpos=n;
   Phase("WAD is complete: size %ld bytes.\n",info->wposit);
}

/***************** Wad structure *******************/

void WADRsetDirRef(struct WADINFO *info,Int32 ntry,Int32 dirpos)
{  struct { Int32 ntry;Int32 dirpos;} Head;
   if(!(info->ok&WADR_WRITE))Bug("WadSDR");
   Head.ntry=BE_Int32(ntry);
   Head.dirpos=BE_Int32(dirpos);
   WADRseek(info,4);
   if(fwrite(&Head,sizeof(Head),1,info->fp)!=1)
   { Warning("That WAD might not be usable anymore!");
     Warning("Restore bytes 4 to 11 manually if you can.");
     ProgError("Failed writing WAD directory References");
   }
   WADRseek(info,info->wposit);
   info->ntry=ntry;
   info->dirpos=dirpos;
}
void WADRchsize(struct WADINFO *info,Int32 fsize)
{ if(!(info->ok&WADR_WRITE)) Bug("WadcSz");
  if(Chsize(fileno(info->fp),fsize)!=0)
	 ProgError("Can't change size of WAD.");
  info->maxpos=fsize;
  info->wposit=fsize;
}
#if 0
Bool WADRchsize2(struct WADINFO *info,Int32 fsize)
{ if(!(info->ok&WADR_WRITE)) Bug("WadcSz");
  if(Chsize(fileno(info->fp),fsize)!=0) return FALSE;
  return TRUE;
}
#endif


/****************Read********************/



void WADRseek(struct WADINFO *info,Int32 position)
{  if(!(info->ok&WADR_RDWR)) Bug("WadSk");
	if(position>info->maxpos) Bug("WadSk>");
	if(fseek(info->fp,position,SEEK_SET))
					 ProgError("Can't seek in WAD");
}
Int32 WADRreadBytes(struct WADINFO *info,char huge *buffer,Int32 nb)
{  Int32 rsize,sz=0;
	if(!(info->ok&WADR_READ)) Bug("WadRdB");
	if(nb<=0) Bug("WadRd<");
	for(rsize=0;rsize<nb;rsize+=sz)
	{ sz=(nb-rsize>MEMORYCACHE)? MEMORYCACHE:nb-rsize;
	  if(fread((buffer+(rsize)),(size_t)sz,1,info->fp)!=1)ProgError("Can't read WAD");
	}
	return nb;
}
Int16  WADRreadShort(struct WADINFO *info)
{  Int16 res=0;
	if(!(info->ok&WADR_READ)) Bug("WadRdS");
	if(fread(&res,sizeof(Int16),1,info->fp)!=1)ProgError("Can't read WAD");
	return BE_Int16(res);
}
Int32 WADRreadLong(struct WADINFO *info)
{  Int32 res=0;
	if(!(info->ok&WADR_READ)) Bug("WadRdL");
	if(fread(&res,sizeof(Int32),1,info->fp)!=1)ProgError("Can't read WAD");
	return BE_Int32(res);
}
void  WADRclose(struct WADINFO *info)
{  if(!(info->ok&WADR_RDWR)) Bug("WadClo");
	info->ok=FALSE;
	Free(info->dir);
	fclose(info->fp);
}
Int16 WADRfindEntry(struct WADINFO *info,char *entry)
{ Int16 i;
  static char name[8];
  struct WADDIR huge *dir;
  if(!(info->ok&WADR_RDWR)) Bug("WadFE");
  for(i=0,dir=info->dir;i<info->ntry;i++,dir+=1)
  { Normalise(name,dir->name);
	 if(strncmp(name,entry,8)==0)
		  return i;
  }
  return -1;
}
/*
** load data in buffer
*/
char huge *WADRreadEntry(struct WADINFO *info,Int16 n,Int32 *psize)
{ char huge *buffer;
  Int32 start,size;
  if(!(info->ok&WADR_READ)) Bug("WadRE");
  if(n>=(info->ntry))Bug("WadRE>");
  start = info->dir[n].start;
  size  = info->dir[n].size;
  buffer=(char huge *)Malloc(size);
  WADRseek(info,start);
  WADRreadBytes(info,buffer,size);
  *psize=size;
  return buffer;
}
#if defined DeuTex
/*
**  copy data from WAD to file
*/
void WADRsaveEntry(struct WADINFO *info,Int16 n, char *file)
{  Int32 wsize,sz=0;
	char huge *buffer;
	Int32 start,size;
	FILE *fp;
	if(!(info->ok&WADR_READ)) Bug("WadSE");
	if(n>=(info->ntry))Bug("WadSE>");
	start = info->dir[n].start;
	size  = info->dir[n].size;
	fp=fopen(file,FOPEN_WB);
	if(fp==NULL) ProgError("Can't open file %s",file);
	buffer = (char huge *)Malloc( MEMORYCACHE);
	WADRseek(info,start);
	for(wsize=0; wsize<size ;wsize+=sz)
	{  sz= (size-wsize>MEMORYCACHE)? MEMORYCACHE : size-wsize;
		WADRreadBytes(info,buffer,sz);
		if(fwrite(buffer,(size_t)sz,1,fp)!=1)
		{ Free(buffer);
		  ProgError("Can't write file %s",file);
		}
	}    /*declare in WAD directory*/
	Free( buffer);
	fclose(fp);
}
#endif /*DeuTex*/

/******************** Write ************************/

void WADRsetLong(struct WADINFO *info,Int32 pos,Int32 val)
{ Int32 v=BE_Int32(val);
  if(!(info->ok&WADR_WRITE)) Bug("WadStL");
  if(pos>(info->maxpos)) Bug("WadSL>");
  if(fseek(info->fp, pos, SEEK_SET)) ProgError( "Can't seek in WAD");
  if(fwrite(&v,sizeof(Int32),1,info->fp)!=1)  ProgError( "Can't write in WAD");
}
void WADRsetShort(struct WADINFO *info,Int32 pos,Int16 val)
{ Int32 v=BE_Int16(val);
  if(!(info->ok&WADR_WRITE)) Bug("WadStS");
  if(pos>(info->maxpos)) Bug("WadSS>");
  if(fseek(info->fp, pos, SEEK_SET)) ProgError( "Can't seek in WAD");
  if(fwrite(&v,sizeof(Int16),1,info->fp)!=1)  ProgError( "Can't write in WAD");
}
/*
** internal functions
**
*/
static void WADRcheckWritePos(struct WADINFO *info)
{ if(!(info->ok&WADR_WRITE)) Bug("WadCkW");
  if (fseek( info->fp, info->wposit, SEEK_SET)) ProgError( "Can't seek in WAD");
}
static Int32 WADRwriteBlock(struct WADINFO *info,char huge *data,Int32 sz)
{ if(fwrite(data,(size_t)sz,1,info->fp) != 1)  ProgError( "WAD write failed");
  info->wposit += sz;
  if(info->maxpos<info->wposit)info->maxpos=info->wposit;
  return sz;
}

/*
** align, give position
*/
void WADRalign4(struct WADINFO *info)
{ Int16 remain;
  static char buffer[] ={0,0x24,0x6,0x68};
  WADRcheckWritePos(info);
  remain = (Int16)(info->wposit&0x03);   /*0 to 3*/
  if(remain>0) WADRwriteBytes(info,buffer,4-remain);
}
/*must be equal to ftell*/
Int32 WADRposition(struct WADINFO *info)
{ WADRcheckWritePos(info);
  return info->wposit;
}
/*
** write
*/
Int32 WADRwriteLong(struct WADINFO *info,Int32 val)
{ Int32 v=BE_Int32(val);
  WADRcheckWritePos(info);
  return WADRwriteBlock(info,(char huge *)&v,sizeof(Int32));
}
Int32 WADRwriteShort(struct WADINFO *info,Int16 val)
{ Int16 v=BE_Int16(val);
  WADRcheckWritePos(info);
  return WADRwriteBlock(info,(char huge *)&v,sizeof(Int16));
}

Int32 WADRwriteBytes(struct WADINFO *info,char huge *data,Int32 size)
{ Int32 wsize,sz=0;
  WADRcheckWritePos(info);
  if(size<=0) Bug("WadWb<");
  for(wsize=0;wsize<size;)
  { sz=(size-wsize>MEMORYCACHE)? MEMORYCACHE : size-wsize;
	 wsize+=WADRwriteBlock(info,&data[wsize],sz);
  }
  return wsize;
}

static Int32 WADRwriteBlock2(struct WADINFO *info,char huge *data,Int32 sz)
{ if(fwrite(data,(size_t)sz,1,info->fp) != 1)return -1;
  info->wposit += sz;
  if(info->maxpos<info->wposit)info->maxpos=info->wposit;
  return sz;
}
Int32 WADRwriteBytes2(struct WADINFO *info,char huge *data,Int32 size)
{ Int32 wsize,sz=0;
  WADRcheckWritePos(info);
  if(size<=0) Bug("WadWb<");
  for(wsize=0;wsize<size;)
  { sz=(size-wsize>MEMORYCACHE)? MEMORYCACHE : size-wsize;
	 sz=WADRwriteBlock2(info,&data[wsize],sz);
    if(sz<0) return -1;
	 wsize+=sz;
  }
  return wsize;
}
/*
**  copy data from SOURCE WAD to WAD
*/
Int32 WADRwriteWADbytes(struct WADINFO *info,struct WADINFO *src,Int32 start,Int32 size)
{  Int32 wsize,sz=0;
   char huge *data;
   data = (char huge *)Malloc( MEMORYCACHE);
   WADRseek(src,start);
   WADRcheckWritePos(info);
   for(wsize=0; wsize<size;)
   {  sz= (size-wsize>MEMORYCACHE)? MEMORYCACHE : size-wsize;
      WADRreadBytes(src,data,sz);
      wsize+=WADRwriteBlock(info,data,sz);
   }    /*declare in WAD directory*/
   Free( data);
   return wsize;
}



#if defined DeuTex
/*
** copy lump from file into WAD
** returns size
*/
Int32 WADRwriteLump(struct WADINFO *info,char *file)
{  Int32      size,sz=0;
   FILE      *fp;
   char huge *data;
   WADRcheckWritePos(info);
   /*Look for entry in master directory */
   fp=fopen(file,FOPEN_RB);
   if(fp==NULL) ProgError("Can't read file %s",file);
   data = (char huge *)Malloc( MEMORYCACHE);
   for(size=0;;)
   { sz = fread(data,1,(size_t)MEMORYCACHE,fp);
     if(sz<=0)break;
     size+=WADRwriteBlock(info,data,sz);
   }
   Free( data);
   fclose(fp);
   return size;
}
Int32 WADRwriteWADentry(struct WADINFO *info,struct WADINFO *src,Int16 n)
{  if(n>(src->ntry)) Bug("WadWW>");
   return WADRwriteWADbytes(info,src,src->dir[n].start,src->dir[n].size);
}
/*
** copy level parts
*/
void WADRwriteWADlevelParts(struct WADINFO *info,struct WADINFO *src,Int16 N)
{ Int32 start,size;
  Int16 n,top;
  /*set level entries*/
  for(n=N+1;n<src->ntry;n++)
  { top=N+11;
    if(n>top)break;
    if(IDENTlevelPart(src->dir[n].name)<0) break;
    WADRalign4(info);
    start=WADRposition(info);
    size=WADRwriteWADentry(info,src,n);
    WADRdirAddEntry(info,start,size,src->dir[n].name);
  }
  top=N+11;
  if(n<top)Warning("Not enough entry in level");
}
/*
** copy level from WAD
** try to match level name (multi-level)
** if level name not found, then take the first level...
*/
void WADRwriteWADlevel(struct WADINFO *info,char *file,char *level)
{ Int16 N,l;
  Int32 pos;
  /*char Level[8];*/
  struct WADINFO src;
  if(IDENTlevel(level)<0)ProgError("Bad level name %s",level);
  src.ok=0;
  WADRopenR(&src,file);
  /*search for entry in level*/
  N=WADRfindEntry(&src,level);
  if(N<0) /* no? then search first level*/
  { for(N=0;;N++)
    { l=IDENTlevel(src.dir[N].name);
      if(l>=0)break;
      if(N>=src.ntry) ProgError("No level in WAD %s",file);
    }
  }
/*set level name*/
  WADRalign4(info);
  pos=WADRposition(info); /*BC++ 4.5 bug!*/
  WADRdirAddEntry(info,pos,0L,level);
  WADRwriteWADlevelParts(info,&src,N);
  WADRclose(&src);
}
#endif  /*DeuTex*/

/*
** replace dir of rwad by dir of newwad
** prepare to write at the end of rwad
** open for append
*/
Int32 WADRprepareAppend(char *wadres,struct WADINFO *rwad,
     struct WADDIR huge *NewDir,Int32 NewNtry,
     Int32 *dirpos,Int32 *ntry, Int32 *size)
{ Int32 ewadstart;
  Int32 rwadsize;
  Int32 time;
  time=GetFileTime(wadres);
  /* append to the Result WAD*/
   WADRopenA(rwad,wadres);
  /*get original size*/
#if defined (__MSDOS__)
#if defined (__GNUC__)
   rwadsize=rwad->maxpos;
#else
   rwadsize=filelength(fileno(rwad->fp));
#endif
#elif defined (__OS2__)
   rwadsize=filelength(fileno(rwad->fp));
#else
   rwadsize=rwad->maxpos;
#endif
   /*last warning*/
   Output("The WAD file %s will be modified, but it can be restored with:\n",wadres);
   Output("%s -res %s\n",DEUTEXNAME,wadres);
   Output("Restoration may fail if you modified the WAD with another tool.\n");
   Output("In case of failure, you can salvage your WAD by:\n");
   Output("- setting bytes 4-7  to \t%08lx\n",LE_Int32(rwad->ntry));
   Output("- setting bytes 8-11 to \t%08lx\n",LE_Int32(rwad->dirpos));
   Output("If possible, set the file size to %ld bytes.\n",rwadsize);
   /*align*/
   ewadstart=((rwadsize+0xF)&(~0xFL));
   if((ewadstart|rwadsize)&EXTERNAL) ProgError("Too big WADs");
   *dirpos=rwad->dirpos;
   *ntry=rwad->ntry;
   *size=rwadsize;
   /*Change size*/
   WADRchsize(rwad,ewadstart);
   /*Write will start at file end*/
   rwad->maxpos=ewadstart;
   rwad->wposit=ewadstart;
   WADRseek(rwad,ewadstart);
   /*Change to New directory*/
   Free(rwad->dir);
   rwad->dir=NewDir;
   rwad->ntry=NewNtry;
   rwad->maxdir=NewNtry;
   rwad->dirpos=-1;
   return time;
}
