/*
   Doom Editor Utility, by Brendon Wyber and Rapha\211l Quinet.

   You are allowed to use any parts of this code in another program, as
   long as you give credits to the authors in the documentation and in
   the program itself.  Read the file README.1ST for more information.

   This program comes with absolutely no warranty.

   DEU-LINUX.H - Some Linux-specific things.

   Originally written by Per Allansson (c91peral@und.ida.liu.se)

   Adapted from DEU-GO32.H by Brad Hawthorne (u9c192@ugrad.cs.ubc.ca)
*/



#if defined(__GNUC__)


#include <unistd.h>
#include "lnxfuncs.h"

#define huge          /* No huge things in gcc */
                      /* Should be done in another way, but ... */


#ifdef __cplusplus
extern "C" {
#endif
extern int getch(void);
extern void delay(unsigned);
#ifdef __cplusplus
}
#endif


#ifndef max
#define max(x,y)   (((x)>(y))?(x):(y))
#define min(x,y)   (((x)<(y))?(x):(y))
#endif

#define farcoreleft() 0         /* remaining memory - not an easy figure in Linux */


#define FreeSomeMemory()
#define ObjectsNeeded(x,y...)   /* GNU CPP ONLY !!! :-) */
#define InitSwap()

#define GetMemory(x)         malloc(x)
#define FreeMemory(x)        free(x)
#define ResizeMemory(x,y)    realloc(x,y)
#define GetFarMemory(x)      malloc(x)
#define FreeFarMemory(x)     free(x)
#define ResizeFarMemory(x,y) realloc(x,y)

#endif  /* __GNUC__   */

#define stricmp(x,y)         strcasecmp(x,y)
#define strnicmp(x,y,n)      strncasecmp(x,y,n)
