/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 D_CONFIG.H

*/

#ifndef _D_CONFIG_H_
#define _D_CONFIG_H_

extern struct _Config
{
  Bool   verbose;          /* verbose output when options are changed, etc. */
  Bool   debug;            /* are we debugging? */
  Bool   gDebug;           /* is graphical debugging enabled? */
  char  *cfgFile;          /* name of the configuration file */
  Bool   reminder;         /* display a funny message when DEU starts */

  char  *mainWad;          /* name of the main wad file */
  char **patchWads;        /* list of patch wad files */
  char  *wadDir;           /* default directory for WAD files */
  char  *libDir;           /* default directory for library of shapes */

  char  *BGIDriver;        /* default extended BGI driver */
  Int16  videoMode;        /* default video mode for VESA/SuperVGA */
  Int16  gamma;            /* gamma correction for Doom palette (256 colors) */
  Bool   forceWhite;       /* force color #15 to be white (for mouse pointer) */
  Bool   fakeCursor;       /* use a "fake" mouse cursor */
  Bool   CirrusCursor;     /* use hardware cursor on Cirrus Logic VGA cards */

  Bool   swapButtons;      /* swap right and middle mouse buttons */
  Int16  mouseRepeatDelay; /* millisecond delay before mouse repeat */
  Int16  mouseRepeatRate;  /* times per second of mouse repeat */

  Bool   quiet;            /* don't play a sound when an object is selected */
  Bool   quieter;          /* don't play any sound, even when an error occurs */
  Bool   expert;           /* don't ask for confirmation for some operations */
  Bool   undo;             /* save the undo info in a buffer */

  Int16  initialScale;     /* initial zoom factor for map */
  Bool   colour2;          /* use the alternate set for things colors */
  Bool   infoShown;        /* should we display the info bar? */
  Bool   additiveSelBox;   /* additive selection box or select in box only? */
  Bool   select0;          /* select object 0 by default when switching modes */
  Bool   moveThings;       /* when a Sector is moved, move Things too? */

  char  *wallTexture;      /* default normal wall texture */
  char  *upperTexture;     /* default upper wall texture */
  char  *lowerTexture;     /* default lower wall texture */
  char  *doorFaceTexture;  /* default door face texture (upper) */
  char  *doorTrakTexture;  /* default door track texture (normal) */
  char  *liftFaceTexture;  /* default lift face texture (lower) */
  char  *switchTexture;    /* default switch texture (normal) */
  char  *stepFaceTexture;  /* default step face texture (lower) */
  char  *floorTexture;     /* default floor texture */
  char  *ceilingTexture;   /* default ceiling texture */
  Int16  floorHeight;      /* default floor height */
  Int16  ceilingHeight;    /* default ceiling height */
  Int16  lightLevel;       /* default light level */

  char  *autoEdit;         /* start the editor on this entry */
  Bool   autoQuit;         /* quit after editing (only if autoEdit != NULL) */
  Bool   autoRandom;       /* run the randomiser, then exit the editor */

  Bool   printBestFit;     /* choose the best orientation to fit paper */
  Bool   printPortrait;    /* print in Portrait or Landscape mode */
  Bool   printGraySecrets; /* print the secret doors (LineDefs) in gray */
  Bool   printThickImpass; /* thicker impassable lines */
  Bool   printThings;      /* print the Things too? */

  Bool   RebuildNodes;     /* Rebuild nodes when saving */
  Bool   RebuildReject;    /* Rebuild REJECT when saving */
  Bool   RebuildBlockmap;  /* Rebuild BLOCKMAP when saving */
  Int16  BSP_splitfactor;  /* BSP split factor (0-100) */
  Int16  BSP_slopefactor;  /* BSP slope factor (0-100) */
  Int16  BSP_speedfactor;  /* BSP speed factor (0-100) */
  Int16  RejectOption;     /* Reject builder option 0: Normal
                                                    1: Peaceful monsters
                                                    2: Fake      */
} Config;

/*RP Copied from B_SAVE.H */
#define REBUILD_NODES_DEF    TRUE
#define REBUILD_REJECT_DEF   TRUE
#define REBUILD_BLOCKMAP_DEF TRUE

#define SPLITFACTOR_DEF 8    /* default and boundary values */
#define SPLITFACTOR_MIN 0
#define SPLITFACTOR_MAX 100
#define SLOPEFACTOR_DEF 1
#define SLOPEFACTOR_MIN 0
#define SLOPEFACTOR_MAX 100
#define SPEEDFACTOR_DEF 100
#define SPEEDFACTOR_MIN 0
#define SPEEDFACTOR_MAX 100

/*RP Defines for the Reject Option */
#define REJECT_NORMAL   0
#define REJECT_PEACEFUL 1
#define REJECT_FAKE     2

#define REJECT_OPTION_DEF  REJECT_NORMAL

/* prototypes */
void  InitDefaultOptions(int argc, char *argv[]);
void  ChangeOption(char *option, char *value);
void  ParseCommandLineOptions(int argc, char *argv[]);
void  ParseConfigFileOptions(char *filename);
char *GetOptionValue(char *option);
void  PrintOptionValues(FILE *file);
Bool  SaveConfigFileOption(char *filename, char *option);

#endif /* _D_CONFIG_H_ */
/* end of file */
