/* F_SOUND.H */

#ifndef _F_SOUND_H_
#define _F_SOUND_H_

UInt32 WadToAU (FILE *aufile, FILE *wadfile);
UInt32 WadToWav(FILE *wavfile, FILE *wadfile);
UInt32 WadToVoc(FILE *vocfile, FILE *wadfile);

UInt32 AUToWad (FILE *wadfile, FILE *aufile);
UInt32 WavToWad(FILE *wadfile, FILE *wavfile);
UInt32 VocToWad(FILE *wadfile, FILE *vocfile);


UInt8 far * ReadAU(FILE *aufile, Int32 *size, Int32 *speed);
void WriteAU(FILE *aufile, Int32 size, Int32 speed, UInt8 far *raw);


UInt8 far * ReadVOC(FILE *vocfile, Int32 *size, Int32 *speed);
void WriteVOC(FILE *vocfile, Int32 size, Int32 speed, UInt8 far *raw);


UInt8 far * ReadWAV(FILE *wavfile, Int32 *size, Int32 *speed);
void WriteWAV(FILE *wavfile, Int32 size, Int32 speed, UInt8 far *raw);


void SaveEntryFromWavFile(FILE *file, FILE *raw, char *entryname);
void SaveEntryFromVocFile(FILE *file, FILE *raw, char *entryname);
void SaveEntryToWavFile(FILE *file, char *entryname);
void SaveEntryToVocFile(FILE *file, char *entryname);





#endif
