/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 G_GFX.H

*/

#ifndef _G_GFX_H_
#define _G_GFX_H_

/* constants for special PC key codes */
#include "g_pckeys.h"

/* constants */
/* color names */
#ifndef LIGHTMAGENTA
#define BLACK         0
#define BLUE          1
#define GREEN         2
#define CYAN          3
#define RED           4
#define MAGENTA       5
#define BROWN         6
#define LIGHTGRAY     7
#define DARKGRAY      8
#define LIGHTBLUE     9
#define LIGHTGREEN   10
#define LIGHTCYAN    11
#define LIGHTRED     12
#define LIGHTMAGENTA 13
#define YELLOW       14
#define WHITE        15
#endif

/* height and width of a text character (fixed font) */
#define TEXT_H       ((Int16) 10)
#define TEXT_W       ((Int16)  8)

/* line drawing modes */
#define DRAW_NORMAL  1301
#define DRAW_XOR     1970

/* line patterns */
#define SOLID_PATTERN  71
#define DOTTED_PATTERN 33
#define DASHED_PATTERN 93


/* global variables */
extern Int16  OrigX;         /* the X origin */
extern Int16  OrigY;         /* the Y origin */
extern float  Scale;         /* the scale value */
extern UInt16 PointerX;      /* X position of pointer */
extern UInt16 PointerY;      /* Y position of pointer */
extern UInt16 ScrMaxX;       /* maximum X screen coord */
extern UInt16 ScrMaxY;       /* maximum Y screen coord */
extern UInt16 ScrCenterX;    /* X coord of screen center */
extern UInt16 ScrCenterY;    /* Y coord of screen center */

/* prototypes */
void InitGfx(void);
void TermGfx(void);
Bool InGfxMode(void);
void ClearScreen(void);

void SetLineDrawingMode(int mode);
void SetLinePatternAndWidth(int pattern, int width);

void DrawMapLine(Int16 mapXstart, Int16 mapYstart, Int16 mapXend, Int16 mapYend);
void DrawMapCircle(Int16 mapXcenter, Int16 mapYcenter, Int16 mapRadius);
void DrawMapVector(Int16 mapXstart, Int16 mapYstart, Int16 mapXend, Int16 mapYend);
void DrawMapArrow(Int16 mapXstart, Int16 mapYstart, UInt16 angle);
void DrawScreenPixel(Int16 X, Int16 Y);
void DrawScreenLine(Int16 Xstart, Int16 Ystart, Int16 Xend, Int16 Yend);
void DrawScreenRectangle(Int16 Xstart, Int16 Ystart, Int16 Xend, Int16 Yend);
void DrawScreenBox(Int16 Xstart, Int16 Ystart, Int16 Xend, Int16 Yend);
void DrawScreenBox3D(Int16 Xstart, Int16 Ystart, Int16 Xend, Int16 Yend);
void DrawScreenBoxSunken(Int16 Xstart, Int16 Ystart, Int16 Xend, Int16 Yend);
void DrawScreenBoxHollow(Int16 Xstart, Int16 Ystart, Int16 Xend, Int16 Yend);
void DrawScreenMeter(Int16 Xstart, Int16 Ystart, Int16 Xend, Int16 Yend, float value);
void DrawScreenText(Int16 Xstart, Int16 Ystart, char *msg, ...);
void DrawScreenBitmap(Int16 Xstart, Int16 Ystart, Int16 Xend, Int16 Yend, UInt8 far *data);

void DrawPointer(Bool rulers);

void SetDoomPalette(int playpalnum);
void SetColor(int color16);
void SetDoomColor(int color256);

UInt16 WaitForKey(void);
Bool   IsKeyPressed(void);
UInt16 GetAltKeys(void);

#endif /* _G_GFX_H_ */
/* end of file */
