/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 G_MOUSGI.C - Mouse driver for SGI (GL)

 Most functions written by Pete Wyckoff
*/

/* the includes */
#include "deu.h"
#include "g_gfx.h"
#include <gl/gl.h>
#include <gl/device.h>
#include "g_mouse.h"

/* the global data */
Bool UseMouse = FALSE;                  /* is there a mouse driver? */
long x_origin, y_origin;                /* coords of origin */

static unsigned short crosshairs[16] = {  /* 16x16, each entry is a line */
   0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0xfffe,
   0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0000,
};


/*
   Initialize the mouse driver.
*/

void InitMouseDriver(void)
{
  /* cursor */
  curstype(C16X1);
  defcursor(1, crosshairs);
  curorigin(1, 7, 7);
  setcursor(1, 0, 0);
  drawmode(CURSORDRAW);
  mapcolor(1, 159, 0, 155);  /* magenta */
  drawmode(NORMALDRAW);

  getorigin(&x_origin, &y_origin);
  UseMouse = TRUE;
}



/*
   Show the pointer.
*/

void ShowMousePointer(void)
{
  qdevice(MOUSEX);
  qdevice(MOUSEY);
}



/*
   Hide the pointer.
*/

void HideMousePointer(void)
{
  unqdevice(MOUSEX);
  unqdevice(MOUSEY);
  qreset();  /* flush anything else out */
}


/*
   Read pointer coordinates.
*/

void GetMouseCoords(UInt16 *x, UInt16 *y, UInt16 *buttons)
{
  Int16 ix, iy;

  ix = (Int16)(getvaluator(MOUSEX) - x_origin);
  /* invert to PC screen */
  iy = (YSIZE - (Int16)(getvaluator(MOUSEY) - y_origin));
  *x = (UInt16) (ix < 0 ? 0 : ix);
  *y = (UInt16) (iy < 0 ? 0 : iy);
  /* left == 1, right == 2, middle == 4 */
  *buttons = (getbutton(LEFTMOUSE) | (getbutton(RIGHTMOUSE) << 1)
    | (getbutton(MIDDLEMOUSE) << 2));
}


/*
   Change pointer coordinates.
*/

void SetMouseCoords(UInt16 x, UInt16 y)
{
  setvaluator(MOUSEX, (Int16)x + x_origin, 0, getgdesc(GD_XPMAX) - 1);
  setvaluator(MOUSEY, (YSIZE - (Int16)y) + y_origin, 0, getgdesc(GD_YPMAX) - 1);
}



/*
   Set horizontal and vertical limits (constrain pointer in a box).
*/
/*ARGSUSED*/
void SetMouseLimits(UInt16 x0, UInt16 y0, UInt16 x1, UInt16 y1)
{
  /* ignored */
}



/*
   Reset horizontal and vertical limits.
*/

void ResetMouseLimits(void)
{
   /* ignored */
}


/* end of file */
