/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 M_MAPDRW.H

*/

#ifndef _M_MAPDRW_H_
#define _M_MAPDRW_H_

#include "w_levels.h"

/* half the size of an object (Thing or Vertex) in map coords */
#define OBJSIZE   7

void DisplayHelp(int objtype, Int16 grid);
void DisplayPointerCoords(void);
void HighlightObject(LevelPtr level, int objtype, Int16 objnum, Int16 color);
void DrawMap(LevelPtr level, int editmode, Int16 grid, Bool drawgrid, int thingmask);
void GoToObject(LevelPtr level, int objtype, int objnum);

#endif /* _M_MAPDRW_H_ */
/* end of file */
