// Include File for DoomEd 4.0
//
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include <windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include <mmsystem.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>
#include <ctl3d.h>
#include <toolhelp.h>

#include "resource.h"
#include "structur.hpp"
#include "globals.hpp"
// prototypes and macros #include'd at the end of this file

#pragma function ( memcpy, _fmemcpy, memset, _fmemset)

// Defines:
// window titles:
#define ProgName        "DoomEd40"
#define ProgErr         "DoomEd40 Error"
#define IniFile         "DoomEd40.Ini"
#define HelpFile        "DoomEd40.Hlp"
// limits:
#define MAXINT          32767
#define MININT         -32767
// map line definitions:
#define ML_BLOCKING         1
#define ML_BLOCKMONSTERS    2
#define ML_TWOSIDED         4
#define ML_DONTPEGTOP       8
#define ML_DONTPEGBOTTOM    16
#define ML_SECRET           32
#define ML_SOUNDBLOCK       64
#define ML_DONTDRAW         128
#define ML_MAPPED           256
// sector connections:
#define S_FLUSH         1       // heights are the same
#define S_RAISED        2       // second is higher
#define S_LOWERED       3       // second is lower
// paradigms:
#define P_SECTOR        1       // standard DoomEd mode
#define P_LINE          2       // Id style
#define P_VERTEX        3       // Deu style
#define P_AUTO          4       // Determine from usage
// file types:
#define FT_ID           1       // Id's Doom.Wad file
#define FT_PROJECT      2       // DoomEd project file
#define FT_MAP          3       // DoomEd single map file
#define FT_PATCH        4       // playable patch wad
// clipboard data formats:
#define CB_MAP          1       // map information
#define CB_BITMAP       2       // picture
#define CB_OTHER        3       // ??
// Header signatutes for various resources
#define BFT_ICON        0x4349  // 'IC'
#define BFT_BITMAP      0x4d42  // 'BM'
#define BFT_CURSOR      0x5450  // 'PT'
// Mouse actions:
#define MA_NORMAL       0
#define MA_ZOOMWINDOW   1
#define MA_SELWINDOW    2
#define MA_SELMULTIPLE  3
#define MA_MOVETHING    4
#define MA_MOVESECTOR   5
#define MA_MOVEVERTEX   6
#define MA_MOVELINEDEF  7
// types of data in wad files:
#define WD_ID           1       // information - null block
#define WD_THINGS       2       // map stuff
#define WD_LINEDEFS     3
#define WD_SIDEDEFS     4
#define WD_VERTEXES     5
#define WD_SEGS         6
#define WD_SSECTORS     7
#define WD_NODES        8
#define WD_SECTORS      9
#define WD_REJECT       10
#define WD_BLOCKMAP     11
#define WD_SPRITE       12      // sprite bitmap
#define WD_PANEL        13      // part of texture
#define WD_TILE         14      // floor/ceiling tile
#define WD_MUSIC        15      // MUS file - D_*
#define WD_SOUND        16      // digitised sound - DS*
#define WD_BEEP         17      // pc-speaker sound - DP*
#define WD_TEXTURE      18      // texture block
#define WD_PLAYPAL      19      // color palettes
#define WD_COLORMAP     20      // color maps
#define WD_ENDOOM       21      // end message
#define WD_DEMO         22      // a demo file
#define WD_PNAMES       23      // patch names for textures
#define WD_DRIVER       24      // like GUS, GENMIDI, etc.
#define WD_STATUS       25      // graphics for status bar
#define WD_LEVEL        26      // everything starting with WI
#define WD_MENU         27      // Menu graphics: M_*
#define WD_GRAPHIC      28      // unclassified graphic
#define WD_MAP          29      // header for a map
#define WD_TAG          30      // tag descriptions

// Which directoy we're working with:
#define DD_EXTERNAL     1       // external wad file
#define DD_INTERNAL     2       // Doom.Wad file

// return values:
#define NotFound        -9999   // for search routines
#define Nothing         -1      // for null data
#define Multiple        -2      // for multiple items in dialogs
#define FlushDialog     -3      // to write in multi-select dialogs
#define DialogClear     -4      // to clear entries in empty dialog

// Control bar settings:
#define T_THING         1       // objects
#define T_VERTEX        2       // points
#define T_LINE          3       // lines
#define T_SECTOR        4       // sectors

// Identifiers for Popup menu items:
#define POPUP_SECTOR        19001
#define POPUP_PARAMETERS    19002
#define POPUP_DEFINESTYLE   19003
#define POPUP_STYLES        19004
#define POPUP_RECTANGLE     19005
#define POPUP_POLYGON       19006
#define POPUP_TITLE         19007
#define POPUP_SHAPE_STAR    19008
#define POPUP_SHAPE_CROSS   19009
#define POPUP_SHAPE_SWAST   19010
#define POPUP_CANCEL        19011
#define POPUP_MAKEDOOR      19012
#define POPUP_ROTATE        19013
#define POPUP_SCALE         19014
#define POPUP_ROTATESCALE   19015
#define POPUP_STEPS         19016
#define POPUP_DUPLICATE     19017
#define POPUP_STYLE00       19100
#define POPUP_STYLE01       19101
#define POPUP_STYLE02       19102
#define POPUP_STYLE03       19103
#define POPUP_STYLE04       19104
#define POPUP_STYLE05       19105
#define POPUP_STYLE06       19106
#define POPUP_STYLE07       19107
#define POPUP_STYLE08       19108
#define POPUP_STYLE09       19109
#define POPUP_STYLE10       19110
#define POPUP_STYLE11       19111
#define POPUP_STYLE12       19112
#define POPUP_STYLE13       19113
#define POPUP_STYLE14       19114
#define POPUP_STYLE15       19115
#define POPUP_STYLE16       19116
#define POPUP_STYLE17       19117
#define POPUP_STYLE18       19118
#define POPUP_STYLE19       19119
#define POPUP_STYLE20       19120
#define POPUP_STYLE21       19121
#define POPUP_STYLE22       19122
#define POPUP_STYLE23       19123
#define POPUP_STYLE24       19124
#define POPUP_STYLE25       19125
#define POPUP_STYLE26       19126
#define POPUP_STYLE27       19127
#define POPUP_STYLE28       19128
#define POPUP_STYLE29       19129
#define POPUP_STYLE30       19130
#define POPUP_STYLE31       19131

// previously loaded files:
#define ID_FILE_FILE1       18500
#define ID_FILE_FILE2       18501
#define ID_FILE_FILE3       18502
#define ID_FILE_FILE4       18503
// owner draw buttons:
#define IDC_CB_CONTENTS     17050
#define IDC_CB_OPEN         17051
#define IDC_CB_SAVE         17052
#define IDC_CB_NEW          17053
#define IDC_CB_THINGS       17054
#define IDC_CB_LINEDEFS     17055
#define IDC_CB_SECTORS      17056
#define IDC_CB_VERTEXES     17057
#define IDC_CB_ZOOMPREV     17058
#define IDC_CB_ZOOMALL      17059
#define IDC_CB_ZOOMWIN      17060

// Map Save options:
#define REJECT_QUICK        1
#define REJECT_FULL         2
#define NODE_NONE           1
#define NODE_INTERNAL       2
#define NODE_EXTERNAL       3
#define NODE_IDBSP          4

// common function types (continued from windows.h):
#define DIALOG          _far _pascal
#define EXPORT          _export _far _pascal

// Our own Windows Messages:
#define DOOMED_HIDE_THING       WM_USER + 66    // for modeless hiding
#define DOOMED_HIDE_SECTOR      WM_USER + 67
#define DOOMED_HIDE_LINEDEF     WM_USER + 68
#define DOOMED_SHOW_THING       WM_USER + 69    // doubt we'll need these six:
#define DOOMED_SHOW_SECTOR      WM_USER + 70
#define DOOMED_SHOW_LINEDEF     WM_USER + 71
#define DOOMED_SHOW_THINGS      WM_USER + 72
#define DOOMED_SHOW_SECTORS     WM_USER + 73
#define DOOMED_SHOW_LINEDEFS    WM_USER + 74
#define DOOMED_ZOOM_IN          WM_USER + 75    // for keyboarding
#define DOOMED_ZOOM_OUT         WM_USER + 76
#define DOOMED_FORCE_UP         WM_USER + 77    // when mouse leaves visible area
#define DOOMED_FORCE_DOWN       WM_USER + 78
#define DOOMED_FORCE_LEFT       WM_USER + 79
#define DOOMED_FORCE_RIGHT      WM_USER + 80
#define DOOMED_SHOW_PROBLEMS    WM_USER + 81
#define DOOMED_HIDE_PROBLEMS    WM_USER + 82

// for values in Move arrays:
#define ADDED                   2               // still logically true...


/////////////////////////////////////////////////////////////////
// Macros:
#include "macros.hpp"

/////////////////////////////////////////////////////////////////
// Function Prototypes:
#include "prototyp.hpp"


