// Add Item Dialog for DoomEd 4.0
// Add and remove vertex, thing, line, side, sector
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"


void DoWhatToAdd(void)
{
  FARPROC lpfnDlgProc;
  lpfnDlgProc = MakeProcInstance((FARPROC)DialogItemAdd, hinst);
  if(lpfnDlgProc) {
    DialogBox(hinst,
              MAKEINTRESOURCE(IDD_ITEMADD),
              hwnd,
              lpfnDlgProc);
    FreeProcInstance(lpfnDlgProc);
    }
}

HWND    hNameOfMap;

int EXPORT DialogItemAdd(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
  int   i;
  switch(wMsg) {
    case WM_INITDIALOG:
      hNameOfMap = GetDlgItem(hDlg, IDC_MAPNAME);
      Edit_LimitText(hNameOfMap, 8);
      Edit_SetText  (hNameOfMap, "MAP");
      Edit_SetSel   (hNameOfMap, 3, 3);
      for(i = 0; i < 10; i++)
        lpszMessage[i] = '\0';
      break;

    case WM_COMMAND:
      switch(wParam) {
        case IDOK:
          Edit_GetText(hNameOfMap, (LPSTR)lpszMessage, 8);
          EndDialog(hDlg, IDOK);
          return FALSE;
          break;
        case IDCANCEL:
          lpszMessage[0] = '\0';
          EndDialog(hDlg, IDCANCEL);
          return TRUE;
          break;
        default:
          break;
      }
    default:
      break;
    }
      return FALSE;
}

// the following 6 routines return the index of a newly added object

int SectorNew(void)
{ // return the sector number for a new sector.
  // This sector is either added to the end or taken
  // from the unused sectors freed up by deletions
  int   i;
  for(i=0; i<MAX_SECTOR; i++)
    if(!eSector[i].Used) {
      eSector[i].Used = TRUE;     // you asked for it, now must use it...
      Sector[i] = DefSector;    // the default
      SectorsNum = max(SectorsNum, (i+1));
      MapChangeNode();
      return i;
      }
  // fallthrough - increase allocation:
  i = MAX_SECTOR;   // new one will be this number
  AllocateSectors(MAX_SECTOR + 20); // add 20 at a time...
  eSector[i].Used = TRUE;     // you asked for it, now must use it...
  Sector[i] = DefSector;    // the default
  SectorsNum = max(SectorsNum, (i+1));
  MapChangeNode();
  return i;
}

int LineDefNew(void)
{
  int   i;
  for(i=0; i<MAX_LINEDEF; i++)
    if(!eLineDef[i].Used) {
      eLineDef[i].Used = TRUE;    // you asked for it, now must use it...
      LineDef[i] = DefLineDef;  // the default
      LineDefsNum = max(LineDefsNum, (i+1));
      MapChangeNode();
      return i;
      }
  // fallthrough - increase allocation:
  i = MAX_LINEDEF;   // new one will be this number
  AllocateLineDefs(MAX_LINEDEF + 20); // add 20 at a time...
  eLineDef[i].Used = TRUE;    // you asked for it, now must use it...
  LineDef[i] = DefLineDef;  // the default
  LineDefsNum = max(LineDefsNum, (i+1));
  MapChangeNode();
  return i;
}

int LineDefSideDefNew(void)
{
  int   i = LineDefNew();
  LineDef[i].sidedef1 = SideDefNew();
  return i;
}

int SideDefNew(void)
{
  int   i;
  for(i = 0; i < MAX_SIDEDEF; i++)
    if(!eSideDef[i].Used) {
      eSideDef[i].Used = TRUE;    // you asked for it, now must use it...
      SideDef[i] = DefSideDef;    // the default
      SideDefsNum = max(SideDefsNum, (i + 1));
      MapChange();
      return i;
      }
  // fallthrough - increase allocation:
  i = MAX_SIDEDEF;   // new one will be this number
  AllocateSideDefs(MAX_SIDEDEF + 20); // add 20 at a time...
  eSideDef[i].Used = TRUE;    // you asked for it, now must use it...
  SideDef[i] = DefSideDef;    // the default
  SideDefsNum = max(SideDefsNum, (i + 1));
  MapChange();
  return i;
}

int VertexNew(void)
{ // return the vertex number for a new vertex.
  // This vertex is either added to the end or taken
  // from the unused vertexes freed up by deletions
  // or segs/ssectors/nodes rebuilding - or more vertex space is allocated.
  int   i;
  for(i=0; i<MAX_VERTEX; i++)
    if(!eVertex[i].Used) {
      eVertex[i].Used = TRUE;    // you asked for it, now must use it...
      VertexNum = max(VertexNum, (i+1));
      MapChangeNode();
      return i;
      }
  // fallthrough - increase allocation:
  i = MAX_VERTEX;    // new one will be this number
  AllocateVertex(MAX_VERTEX + 100); // add 100 at a time...
  Assert(eVertex != NULL)
  eVertex[i].Used = TRUE;    // you asked for it, now must use it...
  VertexNum = max(VertexNum, (i+1));
  MapChangeNode();
  return i;
}

int ThingNew(void)
{
  int   i;
  for(i=0; i<MAX_THING; i++)
    if(!eThing[i].Used) {
      eThing[i].Used = TRUE;      // you asked for it, now must use it...
      Thing[i] = DefThing;      // the default thing
      ThingsNum = max(ThingsNum, (i+1));
      MapChange();
      return i;
      }
  // fallthrough - increase allocation:
  i = MAX_THING;    // new one will be this number
  AllocateThings(MAX_THING + 50);  // add 50 at a time...
  eThing[i].Used = TRUE;    // you asked for it, now must use it...
  ThingsNum = max(ThingsNum, (i+1));
  MapChange();
  return i;
}

// the following 5 routines remove an object:

void SectorDel(int num)
{
  int i;
  // delete the sector:
  for(i=num; i<SectorsNum; i++)
    Sector[i] = Sector[i+1];
  // adjust the sidedef sector references:
  for(i=0; i<SideDefsNum; i++)
    if(SideDef[i].sector > num)
      SideDef[i].sector--;
  SectorsNum--;
  // free up last sector:
  eSector[SectorsNum].Used = FALSE;
  MapChangeNode();
}

void LineDefDel(int num)
{
  int i;
  // remove the sidedefs:
  SideDefDel(LineDef[num].sidedef1);
  SideDefDel(LineDef[num].sidedef2);
  // remove the linedef:
  for(i=num; i<LineDefsNum; i++)
    LineDef[i] = LineDef[i+1];
  // change count:
  LineDefsNum--;
  // free up last linedef
  eLineDef[LineDefsNum].Used = FALSE;
  MapChangeNode();
}

void SideDefDel(int num)
{
  if(num != Nothing)
    eSideDef[num].Used = FALSE;
  // sidedefs are special: see PackMap below
  MapChange();
}

void VertexDel(int num)
{
  // this vertex will probably be reused right away.
  eVertex[num].Used = FALSE;
  MapChangeNode();
}

void ThingDel(int num)
{
  int i;
  for(i=num; i<ThingsNum; i++)
    Thing[i] = Thing[i+1];
  ThingsNum--;
  // free up last thing
  eThing[ThingsNum].Used = FALSE;
  MapChange();
}

void PackMap(void)
{
  // This routine is run before building the nodetree.
  // It removes all deleted linedefs and sectors, then 
  // sorts the sidedefs to the linedefs all neat and tidy.
  HGLOBAL       hgtempSideDef;
  WadSideDefs   __huge *tempSideDef;
  BOOL          OneDone = FALSE;
  int           i, j;

  hgtempSideDef = GlobalAlloc(GHND, (DWORD)SideDefsNum * sizeof(WadSideDefs));
    tempSideDef = (WadSideDefs __huge *)GlobalLock(hgtempSideDef);
  BottomMessage("Packing Map Structure...");
  /////////////////////////////////////////////////////////////////////////////
  // fill the new data structure:
  for(i = 0; i < SideDefsNum; i++)
    tempSideDef[i] = SideDef[i];
  /////SECTORS:////////////////////////////////////////////////////////////////
  GetSectorExtents();   // find and mark orphans
  for(i = 0; i < SectorsNum; i++)
    if(eSector[i].Used &&
       (eSector[i].Extent.left   == MAXINT) &&
       (eSector[i].Extent.right  == MININT) &&
       (eSector[i].Extent.top    == MININT) &&
       (eSector[i].Extent.bottom == MAXINT))
      eSector[i].Used = FALSE;
  do {
    OneDone = FALSE;
    for(i = 0; i < SectorsNum; i++)
      if(!eSector[i].Used) {
        for(j = i; j < (SectorsNum - 1); j++) {
          Sector[j] = Sector[j + 1];      // delete the sector
          eSector[j].Used = eSector[j + 1].Used;
          }
        for(j = 0; j < SideDefsNum; j++)
          if(tempSideDef[j].sector > i) // adjust the sector references
            tempSideDef[j].sector--;    // in the sidedefs
        SectorsNum--;
        OneDone = TRUE;                 // another time through
        break;                          // restart from 0
        } // endif
    }
  while(OneDone);                       // until all deleted sectors are gone
  /////LINEDEFS:///////////////////////////////////////////////////////////////
  do {
    OneDone = FALSE;
    for(i = 0; i < LineDefsNum; i++)
      if(!eLineDef[i].Used) {
        for(j = i; j < (LineDefsNum - 1); j++) {
          LineDef[j] = LineDef[j + 1];    // delete this linedef
          eLineDef[j].Used = eLineDef[j + 1].Used;
          }
        LineDefsNum--;
        OneDone = TRUE;                 // another time through
        break;
        }
    }
  while(OneDone);
  /////THINGS://///////////////////////////////////////////////////////////////
  do {
    OneDone = FALSE;
    for(i = 0; i < ThingsNum; i++)
      if(!eThing[i].Used) {
        for(j = i; j < ThingsNum; j++) {
          Thing[j] = Thing[j + 1];      // delete the sector
          eThing[j].Used = eThing[j + 1].Used;
          }
        ThingsNum--;
        OneDone = TRUE;                 // another time through
        break;                          // restart from 0
        } // endif
    }
  while(OneDone);                       // until all deleted sectors are gone
  /////////////////////////////////////////////////////////////////////////////
  // mark all of the sidedefs as available (clean)
  _fmemset(eSideDef, 0, (size_t)GlobalSize(hgeSideDef));
  /////////////////////////////////////////////////////////////////////////////
  // now pack the sidedefs properly...
  SideDefsNum = 0;
  for(i=0; i<LineDefsNum; i++) {
    if(LineDef[i].sidedef1 != Nothing) {
      SideDef[SideDefsNum] = tempSideDef[LineDef[i].sidedef1];
      eSideDef[SideDefsNum].Used = TRUE;
      LineDef[i].sidedef1 = SideDefsNum++;
      }
    if(LineDef[i].sidedef2 != Nothing) {
      SideDef[SideDefsNum] = tempSideDef[LineDef[i].sidedef2];
      eSideDef[SideDefsNum].Used = TRUE;
      LineDef[i].sidedef2 = SideDefsNum++;
      }
    }
  /////////////////////////////////////////////////////////////////////////////
  GlobalUnlock(hgtempSideDef);
  GlobalFree(hgtempSideDef);
  BottomMessage("");
  return;
}


