// Joining Routines for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

static char  Orig1[8], Orig2[8];
static int   Doubled = Nothing;

// major optimization working and tested 06/28/94:
void ProcessJoins(void)
{
  int   i, j, k;

  CURSOR_BUSY
  BottomMessage("Auto-Connecting...");
  // STEP ONE: do all vertex joins:
  for(i = 0; i < VertexNum; i++) {
    if(eVertex[i].Used && eVertex[i].Moving) {  // check only the moved ones
      for(j = 0; j < VertexNum; j++) {          // compare against all others
        if(eVertex[j].Used &&
           (j != i) &&
           ((Vertex[i].x == Vertex[j].x) &&
            (Vertex[i].y == Vertex[j].y))) {
          // vertex[i] and vertex[j] are the same location.
          // check each line to change references to vertex[j]
          for(k = 0; k < LineDefsNum; k++) {
            if(eLineDef[k].Used) {
              if(LineDef[k].from == j)
                LineDef[k].from = i;
              if(LineDef[k].to == j)
                LineDef[k].to = i;
              // check if a line shrunk to a point:
              // if so, delete the line.
              if(LineDef[k].from == LineDef[k].to) {
                eLineDef[k].Used = FALSE;
                if(LineDef[k].sidedef1 != Nothing)
                  eSideDef[LineDef[k].sidedef1].Used = FALSE;
                if(LineDef[k].sidedef2 != Nothing)
                  eSideDef[LineDef[k].sidedef2].Used = FALSE;
                }   // endif LineDef delete
              }     // endif LineDefUsed[k]
            // now get rid of the unused vertex
            VertexDel(j);
            }       // next k
          }         // endif vertexes the same
        }           // next j
      }             // endif vertex moved
    }               // next i
  // STEP TWO: do line joins:
  for(i=0; i<LineDefsNum; i++) {
    // only check it if it was involved in a move
    if(eLineDef[i].Used && eLineDef[i].Moving) {
      for(j = 0; j<LineDefsNum; j++) {      // against all others
        // do different lines share same ends?
        if(eLineDef[i].Used &&
           eLineDef[j].Used &&
           (i != j) &&
           (((LineDef[i].from == LineDef[j].to  ) &&
             (LineDef[i].to   == LineDef[j].from)) ||
            ((LineDef[i].from == LineDef[j].from) &&
             (LineDef[i].to   == LineDef[j].to  )))) {
          Join2Lines(i, j);
          if(Doubled != Nothing) {
            if(SideDef[LineDef[i].sidedef1].sector == Doubled) {
              // remove front
              eSideDef[LineDef[i].sidedef1].Used = FALSE;
              LineDef[i].sidedef1 = LineDef[i].sidedef2;
              LineDef[i].sidedef2 = Nothing;
              } // endif delete front face
            else if(SideDef[LineDef[i].sidedef2].sector == Doubled) {
              eSideDef[LineDef[i].sidedef2].Used = FALSE;
              LineDef[i].sidedef2 = Nothing;
              } // endif delete back face
            Doubled = Nothing;  // for next time
            }   // endif something doubled
          }     // endif
        }       // next j
      }         // endif
    }           // next i
                     
  FindVertexesInUse();
  BottomMessage("");
  MapChange();
  CURSOR_NOTBUSY
}

void ProcessSectorJoins(void)
{
  int   i;
  int   Sec1 = Nothing, Sec2 = Nothing, newl;

  // Similar to ProcessJoins except looks for selected sectors
  // (called when sector floor/ceil height changes)
  CURSOR_BUSY
  BottomMessage("Matching Sector Heights...");
  // do line height checks:
  for(i=0; i<LineDefsNum; i++) {
    for(i=0; i<LineDefsNum; i++)
      if(eLineDef[i].Used) {
        // determine which sector(s) touch this line:
        if(LineDef[i].sidedef1 != Nothing)
          Sec1 = SideDef[LineDef[i].sidedef1].sector;
        else
          Sec1 = Nothing;
        if(LineDef[i].sidedef2 != Nothing)
          Sec2 = SideDef[LineDef[i].sidedef2].sector;
        else
          Sec2 = Nothing;
        // yes, this line involved. Create a new line, then
        // join the two lines
        if((Sec1 != Nothing) && (Sec2 != Nothing)) {
          if(eSector[Sec1].Selected != eSector[Sec2].Selected) {
            // don't treat sector borders that are both connected.
            int newv1, newv2;
                
            // get new objects
            newl = LineDefNew();
            newv1 = VertexNew();
            newv2 = VertexNew();
            Vertex[newv1] = Vertex[LineDef[i].from];
            Vertex[newv2] = Vertex[LineDef[i].to];
            // fix bits 1&4
            SetLineBit(i, ML_BLOCKING);
            ClearLineBit(i, ML_TWOSIDED);
            // copy old linedef
            LineDef[newl] = LineDef[i];
            // copy 2nd sidedef to new linedef
            LineDef[newl].sidedef1 = LineDef[i].sidedef2;
            // clear unused sidedefs
            LineDef[i].sidedef2 = Nothing;
            LineDef[newl].sidedef2 = Nothing;
            // stick a texture into the openings
            if(SideDef[LineDef[i].sidedef1].t3[0] == '-') {
              if(SideDef[LineDef[i].sidedef1].t2[0] != '-')
                CopyWall(SideDef[LineDef[i].sidedef1].t3,
                         SideDef[LineDef[i].sidedef1].t2);
              if(SideDef[LineDef[i].sidedef1].t1[0] != '-')
                CopyWall(SideDef[LineDef[i].sidedef1].t3,
                         SideDef[LineDef[i].sidedef1].t1);
              // if still nothing, put default there:
              if(SideDef[LineDef[i].sidedef1].t3[0] == '-')
                CopyWall(SideDef[LineDef[i].sidedef1].t3,
                         DefaultSectorWall);
              }
            // second opening
            if(SideDef[LineDef[newl].sidedef1].t3[0] == '-') {
              if(SideDef[LineDef[newl].sidedef1].t2[0] != '-')
                CopyWall(SideDef[LineDef[newl].sidedef1].t3,
                         SideDef[LineDef[newl].sidedef1].t2);
              if(SideDef[LineDef[newl].sidedef1].t1[0] != '-')
                CopyWall(SideDef[LineDef[newl].sidedef1].t3,
                         SideDef[LineDef[newl].sidedef1].t1);
              if(SideDef[LineDef[newl].sidedef1].t3[0] == '-')
                CopyWall(SideDef[LineDef[newl].sidedef1].t3,
                         DefaultSectorWall);
              }
            // reverse lines as required
            if(eSector[Sec1].Selected) {
              LineDef[newl].from = LineDef[i].to;
              LineDef[newl].to = LineDef[i].from;
              LineDef[i].from = newv1;
              LineDef[i].to = newv2;
              }     // endif first sector
            else {
              LineDef[newl].to = newv1;
              LineDef[newl].from = newv2;
              }     // endif second sector
            // ok, we just separated them, now join them again.
            Join2Lines(i, newl);
            }       // endif not both selected
          }         // endif two sided line
        }           // endif linedefused
    }   // next i

  FindVertexesInUse();
  BottomMessage("");
  MapChange();
  CURSOR_NOTBUSY
}

void Join2Vertexes(int a, int b)
{
  int   i, j;

  // this is the old way, and should only be used
  // for single vertex joins (or never).
  for(i=0; i<LineDefsNum; i++)
    if(eLineDef[i].Used) {
      if(LineDef[i].from == b)
        LineDef[i].from = a;
      if(LineDef[i].to == b)
        LineDef[i].to = a;
      // check if you shrunk a line to a point:
      // if so, we must delete the line.
      if(LineDef[i].from == LineDef[i].to) 
        eLineDef[i].Used = FALSE;
      }   // endif LineDefUsed[i]
    
    // check if two lines are now joined:
  for(i=0; i<LineDefsNum; i++)
    // only check it if it was involved in a move
    if(eLineDef[i].Moving)
      for(j=0; j<LineDefsNum; j++)
        // do different lines share same ends?
        if(((LineDef[i].from == LineDef[j].to  ) &&
            (LineDef[i].to   == LineDef[j].from)) ||
           ((LineDef[i].from == LineDef[j].from) &&
            (LineDef[i].to   == LineDef[j].to  )))
          if(eLineDef[i].Used &&
             eLineDef[j].Used &&
             (i != j))
            Join2Lines(i, j);

  FindVertexesInUse();
  MapChange();
}

void Join2Lines(int a, int b)
{
  HDC   rDC;
  if(((LineDef[a].sidedef1 != Nothing) &&
      (LineDef[a].sidedef2 != Nothing)) ||
     ((LineDef[b].sidedef1 != Nothing) &&
      (LineDef[b].sidedef2 != Nothing))) {
     // one of these lines already has two sidedefs:
     // check all four possible doubles:
     if((LineDef[a].sidedef1 != Nothing) &&
        (LineDef[b].sidedef1 != Nothing) &&
        (SideDef[LineDef[a].sidedef1].sector ==
         SideDef[LineDef[b].sidedef1].sector))
        Doubled = SideDef[LineDef[a].sidedef1].sector;
     if((LineDef[a].sidedef2 != Nothing) &&
        (LineDef[b].sidedef1 != Nothing) &&
        (SideDef[LineDef[a].sidedef2].sector ==
         SideDef[LineDef[b].sidedef1].sector))
        Doubled = SideDef[LineDef[a].sidedef2].sector;
     if((LineDef[a].sidedef1 != Nothing) &&
        (LineDef[b].sidedef2 != Nothing) &&
        (SideDef[LineDef[a].sidedef1].sector ==
         SideDef[LineDef[b].sidedef2].sector))
        Doubled = SideDef[LineDef[a].sidedef1].sector;
     if((LineDef[a].sidedef2 != Nothing) &&
        (LineDef[b].sidedef2 != Nothing) &&
        (SideDef[LineDef[a].sidedef2].sector ==
         SideDef[LineDef[b].sidedef2].sector))
        Doubled = SideDef[LineDef[a].sidedef2].sector;
    }

  if(Doubled != Nothing) {
    // all eight possibilities for deleting doubled sector:
    // front:
    if((LineDef[a].sidedef1 != Nothing) &&
       (SideDef[LineDef[a].sidedef1].sector == Doubled) &&
       (LineDef[b].sidedef1 != Nothing) &&
       (LineDef[b].sidedef2 != Nothing) &&
       (SideDef[LineDef[b].sidedef1].sector == Doubled)) {
      eSideDef[LineDef[b].sidedef1].Used = FALSE;
      LineDef[b].sidedef1 = Nothing;
      goto DeletedOne;
      }
    if((LineDef[a].sidedef1 != Nothing) &&
       (SideDef[LineDef[a].sidedef1].sector == Doubled) &&
       (LineDef[b].sidedef1 != Nothing) &&
       (LineDef[b].sidedef2 != Nothing) &&
       (SideDef[LineDef[b].sidedef2].sector == Doubled)) {
      eSideDef[LineDef[b].sidedef2].Used = FALSE;
      LineDef[b].sidedef2 = Nothing;
      goto DeletedOne;
      }
    if((LineDef[a].sidedef2 != Nothing) &&
       (SideDef[LineDef[a].sidedef2].sector == Doubled) &&
       (LineDef[b].sidedef1 != Nothing) &&
       (LineDef[b].sidedef2 != Nothing) &&
       (SideDef[LineDef[b].sidedef1].sector == Doubled)) {
      eSideDef[LineDef[b].sidedef1].Used = FALSE;
      LineDef[b].sidedef1 = Nothing;
      goto DeletedOne;
      }
    if((LineDef[a].sidedef2 != Nothing) &&
       (SideDef[LineDef[a].sidedef2].sector == Doubled) &&
       (LineDef[b].sidedef1 != Nothing) &&
       (LineDef[b].sidedef2 != Nothing) &&
       (SideDef[LineDef[b].sidedef2].sector == Doubled)) {
      eSideDef[LineDef[b].sidedef2].Used = FALSE;
      LineDef[b].sidedef2 = Nothing;
      goto DeletedOne;
      }
    // back:
    if((LineDef[b].sidedef1 != Nothing) &&
       (SideDef[LineDef[b].sidedef1].sector == Doubled) &&
       (LineDef[a].sidedef1 != Nothing) &&
       (LineDef[a].sidedef2 != Nothing) &&
       (SideDef[LineDef[a].sidedef1].sector == Doubled)) {
      eSideDef[LineDef[a].sidedef1].Used = FALSE;
      LineDef[a].sidedef1 = Nothing;
      goto DeletedOne;
      }
    if((LineDef[b].sidedef1 != Nothing) &&
       (SideDef[LineDef[b].sidedef1].sector == Doubled) &&
       (LineDef[a].sidedef1 != Nothing) &&
       (LineDef[a].sidedef2 != Nothing) &&
       (SideDef[LineDef[a].sidedef2].sector == Doubled)) {
      eSideDef[LineDef[a].sidedef2].Used = FALSE;
      LineDef[a].sidedef2 = Nothing;
      goto DeletedOne;
      }
    if((LineDef[b].sidedef2 != Nothing) &&
       (SideDef[LineDef[b].sidedef2].sector == Doubled) &&
       (LineDef[a].sidedef1 != Nothing) &&
       (LineDef[a].sidedef2 != Nothing) &&
       (SideDef[LineDef[a].sidedef1].sector == Doubled)) {
      eSideDef[LineDef[a].sidedef1].Used = FALSE;
      LineDef[a].sidedef1 = Nothing;
      goto DeletedOne;
      }
    if((LineDef[b].sidedef2 != Nothing) &&
       (SideDef[LineDef[b].sidedef2].sector == Doubled) &&
       (LineDef[a].sidedef1 != Nothing) &&
       (LineDef[a].sidedef2 != Nothing) &&
       (SideDef[LineDef[a].sidedef2].sector == Doubled)) {
      eSideDef[LineDef[a].sidedef2].Used = FALSE;
      LineDef[a].sidedef2 = Nothing;
      }
       
DeletedOne:
    ;
    }

  BOOL  FirstReversed  = ((LineDef[a].sidedef2 != Nothing) &&
                          (LineDef[a].sidedef1 == Nothing));
  BOOL  SecondReversed = ((LineDef[b].sidedef2 != Nothing) &&
                          (LineDef[b].sidedef1 == Nothing));

  // make one linedef with two sidedefs where once there
  // were two linedefs each with one sidedef...
  if(FirstReversed) {
    // join these two lines:  
    if(SecondReversed)
      LineDef[a].sidedef1 = LineDef[b].sidedef2;
    else
      LineDef[a].sidedef1 = LineDef[b].sidedef1;
    }       // endif firstreversed
  else {
    // join these two lines:  
    if(SecondReversed)
      LineDef[a].sidedef2 = LineDef[b].sidedef2;
    else
      LineDef[a].sidedef2 = LineDef[b].sidedef1;
    }       // endif not firstreversed

  // set this wall as passable:
  SetLineBit(a, ML_TWOSIDED);
  ClearLineBit(a, ML_BLOCKING);
  // remove textures in opening:
  CopyWall(Orig1, SideDef[LineDef[a].sidedef1].t3);
  NullWall(SideDef[LineDef[a].sidedef1].t3);
  CopyWall(Orig2, SideDef[LineDef[a].sidedef2].t3);
  NullWall(SideDef[LineDef[a].sidedef2].t3);
  if(Orig1[0] == '-')
    CopyWall(Orig1, DefaultSectorWall);
  if(Orig2[0] == '-')
    CopyWall(Orig2, DefaultSectorWall);
  // put (and match) textures where 
  // floor and ceiling don't meet,
  // but only change texture if there wasn't one before:

  // check if first ceiling higher than second ceiling:
  if(Sector[SideDef[LineDef[a].sidedef1].sector].ceilZ > 
    Sector[SideDef[LineDef[a].sidedef2].sector].ceilZ) {
    // put wall texture in place:
    if(SideDef[LineDef[a].sidedef1].t1[0] == '-')
      CopyWall(SideDef[LineDef[a].sidedef1].t1, Orig1);
    // adjust top texture:
    SideDef[LineDef[a].sidedef1].y =
      (Sector[SideDef[LineDef[a].sidedef1].sector].ceilZ -
       Sector[SideDef[LineDef[a].sidedef2].sector].ceilZ);
    }

  // check if first ceiling lower than second ceiling:
  if(Sector[SideDef[LineDef[a].sidedef1].sector].ceilZ < 
     Sector[SideDef[LineDef[a].sidedef2].sector].ceilZ) {
    // put wall texture in place:
    if(SideDef[LineDef[a].sidedef2].t1[0] == '-')
      CopyWall(SideDef[LineDef[a].sidedef2].t1, Orig2);
    // adjust top texture:
    SideDef[LineDef[a].sidedef2].y =
      Sector[SideDef[LineDef[a].sidedef2].sector].ceilZ -
      Sector[SideDef[LineDef[a].sidedef1].sector].ceilZ;
    }

  // check if first floor higher than second floor:
  if(Sector[SideDef[LineDef[a].sidedef1].sector].floorZ > 
     Sector[SideDef[LineDef[a].sidedef2].sector].floorZ)
    if(SideDef[LineDef[a].sidedef2].t2[0] == '-')
      CopyWall(SideDef[LineDef[a].sidedef2].t2, Orig2);

  // check if first floor lower than second floor:
  if(Sector[SideDef[LineDef[a].sidedef1].sector].floorZ < 
     Sector[SideDef[LineDef[a].sidedef2].sector].floorZ)
    if(SideDef[LineDef[a].sidedef1].t2[0] == '-')
      CopyWall(SideDef[LineDef[a].sidedef1].t2, Orig1);

  // draw the new double sided line
  if(!eLineDef[a].Selected) {
    rDC = GetDC(hwnd);
    SelectPen(rDC, hPenMapInnerLines);
    MoveTo(rDC, Vertex[LineDef[a].from].x,
                Vertex[LineDef[a].from].y);
    LineTo(rDC, Vertex[LineDef[a].to].x,
                Vertex[LineDef[a].to].y);
    ReleaseDC(hwnd, rDC);
    }

  // delete the linedef
  eLineDef[b].Used = FALSE;
  MapChange();
}
