// Tags (Platforms) for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

void DoPlatforms(void)
{
  FARPROC lpfnDlgProc;
  lpfnDlgProc = MakeProcInstance((FARPROC)DialogPlatforms, hinst);
  if(lpfnDlgProc) {
    DialogBox(hinst,
              MAKEINTRESOURCE(IDD_PLATFORMS),
              hwnd,
              lpfnDlgProc);
    FreeProcInstance(lpfnDlgProc);
    MapChange();
    }
}

HWND    hList3;

int EXPORT DialogPlatforms(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
  int   i;
  switch(wMsg) {
    case WM_INITDIALOG:
      hList3 = GetDlgItem(hDlg, IDC_PLATFORM_LIST);
      FillListWithPlatforms(hList3);
      break;

    case WM_COMMAND:
      switch(wParam) {
        case IDC_PLATFORM_LIST:
          switch(HIWORD(lParam)) {
            case LBN_DBLCLK:
              // the first click selected the right one...
              SendMessage(hDlg, WM_COMMAND, IDC_PLATFORM_EDIT, 0L);
              return TRUE;
              break;
            case LBN_SELCHANGE:
              CurrentTag = ListBox_GetCurSel(hList3);
              Button_Enable(GetDlgItem(hDlg, IDC_PLATFORM_EDIT), TRUE);
              Button_Enable(GetDlgItem(hDlg, IDC_PLATFORM_DELETE), TRUE);
              return TRUE;
              break;
            default:
              return TRUE;
              break;
            }
        case IDC_PLATFORM_ADD:
          CurrentTag = Nothing;
          SendMessage(hDlg, WM_COMMAND, IDC_PLATFORM_EDIT, 0L);
          return TRUE;
          break;
        case IDC_PLATFORM_DELETE:
          {
            char szTemp[128];
            sprintf(szTemp, "Are you sure you want to delete the\n"
                            "Tag \"%s\"?", Tag[CurrentTag].Name);
            if(MessageBox(hDlg, szTemp, ProgName, MB_YESNO |
                          MB_ICONQUESTION) == IDYES) {
              for(i=CurrentTag; i<TagsNum; i++)
                Tag[i] = Tag[i + 1];
              TagsNum--;
              }
          }
          FillListWithPlatforms(hList3);
          return TRUE;
          break;
        case IDC_PLATFORM_EDIT:
          {
          FARPROC lpfnDlgProc;
          lpfnDlgProc = MakeProcInstance((FARPROC)DialogPlatform, hinst);
          if(lpfnDlgProc) {
            DialogBox(hinst,
                      MAKEINTRESOURCE(IDD_PLATFORM),
                      hDlg,
                      lpfnDlgProc);
            FreeProcInstance(lpfnDlgProc);
            }
          }
          FillListWithPlatforms(hList3);
          return TRUE;
          break;
        case IDOK:
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        case IDCANCEL:
          EndDialog(hDlg, IDCANCEL);
          return TRUE;
          break;
        default:
          break;
      }
    default:
      return FALSE;
    }
    return FALSE;
}

HWND    hName3, hComment;

int EXPORT DialogPlatform(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
  char  szTemp[32];
  BOOL  TryingToAdd = FALSE;
  
  switch(wMsg) {
    case WM_INITDIALOG:
      hName3    = GetDlgItem(hDlg, IDC_PLATFORM_NAME);
      hComment = GetDlgItem(hDlg, IDC_PLATFORM_COMMENT);
      Edit_LimitText(hName3, 32);
      Edit_LimitText(hComment, 250);
      if(CurrentTag != Nothing) {
        Edit_SetText(hName3, Tag[CurrentTag].Name);
        Edit_SetText(hComment, Tag[CurrentTag].Desc);
        }
      else {
        TryingToAdd = TRUE;
        CurrentTag = TagsNum++;
        Tag[CurrentTag].Num = NextTag++;
        wsprintf(szTemp, "Tag%i", Tag[CurrentTag].Num);
        Edit_SetText(hName3, szTemp);
        Edit_SetText(hComment, "");
        }
      break;

    case WM_COMMAND:
      switch(wParam) {
        case IDOK:
          Edit_GetText(hName3, Tag[CurrentTag].Name, 32);
          Edit_GetText(hComment, Tag[CurrentTag].Desc, 250);
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        case IDCANCEL:
          if(TryingToAdd) {
            TagsNum--;
            NextTag--;
            }
          EndDialog(hDlg, IDCANCEL);
          return TRUE;
          break;
        default:
          break;
      }
    default:
      return FALSE;
    }
    return FALSE;
}


