/*
   LNXFUNCS.C -	Functions needed for the Linux operating system
*/

#include <stdio.h>
#include <ctype.h>
#include <unistd.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <string.h>

#include "deu.h"
#undef EGA		/* From bcc2grx.h */
#undef CGA		/* From bcc2grx.h */

#include <sys/types.h>
#include <linux/kd.h>
#include <linux/keyboard.h>

#include "lnxfuncs.h"

int kbd_fd;
unsigned char buf[6];
int currflags;

int init;


/* Functions to convert strings to upper/lower case */

char *strlwr(char *string)
{
    int i, len;

    len = strlen(string);
    for (i = 0; i < len; i++)
	string[i] = tolower(string[i]);

    return string;
}

char *strupr(char *string)
{
    int i, len;

    len = strlen(string);
    for (i = 0; i < len; i++)
	string[i] = toupper(string[i]);

    return string;
}


/* Translate those damn vt100 codes to what deu wants. */
/* I know it's an ugly way of doing it, but it works.  */

int translate(unsigned char key[])
{

    if (!key)
	return 0;

    if (!strncmp(key, "\n", 1))	                /* return key */
	return 0x000D;

    if (!strncmp(key, "\x1b\x5b\x44", 3))	/* left arrow */
	return 0x4B00;
    if (!strncmp(key, "\x1b\x5b\x43", 3))	/* right arrow */
	return 0x4D00;
    if (!strncmp(key, "\x1b\x5b\x42", 3))	/* down arrow */
	return 0x5000;
    if (!strncmp(key, "\x1b\x5b\x41", 3))	/* up arrow */
	return 0x4800;
    if (!strncmp(key, "\x1b\x5b\x35\x7e", 4))	/* page up */
	return 0x4900;
    if (!strncmp(key, "\x1b\x5b\x36\x7e", 4))	/* page down */
	return 0x5100;
    if (!strncmp(key, "\x1b\x5b\x32\x7e", 4))	/* ins */
	return 0x5200;
    if (!strncmp(key, "\x1b\x5b\x33\x7e", 4))	/* del */
	return 0x5300;
    if (!strncmp(key, "\x1b\x5b\x31\x7e", 4))	/* home */
	return 0x4700;
    if (!strncmp(key, "\x1b\x5b\x34\x7e", 4))	/* end */
	return 0x4F00;
    if (!strncmp(key, "\x1b\x5b\x5b\x41", 4))	/* F1 */
	return 0x3B00;
    if (!strncmp(key, "\x1b\x5b\x5b\x42", 4))	/* F2 */
	return 0x3C00;
    if (!strncmp(key, "\x1b\x5b\x5b\x43", 4))	/* F3 */
	return 0x3D00;
    if (!strncmp(key, "\x1b\x5b\x5b\x44", 4))	/* F4 */
	return 0x3E00;
    if (!strncmp(key, "\x1b\x5b\x5b\x45", 4))	/* F5 */
	return 0x3F00;
    if (!strncmp(key, "\x1b\x5b\x31\x39\x7e", 5))	/* F8 */
	return 0x4200;
    if (!strncmp(key, "\x1b\x5b\x32\x30\x7e", 5))	/* F9 */
	return 0x4300;
    if (!strncmp(key, "\x1b\x5b\x32\x31\x7e", 5))	/* F10 */
	return 0x4400;

    if ((key[0] == '\x1b') && (key[1] != '\0'))
	return '\0';

    return key[0];
}

static int PollKeyboard()
{
    fd_set fdset;
    struct timeval tv;

    FD_ZERO(&fdset);
    FD_SET(kbd_fd, &fdset);
    bzero(&tv, sizeof(tv));
    if ( select(32,&fdset,NULL,NULL,&tv) == 0 )
        return(0);
    else
        return(1);
}

static unsigned char *blockRead()
{
    int n;

    bzero(buf, sizeof(buf));

  tryagain:
    n = read(kbd_fd, buf, sizeof(buf) - 1);
    if (n < 0) {
/*        usleep(100); */
	goto tryagain;
    }
    buf[n] = '\0';


    return buf;
}

static unsigned char *nblockRead()
{
    int i, len;

    bzero(buf, sizeof(buf));

    len = read(kbd_fd, buf, 1);
    if (len < 0) {
	return '\0';
    }
    /* if it's an escape code, read the rest of it */
    if (buf[0] == '\x1b' && PollKeyboard() )
	len += read(kbd_fd, &(buf[1]), 4);
    for ( i=0; i<len; ++i )
        (void) ioctl(kbd_fd, TIOCSTI, &buf[i]);
    return buf;
}


int check_scroll()
{
    int status;

    if (ioctl(kbd_fd, KDGETLED, &status))
	perror("check_scroll()");
    if (status & LED_SCR)
	return 1;
    else
	return 0;
}


/* I'm not sure if Linux has a simple equivalent to this function */
/* If it does, I've wasted a lot of time... ;)                    */

int bioskey(int x)
{
    unsigned char *key;

    if (!init) {
	if ((kbd_fd = open("/dev/console", O_RDONLY)) < 0) {
	    perror("/dev/console");
	    exit(1);
	}
	currflags = fcntl(kbd_fd, F_GETFL);
	fcntl(kbd_fd, F_SETFL, currflags | O_NDELAY);

	init = 1;
    }
    switch (x) {
    case 0:
	key = blockRead();
	break;
    case 1:  /* This should really be just a poll of the keyboard */
        if ( PollKeyboard() == 0 )
            return(0);
        /* Read the characters and put them back. *grin*  */
	key = nblockRead();
        break;
    case 2:  /* Let's not bother with scancodes today */
	return '\0';
	break;
    }

    return translate(key);
}


/* Use ioctls for the console to play desired beeps */

void Beep()
{
    unsigned int cons_sound=0;

    if (Quieter == FALSE) {
        /* Lower 16 bits are frequency, high 16 bits are duration (ms) */
        cons_sound = 640;
        cons_sound |= (100<<16);
        if ( ioctl(kbd_fd, KDMKTONE, cons_sound) < 0 )
            printf("%c", 'G'-'@'); fflush(stdout);
    }
}



/* play a sound */

void PlaySound( BCINT freq, BCINT msec)
{
    unsigned int cons_sound=0;

    if (Quiet == FALSE) {
        /* Lower 16 bits are frequency, high 16 bits are duration */
        cons_sound = freq;
        cons_sound |= (msec<<16);
        if ( ioctl(kbd_fd, KDMKTONE, cons_sound) < 0 )
            printf("%c", 'G'-'@'); fflush(stdout);
    }
}









