
DMPSMU(1)                                               DMPSMU(1)

NAME
     dmpsmu - DooM PostScript Maps Utility

SYNOPSIS
     dmpsmu  [ -? ] [ -w main WAD file ] [ -pw patch WAD file ] [
     -file patch WAD files ...  ]

AVAILABILITY
     This command (in its v2.0 version) has been tested on  SunOS
     4.1,  IRIX  4.0,  Ultrix  4.3,  HP-UX  9.0,  Linux 1.0.9 and
     DJGPP/GO32 1.12m2 (DOS), so it should be easily portable  to
     other Unix flavors.

DESCRIPTION
     dmpsmu  is an interactive utility of which the primary func-
     tion is to generate PostScript maps of levels in DOOM,  DOOM
     ][,  Ultimate  DOOM  and  Heretic, the 3D action games by id
     Software and Raven Software.  It is derived  from  DEU,  the
     Doom Editor Utility and retains from this tool all functions
     that have a read-only effect on the DOOM/Heretic WAD  files,
     thus  allowing  examination  but  not  modification of these
     files under Unix.

     The appearance of the PostScript maps  is  controlled  by  a
     large number of print flags, yielding a wide range of possi-
     bilities in outputting the maps. Besides printing the  basic
     map, dmpsmu offers several advanced features:
     - detailed control over layout and appearance of the page(s)
     - multi-page capability, printing on 2 or 4 normal pages
     - detailed control over which Things will be printed
     - fading LineDefs that are secret or part of a secret Sector
     -  shading  secret  and  damage  Sector areas, but not their
     inner Sectors
     - linking teleporters and their exits by faint lines
     For an explanation of Things, LineDefs and Sectors, as  well
     as  anything  else you may want to know about WAD files, see
     the DOOM Specs.

OPTIONS
     Options  are  case-insensitive  and  filenames   are   case-
     sensitive.  Both the short and long forms of the options are
     listed.

     -? -h -help
          Displays usage information.

     -w -main
          Specifies the name of the main  WAD  file;  default  is
          DOOM.WAD.   Eg.  to  use  the  shareware main WAD file,
          specify: -w DOOM1.WAD .

     -pw -pwad
          Specifies the name of a patch WAD file.  Eg. to merge a
          single patch WAD file, specify: -pw <file>.WAD .

DMPSMU                    28 August 1995                        1

DMPSMU(1)                                               DMPSMU(1)

     -file
          Specifies  a  list of names of patch WAD files.  Eg. to
          merge  several  patch   WAD   files,   specify:   -file
          <file1>.WAD <file2>.WAD <file3>.WAD .

COMMANDS
     Commands,  print  flags  and  directory  entries  are  case-
     insensitive  and  filenames  and  level  names   are   case-
     sensitive.   Both  the  short and long forms of the commands
     are listed.

     ? H Help
          Gives a brief command overview. The commands and  their
          parameters with a short explanation are displayed.

     A Analyze
          Analyzes  and displays a level's statistics. Specify an
          episode number and a mission number for a  DOOM/Heretic
          level,  or  0  (zero)  and  a  map number for a DOOM ][
          level. An overview of  that  map's  characteristics  is
          displayed: the map dimensions, the amount of structures
          of various  kinds  (including  the  number  of  player-
          teleporting  LineDefs and secret Sectors), a break-down
          of Things into classes (see THING  CLASSES  below)  and
          break-downs  of PowerUps (weapons and enhancements) and
          Enemies into types. The Analyze  command  respects  the
          state of the M and U print flags.

     D Dump
          Displays  a directory entry in hex. Specify the name of
          a directory entry and an optional  output  filename.  A
          hex/text  dump of the entry is displayed, pausing after
          every 23 lines, or written to the file. In case of mul-
          tiple  entries  with  the same name, the command allows
          for skipping to the next such entry, or writes all such
          entries to the file.

     F Flags
          Displays  or sets the print flags. If no parameters are
          specified, the current state of all  flags  is  listed.
          Otherwise,  specify  a  list  of  flag  settings to set
          (+flag) or reset (-flag)  any  print  flag.  See  PRINT
          FLAGS  below for the available flags and their meaning.

     L List
          Lists the directory of a WAD file. Specify the name  of
          a (main or patch) WAD file and an optional output file-
          name. The directory of the WAD file is displayed, paus-
          ing after every 23 lines, or written to the file.

     M Master
          Displays  the  master  directory. Optionally specify an
          output filename.  The master  directory  is  displayed,
          pausing  after  every 23 lines, or written to the file.

DMPSMU                    28 August 1995                        2

DMPSMU(1)                                               DMPSMU(1)

          The master directory is an administrative  list,  main-
          tained  by  the  program, of the directory entries from
          all open files, both the main WAD file and  any  merged
          patch WAD files.

     N Name
          Displays or (re)sets the user level name. If no parame-
          ter is specified, the current name is displayed. Other-
          wise,  specify  the  name  to be used when subsequently
          printing or analyzing a level, or '' to reset it.  Mul-
          tiple  spaces  within  the name are condensed to single
          ones. The main purpose is to temporarily set the actual
          name  of  a patch WAD level before printing, overruling
          the regular name for that episode/mission.

     P Print
          Prints the map of a level to a PostScript file. Specify
          an   episode   number   and  a  mission  number  for  a
          DOOM/Heretic level, or 0 (zero) and a map number for  a
          DOOM ][ level. Follow either combination with an output
          filename. The  layout  and  objects  of  that  map  are
          printed  in  PostScript  to  the file, according to the
          currect print flag settings.

     Q Quit
          Quits the program.

     R Read
          Reads a new patch WAD file. Specify the filename  of  a
          patch  WAD  file.   The  file is read and its directory
          entries are merged into the master directory, overwrit-
          ing any duplicate entries.

     W Wads
          Displays  a  list  of  the  open WAD files. Requires no
          parameters.  The currently open WAD files  are  listed,
          starting  with  the  main  WAD file and then any merged
          patch WAD files.

     X Xtract Extract
          Extracts a directory entry into a raw file. Specify the
          name  of  a directory entry and an output filename. The
          entry is written as binary data to the file.   In  case
          of  multiple entries with the same name, only the first
          such entry is extracted.

THING CLASSES
     As shown by the Analyze command, DOOM / Heretic  Things  are
     grouped in the following classes:

     START     player and deathmatch starting points

     TLPORT    teleport exits

DMPSMU                    28 August 1995                        3

DMPSMU(1)                                               DMPSMU(1)

     BONUS     helmets,  potions,  stimpacks,  medikits and small
               ammunition (DOOM) / vials, flasks and small  ammu-
               nition (Heretic)

     WEAPON    weapons  and  boxes of ammunition (DOOM) / weapons
               and large ammunition (Heretic)

     ENHANC    keys, armours,  spheres,  hi-tech  gadgets  (suit,
               goggles,   etc.)  and  backpacks  (DOOM)  /  keys,
               shields, artifacts (tome  of  power,  morph  ovum,
               etc.) and bags of holding (Heretic)

     ENEMY     former humans, imps, demons, barons, etc. (DOOM) /
               gargoyles,  golems,  disciples,  ironliches,  etc.
               (Heretic)

     DECOR     pillars, torches, stakes, dead monsters, etc.

     BARREL / POD/VC
               explosive  barrels  (DOOM)  / pods & tiny volcanos
               (Heretic)

PRINT FLAGS
     The following flags are available with  the  Flags  command,
     shown  in  their 'set' meaning with their 'reset' meaning in
     brackets:

     2   use double [normal] page
         Double pages are A3 or Tabloid,  depending  on  flag  A.
         The  resulting  PostScript file can be displayed using a
         GhostScript viewer.  To print the file into an upper and
         lower  normal  sized  page,  use the dmps2ul.sh command.
         Flags 2 and 4 cannot both be set; if necessary flag 4 is
         reset.

     4   use quadruple [normal] page
         Quadruple  pages  are A2 or double_Tabloid, depending on
         flag A.  The resulting PostScript file can be  displayed
         using a GhostScript viewer, although not all viewers may
         be able to show the whole map.  To print a normal  sized
         page  from the file for each of the 4 quadrants, use the
         dmps4qd.sh command. Flags 2 and 4 cannot both be set; if
         necessary flag 2 is reset.

     A   use A4 [Letter] paper size
         Gives a choice of European and American paper sizes.

     B   print [no] border around map
         The  border  is  a  solid  rectangle  with  a thin white
         stripe, 0.25 inch inside the edges of the paper.

     D   print all [no] decorations & barrels / pods
         Decorations are printed  as  tiny  crosses  and  barrels
         (DOOM)  /  pods  (Heretic) as small circles. Heretic pod

DMPSMU                    28 August 1995                        4

DMPSMU(1)                                               DMPSMU(1)

         generators are printed as larger circles.

     E   print all [no] enemies
         Enemies are printed as triangles with a  line  extending
         from the center in the direction the monster faces.

     F   [don't] fade secret lines
         Prints  faint lines for LineDefs part of a secret Sector
         and for secret LineDefs.

     G   print all [no] goodies (weapons/bonuses/enhancements)
         Weapons are printed as double squares, bonuses as  small
         single squares and enhancements as double circles.

     L   print [no] legend above map
         The legend is a box in the upper-right corner of the map
         with the icons used for the Thing classes  and  the  map
         scale.   This  is a relative scale, indicating the ratio
         of map coordinates to PostScript coordinates.

     M   print [no] multi-player things
         Multi-player Things also include player 2,  3  &  4  and
         deathmatch starting points.  An indicator (M) is printed
         in the corner of the legend box.

     N   print [no] name above map
         The name is a text in the upper-left corner of the  map,
         printed  as  ExMy:  <map  name>  . In the name, x is the
         episode number, y is the mission number and  <map  name>
         is  the user level name if set or else the regular name.

     P   use Portrait [Landscape] orientation
         Offers a choice of horizontal and vertical map  orienta-
         tion,  allowing  auto-zoom  to achieve the optimum scale
         depending on a map's dimensions.

     S   [don't] shade secret & damage areas
         Prints medium grey areas for secret  Sectors  and  light
         grey  areas  for  damage Sectors; any inner Sectors (eg.
         massive pillars) are not shaded.

     T   [don't] link teleports
         Prints a faint line from the middle of each (incl.  mon-
         ster-only)  teleporting  LineDef  to  the  corresponding
         teleport exit.

     U   print things for [below] Ultra-Violence skill
         Things below UV skill are all Things on the first  three
         difficulty  levels  together.  This is a simplification,
         but nobody plays below UV anyway, right? :-) The Heretic
         equivalent of Ultra-Violence skill is Smite-Meister.

     Z   auto-zoom [default] map scale
         Auto-zoom  computes the scale such that the map achieves

DMPSMU                    28 August 1995                        5

DMPSMU(1)                                               DMPSMU(1)

         an optimum fit on the page,  depending  on  paper  size,
         orientation and the presence of name and/or legend.  The
         default scale ensures that the largest level (E3M6) fits
         on  a normal Portrait page; this helps to get an idea of
         the sizes of the maps relative to eachother.

     By default, all flags except 2, 4 and M are set. The  player
     1  starting  point  and  teleport  exits are always printed.
     Starting points are printed as circles and teleport exits as
     squares.   Both have a line extending from the center in the
     direction the player faces at that point.

EXAMPLES
     The command:

       dmpsmu -pw foobar.wad

     starts the utility with the following messages:

       DMPSMU: DooM PostScript Maps Utility, ver 2.6
        By Frans P. de Vries <fpv@xymph.iaf.nl>
       [Derived from DEU v5.21 GCC by Brendon Wyber and Raphael Quinet]

       Patch WAD file: foobar.wad.
       Loading main WAD file: DOOM.WAD...
       Loading patch WAD file: foobar.wad...
          [Updating level E1M1]

     Some examples of dmpsmu commands are shown below:

       [? for help]> flags -p +m

       -P      use Landscape orientation
       +M      print multi-player things

       [? for help]> n FooBar

       User level name set : FooBar

       [? for help]> print 1 1 foobar.ps

       Outputting PostScript map of level E1M1 to "foobar.ps".

       [? for help]> name ''

       User level name reset

       [? for help]> a 3 6

       Statistics of level E3M6: Mt. Erebus
       ========================

       MapDim:   MaxX    MinX   SizeX    MaxY    MinY   SizeY
                 4216   -2568    6784    3392   -3400    6792

DMPSMU                    28 August 1995                        6

DMPSMU(1)                                               DMPSMU(1)

       Struct: Things  Vertxs  LinDfs  TelePt  SidDfs  Sectrs  Secret
                  334     550     687      10     949     125       4

       Things:  START  TLPORT   BONUS  WEAPON  ENHANC   ENEMY   DECOR  BARREL
                    9       6      60      18      16     126      85       0

       PowrUps:SHOTGN  COMBAT  CHAING  RCKTLR  PLASMA   BFG9K  CHNSAW  BERSRK  BCKPCK
                    1       0       1       1       1       0       1       1       1
               GRNARM  BLUARM  SOULSP  MEGASP  BLURAF  INVLAF  RDSUIT  CMPMAP  LITAMP
                    2       1       2       0       0       2       5       1       0

       Enemies: HUMAN   SARGE  COMNDO     IMP   DEMON  SPECTR  LOSTSL  CACODM  PNELEM
                    7      18       0      36       6       4      32      22       0
               MANCBS  REVENT  KNIGHT   BARON  ARCHNO  ARVILE  CYBERD  SPIDER  WOLFSS
                    0       0       0       1       0       0       0       0       0

SEE ALSO
     DEU 5.21, by Raphael Quinet and Brendon J. Wyber, ported  to
     GCC by Per Allansson and Per Kofod

     DOOM Specs v1.666, by Matt Fell

     dmpsmap(1)

LIMITATIONS
     When  shading  secret & damage Sectors, those with more than
     250 LineDefs are skipped.

DIAGNOSTICS
     dmpsmu can show warning messages in the following format:
          [<warning message>.]
     or terminate with error messages in the following format:
          Program Error: *** <error message> ***
     The messages are fairly self-explanatory and  are  therefore
     not repeated here.

NOTES
     The  T print flag really just emerged out of my inability to
     remember which teleporter took me to which part of  the  end
     area in DOOM E3M7 :-)

AUTHOR
     Frans P. de Vries <fpv@xymph.iaf.nl>

DMPSMU                    28 August 1995                        7

