// Emacs style mode select -*- C++ -*-
//----------------------------------------------------------------------------
//
// Copyright(C) 1998-2005 Simon Howard
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//--------------------------------------------------------------------------

/* Includes ***************************************************************/
#include<stdio.h>
#include<stdlib.h>
#include<conio.h>
#include<stdarg.h>
#include<dos.h>

/* Defines ****************************************************************/
#define KEYBOARD 1
#define MOUSE 2

/** SF_MISC.C **/

#define STR_HEX 1
#define STR_NUM 2
#define STR_FILEN 3
#define STR_TEXT 4                  // No ", though
#define STR_TEXT2 5                 // Same as STR_TEXT, but shows _ cursor
#define STR_PHONE 6                 // for phone numbers
#define STR_DIR 7                   // For directories

/* Structs ****************************************************************/
typedef struct
{
        long strafe;
        long turn;
        long walk;
        int circle_strafe;
        int controller;
} player_t;

typedef struct
{
        signed char forward;
        signed char strafe;
        signed char turn;
        unsigned char other;
} tic;

typedef struct
{
        unsigned char version;
        unsigned char skill_level;
        unsigned char episode;
        unsigned char level;
        unsigned char mode;
        unsigned char respawn;
        unsigned char fast;
        unsigned char nomonsters;
        unsigned char viewpoint;
        unsigned char player[4];
} lmptype;

/** WADDIR.C **/

typedef struct
{
        long offset;
        long length;
        char name[8];
} entry_t;


/* Globals ****************************************************************/

/** MAIN.C **/
extern lmptype lmp;
extern char loaded_lmp[50];
extern char default_lmp[50];

/** WADDIR.C **/
extern FILE *wadfp;
extern union REGS r;
extern char picentry[8];

/* Prototypes *************************************************************/

/** MAIN.C **/
void load_lmp(char *filen);
void save_lmp(char *filen);
void display_screen();
void mainmenu();
void lmp_name();

/** EDITHEAD.C **/
void display_info(int firstime);
int getinput();
void edit_header();
void more_players(int players_needed);

/** STAT.C **/
void statistics();

/** WADMENU.C **/
void wadmenu();
void import_lmp();
void extract_demo();

/** MANIP.C **/
void manipulate();
void nopause();
void nosaves();
void shorten();

/** SF_MISC.C **/
void error(char *s, ...);
int findipx(void);
char *strlwr(char *s);
char *strupr(char *s);
char *sf_text(char *def_text,int x, int y, int maxstr,int strtype);
int check_file(char filen[]);

/** WADDIR.C **/
long setwadpostodir(void);
long parsedir(char *entrytofind);
void list_entries();
char *convert_string8(entry_t entry);
entry_t findinfo(char *entrytofind);
void addentry(entry_t entry);
int entry_exist(char *entrytofind);
