// Emacs style mode select -*- C++ -*-
//----------------------------------------------------------------------------
//
// Copyright(C) 1998-2005 Simon Howard
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//--------------------------------------------------------------------------

#include "lmpit.h"

/* Globals ****************************************************************/

lmptype lmp;
char loaded_lmp[50];
char default_lmp[50]="";

/* Main *******************************************************************/
int main(int argc, char *argv[])
{
        textmode(C80);

        if(argc==1)
                lmp_name();
        else
                strcpy(loaded_lmp,argv[1]);

        load_lmp(loaded_lmp);

        mainmenu();
        textcolor(WHITE);textbackground(BLACK);
        clrscr();
}

/* Main menu *************************************************************/
void mainmenu()
{
        int temp, selected=0;
        char in1;

        redraw:
        display_screen();
        textbackground(WHITE); textcolor(BLACK);

        gotoxy(2,25); cprintf(" Press ALT-L to change LMPs ");
        
        textbackground(BLACK); textcolor(WHITE);
        gotoxy(20,9); cputs("              Main Menu                   ");
        textbackground(LIGHTGRAY); textcolor(BLACK);
        gotoxy(20,10);cputs("                                          ");
        gotoxy(20,11);cputs("                                          ");
        gotoxy(20,12);cputs("                                          ");
        gotoxy(20,13);cputs("                                          ");
        gotoxy(20,14);cputs("                                          ");
        gotoxy(20,15);cputs("                                          ");
        gotoxy(20,16);cputs("                                          ");

        textbackground(BLACK); textcolor(LIGHTGRAY);
        for(temp=10;temp<17;temp++)
        {       gotoxy(62,temp); cputs(""); }
        gotoxy(22,17);cputs("");
        textbackground(LIGHTGRAY);textcolor(DARKGRAY);
        gotoxy(23,12);cputs("                                 ");
        gotoxy(23,13);cputs("          ");

        gotoxy(23,14);cputs("                               ");
        gotoxy(23,15);cputs("     ");

        textbackground(BLACK); textcolor(WHITE);
        gotoxy(22,12);cputs(" Edit header ");
        gotoxy(45,12);cputs(" Statistics ");
        gotoxy(22,14);cputs(" LMP Manipulation ");
        gotoxy(45,14);cputs(" WAD Menu ");
        textcolor(RED);
        gotoxy(23,12);cputs("E");
        gotoxy(46,12);cputs("S");
        gotoxy(27,14);cputs("M");
        gotoxy(46,14);cputs("W");
        textcolor(WHITE);

        for(;;)
        {
                if(selected==0) gotoxy(23,12);
                if(selected==1) gotoxy(46,12);
                if(selected==2) gotoxy(27,14);
                if(selected==3) gotoxy(46,14);
                in1=getch();
                if(in1==27) break;
                if(in1==0)
                {
                        in1=getch();
                        if(in1==38)
                        {
                                lmp_name();
                                load_lmp(loaded_lmp);
                                goto redraw;
                        }
                        continue;
                }
                if(in1==9)
                {
                        selected++;
                        if(selected==4) selected=0;
                }
                if((in1==13) | (in1==' '))
                {
                        if(selected==0)
                                in1='E';
                        if(selected==1)
                                in1='S';
                        if(selected==2)
                                in1='M';
                        if(selected==3)
                                in1='W';
                }
                if((in1=='E') |(in1=='e'))
                {
                        edit_header();
                        goto redraw;
                }
                if((in1=='M') |(in1=='m'))
                {
                        manipulate();
                        goto redraw;
                }
                if((in1=='W') |(in1=='w'))
                {
                        wadmenu();
                        goto redraw;
                }
                if((in1=='S') |(in1=='s'))
                {
                        statistics();
                        goto redraw;
                }
        }
}

/* Loads the contents of a LMP file ***************************************/
void load_lmp(char *filen)
{
        FILE *fstream;

        fstream=fopen(filen,"rb");
        if(!fstream)
        {
                clrscr();
                cprintf("File not found!\r\n");
                abort();
        }
        fread(&lmp,sizeof(lmptype),1,fstream);

        fclose(fstream);
}

/* Saves the contents of a LMP file ***************************************/
void save_lmp(char *filen)
{
        FILE *fstream;

        fstream=fopen(filen,"rb+");
        if(!fstream)
        {
                cprintf("File not found!\r\n");
                abort();
        }
        fwrite(&lmp,sizeof(lmptype),1,fstream);

        fclose(fstream);
}

/* Displays the main screen ***********************************************/

void display_screen()
{
        short temp;

//        clrscr();
        gotoxy(1,1);

        textbackground(BLUE); textcolor(WHITE);
        for(temp=1;temp!=25;temp++)
                cprintf("");
        textbackground(WHITE); textcolor(BLACK);
        gotoxy(1,1);
                cprintf(" LMP-IT! v1.0 By Simon Howard                                                   ");
        gotoxy(1,25);
                cprintf("                                                                               ");
}



/* The 'input lmp name' screen ********************************************/

void lmp_name()
{
        int temp;
        char tempstr[50];

        display_screen();
        textbackground(BLACK); textcolor(WHITE);
        gotoxy(20,9); cputs("                LMP-IT!                   ");
        textbackground(LIGHTGRAY); textcolor(BLACK);
        gotoxy(20,10);cputs("  Enter the name of the LMP you wish to   ");
        gotoxy(20,11);cputs("   edit:                                  ");
        gotoxy(20,12);cputs("                                          ");
        gotoxy(20,13);cputs("                                          ");
        gotoxy(20,14);cputs("                                          ");
        textbackground(BLACK); textcolor(LIGHTGRAY);
        for(temp=10;temp<16;temp++)
        {       gotoxy(62,temp); cputs(""); }
        gotoxy(22,15);cputs("");

        textbackground(BLACK); textcolor(WHITE);
        gotoxy(23,13);cputs("                                     ");
        gotoxy(23,13);
        strcpy(loaded_lmp,sf_text(default_lmp,23,13,37,STR_DIR));
}
