// doomnet.h
// Created by Id Software for SERSETUP.EXE, 1993, 1994.
// Hacked by Russell Gilbert and others SER4.EXE, SER5.EXE, and SER6.EXE 1994.
// Hacked by Paul T. Hermann for SER5.EXE, SER6.EXE 1994.
//
// Compiled under Borland C++ 3.1 using the Compact Memory module
// Using 80386 instruction set and 80387 emualation support
// Optimizations for speed enabled
//

#define	MAXNETNODES		8			// max computers in a game
#define	MAXPLAYERS		4			// 4 players max + drones

#define	CMD_SEND	1
#define	CMD_GET	2

#define	DOOMCOM_ID		0x12345678l

#define TRUE  1
#define FALSE 0
#define EVER  ;;							// Forever loop
#define CLOCK_FREQUENCY 1843200		// 1.8432 Mhz
#define EOS '\0'							// End of String (null)
#define ESC 0x1B							// Escape key
#define BACKSPACE 0x08					// Backspace key

#define DIR_TYPE_NORMAL 0				// Types passed to dir().
#define DIR_TYPE_ZIP 1

#define UART_8250 0						// Types for uart_type.
#define UART_16550 1

typedef struct
{
	long	id;
	short	intnum;			// DOOM executes an int to send commands

// communication between DOOM and the driver
	short	command;		// CMD_SEND or CMD_GET
	short	remotenode;		// dest for send, set by get (-1 = no packet)
	short	datalength;		// bytes in doomdata to be sent / bytes read

// info common to all nodes
	short	numnodes;		// console is allways node 0
	short	ticdup;			// 1 = no duplication, 2-5 = dup for slow nets
	short	extratics;		// 1 = send a backup tic in every packet
	short	deathmatch;		// 1 = deathmatch
	short	savegame;		// -1 = new game, 0-5 = load savegame
	short	episode;		// 1-3
	short	map;			// 1-9
	short	skill;			// 1-5

// info specific to this node
	short	consoleplayer;	// 0-3 = player number
	short	numplayers;		// 1-4
	short	angleoffset;	// 1 = left, 0 = center, -1 = right
	short	drone;			// 1 = drone

// packet data to be sent
	char	data[512];
} doomcom_t;


extern doomcom_t doomcom;
extern void interrupt (*olddoomvect) ();
extern int vectorishooked;

void LaunchDOOM1_2 (void);
void LaunchDOOM (void);
void interrupt NetISR (void);

