# Watcom WMAKE script for 32-bit models

#		*Translator Definitions*
!ifndef MODEL
MODEL = r				# `r'-register, `s'-stack calling
!endif
CC = wcc386 -onatxe=12 -d1 -5$(MODEL) -zq
LINK = wlink
LINK_OPT = sys pmodew op quiet op c	# change to `sys dos4g' if you haven't got PMODE/W
LIB = wlib
LIB_OPT = /q /n /c /s /t

AWELIB = pawe32.lib

SRCDIR = ..
LIBNAME = muslib3$(MODEL).lib
OBJDIR = OBJ_3$(MODEL)\
AWEDIR = ..\AWE32

.c: $(SRCDIR)
.h: $(SRCDIR);$(AWEDIR)
.obj: $(OBJDIR)

.c.obj:
  $(CC) -fo=$(OBJDIR) $<

MUSLIB_H = deftypes.h muslib.h


$(LIBNAME): mlkernel.obj mltimdos.obj mlapi.obj mlmemory.obj mldummy.obj &
	    mlopl.obj mlopl_io.obj mlmidi.obj mlawe32.obj &
	    mlmpu401.obj mlsbmidi.obj mlsbmix.obj mlmisc.obj
  *$(LIB) $(LIB_OPT) $(LIBNAME) &
  +$(OBJDIR)mlkernel.obj &
  +$(OBJDIR)mltimdos.obj &
  +$(OBJDIR)mlapi.obj &
  +$(OBJDIR)mlmemory.obj &
  +$(OBJDIR)mldummy.obj &
  +$(OBJDIR)mlopl.obj &
  +$(OBJDIR)mlopl_io.obj &
  +$(OBJDIR)mlmidi.obj &
  +$(OBJDIR)mlawe32.obj &
  +$(OBJDIR)mlmpu401.obj &
  +$(OBJDIR)mlsbmidi.obj &
  +$(OBJDIR)mlsbmix.obj &
  +$(OBJDIR)mlmisc.obj
#  +$(AWEDIR)\$(AWELIB)

musplay: muspla3$(MODEL).exe

muspla3$(MODEL).exe: musplay.obj $(LIBNAME)
  $(LINK) $(LINK_OPT) file $(OBJDIR)musplay.obj libp $(AWEDIR) name muspla3$(MODEL)

musplay.obj: musplay.c $(MUSLIB_H)

mlkernel.obj: mlkernel.c $(MUSLIB_H)
mltimdos.obj: mltimdos.c $(MUSLIB_H)
mlapi.obj: mlapi.c $(MUSLIB_H)
mlmemory.obj: mlmemory.c $(MUSLIB_H)
mldummy.obj: mldummy.c $(MUSLIB_H)
mlopl.obj: mlopl.c $(MUSLIB_H)
mlopl_io.obj: mlopl_io.c $(MUSLIB_H)
mlmidi.obj: mlmidi.c $(MUSLIB_H)
mlawe32.obj: mlawe32.c $(MUSLIB_H) ctaweapi.h
mlmpu401.obj: mlmpu401.c $(MUSLIB_H)
mlsbmidi.obj: mlsbmidi.c $(MUSLIB_H)
mlsbmix.obj: mlsbmix.c $(MUSLIB_H)
mlmisc.obj: mlmisc.c $(MUSLIB_H)

cleanup: .SYMBOLIC
  del $(OBJDIR)ml*.obj
  del $(OBJDIR)musplay.obj
