# ------------------------------------------------------------------
# The QuestionBox is used for warning popups
# ------------------------------------------------------------------

proc QuestionBox {message bttn_list {default ""} {bitmap questhead}} {
    global questionBox

    set questionBox(value) $default
    set w .questionBox
    catch {destroy $w}

    toplevel $w
    wm title $w Alert
    wm transient $w .

    frame $w.top
    label $w.top.bitmap -bitmap $bitmap
    message $w.top.msg -text $message -aspect 350
    frame $w.border -bd 1 -relief sunken -height 2
    frame $w.bottom
    frame $w.bottom.defaultFrame -bd 2 -relief sunken

    foreach i $bttn_list {
	set j [string tolower $i]
	regsub -all { } $j {_} j
	button $w.bottom.$j -text $i -command [ format {
	    SaveGeom %s questionBox
	    destroy %s
	    set questionBox(value) {%s}
	} $w $w $i ]
	bind $w.bottom.$j <Return> "ActivateButton [list $w.bottom.$j]"
    }

    grid $w.top -gridwidth 0
    grid $w.top.bitmap -padx 6 -pady 6
    grid $w.top.msg -gridwidth 0 -padx 6 -pady 6
    grid $w.border -gridwidth 0 -weightx 1 -weighty 1 -fill both
    grid $w.bottom -gridwidth 0

    set oldFocus [focus]

    foreach i $bttn_list {
	set j [string tolower $i]
	regsub -all { } $j {_} j
	if {$default == "$i"} {
	    grid $w.bottom.defaultFrame -padx 2 -pady 6
	    grid $w.bottom.$j -in $w.bottom.defaultFrame \
	    	-padx 2 -pady 2
	    focus $w.bottom.$j
	} else {
	    grid $w.bottom.$j -padx 2 -pady 6
	}
    }
    
    if [info exists questionBox(x)] {
	RestoreGeom $w questionBox 0
    }

    tkwait visibility $w
    grab $w
    tkwait window $w
    focus $oldFocus
    update

    return $questionBox(value)
}

proc CenterWindow {w} {
    wm withdraw $w
    update idletasks
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
	- [winfo vrootx [winfo parent $w]]]
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
	- [winfo vrooty [winfo parent $w]]]
    wm geom $w +$x+$y
    wm deiconify $w
}

proc SaveGeom {frame info} {
    global $info

    scan [wm geometry $frame] %dx%d+%d+%d width height x y
    set ${info}(x) $x
    set ${info}(y) $y
    set ${info}(width) $width
    set ${info}(height) $height
}

proc RestoreGeom {frame info {restoreSize 1}} {
    upvar #0 $info v

    if [info exists v(x)] {
	if {$restoreSize && [info exists v(width)]} {
	    wm geometry $frame \
		[format %dx%d+%d+%d $v(width) $v(height) $v(x) $v(y)]
	} else {
	    wm geometry $frame [format +%d+%d $v(x) $v(y)]
	}
    }
}

proc ActivateButton {w {delay 200}} {
    tkButtonEnter $w
    tkButtonDown $w
    update idletasks
    after $delay
    set status [catch {tkButtonUp $w} message]
    if {$status} {
	global errorInfo errorCode
	set info $errorInfo
	set code $errorCode
    }
    catch {tkButtonLeave $w}
    if {$status} {
	error $message $info $code
    }
}

# ------------------------------------------------------------------
# The LoadBox is used to select an item from a list
# ------------------------------------------------------------------

proc LoadBox {title list {load "Load"} {defaultIndex 0}} {
    global loadBox

    set w .loadBox
    catch {destroy $w}

    toplevel $w
    wm title $w $title
    wm minsize $w 64 64
    wm transient $w .

    listbox $w.list -yscrollcommand "$w.sbar set"
    bind $w.list <Double-Button-1> "$w.bttn.ok invoke"

    set maxLength 0
    foreach i $list {
	$w.list insert end $i
	set length [string length $i]
	if {$length > $maxLength} {
	    set maxLength $length
	}
    }
    $w.list configure -width [expr $maxLength+10] -height 10
    catch {$w.list select from $defaultIndex}

    scrollbar $w.sbar -orient vertical -command "$w.list yview"
    frame $w.bttn
    frame $w.bttn.defaultFrame -bd 2 -relief sunken
    button $w.bttn.ok -text $load \
    	-command [format {
	    set loadBox(value) [lindex [%s.list curselection] 0]
	    SaveGeom %s loadBox
	    destroy %s
	} $w $w $w]
    button $w.bttn.cancel -text Cancel \
    	-command [format {
	    set loadBox(value) ""
	    SaveGeom %s loadBox
	    destroy %s
	} $w $w]

    bind $w.bttn.ok <Return> "ActivateButton $w.bttn.ok"

    set oldFocus [focus]
    focus $w.bttn.ok

    grid $w.list -gridwidth -1 -weightx 1 -weighty 1 -fill both
    grid $w.sbar -gridwidth 0 -fill y
    grid $w.bttn -gridwidth 0
    grid $w.bttn.defaultFrame 
    grid $w.bttn.ok -in $w.bttn.defaultFrame
    grid $w.bttn.cancel

    if [info exists loadBox(x)] {
	RestoreGeom $w loadBox 0
    }

    tkwait visibility $w
    grab $w
    tkwait window $w
    focus $oldFocus

    return $loadBox(value)
}

# ------------------------------------------------------------------
# The EntryBox is used to select an item from a list
# ------------------------------------------------------------------

proc EntryBox {title message {buttonText OK} {init {}}} {
    global entryBox

    set w .entryBox
    catch {destroy $w}

    toplevel $w
    wm title $w $title
    wm minsize $w 64 64
    wm transient $w .

    message $w.msg -text $message -aspect 350
    entry $w.entry -textvariable entryBox(value)
    set entryBox(value) $init
    frame $w.pad -height 10

    frame $w.default -bd 2 -relief sunken
    button $w.ok -text $buttonText -command [format {
	SaveGeom %s entryBox
	destroy %s
    } $w $w]
    button $w.cancel -text Cancel -command [format {
	set entryBox(value) ""
	SaveGeom %s entryBox
	destroy %s
    } $w $w]

    bind $w.entry <Return> "ActivateButton $w.ok"
    set oldFocus [focus]
    focus $w.entry

    grid $w.msg -gridwidth 0
    grid $w.entry -padx 5 -pady 5 -gridwidth 0 -fill x
    grid $w.pad -gridwidth 0
    grid $w.default -padx 5 -pady 5 -weightx 1 -anchor e
    grid $w.ok -padx 5 -pady 5 -ipadx 4 -ipady 2 \
    	-in $w.default
    grid $w.cancel -padx 5 -pady 5 -ipadx 4 -ipady 2 \
    	-weightx 1 -anchor w

    if [info exists entryBox(x)] {
	RestoreGeom $w entryBox 0
    }

    tkwait visibility $w
    grab $w
    tkwait window $w
    focus $oldFocus

    return $entryBox(value)
}

# ------------------------------------------------------------------
# The MultiEntryBox is used for single or multi line entries
# ------------------------------------------------------------------

proc ParseArgs {arguments options} {
    uplevel [format {
	aload_argv {%s} argv
	foreach option {%s} {
	    set key [lindex $option 0]
	    set value [lindex $option 1]
	    if {![info exists argv($key)]} {
		set $key $value
	    } else {
		set $key [lindex $argv($key) 0]
	    }
	}
    } $arguments $options]
}

set MultiEntryBoxOptions {
    {title {Multi Entry Box}}
    {message {}}
    {entryList {}}
    {buttonList {}}
    {default {}}
    {callback {}}
}

proc MultiEntryBox {w args} {
    global MultiEntryBoxOptions
    ParseArgs $args $MultiEntryBoxOptions

    if [winfo exists $w] {
	wm deiconify $w
	blt_win raise $w
	return
    }

    toplevel $w

    wm title $w $title
    wm minsize $w 64 64
    wm transient $w .

    upvar #0 $w info

    set info(entryList) $entryList
    set info(callback) $callback

    # Play with the window geometry
    RestoreGeom $w $w

    if ![info exists info(value)] {
	set info(value) ""
    }

    # Start making widgets
    if {$message != ""} {
	message $w.msg -text $message -aspect 350
    }
	
    frame $w.f1
    set index 0
    set last {}
    foreach entry $entryList {
	set name [string tolower $entry]
	regsub -all { } $name {_} name
	label $w.f1.$name-L -text $entry
	entry $w.f1.$name-E \
	    -textvariable [format %s(%s) $w $entry]
	grid $w.f1.$name-L -anchor w
	grid $w.f1.$name-E -weightx 1 -gridwidth 0 -fill x -padx 4
	    
	if {$last != {}} {
	    tabbind $last $w.f1.$name-E
	}
	set last $w.f1.$name-E
	incr index
    }
    set entry [lindex $entryList 0]
    if {$entry != {}} {
	set name [string tolower $entry]
	regsub -all { } $name {_} name
	set entry $w.f1.$name-E
	focus $entry
	tabbind $last $entry
    }
    if {$default != ""} {
	set name [string tolower $default]
	regsub -all { } $name {_} name
	bind $last <Return> \
	    "ActivateButton $w.buttons.defframe.$name"
    }
	
    if {$message != ""} {
	grid $w.msg -gw 0 -wx 1 -fill x
    }
    grid $w.f1 -wx 1 -gw 0 -fill x -pady 6

    frame $w.buttons
    grid $w.buttons -gw 0
    foreach button $buttonList {
	set name [string tolower $button]
	regsub -all { } $name {_} name
	if {$button == $default} {
	    set name defframe.$name
	    frame $w.buttons.defframe -bd 2 -relief sunken
	    grid $w.buttons.defframe -padx 2 -pady 2
	}

	button $w.buttons.$name -text $button \
	    -command "MultiEntryBoxCallback $w $button"
	grid $w.buttons.$name -padx 2 -pady 2
    }
}

proc MultiEntryBoxCallback {w buttonName} {
    upvar #0 $w info

    set info(value) ""
    foreach entry $info(entryList) {
	lappend info(value) $info($entry)
    }
    SaveGeom $w $w
    eval "$info(callback) [list $buttonName] [list $info(value)]"
}
