/* 
   The "fixed" RGB palettes for Doom, Heretic and Hexen type images.
   
*/
 


#include "ew.h"


/* These are the RGB palettes corresponding to the files doom_g1.pcx,
   heretic.pcx and hexeng1.pcx, respectively.
   Each array has 3*256 elements */

const char DOOM_rgb[] = { 
  '\x04', '\x04', '\x04', '\x34', '\x28', '\x18', '\x28', '\x20', '\x10',
  '\x64', '\x64', '\x64', '\xfc', '\xfc', '\xfc', '\x30', '\x30', '\x30',
  '\x24', '\x24', '\x24', '\x18', '\x18', '\x18', '\x10', '\x10', '\x10',
  '\x48', '\x50', '\x34', '\x38', '\x44', '\x20', '\x28', '\x34', '\x10',
  '\x20', '\x28', '\x04', '\x68', '\x54', '\x44', '\x60', '\x4c', '\x38',
  '\x58', '\x44', '\x30', '\xfc', '\xc4', '\xc4', '\xf8', '\xbc', '\xbc',
  '\xf4', '\xb4', '\xb4', '\xf0', '\xac', '\xac', '\xec', '\xa4', '\xa4',
  '\xe4', '\x9c', '\x9c', '\xe4', '\x94', '\x94', '\xdc', '\x8c', '\x8c',
  '\xd4', '\x84', '\x84', '\xd4', '\x7c', '\x7c', '\xcc', '\x74', '\x74',
  '\xc8', '\x70', '\x70', '\xc4', '\x68', '\x68', '\xc0', '\x60', '\x60',
  '\xb8', '\x58', '\x58', '\xb4', '\x54', '\x54', '\xb0', '\x4c', '\x4c',
  '\xac', '\x48', '\x48', '\xa4', '\x44', '\x44', '\xa0', '\x38', '\x38',
  '\x98', '\x34', '\x34', '\x98', '\x30', '\x30', '\x90', '\x28', '\x28',
  '\x8c', '\x24', '\x24', '\x84', '\x20', '\x20', '\x80', '\x18', '\x18',
  '\x78', '\x10', '\x10', '\x74', '\x10', '\x10', '\x6c', '\x10', '\x10',
  '\x68', '\x04', '\x04', '\x60', '\x04', '\x04', '\x5c', '\x04', '\x04',
  '\xfc', '\xf0', '\xe4', '\xfc', '\xe8', '\xdc', '\xfc', '\xe4', '\xd4',
  '\xfc', '\xdc', '\xc8', '\xfc', '\xd8', '\xc4', '\xfc', '\xd4', '\xb8',
  '\xfc', '\xcc', '\xb0', '\xfc', '\xc8', '\xa8', '\xfc', '\xc4', '\x98',
  '\xf8', '\xbc', '\x94', '\xf0', '\xb4', '\x8c', '\xec', '\xb0', '\x84',
  '\xe4', '\xa8', '\x7c', '\xe0', '\xa0', '\x74', '\xd8', '\x98', '\x6c',
  '\xd4', '\x98', '\x68', '\xcc', '\x94', '\x64', '\xc4', '\x8c', '\x60',
  '\xbc', '\x88', '\x5c', '\xb4', '\x84', '\x58', '\xb0', '\x7c', '\x54',
  '\xa4', '\x78', '\x50', '\x9c', '\x70', '\x4c', '\x98', '\x6c', '\x48',
  '\x90', '\x68', '\x44', '\x84', '\x60', '\x3c', '\x78', '\x5c', '\x38',
  '\x6c', '\x58', '\x34', '\x64', '\x50', '\x30', '\x58', '\x48', '\x28',
  '\x4c', '\x44', '\x24', '\x44', '\x38', '\x20', '\xf0', '\xf0', '\xf0',
  '\xec', '\xec', '\xec', '\xe4', '\xe4', '\xe4', '\xe4', '\xe4', '\xe4',
  '\xdc', '\xdc', '\xdc', '\xd4', '\xd4', '\xd4', '\xd4', '\xd4', '\xd4',
  '\xcc', '\xcc', '\xcc', '\xc4', '\xc4', '\xc4', '\xc4', '\xc4', '\xc4',
  '\xbc', '\xbc', '\xbc', '\xb8', '\xb8', '\xb8', '\xb0', '\xb0', '\xb0',
  '\xac', '\xac', '\xac', '\xa8', '\xa8', '\xa8', '\xa0', '\xa0', '\xa0',
  '\x98', '\x98', '\x98', '\x98', '\x98', '\x98', '\x90', '\x90', '\x90',
  '\x88', '\x88', '\x88', '\x84', '\x84', '\x84', '\x7c', '\x7c', '\x7c',
  '\x74', '\x74', '\x74', '\x70', '\x70', '\x70', '\x68', '\x68', '\x68',
  '\x60', '\x60', '\x60', '\x5c', '\x5c', '\x5c', '\x54', '\x54', '\x54',
  '\x50', '\x50', '\x50', '\x48', '\x48', '\x48', '\x3c', '\x3c', '\x3c',
  '\x38', '\x38', '\x38', '\x90', '\xfc', '\x88', '\x88', '\xf0', '\x80',
  '\x80', '\xe4', '\x78', '\x78', '\xd8', '\x70', '\x74', '\xcc', '\x68',
  '\x6c', '\xc0', '\x60', '\x64', '\xb0', '\x58', '\x5c', '\xa8', '\x50',
  '\x58', '\x98', '\x48', '\x50', '\x8c', '\x44', '\x48', '\x7c', '\x38',
  '\x3c', '\x6c', '\x30', '\x34', '\x5c', '\x28', '\x28', '\x4c', '\x20',
  '\x24', '\x38', '\x18', '\x18', '\x28', '\x10', '\xcc', '\xb8', '\xa4',
  '\xc4', '\xb0', '\x9c', '\xc0', '\xac', '\x98', '\xb8', '\xa4', '\x90',
  '\xb0', '\x9c', '\x88', '\xb0', '\x98', '\x84', '\xa8', '\x94', '\x7c',
  '\xa0', '\x8c', '\x74', '\x98', '\x84', '\x70', '\x94', '\x7c', '\x68',
  '\x90', '\x78', '\x64', '\x88', '\x70', '\x5c', '\x80', '\x6c', '\x58',
  '\x78', '\x64', '\x50', '\x70', '\x5c', '\x4c', '\x6c', '\x58', '\x48',
  '\xb0', '\x98', '\x7c', '\xa4', '\x90', '\x6c', '\x98', '\x84', '\x64',
  '\x90', '\x78', '\x58', '\x80', '\x6c', '\x4c', '\x74', '\x60', '\x44',
  '\x68', '\x54', '\x38', '\x5c', '\x4c', '\x30', '\x94', '\x98', '\x7c',
  '\x88', '\x8c', '\x70', '\x80', '\x84', '\x68', '\x74', '\x7c', '\x60',
  '\x6c', '\x70', '\x54', '\x60', '\x68', '\x4c', '\x58', '\x60', '\x44',
  '\x50', '\x58', '\x3c', '\xfc', '\xfc', '\x8c', '\xf0', '\xe4', '\x70',
  '\xe0', '\xc8', '\x5c', '\xd0', '\xb0', '\x48', '\xc0', '\x94', '\x34',
  '\xb0', '\x74', '\x24', '\x9c', '\x5c', '\x10', '\x8c', '\x44', '\x04',
  '\xfc', '\xfc', '\xfc', '\xfc', '\xe4', '\xe4', '\xfc', '\xc8', '\xc8',
  '\xfc', '\xb0', '\xb0', '\xfc', '\x94', '\x94', '\xfc', '\x78', '\x78',
  '\xfc', '\x58', '\x58', '\xfc', '\x34', '\x34', '\xfc', '\x04', '\x04',
  '\xf0', '\x04', '\x04', '\xe8', '\x04', '\x04', '\xe0', '\x04', '\x04',
  '\xd4', '\x04', '\x04', '\xcc', '\x04', '\x04', '\xc4', '\x04', '\x04',
  '\xb8', '\x04', '\x04', '\xb0', '\x04', '\x04', '\xa0', '\x04', '\x04',
  '\x98', '\x04', '\x04', '\x8c', '\x04', '\x04', '\x80', '\x04', '\x04',
  '\x74', '\x04', '\x04', '\x68', '\x04', '\x04', '\x5c', '\x04', '\x04',
  '\xec', '\xec', '\xfc', '\xd4', '\xd4', '\xfc', '\xbc', '\xbc', '\xfc',
  '\xa4', '\xa4', '\xfc', '\x8c', '\x8c', '\xfc', '\x6c', '\x6c', '\xfc',
  '\x50', '\x50', '\xfc', '\x30', '\x30', '\xfc', '\x04', '\x04', '\xfc',
  '\x04', '\x04', '\xe8', '\x04', '\x04', '\xd4', '\x04', '\x04', '\xc4',
  '\x04', '\x04', '\xb0', '\x04', '\x04', '\x98', '\x04', '\x04', '\x84',
  '\x04', '\x04', '\x6c', '\xfc', '\xfc', '\xfc', '\xfc', '\xf0', '\xe4',
  '\xfc', '\xe0', '\xc8', '\xfc', '\xd4', '\xb0', '\xfc', '\xc4', '\x94',
  '\xfc', '\xb4', '\x74', '\xfc', '\xa4', '\x54', '\xfc', '\x98', '\x30',
  '\xf4', '\x8c', '\x28', '\xf0', '\x88', '\x20', '\xe4', '\x80', '\x20',
  '\xe0', '\x78', '\x18', '\xd4', '\x70', '\x10', '\xd0', '\x68', '\x04',
  '\xc4', '\x60', '\x04', '\xc0', '\x5c', '\x04', '\xfc', '\xfc', '\xfc',
  '\xfc', '\xfc', '\xe0', '\xfc', '\xfc', '\xc4', '\xfc', '\xfc', '\xa4',
  '\xfc', '\xfc', '\x84', '\xfc', '\xfc', '\x60', '\xfc', '\xfc', '\x38',
  '\xfc', '\xfc', '\x04', '\xb8', '\x58', '\x04', '\xb0', '\x50', '\x04',
  '\xa8', '\x48', '\x04', '\x9c', '\x38', '\x04', '\x68', '\x54', '\x3c',
  '\x5c', '\x48', '\x30', '\x50', '\x38', '\x24', '\x48', '\x30', '\x18',
  '\x04', '\x04', '\x6c', '\x04', '\x04', '\x60', '\x04', '\x04', '\x54',
  '\x04', '\x04', '\x48', '\x04', '\x04', '\x38', '\x04', '\x04', '\x28',
  '\x04', '\x04', '\x18', '\x04', '\x04', '\x04', '\xfc', '\xb0', '\x5c',
  '\xfc', '\xec', '\x64', '\xfc', '\x94', '\xfc', '\xfc', '\x04', '\xfc',
  '\xd8', '\x04', '\xd8', '\xb0', '\x04', '\xb0', '\x88', '\x04', '\x84',
  '\xb8', '\x84', '\x84' };


const char HERETIC_rgb[] = { 
  '\x00', '\x04', '\x04', '\x00', '\x04', '\x04', '\x0c', '\x10', '\x10',
  '\x14', '\x18', '\x18', '\x1c', '\x1c', '\x1c', '\x20', '\x20', '\x20',
  '\x28', '\x28', '\x28', '\x2c', '\x2c', '\x2c', '\x30', '\x34', '\x34',
  '\x38', '\x38', '\x38', '\x3c', '\x40', '\x40', '\x44', '\x48', '\x48',
  '\x4c', '\x50', '\x50', '\x54', '\x54', '\x54', '\x58', '\x5c', '\x5c',
  '\x60', '\x60', '\x60', '\x68', '\x68', '\x68', '\x6c', '\x70', '\x70',
  '\x74', '\x78', '\x78', '\x7c', '\x7c', '\x7c', '\x80', '\x84', '\x84',
  '\x88', '\x8c', '\x8c', '\x90', '\x90', '\x90', '\x94', '\x98', '\x98',
  '\x9c', '\xa0', '\xa0', '\xa4', '\xa4', '\xa4', '\xac', '\xac', '\xac',
  '\xb0', '\xb4', '\xb4', '\xb8', '\xb8', '\xb8', '\xbc', '\xbc', '\xbc',
  '\xc0', '\xc0', '\xc0', '\xc4', '\xc8', '\xc8', '\xcc', '\xcc', '\xcc',
  '\xd0', '\xd4', '\xd4', '\xd8', '\xdc', '\xdc', '\xe4', '\xe4', '\xe4',
  '\x2c', '\x30', '\x30', '\x34', '\x38', '\x38', '\x3c', '\x40', '\x40',
  '\x44', '\x48', '\x48', '\x4c', '\x54', '\x50', '\x54', '\x5c', '\x58',
  '\x60', '\x64', '\x60', '\x68', '\x70', '\x64', '\x70', '\x78', '\x6c',
  '\x78', '\x80', '\x74', '\x80', '\x88', '\x7c', '\x88', '\x90', '\x84',
  '\x90', '\x98', '\x8c', '\x98', '\xa4', '\x94', '\xa0', '\xa8', '\xa0',
  '\xa8', '\xb0', '\xa8', '\x10', '\x10', '\x20', '\x14', '\x18', '\x28',
  '\x20', '\x20', '\x38', '\x2c', '\x30', '\x48', '\x3c', '\x40', '\x58',
  '\x4c', '\x50', '\x68', '\x60', '\x60', '\x7c', '\x6c', '\x70', '\x88',
  '\x84', '\x84', '\x9c', '\x90', '\x94', '\xa4', '\xa0', '\xa4', '\xb4',
  '\xac', '\xb0', '\xbc', '\xb8', '\xbc', '\xc0', '\xc8', '\xc8', '\xc8',
  '\x18', '\x10', '\x08', '\x20', '\x14', '\x0c', '\x2c', '\x18', '\x10',
  '\x34', '\x1c', '\x10', '\x38', '\x20', '\x10', '\x40', '\x24', '\x14',
  '\x48', '\x28', '\x14', '\x4c', '\x2c', '\x18', '\x54', '\x30', '\x18',
  '\x5c', '\x38', '\x1c', '\x64', '\x3c', '\x20', '\x6c', '\x44', '\x24',
  '\x74', '\x4c', '\x2c', '\x80', '\x54', '\x30', '\x84', '\x58', '\x38',
  '\x8c', '\x60', '\x3c', '\x9c', '\x68', '\x44', '\xa0', '\x70', '\x48',
  '\xac', '\x78', '\x54', '\xb4', '\x80', '\x54', '\xbc', '\x88', '\x5c',
  '\xc0', '\x90', '\x68', '\xc4', '\x98', '\x70', '\xc4', '\x9c', '\x7c',
  '\xc8', '\xa4', '\x88', '\xcc', '\xac', '\x90', '\xd0', '\xb0', '\x9c',
  '\xd4', '\xb8', '\xa4', '\xd4', '\xc0', '\xb0', '\x38', '\x24', '\x0c',
  '\x44', '\x30', '\x10', '\x4c', '\x38', '\x18', '\x54', '\x3c', '\x1c',
  '\x5c', '\x44', '\x24', '\x60', '\x4c', '\x2c', '\x6c', '\x58', '\x34',
  '\x78', '\x60', '\x38', '\x84', '\x6c', '\x44', '\x90', '\x74', '\x4c',
  '\x98', '\x7c', '\x54', '\xa0', '\x84', '\x5c', '\xa8', '\x8c', '\x64',
  '\xac', '\x90', '\x68', '\xb4', '\x98', '\x70', '\xb8', '\xa0', '\x78',
  '\x20', '\x14', '\x04', '\x28', '\x18', '\x04', '\x34', '\x1c', '\x08',
  '\x3c', '\x20', '\x04', '\x44', '\x20', '\x04', '\x4c', '\x24', '\x00',
  '\x54', '\x2c', '\x04', '\x64', '\x30', '\x00', '\x70', '\x38', '\x08',
  '\x7c', '\x44', '\x08', '\x88', '\x4c', '\x10', '\x90', '\x58', '\x14',
  '\x94', '\x5c', '\x18', '\xa0', '\x68', '\x20', '\xa8', '\x70', '\x14',
  '\xb4', '\x7c', '\x18', '\xc4', '\x84', '\x1c', '\xd0', '\x90', '\x18',
  '\xd8', '\x9c', '\x2c', '\xe0', '\xa8', '\x34', '\xe0', '\xb0', '\x40',
  '\xe0', '\xb4', '\x4c', '\xe0', '\xbc', '\x58', '\xe0', '\xc0', '\x64',
  '\xe0', '\xc8', '\x70', '\xdc', '\xcc', '\x7c', '\x8c', '\x30', '\x04',
  '\x98', '\x3c', '\x04', '\xa4', '\x50', '\x04', '\xbc', '\x6c', '\x04',
  '\xd0', '\x94', '\x04', '\xdc', '\xac', '\x04', '\xe4', '\xc0', '\x28',
  '\xe4', '\xe4', '\x00', '\x3c', '\x00', '\x00', '\x44', '\x00', '\x00',
  '\x50', '\x00', '\x00', '\x5c', '\x00', '\x00', '\x64', '\x00', '\x00',
  '\x70', '\x00', '\x00', '\x7c', '\x00', '\x00', '\x88', '\x00', '\x00',
  '\x94', '\x00', '\x00', '\xa0', '\x00', '\x00', '\xa8', '\x00', '\x00',
  '\xb4', '\x00', '\x00', '\xc0', '\x00', '\x00', '\xc8', '\x00', '\x00',
  '\xd4', '\x00', '\x00', '\xe4', '\x00', '\x00', '\xe4', '\x30', '\x30',
  '\xe4', '\x44', '\x44', '\xe4', '\x58', '\x58', '\xe4', '\x70', '\x70',
  '\xe4', '\x8c', '\x8c', '\xe4', '\xa0', '\xa0', '\xe4', '\xb4', '\xb4',
  '\xe4', '\xc0', '\xc0', '\x34', '\x0c', '\x50', '\x48', '\x08', '\x60',
  '\x5c', '\x08', '\x74', '\x70', '\x00', '\x80', '\x88', '\x00', '\xa0',
  '\xa4', '\x00', '\xc8', '\xc0', '\x28', '\xe0', '\xc8', '\x6c', '\xd8',
  '\x20', '\x08', '\x74', '\x34', '\x20', '\x84', '\x48', '\x38', '\x94',
  '\x5c', '\x50', '\xa4', '\x70', '\x68', '\xb4', '\x84', '\x80', '\xc4',
  '\x98', '\x98', '\xd4', '\xac', '\xb0', '\xe4', '\x00', '\x04', '\x28',
  '\x00', '\x08', '\x2c', '\x04', '\x08', '\x34', '\x00', '\x08', '\x3c',
  '\x00', '\x08', '\x48', '\x00', '\x04', '\x50', '\x00', '\x04', '\x58',
  '\x00', '\x04', '\x60', '\x00', '\x08', '\x6c', '\x00', '\x08', '\x7c',
  '\x04', '\x08', '\x90', '\x0c', '\x10', '\xa4', '\x1c', '\x24', '\xb4',
  '\x30', '\x38', '\xc4', '\x48', '\x48', '\xe4', '\x48', '\x60', '\xe0',
  '\x48', '\x7c', '\xe0', '\x48', '\x94', '\xe0', '\x48', '\xb0', '\xe0',
  '\x40', '\xc4', '\xe0', '\x48', '\xd4', '\xe0', '\x4c', '\xe0', '\xe0',
  '\x88', '\xe0', '\xe0', '\xa8', '\xe0', '\xdc', '\x08', '\x18', '\x08',
  '\x10', '\x20', '\x0c', '\x14', '\x30', '\x10', '\x1c', '\x3c', '\x18',
  '\x24', '\x4c', '\x18', '\x28', '\x58', '\x20', '\x30', '\x68', '\x28',
  '\x38', '\x78', '\x2c', '\x3c', '\x84', '\x34', '\x44', '\x90', '\x38',
  '\x48', '\x9c', '\x40', '\x50', '\xac', '\x48', '\x54', '\xb8', '\x50',
  '\x5c', '\xc8', '\x58', '\x64', '\xd8', '\x5c', '\x68', '\xe4', '\x64',
  '\x14', '\x1c', '\x18', '\x18', '\x20', '\x18', '\x1c', '\x28', '\x1c',
  '\x20', '\x30', '\x20', '\x24', '\x34', '\x28', '\x28', '\x38', '\x2c',
  '\x2c', '\x40', '\x30', '\x34', '\x44', '\x34', '\x38', '\x4c', '\x38',
  '\x3c', '\x54', '\x3c', '\x44', '\x58', '\x40', '\x44', '\x5c', '\x44',
  '\x4c', '\x64', '\x48', '\x50', '\x68', '\x4c', '\x54', '\x70', '\x50',
  '\x5c', '\x78', '\x58', '\xe4', '\xc8', '\x00', '\xe4', '\xac', '\x00',
  '\xe4', '\x90', '\x00', '\xe4', '\x74', '\x00', '\xe4', '\x58', '\x00',
  '\xe4', '\x38', '\x00', '\xd8', '\x10', '\x04', '\x30', '\x00', '\x00',
  '\x28', '\x00', '\x00', '\x24', '\x00', '\x00', '\x14', '\x00', '\x00',
  '\x0c', '\x10', '\x10', '\x08', '\x0c', '\x0c', '\x04', '\x08', '\x08',
  '\xe4', '\xe4', '\xe4' };

const char E_HERETIC_rgb[] = {
  '\x00', '\x00', '\x00', '\x28', '\x2c', '\x70', '\x94', '\x84', '\x7c', 
  '\x04', '\x20', '\x5c', '\x24', '\x38', '\x58', '\xac', '\xa4', '\x6c', 
  '\x1c', '\x24', '\x44', '\x14', '\x28', '\x74', '\x90', '\x78', '\x80', 
  '\xa0', '\x94', '\x6c', '\x5c', '\x50', '\x68', '\x18', '\x24', '\x50', 
  '\x00', '\x1c', '\x68', '\x20', '\x28', '\x58', '\x00', '\x18', '\x64', 
  '\x20', '\x28', '\x54', '\x18', '\x24', '\x58', '\x10', '\x1c', '\x4c', 
  '\x10', '\x1c', '\x50', '\x14', '\x20', '\x50', '\x10', '\x20', '\x68', 
  '\x18', '\x20', '\x4c', '\x1c', '\x28', '\x54', '\x20', '\x2c', '\x60', 
  '\x28', '\x30', '\x60', '\x28', '\x30', '\x58', '\x08', '\x1c', '\x68', 
  '\x14', '\x20', '\x58', '\x1c', '\x28', '\x68', '\x08', '\x18', '\x4c', 
  '\x18', '\x24', '\x60', '\x18', '\x24', '\x68', '\x14', '\x20', '\x4c', 
  '\x20', '\x24', '\x50', '\x1c', '\x28', '\x70', '\x1c', '\x28', '\x58', 
  '\x28', '\x2c', '\x54', '\x20', '\x2c', '\x68', '\x14', '\x20', '\x64', 
  '\x0c', '\x18', '\x50', '\x10', '\x1c', '\x58', '\x00', '\x18', '\x58', 
  '\x1c', '\x28', '\x60', '\x08', '\x1c', '\x64', '\x28', '\x2c', '\x58', 
  '\x0c', '\x20', '\x68', '\x28', '\x28', '\x60', '\x30', '\x34', '\x64', 
  '\x30', '\x34', '\x58', '\x30', '\x38', '\x64', '\x34', '\x38', '\x5c', 
  '\x28', '\x30', '\x68', '\x04', '\x18', '\x54', '\x0c', '\x1c', '\x58', 
  '\x10', '\x24', '\x70', '\x00', '\x14', '\x4c', '\x28', '\x30', '\x54', 
  '\x24', '\x30', '\x58', '\x3c', '\x40', '\x60', '\x38', '\x3c', '\x60', 
  '\x34', '\x38', '\x68', '\x38', '\x38', '\x5c', '\x3c', '\x40', '\x68', 
  '\x00', '\x14', '\x50', '\x20', '\x24', '\x4c', '\x00', '\x1c', '\x70', 
  '\x30', '\x2c', '\x54', '\x38', '\x3c', '\x68', '\x04', '\x18', '\x4c', 
  '\x30', '\x30', '\x54', '\x40', '\x44', '\x60', '\x20', '\x30', '\x54', 
  '\x20', '\x28', '\x4c', '\x20', '\x24', '\x64', '\x4c', '\x50', '\x70', 
  '\x0c', '\x20', '\x60', '\x20', '\x24', '\x58', '\x20', '\x2c', '\x70', 
  '\x24', '\x30', '\x60', '\x30', '\x30', '\x68', '\x24', '\x30', '\x68', 
  '\x38', '\x34', '\x60', '\x38', '\x34', '\x58', '\x44', '\x48', '\x68', 
  '\x08', '\x20', '\x58', '\x50', '\x54', '\x70', '\x38', '\x30', '\x54', 
  '\x40', '\x44', '\x68', '\x48', '\x4c', '\x6c', '\x1c', '\x28', '\x4c', 
  '\x28', '\x28', '\x68', '\x48', '\x38', '\x64', '\x14', '\x28', '\x50', 
  '\x80', '\x80', '\x98', '\x40', '\x3c', '\x58', '\x0c', '\x20', '\x70', 
  '\x48', '\x38', '\x58', '\x08', '\x14', '\x4c', '\x58', '\x5c', '\x78', 
  '\x0c', '\x20', '\x50', '\x40', '\x38', '\x64', '\x30', '\x28', '\x58', 
  '\x04', '\x20', '\x68', '\x40', '\x30', '\x50', '\x30', '\x20', '\x54', 
  '\x44', '\x48', '\x70', '\x44', '\x48', '\x64', '\x48', '\x44', '\x60', 
  '\x0c', '\x20', '\x4c', '\x10', '\x1c', '\x68', '\x18', '\x1c', '\x48', 
  '\x60', '\x64', '\x80', '\x64', '\x68', '\x84', '\x28', '\x28', '\x48', 
  '\x28', '\x24', '\x60', '\x34', '\x28', '\x4c', '\x48', '\x34', '\x50', 
  '\x10', '\x1c', '\x64', '\x18', '\x24', '\x70', '\x1c', '\x28', '\x78', 
  '\x18', '\x1c', '\x50', '\x28', '\x24', '\x50', '\x28', '\x24', '\x4c', 
  '\x78', '\x7c', '\x90', '\x48', '\x40', '\x58', '\x48', '\x4c', '\x70', 
  '\x5c', '\x60', '\x7c', '\x70', '\x74', '\x8c', '\x50', '\x38', '\x50', 
  '\x50', '\x3c', '\x60', '\x58', '\x40', '\x58', '\x30', '\x28', '\x60', 
  '\x50', '\x20', '\x54', '\x68', '\x6c', '\x88', '\x88', '\x88', '\xa0', 
  '\x60', '\x44', '\x58', '\x58', '\x40', '\x64', '\x40', '\x38', '\x68', 
  '\x58', '\x3c', '\x50', '\x54', '\x58', '\x74', '\x28', '\x30', '\x70', 
  '\x38', '\x20', '\x54', '\x40', '\x38', '\x54', '\x48', '\x38', '\x54', 
  '\x40', '\x24', '\x54', '\x60', '\x40', '\x50', '\x50', '\x3c', '\x58', 
  '\x44', '\x40', '\x5c', '\x5c', '\x20', '\x54', '\x50', '\x54', '\x78', 
  '\x94', '\x5c', '\x5c', '\x14', '\x28', '\x58', '\x50', '\x44', '\x58', 
  '\x68', '\x48', '\x58', '\x04', '\x20', '\x60', '\x28', '\x24', '\x68', 
  '\x70', '\x4c', '\x58', '\x88', '\x5c', '\x64', '\x40', '\x34', '\x58', 
  '\x68', '\x54', '\x5c', '\x1c', '\x30', '\x50', '\x40', '\x34', '\x60', 
  '\x64', '\x48', '\x60', '\x9c', '\x60', '\x5c', '\x50', '\x28', '\x58', 
  '\x7c', '\x50', '\x58', '\x08', '\x1c', '\x70', '\xb4', '\x70', '\x64', 
  '\x38', '\x40', '\x5c', '\x54', '\x48', '\x60', '\xcc', '\x7c', '\x68', 
  '\x38', '\x34', '\x68', '\x20', '\x2c', '\x78', '\x88', '\x58', '\x58', 
  '\x20', '\x24', '\x68', '\x74', '\x78', '\x90', '\x9c', '\x68', '\x60', 
  '\xa8', '\x6c', '\x60', '\x7c', '\x50', '\x60', '\x58', '\x48', '\x6c', 
  '\x70', '\x50', '\x64', '\x90', '\x6c', '\x60', '\x68', '\x44', '\x54', 
  '\x38', '\x2c', '\x50', '\x50', '\x40', '\x68', '\x7c', '\x50', '\x50', 
  '\x64', '\x54', '\x6c', '\x30', '\x38', '\x70', '\x74', '\x58', '\x58', 
  '\x2c', '\x38', '\x68', '\xcc', '\x9c', '\x6c', '\x18', '\x1c', '\x5c', 
  '\x3c', '\x40', '\x70', '\xd0', '\x90', '\x6c', '\x30', '\x38', '\x54', 
  '\x28', '\x24', '\x58', '\xac', '\x7c', '\x64', '\x38', '\x38', '\x54', 
  '\x70', '\x58', '\x64', '\x9c', '\x70', '\x6c', '\x9c', '\x60', '\x64', 
  '\x40', '\x30', '\x48', '\x60', '\x50', '\x60', '\xb8', '\x84', '\x68', 
  '\x7c', '\x60', '\x68', '\xc4', '\xbc', '\x74', '\x1c', '\x30', '\x58', 
  '\xcc', '\x88', '\x68', '\x70', '\x48', '\x50', '\xcc', '\xcc', '\x7c', 
  '\x80', '\x5c', '\x58', '\x08', '\x14', '\x50', '\x2c', '\x38', '\x58', 
  '\x7c', '\x5c', '\x60', '\x54', '\x40', '\x54', '\xa0', '\x74', '\x60', 
  '\x2c', '\x38', '\x64', '\xac', '\x7c', '\x74', '\x60', '\x48', '\x68', 
  '\x10', '\x2c', '\x60', '\x50', '\x38', '\x4c', '\x0c', '\x28', '\x60', 
  '\x58', '\x48', '\x58', '\xc0', '\x8c', '\x68', '\xbc', '\xac', '\x70', 
  '\x18', '\x1c', '\x60', '\x98', '\x84', '\x64', '\x48', '\x40', '\x68', 
  '\x8c', '\x70', '\x6c', '\xbc', '\x88', '\x74', '\xcc', '\xac', '\x70', 
  '\x38', '\x28', '\x58', '\x30', '\x30', '\x74', '\x38', '\x30', '\x48', 
  '\x14', '\x24', '\x78', '\xc4', '\x70', '\x60', '\x00', '\x14', '\x58', 
  '\x80', '\x70', '\x60', '\xa8', '\x8c', '\x68', '\xc0', '\x8c', '\x78', 
  '\x34', '\x30', '\x4c', '\x38', '\x3c', '\x70', '\x7c', '\x74', '\x70', 
  '\x20', '\x3c', '\x54', '\x14', '\x28', '\x4c', '\x6c', '\x2c', '\x58', 
  '\x24', '\x30', '\x4c', '\x34', '\x40', '\x60', '\x70', '\x2c', '\x5c', 
  '\x6c', '\x60', '\x68', '\x20', '\x24', '\x44', '\x68', '\x68', '\x68', 
  '\x34', '\x40', '\x5c', '\x10', '\x1c', '\x44', '\x20', '\x1c', '\x54', 
  '\xfc', '\xfc', '\xfc' };


const char HEXEN_rgb[] = {
  '\x04', '\x04', '\x04', '\x08', '\x08', '\x08', '\x14', '\x14', '\x14',
  '\x18', '\x18', '\x18', '\x24', '\x24', '\x24', '\x24', '\x24', '\x24',
  '\x2c', '\x2c', '\x2c', '\x30', '\x30', '\x30', '\x38', '\x38', '\x38',
  '\x3c', '\x3c', '\x3c', '\x44', '\x44', '\x44', '\x4c', '\x4c', '\x4c',
  '\x50', '\x50', '\x50', '\x58', '\x58', '\x58', '\x5c', '\x5c', '\x5c',
  '\x60', '\x60', '\x60', '\x68', '\x68', '\x68', '\x6c', '\x6c', '\x6c',
  '\x74', '\x74', '\x74', '\x7c', '\x7c', '\x7c', '\x84', '\x84', '\x84',
  '\x8c', '\x8c', '\x8c', '\x94', '\x94', '\x94', '\x9c', '\x9c', '\x9c',
  '\xa4', '\xa4', '\xa4', '\xac', '\xac', '\xac', '\xb8', '\xb8', '\xb8',
  '\xc0', '\xc0', '\xc0', '\xc8', '\xc8', '\xc8', '\xd0', '\xd0', '\xd0',
  '\xd8', '\xd8', '\xd8', '\xe0', '\xe0', '\xe0', '\xe8', '\xe8', '\xe8',
  '\x24', '\x28', '\x24', '\x30', '\x30', '\x30', '\x3c', '\x3c', '\x3c',
  '\x48', '\x48', '\x48', '\x50', '\x54', '\x50', '\x58', '\x5c', '\x58',
  '\x64', '\x68', '\x60', '\x6c', '\x70', '\x6c', '\x78', '\x7c', '\x74',
  '\x80', '\x84', '\x7c', '\x88', '\x8c', '\x84', '\x90', '\x98', '\x8c',
  '\x98', '\xa0', '\x94', '\xa0', '\xa8', '\x9c', '\xac', '\xb4', '\xa4',
  '\xb4', '\xbc', '\xac', '\xbc', '\xc4', '\xb8', '\xc4', '\xc8', '\xc0',
  '\x1c', '\x24', '\x1c', '\x24', '\x2c', '\x24', '\x28', '\x34', '\x28',
  '\x2c', '\x3c', '\x2c', '\x34', '\x40', '\x34', '\x38', '\x4c', '\x38',
  '\x3c', '\x54', '\x3c', '\x48', '\x58', '\x40', '\x4c', '\x60', '\x48',
  '\x50', '\x68', '\x50', '\x58', '\x6c', '\x54', '\x5c', '\x74', '\x58',
  '\x64', '\x7c', '\x5c', '\x68', '\x80', '\x60', '\x6c', '\x84', '\x64',
  '\x74', '\x8c', '\x6c', '\x1c', '\x18', '\x2c', '\x28', '\x24', '\x38',
  '\x30', '\x2c', '\x44', '\x3c', '\x38', '\x50', '\x48', '\x44', '\x58',
  '\x50', '\x50', '\x64', '\x5c', '\x58', '\x70', '\x64', '\x64', '\x78',
  '\x70', '\x6c', '\x84', '\x78', '\x78', '\x8c', '\x80', '\x80', '\x98',
  '\x8c', '\x8c', '\xa0', '\x94', '\x94', '\xac', '\x9c', '\x9c', '\xb4',
  '\x48', '\x30', '\x10', '\x58', '\x3c', '\x18', '\x60', '\x48', '\x20',
  '\x6c', '\x50', '\x28', '\x74', '\x58', '\x30', '\x78', '\x60', '\x38',
  '\x84', '\x6c', '\x40', '\x94', '\x78', '\x48', '\xa0', '\x80', '\x58',
  '\xac', '\x8c', '\x60', '\xb4', '\x94', '\x68', '\xbc', '\x9c', '\x70',
  '\xc4', '\xa4', '\x78', '\xc8', '\xac', '\x80', '\xd0', '\xb0', '\x88',
  '\xd4', '\xb8', '\x90', '\x24', '\x14', '\x0c', '\x30', '\x1c', '\x10',
  '\x3c', '\x24', '\x14', '\x48', '\x28', '\x14', '\x4c', '\x2c', '\x18',
  '\x54', '\x30', '\x18', '\x60', '\x34', '\x18', '\x64', '\x38', '\x20',
  '\x6c', '\x3c', '\x24', '\x74', '\x48', '\x28', '\x80', '\x50', '\x2c',
  '\x84', '\x58', '\x30', '\x8c', '\x60', '\x38', '\x98', '\x68', '\x3c',
  '\xa0', '\x70', '\x48', '\xa8', '\x78', '\x4c', '\xb8', '\x80', '\x54',
  '\xbc', '\x88', '\x5c', '\xc4', '\x90', '\x68', '\xd0', '\x98', '\x68',
  '\xd8', '\xa0', '\x74', '\xdc', '\xa8', '\x80', '\xe0', '\xb0', '\x88',
  '\xe0', '\xb8', '\x94', '\xe4', '\xbc', '\xa0', '\x30', '\x1c', '\x08',
  '\x38', '\x20', '\x08', '\x44', '\x24', '\x08', '\x50', '\x2c', '\x08',
  '\x58', '\x2c', '\x04', '\x60', '\x30', '\x00', '\x6c', '\x38', '\x04',
  '\x7c', '\x40', '\x00', '\x88', '\x4c', '\x08', '\x98', '\x58', '\x0c',
  '\xa4', '\x60', '\x18', '\xac', '\x6c', '\x1c', '\xb0', '\x74', '\x24',
  '\xbc', '\x7c', '\x28', '\xc4', '\x88', '\x1c', '\xd0', '\x94', '\x20',
  '\xe0', '\x9c', '\x24', '\xec', '\xa8', '\x20', '\xf4', '\xb4', '\x38',
  '\xfc', '\xc0', '\x44', '\xfc', '\xc8', '\x50', '\xfc', '\xcc', '\x60',
  '\xfc', '\xd4', '\x6c', '\xfc', '\xe0', '\x84', '\x04', '\x08', '\x34',
  '\x04', '\x08', '\x3c', '\x08', '\x0c', '\x44', '\x04', '\x08', '\x4c',
  '\x04', '\x08', '\x5c', '\x00', '\x08', '\x64', '\x00', '\x08', '\x6c',
  '\x00', '\x08', '\x74', '\x08', '\x08', '\x84', '\x04', '\x08', '\x94',
  '\x1c', '\x20', '\xa0', '\x30', '\x34', '\xb0', '\x44', '\x48', '\xbc',
  '\x54', '\x58', '\xc8', '\x68', '\x68', '\xd8', '\x78', '\x7c', '\xe4',
  '\x88', '\x8c', '\xf0', '\x9c', '\x9c', '\xfc', '\x28', '\x08', '\x08',
  '\x30', '\x00', '\x00', '\x38', '\x00', '\x00', '\x40', '\x00', '\x00',
  '\x50', '\x00', '\x00', '\x5c', '\x00', '\x00', '\x68', '\x00', '\x00',
  '\x74', '\x00', '\x00', '\x80', '\x00', '\x00', '\x88', '\x00', '\x00',
  '\x94', '\x00', '\x00', '\xa4', '\x00', '\x00', '\xb0', '\x00', '\x00',
  '\xc0', '\x00', '\x00', '\xd0', '\x00', '\x00', '\xe0', '\x00', '\x00',
  '\xec', '\x00', '\x00', '\xfc', '\x00', '\x00', '\xfc', '\x38', '\x38',
  '\xfc', '\x68', '\x68', '\xfc', '\x94', '\x94', '\xfc', '\xb4', '\xb4',
  '\x1c', '\x18', '\x08', '\x14', '\x20', '\x0c', '\x18', '\x2c', '\x10',
  '\x1c', '\x34', '\x14', '\x20', '\x3c', '\x18', '\x24', '\x44', '\x1c',
  '\x28', '\x4c', '\x20', '\x2c', '\x54', '\x24', '\x30', '\x5c', '\x28',
  '\x38', '\x60', '\x30', '\x38', '\x6c', '\x30', '\x3c', '\x74', '\x34',
  '\x48', '\x84', '\x3c', '\x50', '\x94', '\x44', '\x58', '\xa4', '\x4c',
  '\x60', '\xb4', '\x54', '\x68', '\xc4', '\x5c', '\xa4', '\x3c', '\x08',
  '\xb0', '\x4c', '\x04', '\xc0', '\x60', '\x08', '\xd8', '\x80', '\x08',
  '\xec', '\x9c', '\x08', '\xfc', '\xb8', '\x08', '\xfc', '\xc8', '\x24',
  '\xfc', '\xdc', '\x38', '\x08', '\x90', '\x08', '\x0c', '\xb8', '\x0c',
  '\x04', '\xdc', '\x04', '\x04', '\xec', '\x04', '\x34', '\xfc', '\x34',
  '\x84', '\xfc', '\x84', '\x04', '\x04', '\xc0', '\x14', '\x34', '\xe0',
  '\x24', '\x5c', '\xe4', '\x34', '\x80', '\xec', '\x40', '\xa8', '\xf0',
  '\x50', '\xcc', '\xf4', '\x5c', '\xec', '\xfc', '\xf4', '\x14', '\x04',
  '\xfc', '\x4c', '\x00', '\xfc', '\x6c', '\x00', '\xfc', '\x88', '\x00',
  '\xfc', '\xa8', '\x00', '\xfc', '\xc8', '\x24', '\xfc', '\xe0', '\x00',
  '\x34', '\x14', '\x4c', '\x48', '\x14', '\x64', '\x64', '\x14', '\x84',
  '\x84', '\x18', '\xa4', '\xa0', '\x18', '\xc4', '\xb8', '\x18', '\xe0',
  '\xcc', '\x54', '\xe8', '\xdc', '\x8c', '\xf4', '\xec', '\xb0', '\xfc',
  '\x48', '\x18', '\x18', '\x64', '\x2c', '\x2c', '\x80', '\x44', '\x3c',
  '\x9c', '\x58', '\x4c', '\xb8', '\x6c', '\x60', '\xd0', '\x80', '\x70',
  '\x54', '\x40', '\x04', '\x5c', '\x4c', '\x08', '\x6c', '\x54', '\x00',
  '\x78', '\x5c', '\x00', '\x84', '\x64', '\x00', '\x8c', '\x6c', '\x00',
  '\xa0', '\x7c', '\x04', '\xbc', '\x94', '\x04', '\xd8', '\xa8', '\x08',
  '\xfc', '\xfc', '\xfc' };

const char STRIFE_rgb[] = {
  '\x04', '\x04', '\x04', '\xec', '\xe8', '\xe8', '\xe4', '\xe4', '\xe4', 
  '\xe0', '\xdc', '\xdc', '\xd8', '\xd4', '\xd4', '\xd4', '\xd0', '\xd0', 
  '\xcc', '\xcc', '\xcc', '\xc4', '\xc4', '\xc4', '\xc4', '\xc0', '\xc0', 
  '\xbc', '\xb8', '\xb8', '\xb4', '\xb0', '\xb0', '\xb0', '\xac', '\xac', 
  '\xa8', '\xa8', '\xa8', '\xa0', '\xa0', '\xa0', '\x98', '\x98', '\x98', 
  '\x94', '\x94', '\x94', '\x90', '\x8c', '\x8c', '\x88', '\x88', '\x88', 
  '\x80', '\x80', '\x80', '\x78', '\x78', '\x78', '\x70', '\x70', '\x70', 
  '\x68', '\x68', '\x68', '\x60', '\x60', '\x60', '\x5c', '\x58', '\x58', 
  '\x54', '\x54', '\x54', '\x4c', '\x4c', '\x4c', '\x44', '\x44', '\x44', 
  '\x38', '\x38', '\x38', '\x30', '\x30', '\x30', '\x24', '\x24', '\x24', 
  '\x18', '\x18', '\x18', '\x10', '\x10', '\x10', '\xc8', '\xcc', '\xc4', 
  '\xc4', '\xc4', '\xbc', '\xb8', '\xc4', '\xb0', '\xb4', '\xbc', '\xa8', 
  '\xb0', '\xb8', '\xa0', '\xa8', '\xb0', '\x98', '\xa0', '\xb0', '\x90', 
  '\x98', '\xa8', '\x84', '\x98', '\xa4', '\x80', '\x90', '\x9c', '\x74', 
  '\x8c', '\x98', '\x6c', '\x84', '\x94', '\x64', '\x80', '\x90', '\x5c', 
  '\x7c', '\x88', '\x58', '\x74', '\x84', '\x50', '\x70', '\x7c', '\x48', 
  '\x6c', '\x78', '\x44', '\x64', '\x70', '\x38', '\x60', '\x6c', '\x34', 
  '\x5c', '\x64', '\x30', '\x58', '\x60', '\x28', '\x54', '\x58', '\x24', 
  '\x4c', '\x54', '\x20', '\x48', '\x4c', '\x18', '\x44', '\x48', '\x10', 
  '\x3c', '\x44', '\x10', '\x34', '\x38', '\x10', '\x30', '\x34', '\x04', 
  '\x28', '\x28', '\x04', '\x20', '\x24', '\x04', '\x18', '\x18', '\x04', 
  '\x10', '\x10', '\x04', '\xe4', '\x44', '\x44', '\xd4', '\x38', '\x38', 
  '\xcc', '\x34', '\x34', '\xc0', '\x30', '\x30', '\xb4', '\x28', '\x28', 
  '\xa8', '\x24', '\x24', '\x9c', '\x20', '\x20', '\x90', '\x18', '\x18', 
  '\x84', '\x10', '\x10', '\x74', '\x10', '\x10', '\x68', '\x04', '\x04', 
  '\x58', '\x04', '\x04', '\x4c', '\x04', '\x04', '\x3c', '\x04', '\x04', 
  '\x28', '\x04', '\x04', '\x18', '\x04', '\x04', '\xf0', '\xec', '\x04', 
  '\xec', '\xdc', '\x04', '\xe0', '\xc4', '\x04', '\xd4', '\xac', '\x04', 
  '\xc4', '\x98', '\x04', '\xb8', '\x80', '\x04', '\xac', '\x6c', '\x04', 
  '\x9c', '\x58', '\x04', '\x90', '\x48', '\x04', '\x80', '\x38', '\x04', 
  '\x70', '\x28', '\x04', '\x60', '\x18', '\x04', '\x50', '\x10', '\x04', 
  '\x3c', '\x04', '\x04', '\x28', '\x04', '\x04', '\x18', '\x04', '\x04', 
  '\xc4', '\xec', '\x98', '\xb4', '\xe0', '\x88', '\xa4', '\xd4', '\x78', 
  '\x98', '\xc4', '\x68', '\x84', '\xbc', '\x5c', '\x74', '\xb0', '\x50', 
  '\x64', '\xa0', '\x44', '\x58', '\x94', '\x38', '\x48', '\x88', '\x30', 
  '\x38', '\x78', '\x24', '\x28', '\x68', '\x18', '\x20', '\x5c', '\x10', 
  '\x10', '\x4c', '\x10', '\x04', '\x38', '\x04', '\x04', '\x24', '\x04', 
  '\x04', '\x10', '\x04', '\xd4', '\xd8', '\xfc', '\xc4', '\xc8', '\xf0', 
  '\xb4', '\xbc', '\xe4', '\xac', '\xb0', '\xd4', '\x9c', '\xa0', '\xc8', 
  '\x94', '\x98', '\xbc', '\x84', '\x88', '\xb0', '\x78', '\x7c', '\xa0', 
  '\x6c', '\x6c', '\x94', '\x5c', '\x60', '\x84', '\x50', '\x54', '\x74', 
  '\x48', '\x48', '\x64', '\x38', '\x38', '\x54', '\x28', '\x28', '\x44', 
  '\x20', '\x20', '\x30', '\x04', '\x04', '\x18', '\xd4', '\xcc', '\xa8', 
  '\xc4', '\xbc', '\x98', '\xb8', '\xb0', '\x90', '\xb0', '\xa0', '\x88', 
  '\xa4', '\x98', '\x7c', '\x98', '\x88', '\x74', '\x90', '\x7c', '\x68', 
  '\x84', '\x70', '\x60', '\x74', '\x60', '\x54', '\x68', '\x54', '\x4c', 
  '\x5c', '\x48', '\x44', '\x50', '\x3c', '\x38', '\x44', '\x30', '\x30', 
  '\x34', '\x24', '\x24', '\x24', '\x18', '\x18', '\x10', '\x10', '\x04', 
  '\xa4', '\xd0', '\xdc', '\x94', '\xc4', '\xd0', '\x84', '\xb8', '\xc4', 
  '\x74', '\xb0', '\xb8', '\x64', '\xa0', '\xb0', '\x54', '\x98', '\xa0', 
  '\x48', '\x8c', '\x98', '\x38', '\x80', '\x8c', '\x30', '\x74', '\x7c', 
  '\x24', '\x68', '\x70', '\x18', '\x5c', '\x60', '\x10', '\x50', '\x54', 
  '\x04', '\x44', '\x44', '\x04', '\x34', '\x34', '\x04', '\x24', '\x24', 
  '\x04', '\x10', '\x10', '\xdc', '\xcc', '\xc0', '\xd4', '\xc4', '\xb4', 
  '\xd0', '\xbc', '\xac', '\xcc', '\xb0', '\xa4', '\xc4', '\xac', '\x98', 
  '\xc0', '\xa4', '\x94', '\xbc', '\x9c', '\x8c', '\xb4', '\x94', '\x80', 
  '\xb0', '\x8c', '\x78', '\xac', '\x84', '\x70', '\xa4', '\x7c', '\x68', 
  '\xa0', '\x74', '\x60', '\x98', '\x6c', '\x5c', '\x94', '\x64', '\x54', 
  '\x90', '\x5c', '\x4c', '\x88', '\x54', '\x48', '\x80', '\x50', '\x3c', 
  '\x7c', '\x48', '\x38', '\x74', '\x44', '\x34', '\x6c', '\x38', '\x30', 
  '\x68', '\x34', '\x28', '\x60', '\x30', '\x24', '\x58', '\x24', '\x20', 
  '\x54', '\x20', '\x18', '\x4c', '\x18', '\x10', '\x44', '\x10', '\x10', 
  '\x3c', '\x10', '\x04', '\x34', '\x04', '\x04', '\x30', '\x04', '\x04', 
  '\x24', '\x04', '\x04', '\x18', '\x04', '\x04', '\x10', '\x04', '\x04', 
  '\xdc', '\xd4', '\xc8', '\xd4', '\xcc', '\xc4', '\xd0', '\xc4', '\xbc', 
  '\xcc', '\xc0', '\xb4', '\xc4', '\xb8', '\xb0', '\xc0', '\xb0', '\xa8', 
  '\xbc', '\xac', '\xa0', '\xb4', '\xa4', '\x9c', '\xb0', '\xa0', '\x98', 
  '\xac', '\x98', '\x90', '\xa4', '\x94', '\x88', '\x9c', '\x8c', '\x84', 
  '\x98', '\x84', '\x7c', '\x94', '\x80', '\x78', '\x8c', '\x78', '\x70', 
  '\x88', '\x70', '\x6c', '\x80', '\x6c', '\x64', '\x78', '\x64', '\x60', 
  '\x74', '\x5c', '\x58', '\x6c', '\x58', '\x54', '\x68', '\x50', '\x4c', 
  '\x60', '\x4c', '\x48', '\x58', '\x44', '\x44', '\x54', '\x3c', '\x3c', 
  '\x4c', '\x38', '\x34', '\x44', '\x30', '\x30', '\x3c', '\x28', '\x28', 
  '\x34', '\x24', '\x24', '\x28', '\x20', '\x20', '\x24', '\x18', '\x18', 
  '\x18', '\x10', '\x10', '\x10', '\x10', '\x04', '\xf0', '\xf0', '\x04', 
  '\xec', '\xe0', '\x04', '\xe8', '\xcc', '\x04', '\xe4', '\xbc', '\x04', 
  '\xe0', '\xac', '\x04', '\xdc', '\x98', '\x04', '\xd4', '\x88', '\x04', 
  '\xd4', '\x74', '\x04', '\xcc', '\x64', '\x04', '\xc8', '\x54', '\x04', 
  '\xc4', '\x44', '\x04', '\xfc', '\x04', '\x04', '\xe4', '\x04', '\x04', 
  '\xcc', '\x04', '\x04', '\xb0', '\x04', '\x04', '\x98', '\x04', '\x04', 
  '\x04', '\x04', '\x04', '\xa0', '\xd4', '\x80', '\x84', '\xbc', '\x64', 
  '\x68', '\xa4', '\x50', '\x50', '\x8c', '\x38', '\x38', '\x70', '\x24', 
  '\x24', '\x58', '\x18', '\xe0', '\xe4', '\xfc', '\xc8', '\xd4', '\xf8', 
  '\xa4', '\xb8', '\xe4', '\x7c', '\x98', '\xd0', '\x58', '\x74', '\xb8', 
  '\xd4', '\xd4', '\xd4', '\xe0', '\xe0', '\xe0', '\xe4', '\xe4', '\xe4', 
  '\xf0', '\xf0', '\xf0'};
