#! /bin/sh
#
# $Id: doom.sh,v 1.1 1996/04/22 06:09:42 toor Exp $
# $Log: doom.sh,v $
# Revision 1.1  1996/04/22 06:09:42  toor
# Initial revision
#
#
#
# Copyright (C) 1996 Stephen Hocking.
# All Rights Reserved.
# 
# Permission to use, copy, modify and distribute this software
# for any purpose is hereby granted without fee, provided that the
# above copyright notice and this notice appear in all copies
# and that both the copyright notice and this notice appear in
# supporting documentation.  Stephen Hocking makes no representations about
# the suitability of this software for any purpose.  It is provided
# "AS IS" without express or implied warranty.
# 
# STEPHEN HOCKING DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
# INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
# IN NO EVENT SHALL SCO BE LIABLE FOR ANY SPECIAL, INDIRECT,
# PUNITIVE, CONSEQUENTIAL OR INCIDENTAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, LOSS OF DATA OR LOSS OF
# PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
# TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE.
# 
# "DOOM" is a trademark of iD Software Inc. 
# 
# Run doom.

NAME=`basename $0`

DOOMDIR=/home/data/Doom/utilities

SOUNDSERVER=sndserver.linux

DOOMWADDIR=/home/data/Doom/wads/${NAME}
export DOOMWADDIR

unset WADFILES
export WADFILES
DOINFILES=0

PATH=${DOOMDIR}:${PATH}:.
export PATH

if [ -d $HOME/.doomsave ]
then
	:
else
	echo "Making $HOME/.doomsave"
	mkdir $HOME/.doomsave || exit 1
fi

cd $HOME/.doomsave || exit 1

NAS=0
CONSOLE=0

case "$AUDIOSERVER" in
"")
	case "$DISPLAY" in
	:0*|unix:0*|`hostname`:0*|`uname -n`:0*)
		CONSOLE=1
		;;
	*)
		NAS=1
		SOUNDSERVER=sndserver.nas
		;;
	esac
	;;
*)
	NAS=1
	SOUNDSERVER=sndserver.nas
	;;
esac

# workaround the fact that PATH isn't use to find sndserver

rm -f ./sndserver
ln -s $DOOMDIR/$SOUNDSERVER ./sndserver > /dev/null 2>&1

#
#	Look for -files arg so we can set an environment variable for the
#	soundserver to load extra wads for potential sounds
#

WADFILES=

options=$*

for i in ${options}
do
	case $i in
		-file)
			DOINFILES=1
			;;
		-*)
			DOINFILES=0
			;;
		*)
			if [ "$DOINFILES" -eq "1" ]
			then
				if [ "$WADFILES" -eq "" ]
				then
					WADFILES=$i
				else
					WADFILES="$WADFILES $i"
				fi
				export WADFILES
			fi
			;;
	esac
done

xdoom $*
exit 0
