//-------------------------------------------------------------------------
// KSSC
// Script Compiling Code for Strife
// Functions for file handling and token searching
//
// Oringinal functions by Ben Gokey & Raven Software
//
//--------------------------------------------------------------------------
#include "stdafx.h"
#include <fcntl.h>
#include <stdlib.h>
#include <io.h>
#include <stddef.h>
#include <stdarg.h>
#include <ctype.h>
#include <sys/stat.h>
#include <string.h>
#include "File.h"
#include "KSSC.h"

#define MAX_STRING_SIZE 1024
#define ASCII_COMMENT ('#')
#define ASCII_QUOTE ('&')
#define LUMP_SCRIPT 1
#define FILE_ZONE_SCRIPT 2
#define FILE_CLIB_SCRIPT 3
char *sc_String;
int sc_Number;
int sc_Line;
bool sc_End;
bool sc_Crossed;
static char ScriptName[16];
char *ScriptBuffer;
static char *ScriptPtr;
static char *ScriptEndPtr;
static char StringBuffer[MAX_STRING_SIZE];
static bool ScriptOpen = false;
static bool ScriptFreeCLib; // true = de-allocate using free()
static int ScriptSize;
bool AlreadyGot = false;

#define ASCII_SLASH 47
#define ASCII_BACKSLASH 92

bool printFinished = true;
#define strcasecmp _stricmp
//==========================================================================
//
// MS_StripFileExt	//Taken from ACC
//
//==========================================================================

void MS_StripFileExt(char *name)
{
	char *search;

	search = name+strlen(name)-1;
	while(*search != ASCII_SLASH && *search != ASCII_BACKSLASH
		&& search != name)
	{
		if(*search == '.')
		{
			*search = '\0';
			return;
		}
		search--;
	}
}

int MS_LoadFile(char const* name,void** buffer)
{
  int handle, count, length;
  struct stat fileinfo;
  void   *buf;

  handle = open (name, O_RDONLY | O_BINARY, 0666);
  if ((handle == -1) || (fstat (handle,&fileinfo) == -1))
  {
	printFinished = false;
    PrintTitle();
	return 0;
  }

  length = fileinfo.st_size;
  buf = malloc(length);
  count = read (handle, buf, length);
  close (handle);

  if (count < length)
  {
	printFinished = false;
    PrintTitle();
	return 0;
  }

  *buffer = buf;
  return length;
}

//==========================================================================
//
// M_ExtractFileBase
//
//==========================================================================

void M_ExtractFileBase(char *path, char *dest)
{
	char *src;
	int length;

	src = path+strlen(path)-1;

	// Back up until a \ or the start
	while(src != path && *(src-1) != '\\' && *(src-1) != '/')
	{
		src--;
	}

	// Copy up to eight characters
	memset(dest, 0, 8);
	length = 0;
	while(*src && *src != '.')
	{
		if(++length == 9)
		{
			//printf("Filename base of %s > 8 chars", path);
			return;
		}
		*dest++ = toupper((int)*src++);
	}
}

//==========================================================================
//
// SC_Close
//
//==========================================================================

void SC_Close(void)
{
	if(ScriptOpen)
	{
		if(ScriptFreeCLib == true)
		{
			free(ScriptBuffer);
		}
		ScriptOpen = false;
	}
}

//==========================================================================
//
// OpenScript
//
//==========================================================================

static void OpenScript(char *name, int type)
{
	SC_Close();
	if(type == FILE_ZONE_SCRIPT)
	{ // File script - zone
		ScriptSize = MS_LoadFile(name, (void **)&ScriptBuffer);
		M_ExtractFileBase(name, ScriptName);
		ScriptFreeCLib = false; // De-allocate using Z_Free()
	}
	ScriptPtr = ScriptBuffer;
	ScriptEndPtr = ScriptPtr+ScriptSize;
	sc_Line = 1;
	sc_End = false;
	ScriptOpen = true;
	sc_String = StringBuffer;
	AlreadyGot = false;
}

//==========================================================================
//
// SC_OpenFile
//
// Loads a script (from a file) and prepares it for parsing.  Uses the
// zone memory allocator for memory allocation and de-allocation.
//
//==========================================================================

void SC_OpenFile(char *name)
{
	OpenScript(name, FILE_ZONE_SCRIPT);
}

//==========================================================================
//
// SC_Open
//
//==========================================================================

void SC_Open(char *name)
{
	char fileName[128];

		sprintf(fileName, "%s", name);
		SC_OpenFile(fileName);
}

bool SC_Compare(char *text)
{
	if(strcasecmp(text, sc_String) == 0)
	{
		return true;
	}
	return false;
}

//==========================================================================
//
// SC_MatchString
//
// Returns the index of the first match to sc_String from the passed
// array of strings, or -1 if not found.
//
//==========================================================================

int SC_MatchString(char **strings)
{
	int i;

	for(i = 0; *strings != NULL; i++)
	{
		if(SC_Compare(*strings++))
		{
			return i;
		}
	}
	return -1;
}

//==========================================================================
//
// SC_MustMatchString
//
//==========================================================================

int SC_MustMatchString(char **strings)
{
	int i;

	i = SC_MatchString(strings);
	if(i == -1)
	{
		printf("String Error");
		return 0;
	}
	return i;
}


//==========================================================================
//
// SC_GetString
//
//==========================================================================

bool SC_GetString(void)
{
	char *text;
	bool foundToken;

	if(AlreadyGot)
	{
		AlreadyGot = false;
		return true;
	}
	foundToken = false;
	sc_Crossed = false;
	if(ScriptPtr >= ScriptEndPtr)
	{
		sc_End = true;
		return false;
	}
	while(foundToken == false)
	{
		while(*ScriptPtr <= 32)
		{
			if(ScriptPtr >= ScriptEndPtr)
			{
				sc_End = true;
				return false;
			}
			if(*ScriptPtr++ == '\n')
			{
				sc_Line++;
				sc_Crossed = true;
			}
		}
		if(ScriptPtr >= ScriptEndPtr)
		{
			sc_End = true;
			return false;
		}
		if(*ScriptPtr != ASCII_COMMENT)
		{ // Found a token
			foundToken = true;
		}
		else
		{ // Skip comment
			while(*ScriptPtr++ != '\n')
			{
				if(ScriptPtr >= ScriptEndPtr)
				{
					sc_End = true;
					return false;
	
			}
			}
			sc_Line++;
			sc_Crossed = true;
		}
	}
	text = sc_String;
	if(*ScriptPtr == ASCII_QUOTE)
	{ // Quoted string
		ScriptPtr++;
		while(*ScriptPtr != ASCII_QUOTE)
		{
			*text++ = *ScriptPtr++;
			if(ScriptPtr == ScriptEndPtr
				|| text == &sc_String[MAX_STRING_SIZE-1])
			{
				break;
			}
		}
		ScriptPtr++;
	}
	else
	{ // Normal string
		while((*ScriptPtr > 32) && (*ScriptPtr != ASCII_COMMENT))
		{
			*text++ = *ScriptPtr++;
			if(ScriptPtr == ScriptEndPtr
				|| text == &sc_String[MAX_STRING_SIZE-1])
			{
				break;
			}
		}
	}
	*text = 0;
	return true;
}

//==========================================================================
//
// SC_MustGetString
//
//==========================================================================

void SC_MustGetString(void)
{
	if(SC_GetString() == false)
	{
		printf("Missing String");
		return;
	}
}

void SC_MustGetStringName(char *name)
{
	SC_MustGetString();
	if(SC_Compare(name) == false)
	{
		printf("String Error");
		return;
	}
}

bool SC_GetNumber(void)
{
	char *stopper;

	if(SC_GetString())
	{
		sc_Number = strtol(sc_String, &stopper, 0);
		if(*stopper != 0)
		{
			printf("SC_GetNumber: Bad numeric constant \"%s\".\n"
				"Script %s, Line %d", sc_String, ScriptName, sc_Line);
			return 0;
		}
		return true;
	}
	else
	{
		return false;
	}
}

//==========================================================================
//
// SC_MustGetNumber
//
//==========================================================================

void SC_MustGetNumber(void)
{
	if(SC_GetNumber() == false)
	{
		printf("missing integer");
		return;
	}
}