//-------------------------------------------------------------------------
// KSSC
// Script Compiling Code for Strife
// Main compiling code
//
// (c) 10/26/2005 Samuel 'Kaiser' Villarreal
//
//--------------------------------------------------------------------------
#include "stdafx.h"
#include <stdlib.h>
#include <string.h>
#include "File.h"

static char* fileName;

typedef struct
{
	int GiveType;
	int Item[3];
	int Count[3];
	char Reply[32];	
	char Yes[80];
	int Link;
	int Log;
	char No[80];
} npcChoice_t;

typedef struct
{
	int SpeakerType;
	int DropType;
	int ItemCheck[3];
	int Link;
	char Name[16];
	char Sound[8];
	char Backdrop[8];
	char Dialogue[320];	
	npcChoice_t Responses[5];
} npc_t;

#define NPCITEMCHECK	0
#define CHOICEITEMCHECK	1
#define CHOICEAMOUNTCHECK	2
#define CHOICENUM	3

//==========================================================================
//
// PrintTitle - Prints the title
//
//==========================================================================
void PrintTitle(void)
{
	printf("*************************************");
	printf("*************************************");
	printf("			Kaiser's Strife Script Compiler (KSSC)\n");
	printf("		By Samuel Villarreal 10-26-05\n");
	printf("		Email: svkaiser@gmail.com\n");
	printf("		Usage: KSSC.exe [input file]\n");
	printf("		Outputed script file will be generated in the input directory.\n");
	printf("*************************************");
	printf("*************************************");
	return;
}

//==========================================================================
//
// K_Error - Displays error message, then closes files and frees memory
//
//==========================================================================
static void K_Error(npc_t* rSpk, FILE* f, char *text, ...)
{
	printf("ERROR:Line %i - ", sc_Line);
	printf("%s\n", text);
	free(rSpk);
	fclose(f);
	SC_Close();
	remove(fileName);
}

//==========================================================================
//
// K_CheckStringSize - Checks if current string length is larger than its actual size
//
//==========================================================================
static bool K_CheckStringSize(npc_t* rSpk, FILE* f, char* string, size_t buf)
{
	if(strlen(string) > buf)
	{
		printf("ERROR:Line %i - ", sc_Line);
		printf("The text %s is too long!\n", string);
		free(rSpk);
		fclose(f);
		SC_Close();
		remove(fileName);
		return true;
	}
	return false;
}

//==========================================================================
//
// K_GetFileSize - Returns the size of a compiled script
//
//==========================================================================
static long K_GetFileSize(FILE* f)
{
	long fileBuffer;
	fseek (f , 0 , SEEK_END);
	fileBuffer = ftell (f);
	rewind (f);
	return fileBuffer;
}

//==========================================================================
//
// main - Setup the files, write the data into binary form, then save as a lump
//
//==========================================================================
int main(int argc, char **argv)
{
	FILE *mapscript;
	char mapname[128];
	int checkSets[4];
	bool choiceFinish = false;
	int blockNumber = 1;
	int currentMobj;
	bool getNPC = false;
	int i;

	if (argc > 3 || argc == 1)
	{
		PrintTitle();
		return 1;
	}
	//decompile stuff goes here
	if(argv[2])
	{
		if(strcmp(argv[2], "-decompile"))
		{
			PrintTitle();
			return 1;
		}
		npc_t rogueDecompile[255];
		int l, choices, numNPC;
		char tempPanel[9];
		mapscript = fopen (argv[1], "rb");
		if(mapscript == 0)
		{
			printf("Read Error\n");
			return 1;
		}
		printf("*************************************\n");
		printf("KSSC By Samuel 'Kaiser' Villarreal\n");
		printf("Reading script lump...\n");
		printf("*************************************\n");
		if(K_GetFileSize(mapscript) % sizeof(npc_t) != 0)
		{
			printf("ERROR! Lump's file size isn't valid!\n");
			fclose(mapscript);
			return 1;
		}
		long numBlocks = K_GetFileSize(mapscript) / sizeof(npc_t);
		if(K_GetFileSize(mapscript) > sizeof(npc_t)*255)
		{
			printf("YOU FREAK!!!!!\n");
			fclose(mapscript);
			return 1;
		}
		for(i = 0; i < numBlocks; i++)
		{
			fread(&rogueDecompile[i], sizeof(npc_t), 1, mapscript);
			if(rogueDecompile[i].SpeakerType == 0)
				break;
		}
		fclose(mapscript);
		MS_StripFileExt(argv[1]);
		sprintf(mapname,"%s.txt",argv[1]);
		FILE *scr = fopen (mapname, "w");
		numNPC = 0;
		blockNumber = 0;
		for(i = 0; i < numBlocks; i++)
		{
			if(currentMobj != rogueDecompile[i].SpeakerType)
			{
				numNPC++;
				blockNumber = 1;
				currentMobj = rogueDecompile[i].SpeakerType;
			} else blockNumber++;
			fprintf(scr, "#===========================================================================\n#=======================NPC %i: %s - BLOCK %i============================\n#===========================================================================\n",
				numNPC,
				!strcmp(rogueDecompile[i].Name, "") ? "PERSON" : rogueDecompile[i].Name,
				blockNumber);
			fprintf(scr,"$MOBJ %i\n", rogueDecompile[i].SpeakerType);
			if(rogueDecompile[i].DropType != 0)
			{
				fprintf(scr,"DROP %i\n", rogueDecompile[i].DropType);
			}
			fprintf(scr,"NAME &%s&\n", rogueDecompile[i].Name);
			for(l = 0; l < 3; l++)
			{
				if(rogueDecompile[i].ItemCheck[l] != 0)
				{
					fprintf(scr,"IF_ITEM %i\n", rogueDecompile[i].ItemCheck[l]);
				}
			}
			if(rogueDecompile[i].Link != 0)
			{
				fprintf(scr,"GOTO %i\n", rogueDecompile[i].Link);
			}
			fprintf(scr,"VOICE &%s&\n", rogueDecompile[i].Sound);
			//seems to be having problems writing the panel text. Strncpy seems to get this fixed
			strncpy (tempPanel, rogueDecompile[i].Backdrop, 8); tempPanel[8] = 0;
			fprintf(scr,"PANEL &%s&\n", tempPanel);
			fprintf(scr,"DIALOG &%s&\n", rogueDecompile[i].Dialogue);
			for(choices = 0; choices < 5; choices++)
			{
				if(!strcmp(rogueDecompile[i].Responses[choices].Reply, ""))
					break;
				fprintf(scr,"	{\n		GIVEMOBJ %i\n",
					rogueDecompile[i].Responses[choices].GiveType);
				fprintf(scr,"		TEXT &%s&\n",
					rogueDecompile[i].Responses[choices].Reply);
				for(l = 0; l < 3; l++)
				{
					if(rogueDecompile[i].Responses[choices].Item[l] != 0)
					{
						fprintf(scr,"		IF_HAS %i * %i\n",
							rogueDecompile[i].Responses[choices].Item[l],
							rogueDecompile[i].Responses[choices].Count[l]);
					}
				}
				fprintf(scr,"		YESTEXT &%s&\n",
					rogueDecompile[i].Responses[choices].Yes);
				if(rogueDecompile[i].Responses[choices].Link != 0)
				{
					fprintf(scr,"		LINK %i\n",
						rogueDecompile[i].Responses[choices].Link);
				}
				if(rogueDecompile[i].Responses[choices].Log != 0)
				{
					fprintf(scr,"		LOG %i\n",
						rogueDecompile[i].Responses[choices].Log);
				}
				fprintf(scr,"		NOTEXT &%s&\n",
					rogueDecompile[i].Responses[choices].No);
				fprintf(scr,"	}\n");
			}
			fprintf(scr,"$END\n\n\n\n");
		}
		fprintf(scr, "#Total Blocks: %i", numBlocks);
		printf("Decompile finished...\n%i Dialog Blocks read\n%i NPC's found\n",
			numBlocks, numNPC);
		fclose(scr);
		printf("Saved to %s\n", mapname);
		return 1;
	}

	//compile stuff goes here
	if(argv[1])
	{
		SC_Open(argv[1]);
		MS_StripFileExt(argv[1]);	//remove any extentions before adding the .lmp ext
		sprintf(mapname,"%s.lmp",argv[1]);	//argv[1] is the input name. Output name will be the same
		mapscript = fopen (mapname, "wb");
		fileName = mapname;
	}
	if(mapscript == 0)
	{
		PrintTitle();
		return 1;
	}

	printf("*************************************\n");
	printf("KSSC By Samuel 'Kaiser' Villarreal\n");
	printf("Reading script file...\n");
	printf("*************************************\n");
	npc_t* rogueSpeech = (npc_t *)malloc(sizeof(npc_t));
	memset(checkSets, 0, sizeof(checkSets));
	while(SC_GetString())
	{
		if(SC_Compare("$MOBJ"))
		{
			if(getNPC == true)
			{
				K_Error(rogueSpeech, mapscript,
					"Previous block has not been closed properly, or missing $END token!");
				return 1;
			}
			SC_MustGetNumber();
			rogueSpeech->SpeakerType = sc_Number;
			getNPC = true;
		}
		if(SC_Compare("DROP"))
		{
			SC_MustGetNumber();
			rogueSpeech->DropType = sc_Number;
		}
		if(SC_Compare("IF_ITEM"))
		{
			SC_MustGetNumber();
			rogueSpeech->ItemCheck[checkSets[NPCITEMCHECK]] = sc_Number;
			checkSets[NPCITEMCHECK]++;
		}
		if(SC_Compare("GOTO"))
		{
			SC_MustGetNumber();
			rogueSpeech->Link = sc_Number;
		}
		if(SC_Compare("NAME"))
		{
			SC_MustGetString();
			strcpy(rogueSpeech->Name, sc_String);
			if(K_CheckStringSize(rogueSpeech, mapscript, rogueSpeech->Name,
				sizeof(rogueSpeech->Name)))
				return 1;
		}
		if(SC_Compare("VOICE"))
		{
			SC_MustGetString();
			strcpy(rogueSpeech->Sound, sc_String);
			if(K_CheckStringSize(rogueSpeech, mapscript, rogueSpeech->Sound,
				sizeof(rogueSpeech->Sound)))
				return 1;
		}
		if(SC_Compare("PANEL"))
		{
			SC_MustGetString();
			strcpy(rogueSpeech->Backdrop, sc_String);
			if(K_CheckStringSize(rogueSpeech, mapscript, rogueSpeech->Backdrop,
				sizeof(rogueSpeech->Backdrop)))
				return 1;
		}
		if(SC_Compare("DIALOG"))
		{
			SC_MustGetString();
			strcpy(rogueSpeech->Dialogue, sc_String);
			if(K_CheckStringSize(rogueSpeech, mapscript, rogueSpeech->Dialogue,
				sizeof(rogueSpeech->Dialogue)))
				return 1;
		}
		if(SC_Compare("}"))
		{
			K_Error(rogueSpeech, mapscript, "Found a wandering '}'");
			return 1;
		}
		if(SC_Compare("{") && choiceFinish == false)
		{
			while(SC_GetString() && choiceFinish == false)
			{
				if(SC_Compare("GIVEMOBJ"))
				{
					SC_MustGetNumber();
					rogueSpeech->Responses[checkSets[CHOICENUM]].GiveType = sc_Number;
					if(rogueSpeech->Responses[checkSets[CHOICENUM]].GiveType == 0)
					printf("Warning! 'GIVEMOBJ' is 0! Are you sure about this?\n");
				}
				if(SC_Compare("IF_HAS"))
				{
					SC_MustGetNumber();
					rogueSpeech->Responses[checkSets[CHOICENUM]].Item[checkSets[CHOICEITEMCHECK]] = sc_Number;
					checkSets[CHOICEITEMCHECK]++;
					while(SC_GetString())
					{
						if(SC_Compare("*") == false)
						{
							K_Error(rogueSpeech, mapscript, "Please specify amount for the 'IF_HAS' token (use '* itemamount' after token)");
							return 1;
						}
						SC_MustGetNumber();
						rogueSpeech->Responses[checkSets[CHOICENUM]].Count[checkSets[CHOICEAMOUNTCHECK]] = sc_Number;
						checkSets[CHOICEAMOUNTCHECK]++;
						AlreadyGot = true;
						break;

					}
				}
				if(SC_Compare("TEXT"))
				{
					SC_MustGetString();
					strcpy(rogueSpeech->Responses[checkSets[CHOICENUM]].Reply, sc_String);
					//set the default no and yes text
					sprintf(rogueSpeech->Responses[checkSets[CHOICENUM]].No,
						"NO.  you don't have what i want for the  %s!",sc_String);
					sprintf(rogueSpeech->Responses[checkSets[CHOICENUM]].Yes,
						"you got the %s!", sc_String);
					if(K_CheckStringSize(rogueSpeech, mapscript,
						rogueSpeech->Responses[checkSets[CHOICENUM]].Reply,
				sizeof(rogueSpeech->Responses[checkSets[CHOICENUM]].Reply)))
					return 1;
				}
				if(SC_Compare("YESTEXT"))
				{
					memset(rogueSpeech->Responses[checkSets[CHOICENUM]].Yes, 0, 80);
					SC_MustGetString();
					strcpy(rogueSpeech->Responses[checkSets[CHOICENUM]].Yes, sc_String);
					if(K_CheckStringSize(rogueSpeech, mapscript,
						rogueSpeech->Responses[checkSets[CHOICENUM]].Yes,
				sizeof(rogueSpeech->Responses[checkSets[CHOICENUM]].Yes)))
					return 1;
				}
				if(SC_Compare("LINK"))
				{
					SC_MustGetNumber();
					rogueSpeech->Responses[checkSets[CHOICENUM]].Link = sc_Number;
				}
				if(SC_Compare("LOG"))
				{
					SC_MustGetNumber();
					rogueSpeech->Responses[checkSets[CHOICENUM]].Log = sc_Number;
				}
				if(SC_Compare("NOTEXT"))
				{
					SC_MustGetString();
					strcpy(rogueSpeech->Responses[checkSets[CHOICENUM]].No, sc_String);
					if(K_CheckStringSize(rogueSpeech, mapscript,
						rogueSpeech->Responses[checkSets[CHOICENUM]].No,
				sizeof(rogueSpeech->Responses[checkSets[CHOICENUM]].No)))
					return 1;
				}
				//check for unclosed choicedefs
				if(SC_Compare("{"))
				{
					K_Error(rogueSpeech, mapscript, "Bracket '{' found within a choicedef!");
					return 1;
				}
				if(SC_Compare("}") && choiceFinish == false)
				{
					checkSets[CHOICENUM]++;
					choiceFinish = true;
					break;
				}
			}
		}choiceFinish = false;
		if(SC_Compare("$END"))
		{
			getNPC = false;
			(currentMobj != rogueSpeech->SpeakerType) ?
				(currentMobj = rogueSpeech->SpeakerType, blockNumber = 1) : blockNumber++;
			printf("Writting NPC #%i '%s', block #%i\n", rogueSpeech->SpeakerType,
				rogueSpeech->Name, blockNumber);
			printf("\n");
			if(rogueSpeech->SpeakerType <= 0)
			{
				K_Error(rogueSpeech, mapscript, "Need to specify a map thing!");
				return 1;
			}
		fwrite(rogueSpeech,sizeof(npc_t), 1, mapscript);
		memset(rogueSpeech,0,sizeof(npc_t));
		choiceFinish = false;
		memset(checkSets, 0, sizeof(checkSets));
			
		}
		SC_Close();
	}
	if(printFinished == true)
	printf("Compile Finished\n");
	free(rogueSpeech);
	fclose(mapscript);
	printf("Saved to %s\n", mapname);
	return 0;
}

