/*//////////////////////////////////////////////////////////
Winwad
Copyright (C) 2000 John Gaughan

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

The full GNU General Public License can be found archived with these
source files as "gpl.txt"
*///////////////////////////////////////////////////////////

#ifndef _CDIRECTORYWINDOW_
#define _CDIRECTORYWINDOW_

#define IDC_LISTBOX    100
#define IDC_CONTENTS   101
#define IDC_STATUS     102

// Wad directory window
class CDirectoryWindow : public CFrameWnd
{
  private:

  // Controls
  CListBox     wndListBox;
  CEdit        wndContents;
  CStatusBar   wndStatus;

  // Wad
  CWad         m_wWad;
  bool         m_bWadSaved;
  bool         m_bPreCache;
  bool         m_bUseIWAD;

  // Private functions
  void CloseWad ();

  protected:

  // Messages
  afx_msg void OnGetMinMaxInfo (MINMAXINFO FAR* lpMMI);
  afx_msg void OnPaint ();
  afx_msg void OnSize (UINT nType, int cx, int cy);

  // File menu
  afx_msg void OnFileNew ();
  afx_msg void OnFileOpen ();
  afx_msg void OnFileSave ();
  afx_msg void OnFileSaveAs ();
  afx_msg void OnFileExit ();

  // Edit menu
  afx_msg void OnEditCut ();
  afx_msg void OnEditCopy ();
  afx_msg void OnEditPaste ();
  afx_msg void OnEditSelectAll ();
  afx_msg void OnEditImport ();
  afx_msg void OnEditExport ();
  afx_msg void OnEditNew ();
  afx_msg void OnEditDelete ();
  afx_msg void OnEditRename ();

  // View menu
  afx_msg void OnViewRaw ();
  afx_msg void OnViewInterpret ();

  // IWad menu
  afx_msg void OnIwadUseIwad ();
  afx_msg void OnIwadDontUseIwad ();

  // Help menu
  afx_msg void OnHelpLicense ();
  afx_msg void OnHelpAbout ();

  DECLARE_MESSAGE_MAP ()

  public:

  // Constructor
  CDirectoryWindow ();
  BOOL PreCreateWindow (CREATESTRUCT &cs);
};

#endif
